/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.Edge.IslandEdgeSet;
import IslandNetworks.Vertex.IslandSiteSet;
import TimUtilities.NumbersToString;
import TimUtilities.TimSort;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.io.PrintStream;

public class IslandTransferMatrix {
    static final double DUNSET = -97531.0;
    static final int IUNSET = -86420;
    private int modeNumber = 0;
    int edgeVariableIndex = IslandEdge.weightINDEX;
    int dimension = -86420;
    Algebra alg = new Algebra();
    DenseDoubleMatrix2D transferMatrix;
    double[] restartVector;
    boolean restartVectorRandomSites = false;
    boolean evcalc = false;
    boolean evCalcFailed = false;
    EigenvalueDecomposition tMED;
    DoubleMatrix2D Vmatrix;
    DoubleMatrix2D Dmatrix;
    private double[] absevalues;
    TimSort evOrder;
    double tolerance = -97531.0;
    boolean inflcalc = false;
    private double influenceProbability = -97531.0;
    double influenceSteps = -97531.0;
    DoubleMatrix2D influenceMatrix;
    DoubleMatrix2D Vinverse;
    double[] influenceValueIn;
    double[] influenceStrengthIn;
    double[] influenceValueOut;

    public IslandTransferMatrix(int n, int n2, IslandSiteSet islandSiteSet, IslandEdgeSet islandEdgeSet, int n3) {
        this.edgeVariableIndex = n3;
        this.calcTransferMatrix(n, n2, islandSiteSet, islandEdgeSet);
    }

    public IslandTransferMatrix(IslandTransferMatrix islandTransferMatrix) {
        this.modeNumber = islandTransferMatrix.modeNumber;
        this.edgeVariableIndex = islandTransferMatrix.edgeVariableIndex;
        this.dimension = islandTransferMatrix.dimension;
        this.transferMatrix = (DenseDoubleMatrix2D)islandTransferMatrix.transferMatrix.copy();
        this.restartVector = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.restartVector[i] = islandTransferMatrix.restartVector[i];
        }
        if (islandTransferMatrix.evcalc) {
            this.calcEigenvalueDecomposition(islandTransferMatrix.tolerance);
            if (islandTransferMatrix.inflcalc) {
                this.calcInfluenceMatrix(islandTransferMatrix.influenceProbability);
            }
        }
    }

    private void calcTransferMatrix(int n, int n2, IslandSiteSet islandSiteSet, IslandEdgeSet islandEdgeSet) {
        this.modeNumber = n;
        this.dimension = n2;
        this.restartVector = new double[this.dimension];
        this.calcRestartVector(islandSiteSet);
        this.transferMatrix = new DenseDoubleMatrix2D(this.dimension, this.dimension);
        this.calcTransferMatrix(islandEdgeSet);
    }

    private void calcTransferMatrix(IslandEdgeSet islandEdgeSet) {
        int n;
        double d = -99.0;
        double d2 = -876.0;
        int n2 = -345;
        block6: for (int i = 0; i < this.dimension; ++i) {
            d = 0.0;
            if (this.modeNumber > 0) {
                for (n2 = 0; n2 < this.dimension; ++n2) {
                    if (i == n2) continue;
                    d += islandEdgeSet.getVariable(i, n2, this.edgeVariableIndex);
                }
            }
            d2 = 1.0 - d;
            this.transferMatrix.set(i, i, 0.0);
            switch (this.modeNumber) {
                case 3: {
                    for (n2 = 0; n2 < this.dimension; ++n2) {
                        this.transferMatrix.set(n2, i, (i == n2 ? 0.0 : islandEdgeSet.getVariable(i, n2, this.edgeVariableIndex)) + this.restartVector[n2] * d2);
                    }
                    continue block6;
                }
                case 2: {
                    for (n2 = 0; n2 < this.dimension; ++n2) {
                        if (i == n2) continue;
                        this.transferMatrix.set(n2, i, islandEdgeSet.getVariable(i, n2, this.edgeVariableIndex));
                    }
                    this.transferMatrix.set(i, i, d2);
                    continue block6;
                }
                case 1: {
                    if (d > 1.0E-6) {
                        for (n2 = 0; n2 < this.dimension; ++n2) {
                            if (i == n2) continue;
                            this.transferMatrix.set(n2, i, islandEdgeSet.getVariable(i, n2, this.edgeVariableIndex) / d);
                        }
                        continue block6;
                    }
                    for (n2 = 0; n2 < this.dimension; ++n2) {
                        this.transferMatrix.set(n2, i, this.restartVector[n2]);
                    }
                    continue block6;
                }
                case 0: {
                    for (n2 = 0; n2 < this.dimension; ++n2) {
                        if (i == n2) continue;
                        this.transferMatrix.set(n2, i, islandEdgeSet.getVariable(i, n2, this.edgeVariableIndex));
                    }
                    continue block6;
                }
            }
        }
        double d3 = 1.0 / (double)(this.dimension * this.dimension);
        double d4 = 1.0 - d3;
        double d5 = d3 / (double)this.dimension;
        for (n = 0; n < this.dimension; ++n) {
            for (n2 = 0; n2 < this.dimension; ++n2) {
                this.transferMatrix.set(n, n2, this.transferMatrix.getQuick(n, n2) * d4 + d5);
            }
        }
        n = this.checkNonNegative();
        if (n >= 0) {
            System.err.println("*** Transfer Matrix is negative at row " + n / this.dimension + " column " + n % this.dimension);
        } else {
            System.out.println("... Transfer Matrix is non-negative");
        }
    }

    private void calcRestartVector(IslandSiteSet islandSiteSet, boolean bl) {
        int n;
        this.restartVectorRandomSites = bl;
        double d = 0.0;
        if (!bl) {
            for (n = 0; n < this.dimension; ++n) {
                d += islandSiteSet.getWeight(n);
            }
        }
        for (n = 0; n < this.dimension; ++n) {
            this.restartVector[n] = d > 0.0 ? islandSiteSet.getWeight(n) / d : 1.0 / (double)this.dimension;
        }
    }

    private void calcRestartVector(IslandSiteSet islandSiteSet) {
        this.calcRestartVector(islandSiteSet, false);
    }

    private int calcEigenvalueDecomposition(double d) {
        this.inflcalc = false;
        this.Vinverse = null;
        this.Dmatrix = null;
        this.absevalues = null;
        this.tolerance = -88.888888;
        this.absevalues = new double[this.dimension];
        try {
            this.tMED = new EigenvalueDecomposition((DoubleMatrix2D)this.transferMatrix);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("*** EigenvalueDecomposition has failed, " + runtimeException);
            this.evcalc = false;
            this.evCalcFailed = true;
            return -this.dimension - 2;
        }
        this.Vmatrix = this.tMED.getV();
        this.Dmatrix = this.tMED.getD();
        int n = 0;
        double d2 = -987.654321;
        double d3 = -654.321987;
        for (int i = 0; i < this.dimension; ++i) {
            d2 = this.tMED.getImagEigenvalues().get(i);
            d3 = this.tMED.getRealEigenvalues().get(i);
            if (Math.abs(d2) > d) {
                n = -1 - i;
            }
            this.absevalues[i] = Math.sqrt(d3 * d3 + d2 * d2);
        }
        this.evOrder = new TimSort(this.absevalues, false);
        this.evcalc = true;
        this.tolerance = d;
        this.evCalcFailed = false;
        return n;
    }

    private int calcVinverse() {
        try {
            this.Vinverse = this.alg.inverse(this.Vmatrix);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("*** ERROR " + runtimeException + "in calcInfluenceMatrix ");
            return -1;
        }
        return 0;
    }

    public int calcInfluenceMatrix(double d) {
        if (d > 1.0 || d < 0.0) {
            return -2;
        }
        this.influenceProbability = d;
        double d2 = 1.0 - this.influenceProbability;
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        if (this.evCalcFailed) {
            return -2;
        }
        if (this.Vinverse == null && this.calcVinverse() < 0) {
            return -1;
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        int n = this.dimension - 1;
        for (int i = 0; i < this.dimension; ++i) {
            double d3 = 1.0 - this.influenceProbability * this.Dmatrix.get(i, i);
            if (Math.abs(d3) > 1.0E-6) {
                double d4;
                double d5 = d4 = i == n ? 0.0 : this.influenceProbability * this.Dmatrix.get(i, i + 1);
                if (d4 == 0.0) {
                    sparseDoubleMatrix2D.set(i, i, d2 / d3);
                    continue;
                }
                double d6 = d3 * d3 + d4 * d4;
                double d7 = d2 * d3 / d6;
                double d8 = d2 * d4 / d6;
                sparseDoubleMatrix2D.set(i, i, d7);
                sparseDoubleMatrix2D.set(i, i + 1, d8);
                sparseDoubleMatrix2D.set(i + 1, i, -d8);
                sparseDoubleMatrix2D.set(i + 1, i + 1, d7);
                ++i;
                continue;
            }
            sparseDoubleMatrix2D.set(i, i, 1.0);
        }
        DoubleMatrix2D doubleMatrix2D = this.alg.mult(this.Vmatrix, (DoubleMatrix2D)sparseDoubleMatrix2D);
        this.influenceMatrix = this.alg.mult(doubleMatrix2D, this.Vinverse);
        this.inflcalc = true;
        this.influenceSteps = this.influenceProbability / (1.0 - this.influenceProbability);
        this.influenceValueIn = new double[this.dimension];
        this.influenceValueOut = new double[this.dimension];
        this.influenceStrengthIn = null;
        for (int i = 0; i < this.dimension; ++i) {
            this.influenceValueIn[i] = 0.0;
            this.influenceValueOut[i] = 0.0;
            for (int j = 0; j < this.dimension; ++j) {
                int n2 = i;
                this.influenceValueIn[n2] = this.influenceValueIn[n2] + this.influenceMatrix.get(i, j);
                int n3 = i;
                this.influenceValueOut[n3] = this.influenceValueOut[n3] + this.influenceMatrix.get(j, i);
            }
        }
        return 0;
    }

    public double getInfluenceProbability() {
        return this.influenceProbability;
    }

    public double getDimension() {
        return this.dimension;
    }

    public double get(int n, int n2) {
        double d = -2.0;
        if (n < 0 || n >= this.dimension) {
            return -1.0;
        }
        if (n2 < 0 || n2 >= this.dimension) {
            return -1.1;
        }
        try {
            d = this.transferMatrix.get(n, n2);
        }
        catch (ArithmeticException arithmeticException) {
            d = -3.0;
        }
        return d;
    }

    public double getInfluence(int n, int n2) {
        if (n2 < 0 || n2 >= this.dimension) {
            return -1.0;
        }
        if (n < 0 || n >= this.dimension) {
            return -1.1;
        }
        if (this.inflcalc) {
            return this.influenceMatrix.get(n, n2);
        }
        return -97531.0;
    }

    public double getAbsEigenValue(int n) {
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        int n2 = this.evOrder.getIndex(n);
        return this.absevalues[n2];
    }

    public double getRealPartEigenValue(int n) {
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        int n2 = this.evOrder.getIndex(n);
        return this.tMED.getRealEigenvalues().get(n2);
    }

    public double getImaginaryPartEigenValue(int n) {
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        int n2 = this.evOrder.getIndex(n);
        return this.tMED.getImagEigenvalues().get(n2);
    }

    public double[] getEigenVector(int n) {
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        int n2 = this.evOrder.getIndex(n);
        DoubleMatrix1D doubleMatrix1D = this.Vmatrix.viewColumn(n2);
        return doubleMatrix1D.toArray();
    }

    public void printEigenValueList(String string, String string2, PrintStream printStream, int n, boolean bl) {
        this.printEigenValueList(string, string2, printStream, n, bl, true, true);
    }

    public void printEigenValueList(String string, String string2, PrintStream printStream, int n, boolean bl, boolean bl2, boolean bl3) {
        NumbersToString numbersToString = new NumbersToString();
        if (bl) {
            printStream.println("Eigenvalues for transfer matrix  type " + string2 + this.modeNumber);
            printStream.print("Rank");
            if (bl2) {
                printStream.print(string2 + "Abs");
            }
            if (bl3) {
                printStream.print(string2 + "Re" + string2 + "Im");
            }
            printStream.println();
        }
        for (int i = 0; i < this.dimension; ++i) {
            printStream.print(i);
            if (bl2) {
                printStream.print(string2 + NumbersToString.toString(this.getAbsEigenValue(i), n));
            }
            if (bl3) {
                printStream.print(string2 + NumbersToString.toString(this.getRealPartEigenValue(i), n) + string2 + NumbersToString.toString(this.getImaginaryPartEigenValue(i), n));
            }
            printStream.println();
        }
    }

    public void printTransferMatrix(String string, String string2, PrintStream printStream, int n, boolean bl) {
        int n2;
        NumbersToString numbersToString = new NumbersToString();
        if (bl) {
            printStream.println("Transfer Matrix  type " + string2 + this.modeNumber);
            printStream.print("To/From" + string2);
            for (n2 = 0; n2 < this.dimension; ++n2) {
                printStream.print(n2 + string2);
            }
            printStream.println();
        }
        for (n2 = 0; n2 < this.dimension; ++n2) {
            if (bl) {
                printStream.print(n2 + string2);
            }
            for (int i = 0; i < this.dimension; ++i) {
                printStream.print(NumbersToString.toString(this.transferMatrix.get(n2, i), n) + string2);
            }
            printStream.println();
        }
    }

    public void printInfluenceMatrix(String string, String string2, PrintStream printStream, int n, boolean bl) {
        int n2;
        if (!this.inflcalc) {
            if (bl) {
                printStream.println("Influence Matrix not calculated.");
            }
            return;
        }
        NumbersToString numbersToString = new NumbersToString();
        if (bl) {
            printStream.println("Influence Matrix probability " + string2 + this.influenceProbability + string2 + ", steps " + string2 + this.influenceSteps + string2 + " from transfer matrix type " + this.modeNumber);
            printStream.print("To/From" + string2);
            for (n2 = 0; n2 < this.dimension; ++n2) {
                printStream.print(n2 + string2);
            }
            printStream.println();
        }
        for (n2 = 0; n2 < this.dimension; ++n2) {
            if (bl) {
                printStream.print(n2 + string2);
            }
            for (int i = 0; i < this.dimension; ++i) {
                printStream.print(NumbersToString.toString(this.influenceMatrix.get(n2, i), n) + string2);
            }
            printStream.println();
        }
    }

    public String typeString() {
        String string = "Unset";
        switch (this.modeNumber) {
            case 3: {
                string = "Raw edge values plus normalised restart vector to ensure markovian.";
                break;
            }
            case 2: {
                string = "Raw edge values, tadpoles equal to remaining deficit so markovian.";
                break;
            }
            case 1: {
                string = "Normalised edge values (restart vector if deadend), no tadpoles but markovian.";
                break;
            }
            case 0: {
                string = "Raw edge values, no tadpoles, non-markovian.";
                break;
            }
            default: {
                string = "Unknown.";
            }
        }
        return string;
    }

    public int checkDecomposition(double d) {
        DoubleMatrix2D doubleMatrix2D;
        if (d < 0.0) {
            return -4;
        }
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        if (this.Vinverse == null && this.calcVinverse() < 0) {
            return -1;
        }
        try {
            doubleMatrix2D = this.alg.mult(this.alg.mult(this.Vmatrix, this.Dmatrix), this.Vinverse);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("*** ERROR " + runtimeException + "in checkDecomposition ");
            return -2;
        }
        int n = 0;
        double[][] dArray = new double[this.dimension][this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                dArray[i][j] = Math.abs(doubleMatrix2D.get(i, j) - this.transferMatrix.get(i, j));
                if (!(dArray[i][j] > d)) continue;
                n = -3;
            }
        }
        return n;
    }

    public int checkMarkovian(double d) {
        double d2 = -99.0;
        for (int i = 0; i < this.dimension; ++i) {
            d2 = this.transferMatrix.viewColumn(i).zSum();
            if (!(Math.abs(d2 - 1.0) > d)) continue;
            return i;
        }
        return -1;
    }

    public int checkNonNegative() {
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                if (!(this.transferMatrix.getQuick(i, j) < 0.0)) continue;
                return i * this.dimension + j;
            }
        }
        return -1;
    }

    public int checkInfluenceSubMarkovian(double d) {
        double d2 = -99.0;
        for (int i = 0; i < this.dimension; ++i) {
            d2 = this.influenceMatrix.viewColumn(i).zSum();
            if (!(d2 - 1.0 > d) && !(d2 < -d)) continue;
            return i;
        }
        return -1;
    }

    public int checkInfluenceNonNegative(double d) {
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                if (!(this.influenceMatrix.get(i, j) < -d)) continue;
                return i * this.dimension + j;
            }
        }
        return -1;
    }
}

