/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.islandNetwork;
import TimUtilities.NumbersToString;
import TimUtilities.StatisticalQuantity;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IslandParameterWindow {
    private islandNetwork islnet;

    public IslandParameterWindow(islandNetwork islandNetwork2) {
        this.islnet = new islandNetwork(islandNetwork2);
    }

    public Box getParameterBox() {
        Box box = Box.createVerticalBox();
        box.add(this.getBasicSettingsPanel());
        box.add(this.getInputVariablesPanel());
        return box;
    }

    public JPanel getParameterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.getBasicSettingsPanel());
        jPanel.add(this.getInputVariablesPanel());
        return jPanel;
    }

    public JPanel getBasicSettingsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(7, 2));
        this.addValuePair(jPanel, "Input file : ", this.islnet.inputFile.getNameRoot());
        this.addValuePair(jPanel, "Output files : ", this.islnet.outputFile.getNameRoot());
        this.addValuePair(jPanel, "Model : ", this.islnet.modelNumber.major + "_" + this.islnet.modelNumber.minor + ",  " + this.islnet.modelNumber.majorString + "+" + this.islnet.modelNumber.minorString);
        String string = this.islnet.updateMode.toLongString();
        if (this.islnet.updateMode.isMode("MC")) {
            string = string + ", " + this.islnet.monteCarloStartMode.toLongString();
        }
        string = string + " (" + this.islnet.updateMode.getNumber() + ")";
        this.addValuePair(jPanel, "Calculational Mode : ", string);
        this.addValuePair(jPanel, "Edge Update Mode : ", this.islnet.edgeSet.edgeMode.description());
        this.addValuePair(jPanel, "Vertex Update Mode : ", this.islnet.vertexMode.descriptionValue(", value="));
        return jPanel;
    }

    public JPanel getInputVariablesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 4));
        this.addValuePair(jPanel, "kappa", this.islnet.Hamiltonian.kappa);
        this.addValuePair(jPanel, "lambda", this.islnet.Hamiltonian.lambda);
        this.addValuePair(jPanel, "j", this.islnet.Hamiltonian.vertexSource);
        this.addValuePair(jPanel, "mu", this.islnet.Hamiltonian.edgeSource);
        this.addValuePair(jPanel, "distance scale", this.islnet.Hamiltonian.distanceScale);
        this.addValuePair(jPanel, "short distance scale", this.islnet.Hamiltonian.shortDistanceScale);
        this.addValuePair(jPanel, "b", this.islnet.Hamiltonian.getb());
        this.addValuePair(jPanel, "metric number ", this.islnet.Hamiltonian.shortDistanceScale);
        this.addValuePair(jPanel, "initial beta ", this.islnet.betaInitial);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        return jPanel2;
    }

    public JPanel getOutputMeasuresPanel(int n) {
        NumbersToString numbersToString = new NumbersToString(n);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(7, 5));
        jPanel.setToolTipText("These are different measures of the output for this network.");
        jPanel.add(new JLabel("Quantity/Value :", 4));
        jPanel.add(new JLabel("Average", 0));
        jPanel.add(new JLabel("Sigma", 0));
        jPanel.add(new JLabel("Minimum", 0));
        jPanel.add(new JLabel("Maximum", 0));
        jPanel.add(this.makeRightLabelWithToolTip("Site Value :", "Fractional population of one site relative to sites fixed value (v_i)"));
        this.addStatsValues(jPanel, "Site value", this.islnet.siteSet.siteValueStats, n);
        jPanel.add(this.makeRightLabelWithToolTip("Site Weight :", "Population of one site, fixed value * variable fraction (S_i v_i)"));
        this.addStatsValues(jPanel, "Site weight", this.islnet.siteSet.siteWeightStats, n);
        jPanel.add(this.makeRightLabelWithToolTip("Site Out W.Strength :", "Total outgoing trade from one site (sum_j S_i v_i e_(ij) )"));
        this.addStatsValues(jPanel, "Site out w.strength", this.islnet.siteSet.siteStrengthOutStats, n);
        jPanel.add(this.makeRightLabelWithToolTip("Site In W.Strength :", "Total incoming trade from one site (sum_j S_j v_j e_(ij) )"));
        this.addStatsValues(jPanel, "Site in w.strength", this.islnet.siteSet.siteStrengthInStats, n);
        jPanel.add(this.makeRightLabelWithToolTip("Edge Weight :", "Total trade along one edge, (S_i v_i e_(ij) )"));
        this.addStatsValues(jPanel, "Edge weight", this.islnet.edgeSet.edgeStats[IslandEdge.weightINDEX], n);
        jPanel.add(this.makeRightLabelWithToolTip("Edge Value :", "Fraction of trade along one edge, e_(ij) "));
        this.addStatsValues(jPanel, "Edge value", this.islnet.edgeSet.edgeStats[IslandEdge.valueINDEX], n);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        jPanel2.add(this.islnet.globalProperties.getPanel());
        return jPanel2;
    }

    private void addStatsValues(JPanel jPanel, String string, StatisticalQuantity statisticalQuantity, int n) {
        NumbersToString numbersToString = new NumbersToString(n);
        jPanel.add(this.makeCenterLabelWithToolTip(numbersToString.toString(statisticalQuantity.getAverage()), string + " average"));
        jPanel.add(this.makeCenterLabelWithToolTip(numbersToString.toString(statisticalQuantity.getSigma()), string + " sigma"));
        jPanel.add(this.makeCenterLabelWithToolTip(numbersToString.toString(statisticalQuantity.minimum), string + " min"));
        jPanel.add(this.makeCenterLabelWithToolTip(numbersToString.toString(statisticalQuantity.maximum), string + " max"));
    }

    private void addValuePair(JPanel jPanel, String string, double d) {
        jPanel.add(new JLabel(string, 4));
        String string2 = ": " + d;
        jPanel.add(new JLabel(string2, 2));
    }

    private void addValuePair(JPanel jPanel, String string, double d, int n) {
        jPanel.add(new JLabel(string, 4));
        String string2 = "%12.6g";
        if (n > 0) {
            string2 = "%" + (n + 6) + "." + n;
        }
        String string3 = ": " + String.format(string2, d);
        jPanel.add(new JLabel(string3, 0));
    }

    private void addValuePair(JPanel jPanel, String string, double d, String string2) {
        jPanel.add(new JLabel(string, 4));
        String string3 = ": " + d;
        JLabel jLabel = new JLabel(": " + d, 2);
        jLabel.setToolTipText(string2);
        jPanel.add(jLabel);
    }

    private void addValuePair(JPanel jPanel, String string, String string2) {
        jPanel.add(new JLabel(string, 4));
        jPanel.add(new JLabel(string2, 2));
    }

    private void addValuePair(JPanel jPanel, String string, String string2, String string3) {
        jPanel.add(new JLabel(string, 4));
        JLabel jLabel = new JLabel(string2, 2);
        jLabel.setToolTipText(string3);
        jPanel.add(jLabel);
    }

    private JLabel makeRightLabelWithToolTip(String string, String string2) {
        JLabel jLabel = new JLabel(string, 4);
        jLabel.setToolTipText(string2);
        return jLabel;
    }

    private JLabel makeCenterLabelWithToolTip(String string, String string2) {
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setToolTipText(string2);
        return jLabel;
    }
}

