/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import TimUtilities.NumbersToString;
import java.io.PrintStream;

public class IslandHamiltonian {
    static final String IHVERSION = "iN060727";
    public static final double SHORTDISTANCEPOTENTIAL = -9.18273645E8;
    static NumbersToString n2s = new NumbersToString();
    double edgeSource;
    double vertexSource;
    double alpha;
    double beta;
    double gamma;
    double kappa;
    private double kappaZ;
    double lambda;
    double distanceScale;
    double shortDistanceScale;
    private double b;
    double outputcoeff;
    double consumptioncoeff;

    public IslandHamiltonian() {
        this.edgeSource = 0.5;
        this.vertexSource = 0.0;
        this.beta = 0.001;
        this.alpha = 4.0;
        this.gamma = 1.0;
        this.kappa = 1.0;
        this.lambda = 4.0;
        this.distanceScale = 100.0;
        this.shortDistanceScale = this.distanceScale / 20.0;
        this.setb(1.2);
        this.outputcoeff = 1.0;
        this.consumptioncoeff = 2.0 * this.outputcoeff;
    }

    public IslandHamiltonian(IslandHamiltonian islandHamiltonian) {
        this.edgeSource = islandHamiltonian.edgeSource;
        this.vertexSource = islandHamiltonian.vertexSource;
        this.beta = islandHamiltonian.beta;
        this.alpha = islandHamiltonian.alpha;
        this.gamma = islandHamiltonian.gamma;
        this.kappa = islandHamiltonian.kappa;
        this.lambda = islandHamiltonian.lambda;
        this.distanceScale = islandHamiltonian.distanceScale;
        this.shortDistanceScale = islandHamiltonian.shortDistanceScale;
        this.setb(islandHamiltonian.getb());
        this.outputcoeff = islandHamiltonian.outputcoeff;
        this.consumptioncoeff = islandHamiltonian.consumptioncoeff;
    }

    public double getb() {
        return this.b;
    }

    public double setb(double d) {
        this.b = d;
        this.kappaZ = Math.pow(this.b, this.b / (this.b - 1.0)) * (this.b - 1.0);
        return this.b;
    }

    public void setHamiltonianParameters(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.edgeSource = d2;
        this.vertexSource = d;
        this.beta = d3;
        this.setb(d4);
        this.alpha = d5;
        this.gamma = d7;
        this.kappa = d6;
        this.lambda = d8;
        this.distanceScale = d9;
        this.shortDistanceScale = d10;
    }

    public void printParameters(PrintStream printStream, String string) {
        printStream.println("   vertexSource (j) " + string + this.vertexSource);
        printStream.println("     edgeSource (mu)" + string + this.edgeSource);
        printStream.println("              kappa " + string + this.kappa);
        printStream.println("             lambda " + string + this.lambda);
        printStream.println("          distScale " + string + this.distanceScale);
        printStream.println("     shortDistScale " + string + this.shortDistanceScale);
        printStream.println("               beta " + string + String.format("%12.6g", this.beta));
        printStream.println("                  b " + string + this.b);
        printStream.println("              alpha " + string + this.alpha);
        printStream.println("              gamma " + string + this.gamma);
    }

    public void printParametersForData(PrintStream printStream, String string) {
        printStream.println("j" + string + this.vertexSource);
        printStream.println("mu" + string + this.edgeSource);
        printStream.println("kappa" + string + this.kappa);
        printStream.println("lambda " + string + this.lambda);
        printStream.println("distScale" + string + this.distanceScale);
        printStream.println("shortDistScale" + string + this.shortDistanceScale);
        printStream.println("beta" + string + this.beta);
        printStream.println("b" + string + this.b);
        printStream.println("alpha" + string + this.alpha);
        printStream.println("gamma" + string + this.gamma);
    }

    public String inputParametersString(String string) {
        String string2 = "";
        string2 = string2 + string + "-j" + this.vertexSource;
        string2 = string2 + string + "-m" + this.edgeSource;
        string2 = string2 + string + "-k" + this.kappa;
        string2 = string2 + string + "-l" + this.lambda;
        string2 = string2 + string + "-dl" + this.distanceScale;
        string2 = string2 + string + "-ds" + this.shortDistanceScale;
        string2 = string2 + string + "-bt" + this.beta;
        string2 = string2 + string + "-bs" + this.b;
        string2 = string2 + string + "-a" + this.alpha;
        string2 = string2 + string + "-g" + this.gamma;
        return string2;
    }

    public String inputParametersString(String string, String string2, int n) {
        n2s.setDecimalPlaces(n);
        String string3 = "";
        if (string.length() > 0) {
            string3 = string + string2;
        }
        string3 = string3 + "-j" + n2s.toString(this.vertexSource);
        string3 = string3 + string2 + "-m" + n2s.toString(this.edgeSource);
        string3 = string3 + string2 + "-k" + n2s.toString(this.kappa);
        string3 = string3 + string2 + "-l" + n2s.toString(this.lambda);
        string3 = string3 + string2 + "-dl" + n2s.toString(this.distanceScale);
        string3 = string3 + string2 + "-ds" + n2s.toString(this.shortDistanceScale);
        string3 = string3 + string2 + "-bt" + n2s.toString(this.beta);
        string3 = string3 + string2 + "-bs" + n2s.toString(this.b);
        string3 = string3 + string2 + "-a" + n2s.toString(this.alpha);
        string3 = string3 + string2 + "-g" + n2s.toString(this.gamma);
        return string3;
    }

    public String parameterString(String string) {
        String string2 = "j" + this.vertexSource + string + "m" + this.edgeSource + string + "k" + this.kappa + string + "l" + this.lambda + string + "b" + this.b + string + "D" + this.distanceScale;
        return string2;
    }

    public String parameterString(String string, int n) {
        String string2 = "%0" + (n + 3) + "." + n + "g";
        String string3 = "j" + String.format(string2, this.vertexSource) + string + "m" + String.format(string2, this.edgeSource) + string + "k" + String.format(string2, this.kappa) + string + "l" + String.format(string2, this.lambda) + string + "b" + String.format(string2, this.b) + string + "D" + String.format(string2, this.distanceScale);
        return string3;
    }

    public double vertexPotential1(double d, double d2) {
        return this.kappa * 4.0 * d2 * (1.0 - d2) * d;
    }

    public double vertexPotential5(double d, double d2) {
        return this.kappa * this.kappaZ * d * (d2 - Math.pow(d2, this.b));
    }

    public double edgePotential1(double d, double d2) {
        return d2 * this.lambda * this.edgePotential1Bare(d);
    }

    public double edgePotential1MC(double d) {
        return d < this.shortDistanceScale ? -9.18273645E8 : this.lambda * this.edgePotential1Bare(d);
    }

    public double edgePotential1Bare(double d) {
        return Math.pow(Math.pow(d / this.distanceScale, this.alpha) + 1.0, -this.gamma);
    }
}

