/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import TimUtilities.NumbersToString;
import TimUtilities.TimMessage;
import TimUtilities.TimTiming;
import java.io.PrintStream;
import java.util.Random;

public class IslandCulture {
    public TimMessage message = new TimMessage(0);
    int numberSites = 0;
    EventProbability eProb;
    private int numberInd = 0;
    private double totalWeight;
    private int[] indArray;
    private int[] indSite;
    private int[] firstInd;
    private int[] nIndAtSite;
    private int[] nArtifact;
    private EventProbability[] neighbourProb;
    private Random Rnd = new Random();
    double[][] siteCultureVector;
    double[] siteCultureF2;
    double[] cultureF2;
    double[] maxCulture;
    int[] maxCultureSite;
    double[][] cultureCorrelation;

    public IslandCulture(double d, double d2, double d3) {
        this.eProb = new EventProbability(4);
        this.eProb.addProbability(d);
        this.eProb.addProbability(d2);
        this.eProb.addProbability(d3);
        this.eProb.addProbability(1.0 - d - d2 - d3);
    }

    public IslandCulture(IslandCulture islandCulture) {
        this.numberSites = islandCulture.numberSites;
        this.siteCultureVector = new double[this.numberSites][this.numberSites];
        this.cultureCorrelation = new double[this.numberSites][this.numberSites];
        this.siteCultureF2 = new double[this.numberSites];
        this.cultureF2 = new double[this.numberSites];
        for (int i = 0; i < this.numberSites; ++i) {
            this.cultureF2[i] = islandCulture.cultureF2[i];
            this.siteCultureF2[i] = islandCulture.siteCultureF2[i];
            for (int j = 0; j < this.numberSites; ++j) {
                this.siteCultureVector[i][j] = islandCulture.siteCultureVector[i][j];
            }
        }
        this.eProb = new EventProbability(islandCulture.eProb);
    }

    public void setup(double[] dArray, double[][] dArray2, int n, int n2) {
        int n3;
        this.numberSites = dArray.length;
        this.totalWeight = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            this.totalWeight += dArray[i];
        }
        double d = this.totalWeight / (double)n;
        this.indArray = new int[n + this.numberSites];
        this.indSite = new int[n + this.numberSites];
        this.firstInd = new int[this.numberSites + 1];
        this.nIndAtSite = new int[this.numberSites];
        this.nArtifact = new int[this.numberSites];
        this.neighbourProb = new EventProbability[this.numberSites];
        this.numberInd = 0;
        for (n3 = 0; n3 < this.numberSites; ++n3) {
            this.nIndAtSite[n3] = (int)(0.5 + dArray[n3] / d);
            if (this.nIndAtSite[n3] < 1) {
                this.nIndAtSite[n3] = 1;
            }
            this.firstInd[n3] = this.numberInd;
            for (int i = 0; i < this.nIndAtSite[n3]; ++i) {
                this.indArray[i + this.numberInd] = n3 + (n2 == 0 ? 0 : i * this.numberSites);
                this.indSite[i + this.numberInd] = n3;
            }
            this.nArtifact[n3] = n2 == 0 ? 1 : this.numberSites;
            this.numberInd += this.nIndAtSite[n3];
        }
        this.firstInd[this.numberSites] = this.numberInd;
        for (n3 = 0; n3 < this.numberSites; ++n3) {
            int n4;
            this.neighbourProb[n3] = new EventProbability(this.numberSites);
            double d2 = 0.0;
            for (n4 = 0; n4 < this.numberSites; ++n4) {
                if (n3 == n4) continue;
                d2 += dArray[n3] * dArray2[n3][n4] + dArray[n4] * dArray2[n4][n3];
            }
            if (d2 > 0.0) {
                for (n4 = 0; n4 < this.numberSites; ++n4) {
                    if (n3 == n4) {
                        this.neighbourProb[n3].addProbability(1.0 - d2);
                        continue;
                    }
                    this.neighbourProb[n3].addProbability((dArray[n3] * dArray2[n3][n4] + dArray[n4] * dArray2[n4][n3]) / d2);
                }
                continue;
            }
            for (n4 = 0; n4 < this.numberSites; ++n4) {
                if (n3 == n4) {
                    this.neighbourProb[n3].addProbability(1.0);
                    continue;
                }
                this.neighbourProb[n3].addProbability(0.0);
            }
        }
    }

    public void evolve(int n) {
        int n2;
        int n3 = n + 1;
        int n4 = 10;
        double d = 0.01;
        if (d > 0.0) {
            n3 = (int)((double)n * d);
        }
        if (n3 < 1) {
            n3 = 1;
        }
        int n5 = n2 = n3;
        TimTiming timTiming = new TimTiming();
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        timTiming.setInitialTime();
        this.message.println(0, " /// Starting Culture Evolution /// ");
        for (int i = 0; i < n; ++i) {
            n6 = this.Rnd.nextInt(this.numberInd);
            n8 = this.indSite[n6];
            n13 = this.eProb.getEvent(this.Rnd.nextDouble());
            switch (n13) {
                case 0: {
                    n7 = this.firstInd[n8] + this.Rnd.nextInt(this.nIndAtSite[n8]);
                    n12 = this.indArray[n6];
                    break;
                }
                case 1: {
                    n9 = this.neighbourProb[n8].getEvent(this.Rnd.nextDouble());
                    n7 = this.firstInd[n9] + this.Rnd.nextInt(this.nIndAtSite[n9]);
                    n12 = this.indArray[n6];
                    break;
                }
                case 2: {
                    n7 = n6;
                    n10 = this.indArray[n8] % this.numberSites;
                    n12 = this.nArtifact[n10] * this.numberSites + n10;
                    int n14 = n10;
                    this.nArtifact[n14] = this.nArtifact[n14] + 1;
                    break;
                }
                case 3: {
                    n7 = n6;
                    n12 = this.nArtifact[n8] * this.numberSites + n8;
                    int n15 = n8;
                    this.nArtifact[n15] = this.nArtifact[n15] + 1;
                }
            }
            this.indArray[n7] = n12;
            if (!this.message.testInformationLevel(1) || 0 != --n5) continue;
            System.out.print(".");
            n5 = n2;
            if (0 != --n4) continue;
            System.out.println(" " + timTiming.runTimeString());
            n4 = 10;
        }
    }

    public double calcHomogeneity(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                if (this.indArray[i] != this.indArray[j]) continue;
                ++n3;
            }
        }
        double d = n2 - n;
        double d2 = (double)n3 * 2.0 / (d * (d - 1.0));
        return d2;
    }

    public double calcSiteHomogeneity(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                if (this.indArray[i] % this.numberSites != this.indArray[j] % this.numberSites) continue;
                ++n3;
            }
        }
        double d = n2 - n;
        double d2 = (double)n3 * 2.0 / (d * (d - 1.0));
        return d2;
    }

    public void calcHomogeneity() {
        this.cultureF2 = new double[this.numberSites];
        this.siteCultureF2 = new double[this.numberSites];
        boolean bl = false;
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteCultureF2[i] = this.calcSiteHomogeneity(this.firstInd[i], this.firstInd[i + 1]);
            this.cultureF2[i] = this.calcHomogeneity(this.firstInd[i], this.firstInd[i + 1]);
        }
    }

    public void calcCultureVectors() {
        this.siteCultureVector = new double[this.numberSites][this.numberSites];
        this.maxCulture = new double[this.numberSites];
        this.maxCultureSite = new int[this.numberSites];
        boolean bl = false;
        double d = -1.0;
        for (int i = 0; i < this.numberSites; ++i) {
            int n;
            for (int j = 0; j < this.numberSites; ++j) {
                this.siteCultureVector[i][j] = 0.0;
            }
            double d2 = 1.0 / (double)this.nIndAtSite[i];
            for (n = this.firstInd[i]; n < this.firstInd[i + 1]; ++n) {
                double[] dArray = this.siteCultureVector[i];
                int n2 = this.indArray[n] % this.numberSites;
                dArray[n2] = dArray[n2] + d2;
            }
            this.maxCulture[i] = 0.0;
            this.maxCultureSite[i] = -1;
            for (n = 0; n < this.numberSites; ++n) {
                d = this.siteCultureVector[i][n];
                if (!(d > this.maxCulture[i]) && (d != this.maxCulture[i] || !this.Rnd.nextBoolean())) continue;
                this.maxCulture[i] = d;
                this.maxCultureSite[i] = n;
            }
        }
    }

    public double calcCorrelation(int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            d += this.siteCultureVector[n][i] * this.siteCultureVector[n2][i];
            d2 += this.siteCultureVector[n][i] * this.siteCultureVector[n][i];
            d3 += this.siteCultureVector[n2][i] * this.siteCultureVector[n2][i];
        }
        if (d2 > 0.0 && d3 > 0.0) {
            d /= Math.sqrt(d2 * d3);
        }
        return d;
    }

    public void calcCorrelation() {
        this.cultureCorrelation = new double[this.numberSites][this.numberSites];
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.cultureCorrelation[i][j] = this.calcCorrelation(i, j);
            }
        }
    }

    public void calcAllStats() {
        this.calcCultureVectors();
        this.calcHomogeneity();
        this.calcCorrelation();
    }

    public void print(PrintStream printStream, String string, String string2, int n) {
        printStream.println(this.label(string, string2));
        for (int i = 0; i < this.numberSites; ++i) {
            printStream.println(this.toString(i, string, string2, n));
        }
    }

    public String label(String string, String string2) {
        int n;
        String string3 = "";
        string3 = string + string2 + "#Ind" + string2 + "Max.Cult.Site" + string2 + "Max.Cult." + string2 + "#Art" + string2 + "F2" + string2 + "F2Site" + string2;
        for (n = 0; n < this.numberSites; ++n) {
            string3 = string3 + "Cult." + n + "AT row" + string2;
        }
        string3 = string3 + "cos(theta)" + string2;
        for (n = 0; n < this.numberSites; ++n) {
            string3 = string3 + n + string2;
        }
        return string3;
    }

    public String toString(int n, String string, String string2, int n2) {
        int n3;
        NumbersToString numbersToString = new NumbersToString();
        String string3 = "";
        string3 = n + string2 + this.nIndAtSite[n] + string2 + this.maxCultureSite[n] + string2 + NumbersToString.toString(this.maxCulture[n], n2) + string2 + NumbersToString.toString(this.nArtifact[n], n2) + string2 + NumbersToString.toString(this.cultureF2[n], n2) + string2 + NumbersToString.toString(this.siteCultureF2[n], n2);
        for (n3 = 0; n3 < this.numberSites; ++n3) {
            string3 = string3 + string2 + NumbersToString.toString(this.siteCultureVector[n][n3], n2);
        }
        string3 = string3 + string2 + "   ";
        for (n3 = 0; n3 < this.numberSites; ++n3) {
            string3 = string3 + string2 + NumbersToString.toString(this.cultureCorrelation[n][n3], n2);
        }
        return string3;
    }

    public class EventProbability {
        double[] prob;
        double[] cummulativeProb;
        int numberProb = -1;

        public EventProbability(int n) {
            this.prob = new double[n];
            this.cummulativeProb = new double[n];
            this.numberProb = 0;
        }

        public EventProbability(EventProbability eventProbability) {
            this.numberProb = eventProbability.numberProb;
            this.prob = new double[this.numberProb];
            this.cummulativeProb = new double[this.numberProb];
            this.numberProb = 0;
            for (int i = 0; i < this.numberProb; ++i) {
                this.addProbability(eventProbability.prob[i]);
            }
        }

        public boolean addProbability(double d) {
            if (this.test(d)) {
                return true;
            }
            this.prob[this.numberProb] = d;
            this.cummulativeProb[this.numberProb] = this.numberProb > 0 ? d + this.cummulativeProb[this.numberProb - 1] : d;
            if (this.test(this.cummulativeProb[this.numberProb])) {
                return true;
            }
            ++this.numberProb;
            return this.test();
        }

        public int getEvent(double d) {
            int n = 0;
            while (d > this.cummulativeProb[n]) {
                ++n;
            }
            return n;
        }

        public boolean test() {
            return !(this.cummulativeProb[this.numberProb - 1] > 1.000001);
        }

        public boolean test(double d) {
            return d > 1.000001 || d < 0.0;
        }

        public String label(String string) {
            String string2 = "";
            for (int i = 0; i < this.numberProb; ++i) {
                string2 = string2 + "prob[i]" + string;
            }
            return string2;
        }

        public String toString(String string) {
            String string2 = "";
            for (int i = 0; i < this.numberProb; ++i) {
                string2 = string2 + this.prob[i] + string;
            }
            return string2;
        }
    }
}

