/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.islandNetwork;
import java.awt.GridLayout;
import java.io.PrintStream;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GlobalProperties {
    static final double DUNSET = -1.3579E24;
    private double[] value;
    static final int UNIQUENAMELENGTH = 6;
    public static final String[] name = new String[]{"Energy", "TEWeight", "InSSEntropy", "OutSSEntropy", "EWEntropy", "EWMInformation", "EWMIDistance"};
    static final String[] longName = new String[]{"Energy", "Total Edge Weight", "In Site Strength Entropy", "Out Site Strength Entropy", "Edge Weight Entropy", "Edge Weight Mutual Information ", "Edge Weight M.I. Distance"};
    static final int EnergINDEX = GlobalProperties.getIndex("Energy");
    static final int TEWeiINDEX = GlobalProperties.getIndex("TEWeight");
    static final int InSSEINDEX = GlobalProperties.getIndex("InSSEntropy");
    static final int OutSSINDEX = GlobalProperties.getIndex("OutSSEntropy");
    static final int EWEntINDEX = GlobalProperties.getIndex("EWEntropy");
    static final int EWMInINDEX = GlobalProperties.getIndex("EWMInformation");
    static final int EWMIDINDEX = GlobalProperties.getIndex("EWMIDistance");

    public GlobalProperties() {
        this.initialise();
    }

    public GlobalProperties(GlobalProperties globalProperties) {
        this.initialise();
        for (int i = 0; i < name.length; ++i) {
            this.value[i] = globalProperties.getValue(i);
        }
    }

    private void initialise() {
        this.value = new double[name.length];
        for (int i = 0; i < name.length; ++i) {
            this.value[i] = -1.3579E24;
        }
    }

    public double getValue(int n) {
        return this.value[n];
    }

    public String getValueString(int n) {
        double d = this.getValue(n);
        if (d == -1.3579E24) {
            return "UNSET";
        }
        return String.format("%12.6g", d);
    }

    public double getEnergy() {
        return this.value[EnergINDEX];
    }

    public double getTotalEdgeWeight() {
        return this.value[TEWeiINDEX];
    }

    public double getInSiteStrengthEntropy() {
        return this.value[InSSEINDEX];
    }

    public double getOutSiteStrengthEntropy() {
        return this.value[OutSSINDEX];
    }

    public double getMutualInformation() {
        return this.value[EWMInINDEX];
    }

    public double getMutualInformationDistance() {
        return this.value[EWMIDINDEX];
    }

    public void calculateAll(islandNetwork islandNetwork2) {
        this.calcEnergy(islandNetwork2);
        this.calcEntropies(islandNetwork2);
    }

    public void calcEnergy(islandNetwork islandNetwork2) {
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = -1.0;
        switch (islandNetwork2.modelNumber.major) {
            case 1: {
                for (int i = 0; i < islandNetwork2.numberSites; ++i) {
                    d4 = islandNetwork2.siteSet.getWeight(i);
                    d2 = islandNetwork2.modelNumber.bit0 ? d4 : 1.0;
                    d += islandNetwork2.Hamiltonian.vertexSource * d4;
                    d -= islandNetwork2.Hamiltonian.vertexPotential1(islandNetwork2.siteSet.getSize(i), islandNetwork2.siteSet.getValue(i));
                    for (int j = 0; j < islandNetwork2.numberSites; ++j) {
                        d3 = islandNetwork2.modelNumber.bit1 ? islandNetwork2.siteSet.getWeight(j) : 1.0;
                        d -= islandNetwork2.edgeSet.getEdgePotential1(i, j) * islandNetwork2.edgeSet.getEdgeValue(i, j) * d3 * d2;
                        d += islandNetwork2.Hamiltonian.edgeSource * d4 * islandNetwork2.edgeSet.getEdgeValue(i, j);
                    }
                }
                break;
            }
        }
        this.value[GlobalProperties.EnergINDEX] = d;
    }

    public void calcEntropies(islandNetwork islandNetwork2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < islandNetwork2.numberSites; ++i) {
            d2 += islandNetwork2.siteSet.getStrengthIn(i);
        }
        this.value[GlobalProperties.TEWeiINDEX] = d2;
        double d6 = -1.0;
        double d7 = -1.0;
        if (d2 > 1.0E-10) {
            for (int i = 0; i < islandNetwork2.numberSites; ++i) {
                d6 = islandNetwork2.siteSet.getStrengthOut(i) / d2;
                if (d6 > 1.0E-10) {
                    d4 -= d6 * Math.log(d6);
                }
                for (int j = 0; j < islandNetwork2.numberSites; ++j) {
                    double d8;
                    d7 = islandNetwork2.siteSet.getStrengthIn(j) / d2;
                    if (d7 > 1.0E-10) {
                        d3 -= d7 * Math.log(d7);
                    }
                    if ((d8 = islandNetwork2.edgeSet.getEdgeWeight(i, j) / d2) > 1.0E-10) {
                        d5 -= d8 * Math.log(d8);
                    }
                    if (d8 < 1.0E-10 || d6 < 1.0E-10 || d7 < 1.0E-10) continue;
                    d += d8 * Math.log(d8 / (d6 * d7));
                }
            }
        }
        double d9 = 0.0;
        if (d5 > 1.0E-10) {
            d9 = 1.0 - d / d5;
        }
        this.value[GlobalProperties.InSSEINDEX] = d3;
        this.value[GlobalProperties.OutSSINDEX] = d4;
        this.value[GlobalProperties.EWEntINDEX] = d5;
        this.value[GlobalProperties.EWMInINDEX] = d;
        this.value[GlobalProperties.EWMIDINDEX] = d9;
    }

    public static int getIndex(String string) {
        String string2 = string.substring(0, 6);
        for (int i = 0; i < name.length; ++i) {
            if (!name[i].startsWith(string2)) continue;
            return i;
        }
        return -1;
    }

    public void print(PrintStream printStream, String string) {
        for (int i = 0; i < name.length; ++i) {
            printStream.println(longName[i] + string + this.getValueString(i));
        }
    }

    public JPanel getPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(name.length + 1, 2));
        jPanel.add(new JLabel("Quantity:", 4));
        jPanel.add(new JLabel("Value", 0));
        for (int i = 0; i < name.length; ++i) {
            jPanel.add(new JLabel(longName[i] + ":", 4));
            jPanel.add(new JLabel(this.getValueString(i), 0));
        }
        return jPanel;
    }
}

