/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import java.io.File;
import java.io.PrintStream;

public class FileLocation {
    private File rootDirectory;
    private File fullDirectory;
    private String basicRoot;
    private String parameterName;
    private String ending;
    private String extension;
    private static final int NOSEQNO = -24680;
    public int sequenceNumber = -24680;
    private static final String SEQIND = "_r";

    public FileLocation(String string, String string2, String string3, String string4, int n, String string5, String string6) {
        this.setAll(string, string2, string3, string4, n, string5, string6);
    }

    public FileLocation(String string, String string2, String string3, String string4, String string5, String string6) {
        this.setAll(string, string2, string3, string4, -24680, string5, string6);
    }

    public FileLocation(String string, String string2, String string3) {
        this.setNamesLocations(string, string2, string3);
        this.sequenceNumber = -24680;
    }

    public FileLocation(String string) {
        this.setFileLocationName(string);
    }

    public FileLocation(File file) {
        if (!file.isFile()) {
            System.out.println("*** ERROR " + file.getPath() + " is not a file in FileLocation");
            return;
        }
        this.setFileLocationName(file.getPath());
    }

    public FileLocation(String string, String string2, String string3, int n) {
        this.setNamesLocations(string, string2, string3);
        this.sequenceNumber = n;
    }

    public FileLocation(FileLocation fileLocation) {
        this.rootDirectory = fileLocation.rootDirectory;
        this.fullDirectory = fileLocation.fullDirectory;
        this.basicRoot = fileLocation.basicRoot;
        this.parameterName = fileLocation.parameterName;
        this.sequenceNumber = fileLocation.sequenceNumber;
        this.ending = fileLocation.ending;
        this.extension = fileLocation.extension;
    }

    public String getRootDirectoryPath() {
        return this.rootDirectory.getPath();
    }

    public String getSubDirectoryName() {
        return this.fullDirectory.getName();
    }

    public String getSubDirectoryPath() {
        return this.fullDirectory.getPath();
    }

    public String getFullLocation() {
        return this.fullDirectory.getPath();
    }

    public String getNameRoot() {
        return this.basicRoot + this.getParameterName();
    }

    public String getFullFileRoot() {
        return this.getNameRoot() + this.sequenceString();
    }

    public String getFullFileName() {
        return this.getNameRoot() + this.sequenceString() + this.ending + "." + this.extension;
    }

    public String getFullFileName(String string, String string2) {
        this.ending = string;
        this.extension = string2;
        return this.getFullFileName();
    }

    public String getFullLocationFileRoot() {
        return this.fullDirectory.getPath() + File.separator + this.getRootName();
    }

    public String getFullLocationFileRootSN() {
        return this.fullDirectory.getPath() + File.separator + this.getRootName() + this.sequenceString();
    }

    public String getFullLocationFileName() {
        return this.fullDirectory.getPath() + File.separator + this.getFullFileName();
    }

    public String getFullLocationSimpleFileName() {
        return this.fullDirectory.getPath() + File.separator + this.basicRoot + this.ending + "." + this.extension;
    }

    public String getFullLocationSimpleFileName(String string, String string2) {
        this.ending = string;
        this.extension = string2;
        return this.getFullLocationSimpleFileName();
    }

    public File getFullLocationFile() {
        return new File(this.getFullLocationFileName());
    }

    public String getFullLocationFileName(String string, String string2) {
        this.ending = string;
        this.extension = string2;
        return this.getFullLocationFileName();
    }

    public String getBasicRoot() {
        return this.basicRoot;
    }

    public String getEnding() {
        return this.ending;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getRootName() {
        return this.basicRoot + this.getParameterName();
    }

    public String getRootLocationSimpleFileName(String string, String string2) {
        this.ending = string;
        this.extension = string2;
        return this.getRootLocationSimpleFileName();
    }

    public String getRootLocationSimpleFileName() {
        return this.rootDirectory.getPath() + File.separator + this.basicRoot + this.ending + "." + this.extension;
    }

    public String getParameterName() {
        if (this.parameterName.length() > 0) {
            return "_" + this.parameterName;
        }
        return "";
    }

    public boolean mkDirs() {
        return this.fullDirectory.mkdirs();
    }

    public void setNamesLocations(String string, String string2, String string3) {
        this.setRootDirectory(string);
        this.setSubDirectory(string2);
        this.setNameRoot(string3);
    }

    public void setNamesLocations(String string, String string2, String string3, String string4) {
        this.setRootDirectory(string);
        this.setSubDirectory(string2);
        this.basicRoot = string3;
        this.parameterName = string4;
    }

    public void setAll(String string, String string2, String string3, int n, String string4, String string5) {
        this.setNamesLocations(string, string2, string3);
        this.sequenceNumber = n;
        this.ending = string4;
        this.extension = string5;
    }

    public void setAll(String string, String string2, String string3, String string4, int n, String string5, String string6) {
        this.setNamesLocations(string, string2, string3, string4);
        this.sequenceNumber = n;
        this.ending = string5;
        this.extension = string6;
    }

    public void setRootDirectory(String string) {
        this.rootDirectory = new File(string);
    }

    public void setSubDirectory(String string) {
        this.fullDirectory = new File(this.rootDirectory.getPath() + File.separator + string);
    }

    public void setNextExistingSequenceNumber() {
        ++this.sequenceNumber;
        if (!this.isFullFile()) {
            this.sequenceNumber = 0;
        }
    }

    public void setFirstFreeSequenceNumber(int n) {
        int n2 = this.sequenceNumber = n > 0 ? n : 0;
        while (this.getFullLocationFile().isFile()) {
            ++this.sequenceNumber;
        }
    }

    public void setFirstFreeSequenceNumber() {
        this.sequenceNumber = 0;
        while (this.getFullLocationFile().isFile()) {
            ++this.sequenceNumber;
        }
    }

    public void setNoSequence() {
        this.sequenceNumber = -24680;
    }

    public String sequenceString() {
        if (this.sequenceNumber == -24680) {
            return "";
        }
        return SEQIND + this.sequenceNumber;
    }

    public void setFileLocationName(String string) {
        this.setAll("NOROOTDIR", "NOSUBDIR", "NONAMEROOT", -24680, "NOENDING", "NOEXT");
        try {
            File file = new File(string);
            if (file.isDirectory()) {
                this.rootDirectory = file.getParentFile();
                this.fullDirectory = file;
                return;
            }
            String string2 = file.getName();
            this.fullDirectory = file.getParentFile();
            this.rootDirectory = this.fullDirectory.getParentFile();
            this.setFileName(string2);
        }
        catch (RuntimeException runtimeException) {
            System.out.println(runtimeException);
        }
    }

    public void setFileLocationName(File file) {
        this.setAll("NOROOTDIR", "NOSUBDIR", "NONAMEROOT", -24680, "NOENDING", "NOEXT");
        try {
            if (file.isDirectory()) {
                this.rootDirectory = file.getParentFile();
                this.fullDirectory = file;
                return;
            }
            String string = file.getName();
            this.fullDirectory = file.getParentFile();
            this.rootDirectory = this.fullDirectory.getParentFile();
            if (file.isFile()) {
                this.setFileName(string);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void setFileLocationSimpleName(File file) {
        this.setAll("NOROOTDIR", "NOSUBDIR", "NONAMEROOT", -24680, "NOENDING", "NOEXT");
        try {
            if (file.isDirectory()) {
                this.rootDirectory = file.getParentFile();
                this.fullDirectory = file;
                return;
            }
            String string = file.getName();
            this.fullDirectory = file.getParentFile();
            this.rootDirectory = this.fullDirectory.getParentFile();
            if (file.isFile()) {
                this.setSimpleFileName(string);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void setFileName(String string) {
        try {
            int n;
            int n2 = string.lastIndexOf(46);
            if (n2 < 0) {
                n2 = string.length();
            } else {
                this.extension = string.substring(n2 + 1);
            }
            int n3 = string.indexOf(SEQIND);
            if (n3 < 0) {
                this.setNameRoot(string);
                return;
            }
            this.setNameRoot(string.substring(0, n3));
            int n4 = n = n3 + SEQIND.length();
            if (string.charAt(n4) == '-') {
                ++n4;
            }
            while (string.codePointAt(n4) > 47 && string.codePointAt(n4) < 58) {
                ++n4;
            }
            this.sequenceNumber = Integer.parseInt(string.substring(n, n4));
            this.ending = string.substring(n4, n2);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void setNameRoot(String string) {
        int n = string.indexOf(95);
        if (n < 0 || n + 1 >= string.length()) {
            this.basicRoot = string;
            this.parameterName = "";
        } else {
            this.basicRoot = string.substring(0, n);
            this.parameterName = string.substring(n + 1);
        }
    }

    public void setSimpleFileName(String string) {
        this.basicRoot = string;
        this.ending = "";
        int n = string.indexOf(95);
        if (n < 0 || n + 1 >= string.length()) {
            return;
        }
        this.basicRoot = string.substring(0, n);
        this.ending = string.substring(n + 1);
    }

    public boolean setParameterName(String string) {
        this.parameterName = string;
        return true;
    }

    public boolean setBasicRoot(String string) {
        if (string.length() > 0 && string.indexOf(95) > -1) {
            return false;
        }
        this.basicRoot = string;
        return true;
    }

    public boolean setEnding(String string) {
        if (string.length() > 1 && string.indexOf(SEQIND) > -1) {
            return false;
        }
        this.ending = string;
        return true;
    }

    public boolean setExtension(String string) {
        if (string.length() > 0 && string.indexOf(46) > -1) {
            return false;
        }
        this.extension = string;
        return true;
    }

    public boolean set(String string) {
        try {
            switch (string.charAt(0)) {
                case 'r': {
                    this.setRootDirectory(string.substring(1));
                    return true;
                }
                case 's': {
                    this.setSubDirectory(string.substring(1));
                    return true;
                }
                case 'b': {
                    return this.setBasicRoot(string.substring(1));
                }
                case 'p': {
                    return this.setParameterName(string.substring(1));
                }
                case 'n': {
                    this.sequenceNumber = Integer.parseInt(string.substring(1));
                    return true;
                }
                case 't': {
                    return this.setEnding(string.substring(1));
                }
                case 'e': {
                    return this.setExtension(string.substring(1));
                }
            }
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return true;
    }

    public String setString(char c) {
        String string = "";
        switch (c) {
            case 'r': {
                string = "'r' = root directory path";
                break;
            }
            case 's': {
                string = "'s' = sub directory name (relative to root)";
                break;
            }
            case 'b': {
                string = "'b' = basic root of file names (no '_')";
                break;
            }
            case 'p': {
                string = "'p' = parameter string (will have '_' at start added when needed)";
                break;
            }
            case 'n': {
                string = "'n' = sequence or run number (integer)";
                break;
            }
            case 't': {
                string = "'t' = terminating or ending string (no '_r' allowed)";
                break;
            }
            case 'e': {
                string = "'e' = extension (no '.' allowed)";
                break;
            }
            default: {
                string = c + " is unknown";
            }
        }
        return string;
    }

    public void printSetStrings(PrintStream printStream, String string) {
        String string2 = "rsbpnte";
        for (int i = 0; i < string2.length(); ++i) {
            printStream.println(string + this.setString(string2.charAt(i)));
        }
    }

    private int getInt(String string, int n) {
        int n2 = -888888;
        int n3 = n;
        if (string.charAt(n3) == '-') {
            ++n3;
        }
        while (string.codePointAt(n3) > 47 && string.codePointAt(n3) < 58) {
            ++n3;
        }
        try {
            n2 = Integer.parseInt(string.substring(n, n3));
        }
        catch (RuntimeException runtimeException) {
            return -9999999;
        }
        return n2;
    }

    public boolean isRootLocationDirectory() {
        return this.rootDirectory.isDirectory();
    }

    public boolean isFullLocationDirectory() {
        return this.fullDirectory.isDirectory();
    }

    public boolean isFullFile() {
        return this.getFullLocationFile().isFile();
    }
}

