/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Edge;

import IslandNetworks.Edge.DistanceMetric;
import IslandNetworks.Edge.EdgeTypeSelection;
import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.IslandHamiltonian;
import IslandNetworks.IslandTransferMatrix;
import IslandNetworks.Vertex.IslandSite;
import IslandNetworks.Vertex.IslandSiteSet;
import TimUtilities.NumbersToString;
import TimUtilities.Permutation;
import TimUtilities.StatisticalQuantity;
import java.io.PrintStream;
import java.util.Random;

public class IslandEdgeSet {
    static final String IESVERSION = "IES080412";
    static final int STRUPDATE = 1000;
    public static double MAXSEPARATION = 8.8E22;
    static NumbersToString n2s = new NumbersToString(3);
    private int numberSites;
    private int numberEdges = -1;
    public EdgeMode edgeMode;
    private IslandEdge[][] edge;
    private int[] edgeWeightRankList;
    private double[] outEdgeStrength;
    private double[] inEdgeStrength;
    private int[] strengthInCount;
    private int[] strengthOutCount;
    public StatisticalQuantity[] edgeStats;
    public int maxEdgeWeightSource = -1;
    public int maxEdgeWeightTarget = -1;
    public DistanceMetric metric;
    public static int numberMetrics = 6;
    public double DijkstraMaxSep;
    public EdgeTypeSelection DisplayEdgeType;
    public double zeroColourFrac = 0.03;
    public double minColourFrac = 0.1;
    public double DisplayMaxEdgeScale = 1.0;
    public double displayMaximumEdgeWeight;
    public double displayMinimumEdgeWeight;
    public double displayZeroEdgeWeight;
    private double distanceDiameter = -1.0;
    private double separationDiameter = -1.0;

    public IslandEdgeSet(int n, double d) {
        this.numberSites = n;
        this.outEdgeStrength = new double[this.numberSites];
        this.inEdgeStrength = new double[this.numberSites];
        this.strengthInCount = new int[this.numberSites];
        this.strengthOutCount = new int[this.numberSites];
        this.edge = new IslandEdge[this.numberSites][this.numberSites];
        this.edgeMode = new EdgeMode(d);
        for (int i = 0; i < this.numberSites; ++i) {
            this.outEdgeStrength[i] = 0.0;
            this.inEdgeStrength[i] = 0.0;
            this.strengthInCount[i] = 1000;
            this.strengthOutCount[i] = 1000;
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j] = new IslandEdge();
            }
        }
        this.metric = new DistanceMetric(0);
        this.DijkstraMaxSep = MAXSEPARATION;
        this.DisplayEdgeType = new EdgeTypeSelection();
    }

    public IslandEdgeSet(IslandEdgeSet islandEdgeSet) {
        int n;
        this.numberSites = islandEdgeSet.numberSites;
        this.outEdgeStrength = new double[this.numberSites];
        this.inEdgeStrength = new double[this.numberSites];
        this.strengthInCount = new int[this.numberSites];
        this.strengthOutCount = new int[this.numberSites];
        this.edge = new IslandEdge[this.numberSites][this.numberSites];
        this.edgeMode = new EdgeMode(islandEdgeSet.edgeMode);
        for (n = 0; n < this.numberSites; ++n) {
            for (int i = 0; i < this.numberSites; ++i) {
                this.edge[n][i] = new IslandEdge(islandEdgeSet.edge[n][i]);
            }
        }
        for (n = 0; n < this.numberSites; ++n) {
            this.calcInStrength(n);
            this.calcOutStrength(n);
        }
        this.DisplayEdgeType = new EdgeTypeSelection(islandEdgeSet.DisplayEdgeType);
        this.edgeStats = new StatisticalQuantity[IslandEdge.numberVariables];
        for (n = 0; n < IslandEdge.numberVariables; ++n) {
            this.edgeStats[n] = new StatisticalQuantity(islandEdgeSet.edgeStats[n]);
        }
        this.maxEdgeWeightSource = islandEdgeSet.maxEdgeWeightSource;
        this.maxEdgeWeightTarget = islandEdgeSet.maxEdgeWeightTarget;
        this.metric = new DistanceMetric(islandEdgeSet.metric);
        this.DijkstraMaxSep = islandEdgeSet.DijkstraMaxSep;
        this.zeroColourFrac = islandEdgeSet.zeroColourFrac;
        this.minColourFrac = islandEdgeSet.minColourFrac;
        this.DisplayMaxEdgeScale = islandEdgeSet.DisplayMaxEdgeScale;
        this.displayMaximumEdgeWeight = islandEdgeSet.displayMaximumEdgeWeight;
        this.displayMinimumEdgeWeight = islandEdgeSet.displayMinimumEdgeWeight;
        this.displayZeroEdgeWeight = islandEdgeSet.displayZeroEdgeWeight;
    }

    public int getNumberSites() {
        return this.numberSites;
    }

    public int getIndex(int n, int n2) {
        return n * this.numberSites + n2;
    }

    public IslandEdge getEdge(int n, int n2) {
        return this.edge[n][n2];
    }

    public IslandEdge getEdge(int n) {
        return this.edge[n / this.numberSites][n % this.numberSites];
    }

    public int getSource(int n) {
        return n / this.numberSites;
    }

    public int getTarget(int n) {
        return n % this.numberSites;
    }

    public double getVariable(int n, int n2) {
        return this.getEdge(n).getVariable(n2);
    }

    public double getVariable(int n, int n2, int n3) {
        return this.edge[n][n2].getVariable(n3);
    }

    public double getVariable(int n, int n2, String string) {
        return this.edge[n][n2].getVariable(string);
    }

    public double getDisplayVariable(int n) {
        return this.getEdge(n).getVariable(this.DisplayEdgeType.getValueIndex());
    }

    public double getDisplayVariable(int n, int n2) {
        return this.getEdge(n, n2).getVariable(this.DisplayEdgeType.getValueIndex());
    }

    public double getEdgeDisplaySize(int n) {
        return this.getEdgeDisplaySize(this.getDisplayVariable(n) / this.displayMaximumEdgeWeight);
    }

    public double getEdgeDisplaySize(int n, int n2) {
        return this.getEdgeDisplaySize(this.getDisplayVariable(n, n2) / this.displayMaximumEdgeWeight);
    }

    private double getEdgeDisplaySize(double d) {
        if (d < this.minColourFrac) {
            d = d < this.zeroColourFrac ? 0.0 : this.zeroColourFrac;
        } else if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    public double getAverage(int n) {
        return this.edgeStats[n].getAverage();
    }

    public double getMaximum(int n) {
        return this.edgeStats[n].maximum;
    }

    public double getDisplayMaximum() {
        return this.edgeStats[this.DisplayEdgeType.getValueIndex()].maximum;
    }

    public double getEdgeValue(int n, int n2) {
        return this.edge[n][n2].getValue();
    }

    public double getEdgeWeight(int n, int n2) {
        return this.edge[n][n2].getWeight();
    }

    public double getEdgeValueSquared(int n, int n2) {
        double d = this.edge[n][n2].getValue();
        return d * d;
    }

    public double getEdgeColour(int n, int n2) {
        return this.edge[n][n2].getColour();
    }

    public double getEdgeDistance(int n, int n2) {
        return this.edge[n][n2].getDistance();
    }

    public double getDistanceDiameter() {
        if (this.distanceDiameter < 0.0) {
            for (int i = 0; i < this.numberSites; ++i) {
                for (int j = 0; j < this.numberSites; ++j) {
                    if (!(this.distanceDiameter < this.edge[i][j].getDistance())) continue;
                    this.distanceDiameter = this.edge[i][j].getDistance();
                }
            }
        }
        return this.distanceDiameter;
    }

    public double getSeparationDiameter() {
        if (this.separationDiameter < 0.0) {
            for (int i = 0; i < this.numberSites; ++i) {
                for (int j = 0; j < this.numberSites; ++j) {
                    if (!(this.separationDiameter < this.edge[i][j].getSeparation())) continue;
                    this.separationDiameter = this.edge[i][j].getSeparation();
                }
            }
        }
        return this.separationDiameter;
    }

    public double getEdgePotential1(int n, int n2) {
        return this.edge[n][n2].getEdgePotential1();
    }

    public double getEdgePotentialSeparation1(int n, int n2, IslandHamiltonian islandHamiltonian) {
        return this.edge[n][n2].getEdgePotentialSeparation1(islandHamiltonian);
    }

    public double getEdgeSeparation(int n, int n2) {
        return this.edge[n][n2].getSeparation();
    }

    public double getGeneCorrelation(int n, int n2) {
        return this.edge[n][n2].getGeneCorrelation();
    }

    public int getInDegree(int n) {
        int n2 = 0;
        for (int i = 0; i < this.numberSites; ++i) {
            if (!(this.edge[i][n].getValue() > 0.0)) continue;
            ++n2;
        }
        return n2;
    }

    public int getOutDegree(int n) {
        int n2 = 0;
        for (int i = 0; i < this.numberSites; ++i) {
            if (!(this.edge[n][i].getValue() > 0.0)) continue;
            ++n2;
        }
        return n2;
    }

    public double getOutEdgeStrength(int n) {
        return this.outEdgeStrength[n];
    }

    public double getInEdgeStrength(int n) {
        return this.inEdgeStrength[n];
    }

    public double setEdgeValueBounded(int n, int n2, double d) {
        double d2 = d - this.edge[n][n2].getValue();
        if (this.edgeMode.maxValueModeOn && d > this.edgeMode.maximumValue) {
            d = this.edgeMode.maximumValue;
            d2 = d - this.edge[n][n2].getValue();
        }
        if (this.edgeMode.outStrengthLimitOn && this.outEdgeStrength[n] + d2 > this.edgeMode.maximumValue) {
            d2 = this.edgeMode.maximumValue - this.outEdgeStrength[n];
            d = d2 + this.edge[n][n2].getValue();
        }
        if (d < 0.0) {
            d = 0.0;
            d2 = d - this.edge[n][n2].getValue();
        }
        this.edge[n][n2].setValue(d);
        int n3 = n2;
        this.strengthInCount[n3] = this.strengthInCount[n3] - 1;
        if (this.strengthInCount[n3] < 0) {
            this.calcInStrength(n2);
        } else {
            int n4 = n2;
            this.inEdgeStrength[n4] = this.inEdgeStrength[n4] + d2;
        }
        int n5 = n;
        this.strengthOutCount[n5] = this.strengthOutCount[n5] - 1;
        if (this.strengthOutCount[n5] < 0) {
            this.calcOutStrength(n);
        } else {
            int n6 = n;
            this.outEdgeStrength[n6] = this.outEdgeStrength[n6] + d2;
        }
        return d;
    }

    public double setEdgeValueNoBounds(int n, int n2, double d) {
        double d2 = d - this.edge[n][n2].getValue();
        this.edge[n][n2].setValue(d);
        int n3 = n2;
        this.strengthInCount[n3] = this.strengthInCount[n3] - 1;
        if (this.strengthInCount[n3] < 0) {
            this.calcInStrength(n2);
        } else {
            int n4 = n2;
            this.inEdgeStrength[n4] = this.inEdgeStrength[n4] + d2;
        }
        int n5 = n;
        this.strengthOutCount[n5] = this.strengthOutCount[n5] - 1;
        if (this.strengthOutCount[n5] < 0) {
            this.calcOutStrength(n);
        } else {
            int n6 = n;
            this.outEdgeStrength[n6] = this.outEdgeStrength[n6] + d2;
        }
        return d;
    }

    public void setVariable(int n, int n2, int n3, double d) {
        this.edge[n][n2].setVariable(n3, d);
    }

    public void setVariable(int n, int n2, double d) {
        this.edge[n / this.numberSites][n % this.numberSites].setVariable(n2, d);
    }

    public double setEdgeValue(int n, int n2, double d, double d2, double d3) {
        double d4 = this.edge[n][n2].getValue();
        double d5 = d - d4;
        if (this.outEdgeStrength[n] + d5 > d3) {
            return d4;
        }
        if (this.inEdgeStrength[n2] + d5 > d2) {
            return d4;
        }
        return this.setEdgeValueBounded(n, n2, d);
    }

    public double setEdgeColour(int n, int n2, double d) {
        this.edge[n][n2].setColour(d);
        return d;
    }

    public double setEdgeDistance(int n, int n2, double d) {
        this.edge[n][n2].setDistance(d);
        return d;
    }

    public double setGeneCorrelation(int n, int n2, double d) {
        this.edge[n][n2].setGeneCorrelation(d);
        return d;
    }

    public void setGeneCorrelations(IslandSiteSet islandSiteSet) {
        islandSiteSet.setGeneLengths();
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.setGeneCorrelation(i, j, islandSiteSet.getGeneCorrelation(i, j));
            }
        }
    }

    public double setEdgeSeparation(int n, int n2, double d) {
        this.separationDiameter = -1.0;
        this.edge[n][n2].setSeparation(d);
        return d;
    }

    public void setEdgeValues(double d) {
        this.setEdgeValuesZero();
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j || !(this.getEdgeDistance(i, j) > -9.18273645E8)) continue;
                this.setEdgeValueBounded(i, j, d);
            }
        }
    }

    public void setEdgeValuesZero() {
        for (int i = 0; i < this.numberSites; ++i) {
            this.outEdgeStrength[i] = 0.0;
            this.inEdgeStrength[i] = 0.0;
            this.strengthInCount[i] = 1000;
            this.strengthOutCount[i] = 1000;
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j].setValue(0.0);
            }
        }
    }

    public void setRandomEdgeValues(Random random) {
        if (this.edgeMode.binary) {
            this.setRandomBinaryEdgeValues(random);
            return;
        }
        this.setEdgeValuesZero();
        int n = -1;
        int n2 = -1;
        Permutation permutation = new Permutation(this.numberSites);
        for (int i = 0; i < this.numberSites; ++i) {
            double d = this.edgeMode.maximumValue;
            n = permutation.next();
            Permutation permutation2 = new Permutation(this.numberSites);
            for (int j = 0; j < this.numberSites; ++j) {
                n2 = permutation2.next();
                if (n != n2 && this.getEdgeDistance(n, n2) > -9.18273645E8) {
                    this.setEdgeValueBounded(n, n2, d * random.nextDouble());
                }
                if (!this.edgeMode.outStrengthLimitOn) continue;
                d = this.edgeMode.maximumValue - this.outEdgeStrength[n];
            }
        }
    }

    private void setRandomBinaryEdgeValues(Random random) {
        this.setEdgeValuesZero();
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j || !(this.getEdgeDistance(i, j) > -9.18273645E8)) continue;
                this.setEdgeValueBounded(i, j, random.nextBoolean() ? 1.0 : 0.0);
            }
        }
    }

    private double calcInStrength(int n) {
        this.strengthInCount[n] = 1000;
        double d = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            d += this.getEdgeValue(i, n);
        }
        return d;
    }

    private double calcOutStrength(int n) {
        this.strengthOutCount[n] = 1000;
        double d = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            d += this.getEdgeValue(n, i);
        }
        this.outEdgeStrength[n] = d;
        return d;
    }

    public double getInStrengthSquared(int n) {
        double d = 0.0;
        double d2 = -1.0;
        for (int i = 0; i < this.numberSites; ++i) {
            d2 = this.getEdgeValue(i, n);
            d += d2 * d2;
        }
        return d;
    }

    public double getOutStrengthSquared(int n) {
        double d = 0.0;
        double d2 = -1.0;
        for (int i = 0; i < this.numberSites; ++i) {
            d2 = this.getEdgeValue(n, i);
            d += d2 * d2;
        }
        return d;
    }

    public void setEdgePotential1(IslandHamiltonian islandHamiltonian) {
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j].setEdgePotential1(islandHamiltonian);
            }
        }
    }

    public void setUpEdgeDisplayValues(IslandSiteSet islandSiteSet) {
        int n = this.DisplayEdgeType.getValueIndex();
        this.calcStats(islandSiteSet, n);
        double d = -1.0;
        d = this.DisplayMaxEdgeScale > 0.0 ? this.DisplayMaxEdgeScale : this.edgeStats[n].maximum;
        this.displayZeroEdgeWeight = d * this.zeroColourFrac;
        this.displayMinimumEdgeWeight = d * this.minColourFrac;
        this.displayMaximumEdgeWeight = d;
    }

    public void setUpEdgeDisplayValues(IslandSiteSet islandSiteSet, double d) {
        this.setUpEdgeDisplayValues(islandSiteSet);
        int n = this.DisplayEdgeType.getValueIndex();
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.setEdgeColour(i, j, d * this.getVariable(i, j, n) / this.displayMaximumEdgeWeight);
                if (this.getEdgeColour(i, j) > d) {
                    this.setEdgeColour(i, j, d);
                }
                if (!(this.getEdgeColour(i, j) < d * this.minColourFrac)) continue;
                if (this.getEdgeColour(i, j) < d * this.zeroColourFrac) {
                    this.setEdgeColour(i, j, 0.0);
                    continue;
                }
                this.setEdgeColour(i, j, d * this.zeroColourFrac);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDijkstra(IslandSite[] islandSiteArray, double d) {
        double d2 = MAXSEPARATION * 1.0001;
        this.DijkstraMaxSep = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            int n;
            int n2 = i;
            double d3 = MAXSEPARATION;
            boolean[] blArray = new boolean[this.numberSites];
            for (n = 0; n < this.numberSites; ++n) {
                this.setEdgeSeparation(i, n, MAXSEPARATION);
                blArray[n] = true;
            }
            this.setEdgeSeparation(i, i, 0.0);
            for (n = 0; n < this.numberSites; ++n) {
                int n3;
                d3 = MAXSEPARATION;
                for (n3 = 0; n3 < this.numberSites; ++n3) {
                    if (!blArray[n3] || !(this.getEdgeSeparation(i, n3) < d3)) continue;
                    d3 = this.getEdgeSeparation(i, n3);
                    n2 = n3;
                }
                if (d3 == MAXSEPARATION) break;
                blArray[n2] = false;
                for (n3 = 0; n3 < this.numberSites; ++n3) {
                    if (!blArray[n3]) continue;
                    double d4 = this.getEdgeValue(n2, n3);
                    double d5 = d2;
                    switch (this.metric.getNumber()) {
                        case 5: {
                            double d6 = this.getEdgeDistance(n2, n3);
                            if (d6 <= d) {
                                d5 = d3 + this.getEdgeDistance(n2, n3);
                                break;
                            }
                            d5 = d3 + d6 / this.getEdgePotential1(n2, n3);
                            break;
                        }
                        case 4: {
                            d5 = d3 + 1.0 / (islandSiteArray[n2].getWeight() * d4);
                            break;
                        }
                        case 3: {
                            double d6 = this.getEdgeDistance(n2, n3);
                            if (d6 <= d) {
                                d5 = d3 + d6 / islandSiteArray[n2].getWeight();
                                break;
                            }
                            d5 = d3 + d6 / (this.getEdgePotential1(n2, n3) * (islandSiteArray[n2].getWeight() * d4));
                            break;
                        }
                        case 2: {
                            d5 = d3 + 1.0 / d4;
                            break;
                        }
                        case 1: {
                            double d6 = this.getEdgeDistance(n2, n3);
                            if (d6 <= d) {
                                d5 = d3 + d6;
                                break;
                            }
                            d5 = d3 + d6 / (this.getEdgePotential1(n2, n3) * d4);
                            break;
                        }
                        default: {
                            d5 = d3 + this.getEdgeDistance(n2, n3);
                        }
                    }
                    if (!(this.getEdgeSeparation(i, n3) > d5)) continue;
                    this.setEdgeSeparation(i, n3, d5);
                    continue;
                }
            }
            if (!(this.DijkstraMaxSep < d3)) continue;
            this.DijkstraMaxSep = d3;
        }
    }

    public int getEdgeGivenValueRank(int n) {
        if (this.numberEdges < 0) {
            this.calcEdgeValueOrder();
        }
        return this.edgeWeightRankList[n];
    }

    public void setEdgeWeights(IslandSiteSet islandSiteSet) {
        for (int i = 0; i < this.numberSites; ++i) {
            double d = islandSiteSet.getWeight(i);
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j].setWeight(this.getEdgeValue(i, j) * d);
            }
        }
    }

    public void calcStats(IslandSiteSet islandSiteSet) {
        this.edgeStats = new StatisticalQuantity[IslandEdge.numberVariables];
        for (int i = 0; i < IslandEdge.numberVariables; ++i) {
            this.calcStats(islandSiteSet, i);
        }
    }

    public void calcStats(IslandSiteSet islandSiteSet, int n) {
        if (n == IslandEdge.weightINDEX) {
            this.setEdgeWeights(islandSiteSet);
        }
        this.calcStats(n);
    }

    public void calcStats(int n) {
        if (this.edgeStats == null) {
            this.edgeStats = new StatisticalQuantity[IslandEdge.numberVariables];
        }
        if (!this.isSet(1, n)) {
            return;
        }
        this.edgeStats[n] = new StatisticalQuantity(1.23E34, -1.0);
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                double d = this.getVariable(i, j, n);
                if (n == IslandEdge.weightINDEX && d > this.edgeStats[n].maximum) {
                    this.maxEdgeWeightSource = i;
                    this.maxEdgeWeightTarget = j;
                }
                this.edgeStats[n].add(d);
            }
        }
    }

    public boolean isSet(int n, int n2) {
        return this.getEdge(n).isSet(n2);
    }

    public void setInfluenceWeight(IslandSiteSet islandSiteSet, IslandTransferMatrix islandTransferMatrix) {
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j].setInfluenceWeight(islandTransferMatrix.getInfluence(j, i) * islandSiteSet.getWeight(i));
            }
        }
        this.calcStats(IslandEdge.influenceWeightINDEX);
    }

    public String displaySizeString(String string, String string2) {
        return "ew zero" + string + this.displayZeroEdgeWeight + string2 + "ew min" + string + this.displayMinimumEdgeWeight + string2 + "ew max" + string + this.displayMaximumEdgeWeight;
    }

    public String toGraphToolTipString(int n, String string, String string2, int n2) {
        String string3 = "Source" + string + this.getSource(n) + string2 + "Target" + string + this.getTarget(n);
        int n3 = this.DisplayEdgeType.getValueIndex();
        if (this.getEdge(n).isSet(n3)) {
            string3 = string3 + string2 + IslandEdge.name[n3] + string + n2s.TruncDecimal(this.getVariable(n, n3), n2);
        }
        return string3;
    }

    public String toString(int n, String string, String string2, int n2) {
        String string3 = "Source/Target" + string + this.getSource(n) + " " + this.getTarget(n) + string2;
        for (int i = 0; i < IslandEdge.numberVariables; ++i) {
            if (!this.getEdge(n).isSet(i)) continue;
            string3 = string3 + IslandEdge.name[i] + string + this.getVariable(n, i) + string2;
        }
        return string3;
    }

    public String getEdgeString(int n, int n2, String string, int n3) {
        return this.edge[n][n2].toString(string, n3);
    }

    public void printList(PrintStream printStream, String string, String string2, int n, boolean bl) {
        if (bl) {
            printStream.println(string + "source" + string2 + "Target" + string2 + IslandEdge.toStringLabel(string2));
        }
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                printStream.println(i + string2 + j + string2 + this.edge[i][j].toString(string2, n));
            }
        }
    }

    public void printParameterList(PrintStream printStream, String string, String string2, int n, boolean bl) {
        if (bl) {
            printStream.println(string + IslandEdge.parameterNames(string2));
        }
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                printStream.println(this.edge[i][j].parameterString(string2, n));
            }
        }
    }

    public void printParameterNames(PrintStream printStream, String string) {
        printStream.println(IslandEdge.parameterNames(string));
    }

    public void printValueBareTable(PrintStream printStream, String string, int n) {
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                printStream.print(this.edge[i][j].getValue() + string);
            }
            printStream.println();
        }
    }

    public void printDistanceBareTable(PrintStream printStream, String string, int n) {
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                printStream.print(this.edge[i][j].getDistance() + string);
            }
            printStream.println();
        }
    }

    public void printEdgeFullTable(String string, PrintStream printStream, String string2, int n, String string3, IslandSiteSet islandSiteSet) {
        int n2;
        int n3;
        double[] dArray = new double[this.numberSites];
        String string4 = "";
        double[] dArray2 = new double[this.numberSites];
        double[] dArray3 = new double[this.numberSites];
        for (n3 = 0; n3 < this.numberSites; ++n3) {
            string4 = string4 + "---" + string2;
        }
        printStream.println(string + "EDGE " + string3 + string4);
        printStream.print("From/to");
        for (n3 = 0; n3 < this.numberSites; ++n3) {
            dArray[n3] = 0.0;
        }
        for (n3 = 0; n3 < this.numberSites; ++n3) {
            printStream.print(string2 + islandSiteSet.getName(n3));
        }
        printStream.println(string2 + "Total Out" + string2 + "Total^2 Out");
        for (n3 = 0; n3 < this.numberSites; ++n3) {
            double d = 0.0;
            double d2 = 0.0;
            printStream.print(islandSiteSet.getName(n3));
            int n4 = 0;
            while (n4 < this.numberSites) {
                if (n3 == 0) {
                    dArray2[n4] = 0.0;
                    dArray3[n4] = 0.0;
                }
                double d3 = this.getVariable(n3, n4, string3);
                d += d3;
                d2 += d3 * d3;
                int n5 = n4;
                dArray2[n5] = dArray2[n5] + d3;
                int n6 = n4++;
                dArray3[n6] = dArray3[n6] + d3 * d3;
                printStream.print(string2 + n2s.TruncDecimal(d3, n));
            }
            printStream.println(string2 + n2s.TruncDecimal(d, n) + string2 + n2s.TruncDecimal(d2, n));
        }
        printStream.print("Total In");
        double d = 0.0;
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            d += dArray2[n2];
            printStream.print(string2 + n2s.TruncDecimal(dArray2[n2], n));
        }
        printStream.println(string2 + n2s.TruncDecimal(d, n));
        printStream.print("Total^2 In");
        d = 0.0;
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            d += dArray3[n2];
            printStream.print(string2 + n2s.TruncDecimal(dArray3[n2], n));
        }
        printStream.println(string2 + n2s.TruncDecimal(d, n));
    }

    public void printGeneCorrelationFullTable(String string, PrintStream printStream, String string2, int n, IslandSiteSet islandSiteSet) {
        int n2;
        double[] dArray = new double[this.numberSites];
        String string3 = "";
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            string3 = string3 + "---" + string2;
        }
        printStream.println(string + "EDGE GENE CORRELATIONS" + string3);
        printStream.print("From/to");
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            dArray[n2] = 0.0;
        }
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.print(string2 + islandSiteSet.getName(n2));
        }
        printStream.println();
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.print(islandSiteSet.getName(n2));
            for (int i = 0; i < this.numberSites; ++i) {
                printStream.print(string2 + n2s.TruncDecimal(this.getGeneCorrelation(n2, i), n));
            }
            printStream.println();
        }
    }

    public void calcEdgeValueOrder() {
        int n;
        Random random = new Random();
        this.numberEdges = this.numberSites * this.numberSites;
        this.edgeWeightRankList = new int[this.numberEdges];
        for (n = 0; n < this.numberEdges; ++n) {
            this.edgeWeightRankList[n] = n;
        }
        for (int i = 0; i < this.numberEdges; ++i) {
            int n2 = random.nextInt(this.numberEdges);
            if (n2 == i) continue;
            n = this.edgeWeightRankList[n2];
            this.edgeWeightRankList[n2] = this.edgeWeightRankList[i];
            this.edgeWeightRankList[i] = n;
        }
        this.QuickSort(this.edgeWeightRankList, 0, this.numberEdges - 1);
    }

    private void QuickSort(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            int n5 = (n + n2) / 2;
            double d = this.edge[n5 / this.numberSites][n5 % this.numberSites].getValue();
            while (n3 <= n4) {
                while (n3 < n2 && this.edge[nArray[n3] / this.numberSites][nArray[n3] % this.numberSites].getValue() < d) {
                    ++n3;
                }
                while (n4 > n && this.edge[nArray[n4] / this.numberSites][nArray[n4] % this.numberSites].getValue() > d) {
                    --n4;
                }
                if (n3 > n4) continue;
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.QuickSort(nArray, n, n4);
            }
            if (n3 < n2) {
                this.QuickSort(nArray, n3, n2);
            }
        }
    }

    public class EdgeMode {
        public boolean binary;
        public boolean maxValueModeOn;
        public boolean outStrengthLimitOn;
        public double maximumValue;

        public EdgeMode(double d) {
            this.setEdgeMode(d);
        }

        public EdgeMode(EdgeMode edgeMode) {
            this.binary = edgeMode.binary;
            this.maxValueModeOn = edgeMode.maxValueModeOn;
            this.outStrengthLimitOn = edgeMode.outStrengthLimitOn;
            this.maximumValue = edgeMode.maximumValue;
        }

        public void setEdgeMode(double d) {
            if (d == 0.0) {
                this.setBinaryModeOn();
            } else if (d > 0.0) {
                this.setMaxValueModeOn(d);
            } else {
                this.setMaxOutStrengthModeOn(d);
            }
        }

        public void setBinaryModeOn() {
            this.binary = true;
            this.maxValueModeOn = false;
            this.outStrengthLimitOn = false;
            this.maximumValue = 1.0;
        }

        public void setMaxValueModeOn(double d) {
            this.binary = false;
            this.maxValueModeOn = true;
            this.outStrengthLimitOn = false;
            this.maximumValue = Math.abs(d);
        }

        public void setMaxOutStrengthModeOn(double d) {
            this.binary = false;
            this.maxValueModeOn = false;
            this.outStrengthLimitOn = true;
            this.maximumValue = Math.abs(d);
        }

        public String description() {
            String string = "";
            if (this.binary) {
                string = string + "Binary Edge Values";
            }
            if (this.maxValueModeOn) {
                string = string + "Maximum Edge Value " + this.maximumValue;
            }
            if (this.outStrengthLimitOn) {
                string = string + "Limits on Out Strength " + this.maximumValue;
            }
            return string;
        }

        public double edgeModeValue() {
            double d = -9.87654321E8;
            if (this.binary) {
                d = 0.0;
            }
            if (this.maxValueModeOn) {
                d = this.maximumValue;
            }
            if (this.outStrengthLimitOn) {
                d = -this.maximumValue;
            }
            return d;
        }
    }
}

