/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Edge;

import IslandNetworks.IslandHamiltonian;
import TimUtilities.NumbersToString;

public class IslandEdge {
    static final String IEVERSION = "IE060728";
    static final double DUNSET = -9.7531E92;
    static final int IUNSET = -97531;
    static final double MAXDISTANCE = 99999.0;
    static final int UNIQUENAME = 3;
    static final String[] name = new String[]{"value", "weight", "distance", "potential1", "geneCorrelation", "separation", "influenceWeight"};
    static final int numberVariables = name.length;
    public double[] valueArray = new double[name.length];
    public static final int valueINDEX = IslandEdge.getIndex("value");
    public static final int weightINDEX = IslandEdge.getIndex("weight");
    public static final int distanceINDEX = IslandEdge.getIndex("distance");
    public static final int potential1INDEX = IslandEdge.getIndex("potential1");
    public static final int geneCorrelationINDEX = IslandEdge.getIndex("geneCorrelation");
    public static final int influenceWeightINDEX = IslandEdge.getIndex("influenceWeight");
    public static final int separationINDEX = IslandEdge.getIndex("separation");
    static final String[] parameterName = new String[]{"value", "distance", "geneCorrelation"};

    public IslandEdge() {
        for (int i = 0; i < numberVariables; ++i) {
            this.valueArray[i] = -9.7531E92;
        }
    }

    public IslandEdge(IslandEdge islandEdge) {
        for (int i = 0; i < numberVariables; ++i) {
            this.valueArray[i] = islandEdge.valueArray[i];
        }
    }

    public boolean isGeneCorrelationSet() {
        return this.valueArray[geneCorrelationINDEX] != -9.7531E92;
    }

    public boolean isSet(int n) {
        return this.valueArray[n] != -9.7531E92;
    }

    public double getVariable(String string) {
        return this.getVariable(IslandEdge.getIndex(string));
    }

    public double getVariable(int n) {
        return this.valueArray[n];
    }

    public static int getIndex(String string) {
        String string2 = string.substring(0, 3);
        for (int i = 0; i < numberVariables; ++i) {
            if (!name[i].startsWith(string2)) continue;
            return i;
        }
        return -1;
    }

    public double getValue() {
        return this.valueArray[valueINDEX];
    }

    public double getWeight() {
        return this.valueArray[weightINDEX];
    }

    public double getColour() {
        return -9.7531E92;
    }

    public double getDistance() {
        return this.valueArray[distanceINDEX];
    }

    public double getGeneCorrelation() {
        return this.isGeneCorrelationSet() ? this.valueArray[geneCorrelationINDEX] : 1.0;
    }

    public double getSeparation() {
        return this.valueArray[separationINDEX];
    }

    public void setValue(double d) {
        this.valueArray[IslandEdge.valueINDEX] = d;
    }

    public void setWeight(double d) {
        this.valueArray[IslandEdge.weightINDEX] = d;
    }

    public void setColour(double d) {
    }

    public void setDistance(double d) {
        this.valueArray[IslandEdge.distanceINDEX] = d;
    }

    public void setGeneCorrelation(double d) {
        this.valueArray[IslandEdge.geneCorrelationINDEX] = d;
    }

    public void setSeparation(double d) {
        this.valueArray[IslandEdge.separationINDEX] = d;
    }

    public void setInfluenceWeight(double d) {
        this.valueArray[IslandEdge.influenceWeightINDEX] = d;
    }

    public void setVariable(int n, double d) {
        this.valueArray[n] = d;
    }

    public static boolean checkIndex(int n) {
        return n >= 0 && n < name.length;
    }

    public double getEdgePotentialSeparation1(IslandHamiltonian islandHamiltonian) {
        return islandHamiltonian.edgePotential1(this.valueArray[separationINDEX], this.valueArray[geneCorrelationINDEX]);
    }

    public double getEdgePotential1() {
        return this.valueArray[potential1INDEX];
    }

    public double setEdgePotential1(IslandHamiltonian islandHamiltonian) {
        this.valueArray[IslandEdge.potential1INDEX] = this.isGeneCorrelationSet() ? islandHamiltonian.edgePotential1(this.valueArray[distanceINDEX], this.valueArray[geneCorrelationINDEX]) : islandHamiltonian.edgePotential1(this.valueArray[distanceINDEX], 1.0);
        return this.valueArray[potential1INDEX];
    }

    public static String dataName(int n) {
        if (n < 0 || n >= name.length) {
            return "value unknown";
        }
        return name[n];
    }

    public static String parameterName(int n) {
        if (n < 0 || n >= parameterName.length) {
            return "value unknown";
        }
        return parameterName[n];
    }

    public static String dataNameInformation(int n) {
        if (n < 0 || n >= name.length) {
            return "value unknown";
        }
        String string = name[n] + ": ";
        if (n == valueINDEX) {
            return string + "edge value derived from modelling";
        }
        if (n == weightINDEX) {
            return string + "edge weight (edge * source site) derived from modelling";
        }
        if (n == distanceINDEX) {
            return string + "geographical distance, may be in units of time";
        }
        if (n == potential1INDEX) {
            return string + "geographical distance potential term used in model one, includes lambda etc.";
        }
        if (n == geneCorrelationINDEX) {
            return string + "correlation between genes of source/target sites";
        }
        if (n == separationINDEX) {
            return string + "effective distance set for instance by Dijstra routines";
        }
        if (n == influenceWeightINDEX) {
            return string + "influence weight I_{ij}S_jv_j";
        }
        return string + " valid but no information given";
    }

    public String toString(String string, int n) {
        NumbersToString numbersToString = new NumbersToString(n);
        String string2 = "";
        for (int i = 0; i < name.length; ++i) {
            string2 = string2 + numbersToString.toString(this.getVariable(name[i])) + string;
        }
        return string2;
    }

    public static String toStringLabel(String string) {
        String string2 = "";
        for (int i = 0; i < name.length; ++i) {
            string2 = string2 + name[i] + string;
        }
        return string2;
    }

    public String parameterString(String string, int n) {
        NumbersToString numbersToString = new NumbersToString(n);
        String string2 = "";
        for (int i = 0; i < parameterName.length; ++i) {
            string2 = string2 + numbersToString.toString(this.getVariable(parameterName[i])) + string;
        }
        return string2;
    }

    public static String parameterNames(String string) {
        String string2 = "";
        for (int i = 0; i < parameterName.length; ++i) {
            string2 = string2 + parameterName[i] + string;
        }
        return string2;
    }
}

