/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.Edge.EdgeTypeSelection;
import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.InputParameterFrame;
import IslandNetworks.ProbabilityDistance;
import IslandNetworks.Vertex.VertexTypeSelection;
import IslandNetworks.islandNetwork;
import IslandNetworks.jungInterfaces.AriadneEdgePaintFunction;
import IslandNetworks.jungInterfaces.AriadneEdgeStrokeFunction;
import IslandNetworks.jungInterfaces.AriadneVertexPaintFunction;
import IslandNetworks.jungInterfaces.AriadneVertexShapeSizeAspect;
import IslandNetworks.jungInterfaces.ClickableVertexListener;
import IslandNetworks.jungInterfaces.EPSNetwork;
import IslandNetworks.jungInterfaces.EdgePercolationClusterer;
import IslandNetworks.jungInterfaces.GeographicalLayout;
import IslandNetworks.jungInterfaces.GraphML;
import IslandNetworks.jungInterfaces.GraphToolTip;
import IslandNetworks.jungInterfaces.JpegNetwork;
import IslandNetworks.jungInterfaces.JungConverter;
import IslandNetworks.jungInterfaces.KKWeightedLayout;
import IslandNetworks.jungInterfaces.PrintableNetwork;
import TimUtilities.JavaColours;
import TimUtilities.NumbersToString;
import edu.uci.ics.jung.algorithms.cluster.EdgeBetweennessClusterer;
import edu.uci.ics.jung.algorithms.cluster.VertexClusterSet;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.ToolTipFunction;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberVertexValue;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphMouseListener;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.MultiPickedState;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.contrib.CircleLayout;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.subLayout.CircularSubLayout;
import edu.uci.ics.jung.visualization.subLayout.SubLayout;
import edu.uci.ics.jung.visualization.subLayout.SubLayoutDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClusteringWindow
extends JPanel {
    private static final Object ISLANDCLUSTERKEY = "ISLANDCLUSTERKEY";
    private static final int MAXSLIDERVALUE = 100;
    private static final double DMAXSLIDERVALUE = 100.0;
    static final NumbersToString n2s = new NumbersToString(3);
    private double defaultEdgeFraction = 0.5;
    private String edgeFractionSliderString = "NONE";
    private int sliderValue = 50;
    private int isliderValue = 50;
    private Float minEdgeDisplaySize = Float.valueOf(0.0f);
    private Float maxEdgeDisplaySize = Float.valueOf(10.0f);
    private static final float MAXEDGESTROKESIZE = 20.0f;
    private Integer maxVertexDisplaySize = 3;
    private static final int MAXVERTEXDISPLAYSIZE = 40;
    private ClusterType clusterType;
    private LayoutType layoutType;
    AriadneVertexShapeSizeAspect vShapeSizeAspect;
    AriadneVertexPaintFunction vertexPaintFunction;
    AriadneEdgePaintFunction edgePaintFunction;
    AriadneEdgeStrokeFunction edgeStrokeFunction;
    public static final Color BACKGROUNDCOLOUR = Color.WHITE;
    public static final Color PERCREMOVEDCOLOUR = Color.LIGHT_GRAY;
    public static final Color REMOVEDCOLOUR = new Color(255, 255, 255, 0);
    private VisualizationViewer vv;
    private JungConverter jc;
    private int jpegCount = 0;
    private int gmlCount = 0;
    private islandNetwork inet;
    JavaColours javaColours = new JavaColours();
    public static final Color[] similarColors = new Color[]{new Color(216, 134, 134), new Color(135, 137, 211), new Color(134, 206, 189), new Color(206, 176, 134), new Color(194, 204, 134), new Color(145, 214, 134), new Color(133, 178, 209), new Color(103, 148, 255), new Color(60, 220, 220), new Color(30, 250, 100), new Color(30, 100, 250), new Color(220, 220, 60), new Color(250, 100, 30), new Color(100, 250, 30), new Color(220, 60, 220), new Color(100, 30, 250), new Color(250, 30, 100)};

    public ClusteringWindow(islandNetwork islandNetwork2, Dimension dimension) {
        int n = this.networkVisualisationSize(dimension.width, dimension.height);
        this.initialiseClusteringWindow(islandNetwork2, n);
        this.setUpView(n);
    }

    public ClusteringWindow() {
    }

    public void initialiseClusteringWindow(islandNetwork islandNetwork2, int n) {
        this.inet = islandNetwork2;
        this.inet.calcNetworkStats();
        this.jc = new JungConverter(this.inet);
        this.vertexPaintFunction = new AriadneVertexPaintFunction((PickedState)new MultiPickedState(), ISLANDCLUSTERKEY);
        this.vShapeSizeAspect = new AriadneVertexShapeSizeAspect(this.inet, 1);
        this.edgePaintFunction = new AriadneEdgePaintFunction(this.inet, ISLANDCLUSTERKEY, PERCREMOVEDCOLOUR);
        this.edgeStrokeFunction = new AriadneEdgeStrokeFunction(this.inet, ISLANDCLUSTERKEY, PERCREMOVEDCOLOUR, this.minEdgeDisplaySize, this.maxEdgeDisplaySize);
        this.clusterType = new ClusterType();
        this.layoutType = new LayoutType(n);
    }

    private Dimension networkVisualisationDimension() {
        int n = this.networkVisualisationSize(this.getWidth(), this.getHeight());
        return new Dimension(n, n);
    }

    private Dimension networkVisualisationDimension(Dimension dimension) {
        int n = this.networkVisualisationSize(dimension.width, dimension.height);
        return new Dimension(n, n);
    }

    private int networkVisualisationSize() {
        return this.networkVisualisationSize(this.getWidth(), this.getHeight());
    }

    private int networkVisualisationSize(int n, int n2) {
        return Math.max(Math.min(n, n2) - 100, 200);
    }

    public void start() {
        try {
            this.setUpView(this.networkVisualisationSize());
        }
        catch (Exception exception) {
            System.out.println("Error " + exception);
            exception.printStackTrace();
        }
    }

    public void setUpPrintableView(int n, int n2) {
        this.layoutType.setlayoutType("Geo");
        this.clusterType.setclusterType("Perc");
        this.defaultEdgeFraction = 3.0 / (double)this.inet.edgeSet.getNumberSites();
        this.setUpJungViewer(this.jc.getGraph(), new Dimension(n, n2));
        this.vv.setSize(n, n2);
    }

    public void setUpJungViewer(Graph graph, Dimension dimension) {
        MultiPickedState multiPickedState = new MultiPickedState();
        PluggableRenderer pluggableRenderer = new PluggableRenderer();
        this.vertexPaintFunction.setPickedState((PickedState)multiPickedState);
        pluggableRenderer.setVertexPaintFunction((VertexPaintFunction)this.vertexPaintFunction);
        pluggableRenderer.setVertexShapeFunction((VertexShapeFunction)this.vShapeSizeAspect);
        pluggableRenderer.setEdgePaintFunction((EdgePaintFunction)this.edgePaintFunction);
        pluggableRenderer.setEdgeStrokeFunction((EdgeStrokeFunction)this.edgeStrokeFunction);
        this.vv = new VisualizationViewer((Layout)this.layoutType.getLayoutType(graph), (Renderer)pluggableRenderer, dimension);
        this.vv.setBackground(BACKGROUNDCOLOUR);
        this.vv.setPickedState((PickedState)multiPickedState);
        this.vv.setSize(dimension);
    }

    private void setUpView(int n) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        System.out.println("--- jung VisualisationViewer size " + n);
        Dimension dimension3 = new Dimension(n, n);
        this.setUpJungViewer(this.jc.getGraph(), dimension3);
        DefaultModalGraphMouse defaultModalGraphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)defaultModalGraphMouse);
        this.vv.setPickSupport((PickSupport)new ShapePickSupport());
        this.vv.addGraphMouseListener((GraphMouseListener)new ClickableVertexListener(new UserDatumNumberVertexValue((Object)"IN_VIDKey"), this.inet.siteSet));
        GraphToolTip graphToolTip = new GraphToolTip(new UserDatumNumberVertexValue((Object)"IN_VIDKey"), this.inet.siteSet, new UserDatumNumberEdgeValue((Object)"IN_EIDKey"), this.inet.edgeSet);
        this.vv.setToolTipFunction((ToolTipFunction)graphToolTip);
        JPanel jPanel = new JPanel(new GridLayout(5, 2));
        JLabel jLabel = new JLabel("Vertex Display Size", 4);
        final JTextField jTextField = new JTextField(Double.toString(this.inet.DisplayMaxVertexScale), 4);
        jLabel.setToolTipText("Display size of vertices of weight 1.0, unless negative when absolute value sets size of largest valued vertex.");
        jTextField.setToolTipText("Display size of vertices of weight 1.0, unless negative when absolute value sets size of largest valued vertex.");
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ClusteringWindow)ClusteringWindow.this).inet.DisplayMaxVertexScale = Double.parseDouble(jTextField.getText());
                ClusteringWindow.this.setVertexDisplaySizes();
            }
        });
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        JLabel jLabel2 = new JLabel("edge weight zero", 4);
        String string = String.format("%8.6f", this.inet.edgeSet.displayZeroEdgeWeight);
        final JTextField jTextField2 = new JTextField(string, 4);
        jLabel2.setToolTipText("Minimum weight of edge shown in display");
        jTextField2.setToolTipText("Minimum weight of edge shown in display");
        jTextField2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayZeroEdgeWeight = Double.parseDouble(jTextField2.getText());
            }
        });
        jPanel.add(jLabel2);
        jPanel.add(jTextField2);
        JLabel jLabel3 = new JLabel("edge weight min", 4);
        final JTextField jTextField3 = new JTextField(Double.toString(this.inet.edgeSet.displayMinimumEdgeWeight), 4);
        jLabel3.setToolTipText("Maximum weight of any edges given the thinest displayed edge size");
        jTextField3.setToolTipText("Maximum weight of any edges given the thinest displayed edge size");
        jTextField3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMinimumEdgeWeight = Double.parseDouble(jTextField3.getText());
            }
        });
        jPanel.add(jLabel3);
        jPanel.add(jTextField3);
        JLabel jLabel4 = new JLabel("edge weight max", 4);
        final JTextField jTextField4 = new JTextField(Double.toString(this.inet.edgeSet.displayMaximumEdgeWeight), 4);
        jLabel4.setToolTipText("Thickest lines associated with edges of this edge weight or greater");
        jTextField4.setToolTipText("Thickest lines associated with edges of this edge weight or greater");
        jTextField4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMaximumEdgeWeight = Double.parseDouble(jTextField4.getText());
            }
        });
        jPanel.add(jLabel4);
        jPanel.add(jTextField4);
        JLabel jLabel5 = new JLabel("line width max", 4);
        jLabel5.setToolTipText("Maximum width of lines when drawing edges");
        final JTextField jTextField5 = new JTextField(this.maxEdgeDisplaySize.toString(), 4);
        jLabel5.setToolTipText("Maximum width of lines in display");
        jTextField5.setToolTipText("Maximum width of lines in display");
        jTextField5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringWindow.this.setMaxEdgeStrokeSize(Float.valueOf(Float.parseFloat(jTextField5.getText())));
            }
        });
        jPanel.add(jLabel5);
        jPanel.add(jTextField5);
        this.defaultEdgeFraction = 3.0 / (double)this.inet.edgeSet.getNumberSites();
        final JSlider jSlider = this.makePercentageSlider(new Dimension(210, 50), "Sets the proportion of black edges used to cluster vertices", this.defaultEdgeFraction);
        final JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(true);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(jSlider);
        final JToggleButton jToggleButton = new JToggleButton("Group Clusters");
        jToggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ClusteringWindow.this.clusterAndRecolor(ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()), jSlider.getValue(), similarColors, itemEvent.getStateChange() == 1);
            }
        });
        jToggleButton.setToolTipText("If button is depressed then network is coloured using clustering method");
        this.edgeFractionSliderString = "Clustering percentage: ";
        String string2 = this.edgeFractionSliderString + jSlider.getValue();
        final TitledBorder titledBorder = BorderFactory.createTitledBorder(string2);
        jPanel2.setBorder(titledBorder);
        jPanel2.add(Box.createVerticalGlue());
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    ClusteringWindow.this.sliderValue = jSlider.getValue();
                    ClusteringWindow.this.clusterAndRecolor(ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()), ClusteringWindow.this.sliderValue, similarColors, jToggleButton.isSelected());
                    titledBorder.setTitle(ClusteringWindow.this.edgeFractionSliderString + ClusteringWindow.this.sliderValue);
                    jPanel2.repaint();
                    ClusteringWindow.this.vv.validate();
                    ClusteringWindow.this.vv.repaint();
                }
            }
        });
        this.clusterAndRecolor(this.layoutType.getLayoutType(this.jc.getGraph()), jSlider.getValue(), similarColors, jToggleButton.isSelected());
        double d = 0.5;
        JSlider jSlider2 = this.makePercentageSlider(new Dimension(210, 50), "Sets the inluence probability", d);
        final JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(true);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(Box.createVerticalGlue());
        jPanel3.add(jSlider2);
        String string3 = "Influence probability percentage: " + jSlider2.getValue() + " (distance=" + ProbabilityDistance.probabilityToDistanceString((double)this.isliderValue / 100.0) + ")";
        final TitledBorder titledBorder2 = BorderFactory.createTitledBorder(string3);
        jPanel3.setBorder(titledBorder2);
        jPanel3.add(Box.createVerticalGlue());
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    ClusteringWindow.this.isliderValue = jSlider.getValue();
                    ClusteringWindow.this.inet.calcInfluence((double)ClusteringWindow.this.isliderValue / 100.0);
                    System.out.println("!!! Average Influence Weight= " + ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getAverage(IslandEdge.influenceWeightINDEX) + ", prob =" + ClusteringWindow.this.inet.getInfluenceProbability() + " (distance=" + ProbabilityDistance.probabilityToDistanceString((double)ClusteringWindow.this.isliderValue / 100.0) + ")");
                    titledBorder2.setTitle("Influence probability percentage: " + ClusteringWindow.this.isliderValue + " (distance=" + ProbabilityDistance.probabilityToDistanceString((double)ClusteringWindow.this.isliderValue / 100.0) + ")");
                    jPanel3.repaint();
                    ClusteringWindow.this.vv.validate();
                    ClusteringWindow.this.vv.repaint();
                }
            }
        });
        this.inet.calcInfluence((double)this.isliderValue / 100.0);
        final JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setToolTipText("Choose type of layout of network");
        for (int i = 0; i < this.layoutType.numberTypes; ++i) {
            jComboBox.addItem(this.layoutType.getString(i));
        }
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ClusteringWindow)ClusteringWindow.this).layoutType.value = jComboBox.getSelectedIndex();
                ClusteringWindow.this.vv.setGraphLayout((Layout)ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()));
                ClusteringWindow.this.vv.validate();
                ClusteringWindow.this.vv.repaint();
            }
        });
        jComboBox.setSelectedIndex(this.layoutType.value);
        final JComboBox<String> jComboBox2 = new JComboBox<String>();
        jComboBox2.setToolTipText("Choose Edge Selector");
        for (int i = 0; i < this.clusterType.numberTypes; ++i) {
            jComboBox2.addItem(this.clusterType.getString(i));
        }
        jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ClusteringWindow)ClusteringWindow.this).clusterType.value = jComboBox2.getSelectedIndex();
                ClusteringWindow.this.edgeFractionSliderString = ClusteringWindow.this.clusterType.getCurrentTypeString() + " clusterer percentage ";
                jSlider.setEnabled(!ClusteringWindow.this.clusterType.noVariableClustering());
                ClusteringWindow.this.vv.restart();
            }
        });
        jComboBox2.setSelectedIndex(this.clusterType.value);
        jSlider.setEnabled(!this.clusterType.noVariableClustering());
        final JComboBox<String> jComboBox3 = new JComboBox<String>();
        jComboBox3.setToolTipText("Choose type of vertex to display");
        for (int i = 0; i < VertexTypeSelection.numberTypes; ++i) {
            jComboBox3.addItem(VertexTypeSelection.name[i]);
        }
        jComboBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ClusteringWindow)ClusteringWindow.this).inet.DisplayVertexType.setValue(jComboBox3.getSelectedIndex());
                ClusteringWindow.this.setVertexDisplaySizes();
                ClusteringWindow.this.vv.restart();
            }
        });
        jComboBox3.setSelectedIndex(this.inet.DisplayVertexType.getValue());
        final JComboBox<String> jComboBox4 = new JComboBox<String>();
        jComboBox4.setToolTipText("Choose type of edge to display");
        for (int i = 0; i < EdgeTypeSelection.numberTypes; ++i) {
            jComboBox4.addItem(EdgeTypeSelection.name[i]);
        }
        jComboBox4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.DisplayEdgeType.setValue(jComboBox4.getSelectedIndex());
                ClusteringWindow.this.jc.replaceAllEdges();
                ClusteringWindow.this.vv.restart();
            }
        });
        jComboBox4.setSelectedIndex(this.inet.edgeSet.DisplayEdgeType.getValue());
        JButton jButton = new JButton("Redraw");
        jButton.setToolTipText("Redraw network using current parameter values");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringWindow.this.setVertexDisplaySizes(Double.parseDouble(jTextField.getText()), jComboBox3.getSelectedIndex());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayZeroEdgeWeight = Double.parseDouble(jTextField2.getText());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMinimumEdgeWeight = Double.parseDouble(jTextField3.getText());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMaximumEdgeWeight = Double.parseDouble(jTextField4.getText());
                ClusteringWindow.this.setMaxEdgeStrokeSize(Float.valueOf(Float.parseFloat(jTextField5.getText())));
                ClusteringWindow.this.clusterAndRecolor(ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()), ClusteringWindow.this.sliderValue, similarColors, jToggleButton.isSelected());
                ClusteringWindow.this.vv.setGraphLayout((Layout)ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()));
                ClusteringWindow.this.vv.restart();
                ClusteringWindow.this.vv.validate();
                ClusteringWindow.this.vv.repaint();
            }
        });
        JButton jButton2 = new JButton("Restart");
        jButton2.setToolTipText("Restart network drawing routines current parameter values");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringWindow.this.setVertexDisplaySizes(Double.parseDouble(jTextField.getText()), jComboBox3.getSelectedIndex());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayZeroEdgeWeight = Double.parseDouble(jTextField2.getText());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMinimumEdgeWeight = Double.parseDouble(jTextField3.getText());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMaximumEdgeWeight = Double.parseDouble(jTextField4.getText());
                ClusteringWindow.this.setMaxEdgeStrokeSize(Float.valueOf(Float.parseFloat(jTextField5.getText())));
                ClusteringWindow.this.jc.replaceAllEdges();
                ClusteringWindow.this.clusterAndRecolor(ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()), ClusteringWindow.this.sliderValue, similarColors, jToggleButton.isSelected());
                ClusteringWindow.this.setUpJungViewer(ClusteringWindow.this.jc.getGraph(), ClusteringWindow.this.networkVisualisationDimension());
                ClusteringWindow.this.vv.setGraphLayout((Layout)ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()));
                ClusteringWindow.this.vv.restart();
                ClusteringWindow.this.vv.validate();
                ClusteringWindow.this.vv.repaint();
                System.out.println("!!! Jung display has " + ClusteringWindow.this.jc.getNumberEdges() + " edges, width=" + ClusteringWindow.this.vv.getWidth() + ", height=" + ClusteringWindow.this.vv.getHeight());
            }
        });
        JButton jButton3 = new JButton("Reheat");
        jButton3.setToolTipText("Monte Carlo network reheating starting from current layout");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                islandNetwork islandNetwork2 = new islandNetwork(ClusteringWindow.this.inet);
                islandNetwork2.message.setInformationLevel(2);
                islandNetwork2.updateMode.setFromName("MC");
                islandNetwork2.monteCarloStartMode.setFromName("Old");
                InputParameterFrame inputParameterFrame = new InputParameterFrame(islandNetwork2);
            }
        });
        JButton jButton4 = new JButton("Info");
        jButton4.setToolTipText("Gives debugging information");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displaySizeString(": ", ", ") + ", max screen size:" + ClusteringWindow.this.maxEdgeDisplaySize + ",\n Clustering: " + ClusteringWindow.this.clusterType.getCurrentTypeString() + ", Layout: " + ClusteringWindow.this.layoutType.getCurrentTypeString();
                JOptionPane.showMessageDialog(null, string);
            }
        });
        JButton jButton5 = new JButton("GraphML");
        jButton5.setToolTipText("Writes a GraphML file for Visone");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringWindow.this.writeGMLImage(ClusteringWindow.this.vv);
            }
        });
        JButton jButton6 = new JButton("JPEG");
        jButton6.setToolTipText("Writes a jpeg file of network");
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringWindow.this.writeJPEGImage();
            }
        });
        JButton jButton7 = new JButton("EPS");
        jButton7.setToolTipText("Writes a eps file of network");
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringWindow.this.writeEPSImage();
            }
        });
        JButton jButton8 = new JButton("Print");
        jButton8.setToolTipText("Prints a jpeg file of network");
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintableNetwork printableNetwork = new PrintableNetwork(ClusteringWindow.this.vv, ClusteringWindow.this.inet.getNameString(", "));
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(printableNetwork);
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        JButton jButton9 = new JButton("Save");
        jButton9.setToolTipText("Saves files for this network ");
        jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringWindow.this.writeJPEGImage(ClusteringWindow.this.vv, ClusteringWindow.this.networkVisualisationDimension());
                ClusteringWindow.this.inet.saveFiles("#", 5);
            }
        });
        JPanel jPanel4 = new JPanel(new GridLayout(3, 3, 3, 3));
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel4.add(jButton3);
        jPanel4.add(jButton4);
        jPanel4.add(jToggleButton);
        jPanel4.add(jButton6);
        jPanel4.add(jButton7);
        jPanel4.add(jButton8);
        jPanel4.add(jButton9);
        JPanel jPanel5 = new JPanel(new GridLayout(4, 2));
        jPanel5.add(new JLabel("basic name:  ", 4));
        jPanel5.add(new JLabel(this.inet.outputFile.getBasicRoot(), 2));
        jPanel5.add(new JLabel("parameters:  ", 4));
        jPanel5.add(new JLabel(this.inet.outputFile.getParameterName(), 2));
        jPanel5.add(new JLabel("run:  ", 4));
        jPanel5.add(new JLabel("" + this.inet.outputFile.sequenceNumber, 2));
        jPanel5.add(new JLabel("energy:  ", 4));
        jPanel5.add(new JLabel(String.format("%10.4g", this.inet.globalProperties.getEnergy()), 2));
        JPanel jPanel6 = new JPanel(new GridLayout(2, 5));
        jPanel6.add(new JLabel("mu", 0));
        jPanel6.add(new JLabel("j", 0));
        jPanel6.add(new JLabel("k", 0));
        jPanel6.add(new JLabel("l", 0));
        jPanel6.add(new JLabel("s", 0));
        jPanel6.add(new JLabel(n2s.toString(this.inet.Hamiltonian.edgeSource), 0));
        jPanel6.add(new JLabel(n2s.toString(this.inet.Hamiltonian.vertexSource), 0));
        jPanel6.add(new JLabel(n2s.toString(this.inet.Hamiltonian.kappa), 0));
        jPanel6.add(new JLabel(n2s.toString(this.inet.Hamiltonian.lambda), 0));
        jPanel6.add(new JLabel(n2s.toString(this.inet.Hamiltonian.distanceScale), 0));
        JPanel jPanel7 = new JPanel(new GridLayout(2, 5));
        boolean bl = false;
        if (this.inet.vertexMode.maxValueModeOn && this.inet.siteSet.siteWeightStats.maximum > this.inet.vertexMode.maximumValue * 0.95) {
            bl = true;
        }
        jPanel7.add(new JLabel("<Sv>", 0));
        jPanel7.add(new JLabel("Sv.Max", 0));
        jPanel7.add(new JLabel("<Str.In> ", 0));
        JLabel jLabel6 = new JLabel("v.Max", 0);
        if (bl) {
            jLabel6.setForeground(Color.RED);
            jLabel6.setBackground(Color.BLACK);
            jLabel6.setOpaque(true);
        }
        jPanel7.add(jLabel6);
        jPanel7.add(new JLabel("E", 0));
        jPanel7.add(new JLabel(n2s.toString(this.inet.siteSet.siteWeightStats.getAverage()), 0));
        jPanel7.add(new JLabel(n2s.toString(this.inet.siteSet.siteWeightStats.maximum), 0));
        jPanel7.add(new JLabel(n2s.toString(this.inet.siteSet.siteStrengthInStats.getAverage()), 0));
        jLabel6 = new JLabel(n2s.toString(this.inet.siteSet.siteValueStats.maximum), 0);
        if (bl) {
            jLabel6.setForeground(Color.RED);
            jLabel6.setBackground(Color.BLACK);
            jLabel6.setOpaque(true);
        }
        jPanel7.add(jLabel6);
        jPanel7.add(new JLabel(String.format("%10.4g", this.inet.globalProperties.getEnergy()), 0));
        String string4 = this.inet.outputFile.getFullFileRoot();
        int n2 = Math.max(string4.length() * 6, 90);
        Box box = Box.createVerticalBox();
        Dimension dimension4 = new Dimension(Math.min(n / 2, dimension2.width - n), n);
        box.setPreferredSize(dimension4);
        box.add(jPanel5);
        box.add(jPanel6);
        box.add(jPanel7);
        box.add(jPanel4);
        box.add(jPanel2);
        box.add(jPanel3);
        JPanel jPanel8 = new JPanel(new GridLayout(5, 2, 3, 3));
        this.addJComboBoxToGrid(jPanel8, "Mouse Mode", defaultModalGraphMouse.getModeComboBox());
        this.addJComboBoxToGrid(jPanel8, "Clusterer", jComboBox2);
        this.addJComboBoxToGrid(jPanel8, "Layout", jComboBox);
        this.addJComboBoxToGrid(jPanel8, "Vertex Type", jComboBox3);
        this.addJComboBoxToGrid(jPanel8, "Edge Type", jComboBox4);
        box.add(jPanel8);
        box.add(jPanel);
        GraphZoomScrollPane graphZoomScrollPane = new GraphZoomScrollPane(this.vv);
        int n3 = this.networkVisualisationSize();
        graphZoomScrollPane.setSize(n3, n3);
        this.add((Component)graphZoomScrollPane);
        this.add(box);
    }

    private void addJComboBoxToGrid(JPanel jPanel, String string, JComboBox jComboBox) {
        JLabel jLabel = new JLabel(string, 4);
        jLabel.setToolTipText(jComboBox.getToolTipText());
        jPanel.add(jLabel);
        jPanel.add(jComboBox);
    }

    private JSlider makePercentageSlider(Dimension dimension, String string, double d) {
        JSlider jSlider = new JSlider(0);
        jSlider.setToolTipText(string);
        jSlider.setBackground(Color.WHITE);
        jSlider.setPreferredSize(dimension);
        jSlider.setPaintTicks(true);
        jSlider.setMaximum(100);
        jSlider.setMinimum(0);
        this.sliderValue = (int)(100.0 * d);
        jSlider.setValue(this.sliderValue);
        jSlider.setMinorTickSpacing(5);
        jSlider.setMajorTickSpacing(20);
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(true);
        return jSlider;
    }

    private void setMaxEdgeStrokeSize(Float f) {
        this.maxEdgeDisplaySize = f;
        if (this.maxEdgeDisplaySize.floatValue() < 0.0f) {
            this.maxEdgeDisplaySize = Float.valueOf(0.0f);
        }
        if (this.maxEdgeDisplaySize.floatValue() > 20.0f) {
            this.maxEdgeDisplaySize = Float.valueOf(20.0f);
        }
    }

    private void setVertexDisplaySizes(double d, int n) {
        this.inet.DisplayMaxVertexScale = d;
        this.inet.DisplayVertexType.setValue(n);
        this.setVertexDisplaySizes();
    }

    private void setVertexDisplaySizes() {
        this.inet.siteSet.setAllDisplaySizes(this.inet.DisplayVertexType.getValueIndex(), this.inet.DisplayMaxVertexScale);
    }

    public void clusterAndRecolor(SubLayoutDecorator subLayoutDecorator, int n, Color[] colorArray, boolean bl) {
        List list;
        VertexClusterSet vertexClusterSet;
        int n2;
        Graph graph = subLayoutDecorator.getGraph();
        subLayoutDecorator.removeAllSubLayouts();
        switch (this.clusterType.value) {
            case 2: {
                n2 = (int)(0.5 + (double)(graph.numEdges() * n) / 100.0);
                EdgeBetweennessClusterer edgeBetweennessClusterer = new EdgeBetweennessClusterer(n2);
                vertexClusterSet = edgeBetweennessClusterer.extract((ArchetypeGraph)graph);
                list = edgeBetweennessClusterer.getEdgesRemoved();
                break;
            }
            case 1: {
                EdgePercolationClusterer edgePercolationClusterer = new EdgePercolationClusterer((ArchetypeGraph)graph, this.inet);
                double d = this.inet.edgeSet.getDisplayMaximum() * 1.01010101 * (double)n / 100.0;
                vertexClusterSet = edgePercolationClusterer.extract(d);
                list = edgePercolationClusterer.getEdgesRemoved();
                break;
            }
            default: {
                list = new ArrayList();
                vertexClusterSet = new VertexClusterSet((ArchetypeGraph)graph);
                vertexClusterSet.addCluster(graph.getVertices());
            }
        }
        n2 = 0;
        for (Set set : vertexClusterSet) {
            Color color = colorArray[n2 % colorArray.length];
            this.colorCluster(set, color);
            if (bl) {
                this.groupCluster(subLayoutDecorator, set);
            }
            ++n2;
        }
        for (Set set : graph.getEdges()) {
            if (list.contains(set)) {
                set.setUserDatum(ISLANDCLUSTERKEY, PERCREMOVEDCOLOUR, UserData.REMOVE);
                continue;
            }
            set.setUserDatum(ISLANDCLUSTERKEY, Color.BLACK, UserData.REMOVE);
        }
    }

    private void colorCluster(Set set, Color color) {
        for (Vertex vertex : set) {
            vertex.setUserDatum(ISLANDCLUSTERKEY, (Object)color, UserData.REMOVE);
        }
    }

    private void groupCluster(SubLayoutDecorator subLayoutDecorator, Set set) {
        if (set.size() < subLayoutDecorator.getGraph().numVertices()) {
            Point2D point2D = subLayoutDecorator.getLocation((ArchetypeVertex)set.iterator().next());
            CircularSubLayout circularSubLayout = new CircularSubLayout((Collection)set, 20.0, point2D);
            subLayoutDecorator.addSubLayout((SubLayout)circularSubLayout);
        }
    }

    public void writeJPEGImage() {
        this.writeJPEGImage(this.vv, this.vv.getPreferredSize());
    }

    private void writeJPEGImage(VisualizationViewer visualizationViewer, Dimension dimension) {
        String string = this.inet.outputFile.getFullLocationFileRootSN() + "_sl" + this.sliderValue + "_j" + this.jpegCount++;
        this.inet.message.println(-1, "Attempting to write jpg file to " + string);
        String string2 = this.inet.getNameString(", ");
        JpegNetwork.writeJPEGImage(string, string2, visualizationViewer, dimension.width, dimension.height);
        this.writeJPEGDescriptionFile(string);
    }

    public void writeEPSImage() {
        this.writeEPSImage(this.vv, this.vv.getPreferredSize());
    }

    private void writeEPSImage(VisualizationViewer visualizationViewer, Dimension dimension) {
        String string = this.inet.outputFile.getFullLocationFileRootSN() + "_sl" + this.sliderValue + "_j" + this.jpegCount++;
        this.inet.message.println(-1, "Attempting to write eps file to " + string);
        String string2 = this.inet.getNameString(", ");
        boolean bl = true;
        EPSNetwork.FileOutputEPSNetwork(string, this.jc, visualizationViewer, bl, bl);
        this.writeImageDescriptionFile(string, "eps");
    }

    private void writeJPEGDescriptionFile(String string) {
        this.writeImageDescriptionFile(string, "jpg");
    }

    private void writeImageDescriptionFile(String string, String string2) {
        String string3 = string + "_" + string2 + "descr.dat";
        this.inet.message.println(-1, "Attempting to write description of " + string2 + " file to " + string3);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.inet.printiNVERSION("#", printStream);
            this.inet.showHamiltonianParameters(printStream);
            this.printDisplayVariables(printStream, "\t");
            try {
                fileOutputStream.close();
                if (this.inet.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string3);
                }
            }
            catch (IOException iOException) {
                System.err.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file " + string3);
            return;
        }
    }

    private void writeGMLImage(VisualizationViewer visualizationViewer) {
        String string = this.inet.outputFile.getFullLocationFileRootSN() + "_sl" + this.sliderValue + "_g" + this.gmlCount++;
        GraphML.FileOutputGMLNetwork(string + ".graphml", this.jc, visualizationViewer, true, true);
        this.writeGMLDescriptionFile(string);
    }

    private void writeGMLDescriptionFile(String string) {
        String string2 = string + "_gmldescr.dat";
        this.inet.message.println(-1, "Attempting to write description of graphMLfile to " + string2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.inet.printiNVERSION("#", printStream);
            this.inet.showHamiltonianParameters(printStream);
            this.printDisplayVariables(printStream, "\t");
            try {
                fileOutputStream.close();
                if (this.inet.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.err.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file " + string2);
            return;
        }
    }

    private void printDisplayVariables(PrintStream printStream, String string) {
        printStream.println("         Slider value " + string + this.sliderValue);
        printStream.println("            Clusterer " + string + this.clusterType.getCurrentTypeString());
        printStream.println("               Layout " + string + this.layoutType.getCurrentTypeString());
        printStream.println("     Vertex Displayed " + string + this.inet.DisplayVertexType.getCurrentTypeString());
        printStream.println(" defaultEdgeFractiont " + string + this.defaultEdgeFraction);
        printStream.println("        maxEdgeWeight " + string + this.inet.edgeSet.displayMinimumEdgeWeight);
        printStream.println("        minEdgeWeight " + string + this.inet.edgeSet.displayMinimumEdgeWeight);
        printStream.println("   maxEdgeDisplaySize " + string + this.maxEdgeDisplaySize);
        printStream.println("DisplayMaxVertexScale " + string + this.inet.DisplayMaxVertexScale);
        printStream.println(" maxVertexDisplaySize " + string + this.maxVertexDisplaySize);
    }

    private void writeJPEGImageOld(VisualizationViewer visualizationViewer) {
        String string = this.inet.outputFile.getFullLocationFileRoot() + "sl" + this.sliderValue + "_" + this.jpegCount++ + ".jpg";
        System.out.println("Attempting to write jpg file to " + string);
        File file = new File(string);
        int n = visualizationViewer.getWidth();
        int n2 = visualizationViewer.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        visualizationViewer.paint((Graphics)graphics2D);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(this.inet.Hamiltonian.inputParametersString(this.inet.outputFile.getBasicRoot(), ", ", 3), 2, n2 - 2);
        graphics2D.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class ClusterType {
        final String[] clusterTypeArray = new String[]{"Nothing", "Percolation", "Edge Betweenness"};
        public final int numberTypes = this.clusterTypeArray.length;
        public int value = 0;

        public void setclusterType(String string) {
            for (int i = 0; i < this.clusterTypeArray.length; ++i) {
                if (!this.clusterTypeArray[i].startsWith(string.substring(0, 1))) continue;
                this.value = i;
                return;
            }
            this.value = -1;
        }

        public String getString(int n) {
            if (n < 0 || n >= this.clusterTypeArray.length) {
                return "UNKNOWN";
            }
            return this.clusterTypeArray[n];
        }

        public String getCurrentTypeString() {
            return this.getString(this.value);
        }

        public boolean noVariableClustering() {
            return this.value == 0;
        }
    }

    private class LayoutType {
        final String[] layoutTypeArray = new String[]{"Geographical", "Circular", "KK Geographical", "KK Edge Value", "KK Edge Separation", "FR"};
        public final int numberTypes = this.layoutTypeArray.length;
        public int value = 0;
        public double scale = 1.0;

        public LayoutType(double d) {
            this.scale = d;
        }

        public void setlayoutType(String string) {
            for (int i = 0; i < this.layoutTypeArray.length; ++i) {
                if (!string.substring(0, 1).equals(this.layoutTypeArray[i].substring(0, 1))) continue;
                this.value = i;
                return;
            }
            this.value = -1;
        }

        public String getString(int n) {
            if (n < 0 || n >= this.layoutTypeArray.length) {
                return "UNKNOWN";
            }
            return this.layoutTypeArray[n];
        }

        public String getCurrentTypeString() {
            return this.getString(this.value);
        }

        private SubLayoutDecorator getLayoutType(Graph graph) {
            SubLayoutDecorator subLayoutDecorator;
            double d = 0.5;
            switch (this.value) {
                case 5: {
                    subLayoutDecorator = new SubLayoutDecorator((Layout)new FRLayout(graph));
                    break;
                }
                case 4: {
                    int n = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getNumberSites();
                    double d2 = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getSeparationDiameter();
                    double[][] dArray = new double[n][n];
                    double d3 = (1.0 + (double)ClusteringWindow.this.sliderValue) / 101.0;
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n; ++j) {
                            double d4 = (((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeSeparation(i, j) + ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeSeparation(j, i)) / (2.0 * d2);
                            dArray[i][j] = d4 > d3 ? 1.0 : d4;
                        }
                    }
                    subLayoutDecorator = new SubLayoutDecorator((Layout)new KKWeightedLayout(graph, dArray, d));
                    break;
                }
                case 3: {
                    int n = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getNumberSites();
                    double d5 = (1.0 + (double)ClusteringWindow.this.sliderValue) / 101.0;
                    double[][] dArray = new double[n][n];
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n; ++j) {
                            double d6 = (((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeValue(i, j) + ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeValue(j, i)) / 2.0;
                            dArray[i][j] = d6 < d5 ? 1.0 : d5 / d6;
                        }
                    }
                    subLayoutDecorator = new SubLayoutDecorator((Layout)new KKWeightedLayout(graph, dArray, d));
                    break;
                }
                case 2: {
                    int n = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getNumberSites();
                    double d7 = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getDistanceDiameter();
                    double[][] dArray = new double[n][n];
                    double d8 = (1.0 + (double)ClusteringWindow.this.sliderValue) / 101.0;
                    double d9 = 0.009900990099009901;
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n; ++j) {
                            double d10 = (((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeDistance(i, j) + ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeDistance(j, i)) / (2.0 * d7);
                            dArray[i][j] = d10 > d8 ? 1.0 : (d10 < d9 ? d9 : d10);
                            if (!(d10 <= 0.0)) continue;
                            System.err.println("Distance from " + i + " to " + j + " is negative or zero");
                        }
                    }
                    subLayoutDecorator = new SubLayoutDecorator((Layout)new KKWeightedLayout(graph, dArray, d));
                    break;
                }
                case 1: {
                    subLayoutDecorator = new SubLayoutDecorator((Layout)new CircleLayout(graph));
                    break;
                }
                default: {
                    subLayoutDecorator = new SubLayoutDecorator((Layout)new GeographicalLayout(graph, ClusteringWindow.this.jc.getXCoordKey(), ClusteringWindow.this.jc.getYCoordKey(), this.scale * 0.8, this.scale * 0.1));
                }
            }
            return subLayoutDecorator;
        }
    }
}

