/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.islandNetwork;
import IslandNetworks.jungInterfaces.EdgePercolationClusterer;
import IslandNetworks.jungInterfaces.JungConverter;
import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.MultiPickedState;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.contrib.CircleLayout;
import edu.uci.ics.jung.visualization.subLayout.CircularSubLayout;
import edu.uci.ics.jung.visualization.subLayout.SubLayout;
import edu.uci.ics.jung.visualization.subLayout.SubLayoutDecorator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CWTest
extends JPanel {
    private static final Object ISLANDCLUSTERKEY = "ISLANDCLUSTERKEY";
    private static final int MAXSLIDERVALUE = 100;
    private static final double maxEdgeValue = 1.0;
    private JungConverter jc;
    private islandNetwork inet;
    private int layoutType = 0;
    public final Color[] similarColors = new Color[]{new Color(216, 134, 134), new Color(135, 137, 211), new Color(134, 206, 189), new Color(206, 176, 134), new Color(194, 204, 134), new Color(145, 214, 134), new Color(133, 178, 209), new Color(103, 148, 255), new Color(60, 220, 220), new Color(30, 250, 100)};

    public CWTest(islandNetwork islandNetwork2) {
        this.jc = new JungConverter(this.inet);
        this.inet = islandNetwork2;
        this.layoutType = this.getLayoutType("circular");
        JTextField jTextField = new JTextField("testing JLabel class CWTest constructor");
        this.add(jTextField);
    }

    public void init() {
        JTextField jTextField = new JTextField("testing init");
        this.add(jTextField);
    }

    public void start() {
        JTextField jTextField = new JTextField("testing start");
        this.add(jTextField);
    }

    private void setUpView() {
        Graph graph = this.jc.getGraph();
        SubLayoutDecorator subLayoutDecorator = new SubLayoutDecorator((Layout)new CircleLayout(graph));
        MultiPickedState multiPickedState = new MultiPickedState();
        PluggableRenderer pluggableRenderer = new PluggableRenderer();
        pluggableRenderer.setVertexPaintFunction(new VertexPaintFunction((PickedState)multiPickedState){
            final /* synthetic */ PickedState val$ps;
            {
                this.val$ps = pickedState;
            }

            public Paint getFillPaint(Vertex vertex) {
                Color color = (Color)vertex.getUserDatum(ISLANDCLUSTERKEY);
                if (color != null) {
                    return color;
                }
                return Color.white;
            }

            public Paint getDrawPaint(Vertex vertex) {
                if (this.val$ps.isPicked((ArchetypeVertex)vertex)) {
                    return Color.cyan;
                }
                return Color.BLACK;
            }
        });
        pluggableRenderer.setEdgePaintFunction(new EdgePaintFunction(){

            public Paint getDrawPaint(Edge edge) {
                Color color = (Color)edge.getUserDatum(ISLANDCLUSTERKEY);
                if (color != null) {
                    return color;
                }
                return Color.blue;
            }

            public Paint getFillPaint(Edge edge) {
                return null;
            }
        });
        pluggableRenderer.setEdgeStrokeFunction(new EdgeStrokeFunction(){
            protected final Stroke THIN = new BasicStroke(1.0f);
            protected final Stroke THICK = new BasicStroke(2.0f);

            public Stroke getStroke(Edge edge) {
                Color color = (Color)edge.getUserDatum(ISLANDCLUSTERKEY);
                if (color == Color.LIGHT_GRAY) {
                    return this.THIN;
                }
                return this.THICK;
            }
        });
        VisualizationViewer visualizationViewer = new VisualizationViewer((Layout)subLayoutDecorator, (Renderer)pluggableRenderer, new Dimension(100, 100));
        visualizationViewer.setBackground(Color.yellow);
        JTextField jTextField = new JTextField("testing");
        this.add(jTextField);
    }

    public void clusterAndRecolor(SubLayoutDecorator subLayoutDecorator, int n, Color[] colorArray, boolean bl) {
        Graph graph = subLayoutDecorator.getGraph();
        subLayoutDecorator.removeAllSubLayouts();
        EdgePercolationClusterer edgePercolationClusterer = new EdgePercolationClusterer((ArchetypeGraph)graph, this.inet);
        double d = 1.0 * (double)n / 100.0;
        ClusterSet clusterSet = edgePercolationClusterer.extract(d);
        List list = edgePercolationClusterer.getEdgesRemoved();
        int n2 = 0;
        for (Set set : clusterSet) {
            Color color = colorArray[n2 % colorArray.length];
            this.colorCluster(set, color);
            if (bl) {
                this.groupCluster(subLayoutDecorator, set);
            }
            ++n2;
        }
        for (Set set : graph.getEdges()) {
            if (list.contains(set)) {
                set.setUserDatum(ISLANDCLUSTERKEY, Color.LIGHT_GRAY, UserData.REMOVE);
                continue;
            }
            set.setUserDatum(ISLANDCLUSTERKEY, Color.BLACK, UserData.REMOVE);
        }
    }

    private void colorCluster(Set set, Color color) {
        for (Vertex vertex : set) {
            vertex.setUserDatum(ISLANDCLUSTERKEY, (Object)color, UserData.REMOVE);
        }
    }

    private void groupCluster(SubLayoutDecorator subLayoutDecorator, Set set) {
        if (set.size() < subLayoutDecorator.getGraph().numVertices()) {
            Point2D point2D = subLayoutDecorator.getLocation((ArchetypeVertex)set.iterator().next());
            CircularSubLayout circularSubLayout = new CircularSubLayout((Collection)set, 20.0, point2D);
            subLayoutDecorator.addSubLayout((SubLayout)circularSubLayout);
        }
    }

    private int getLayoutType(String string) {
        if (string.substring(0, 1) == "g") {
            return 0;
        }
        if (string.substring(0, 1) == "c") {
            return 1;
        }
        if (string.substring(0, 1) == "f") {
            return 2;
        }
        return 0;
    }
}

