/*
 * Decompiled with CFR 0.152.
 */
package DistributionAnalysis;

import JavaNotes.TextReader;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class DistributionAnalysis {
    String DAVersion = "DistributionAnalysis050201";
    String nameroot;
    String dirname;
    String inputddext;
    String inputdiststatsext;
    double lbratio;
    boolean NormaliseDD;
    public int infolevel;
    int outputcontrol;
    int minDegreeRead;
    String[] filelist;
    String[] filenamerootlist;
    DoubleArrayList ddarr = new DoubleArrayList();
    DoubleArrayList ddlbarr = new DoubleArrayList();
    DoubleArrayList ddlberrarr = new DoubleArrayList();
    DoubleArrayList ddlbsizearr = new DoubleArrayList();
    DoubleArrayList btokarr = new DoubleArrayList();
    DoubleArrayList totddarr = new DoubleArrayList();
    DoubleArrayList totdd2arr = new DoubleArrayList();
    long Nvertices;
    long Nedges;
    int kmin;
    int kcont;
    int kmax;
    int totkmin;
    int totkcont;
    int totkmax;
    int nruns;
    OneParamStatistics diameter;
    OneParamStatistics totdistance;
    OneParamStatistics onesdistance;
    int diametermax;
    int diametermin;
    int diameterbigmin;
    int diameterbigmax;
    double diameterav;
    double diametererr;
    double diametersigma;
    double totdistanceav;
    double totdistanceerr;
    double totdistancesigma;
    double onesdistanceav;
    double onesdistanceerr;
    double onesdistancesigma;
    int columnnumber;
    int choosecolumnnumber;

    public DistributionAnalysis() {
        this.initialiseDistributionAnalysis("test", "/PRG/networks/DistributionAnalysis/output/", 1.1);
    }

    public DistributionAnalysis(String string, String string2, double d) {
        this.initialiseDistributionAnalysis(string, string2, d);
    }

    private void initialiseDistributionAnalysis(String string, String string2, double d) {
        this.nameroot = string;
        this.dirname = string2;
        this.lbratio = d;
        this.inputddext = ".Jdd.txt";
        this.inputdiststatsext = ".Jdiststat.txt";
        this.infolevel = 0;
        this.outputcontrol = 255;
        this.NormaliseDD = false;
        this.minDegreeRead = 1;
        this.nruns = 0;
        this.totkmin = 9999999;
        this.totkcont = -1;
        this.totkmax = -1;
        this.diameter = new OneParamStatistics();
        this.totdistance = new OneParamStatistics();
        this.onesdistance = new OneParamStatistics();
        this.diameterbigmin = this.totkmin;
        this.diameterbigmax = 0;
        this.columnnumber = 2;
        this.choosecolumnnumber = 2;
    }

    public static void main(String[] stringArray) {
        DistributionAnalysis distributionAnalysis = new DistributionAnalysis();
        int n = distributionAnalysis.ParamParse(stringArray);
        distributionAnalysis.print();
        if (n != 0) {
            return;
        }
        distributionAnalysis.processAll("#", distributionAnalysis.inputddext, "lb" + distributionAnalysis.inputddext, false);
        if ((distributionAnalysis.outputcontrol & 2) > 0) {
            distributionAnalysis.processDistanceAll("#", "diststats" + distributionAnalysis.inputddext);
        }
    }

    public int calcLBind() {
        return this.calcLBany(this.ddarr, this.kmin, this.kmax, 1);
    }

    public int calcLBtot() {
        return this.calcLBany(this.totddarr, this.totkmin, this.totkmax, this.nruns);
    }

    public int calcLBany(DoubleArrayList doubleArrayList, int n, int n2, int n3) {
        if (this.lbratio <= 1.0) {
            return 1;
        }
        int n4 = n2;
        if (doubleArrayList.size() <= n4) {
            n4 = doubleArrayList.size() - 1;
        }
        this.ddlbarr = new DoubleArrayList();
        this.ddlberrarr = new DoubleArrayList();
        this.ddlbsizearr = new DoubleArrayList();
        this.btokarr = new DoubleArrayList();
        int n5 = n;
        while (n5 <= n4) {
            int n6 = (int)((double)n5 * this.lbratio);
            this.btokarr.add((double)(n6 + n5) / 2.0);
            int n7 = n6 + 1 - n5;
            double d = 0.0;
            double d2 = 0.0;
            for (int i = n5; i <= n6 && i <= n4; ++i) {
                double d3 = doubleArrayList.get(i);
                d += d3;
                d2 += d3 * d3;
            }
            this.ddlbarr.add(d / (double)(n7 * n3));
            double d4 = n7 > 1 ? (d2 - d * d / (double)n7) / (double)(n7 * (n7 - 1)) : -1.0;
            double d5 = d4 > 0.0 ? Math.sqrt(d4) : 0.0;
            this.ddlberrarr.add(d5 / (double)n3);
            this.ddlbsizearr.add((double)n7);
            n5 = n6 + 1;
        }
        return 0;
    }

    public void calcNumbers(DoubleArrayList doubleArrayList) {
        this.Nedges = 0L;
        this.Nvertices = 0L;
        int n = 0;
        for (int i = 0; i < doubleArrayList.size(); ++i) {
            n = (int)(doubleArrayList.get(i) + 0.5);
            this.Nvertices += (long)n;
            this.Nedges += (long)(n * i);
        }
    }

    void FileOutputDegreeDistribution(String string, String string2) {
        String string3 = this.dirname + string + ".Jdd.txt";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintStream printStream = new PrintStream(fileOutputStream);
            Date date = new Date();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            printStream.println(string2 + " No.vertices:\t" + this.Nvertices + " No.edges:\t " + this.Nedges + "\t " + this.DAVersion + "\t " + date);
            printStream.println(string2 + " k \t n(k) \t gamma(k) ");
            for (int i = 0; i < this.ddarr.size(); ++i) {
                d = this.ddarr.get(i);
                if (!(d > 0.0)) continue;
                printStream.print(i + "\t " + d);
                if (d2 > 0.0 && d3 > 0.0) {
                    printStream.print("\t " + -Math.log(d2 / d) / Math.log(d3 / (double)i));
                }
                printStream.println();
                d2 = d;
                d3 = i;
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string3);
            return;
        }
    }

    void FileOutputDD(String string, String string2) {
        String string3 = this.NormaliseDD ? "norm" : "";
        String string4 = this.dirname + string2 + string3 + ".stddd.txt";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string4);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (this.infolevel > 0) {
                System.out.println(string + " writing data to " + string4);
            }
            Date date = new Date();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            printStream.println(string + " No.vertices:\t" + this.Nvertices + " No.edges:\t " + this.Nedges + "\t " + this.DAVersion + "\t " + date);
            printStream.println(string + " x \t n(x) \t gamma(x) \t Lines " + this.ddarr.size());
            for (int i = 0; i < this.ddarr.size(); ++i) {
                d = this.ddarr.get(i);
                if (!(d > 0.0)) continue;
                printStream.print(i + "\t " + d);
                if (d2 > 0.0 && d3 > 0.0) {
                    printStream.print("\t " + -Math.log(d2 / d) / Math.log(d3 / (double)i));
                }
                printStream.println();
                d2 = d;
                d3 = i;
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string4);
            return;
        }
    }

    void FileOutputLogBinDD(String string, String string2) {
        String string3 = this.dirname + string;
        try {
            double d;
            double d2;
            double d3;
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (this.infolevel > 0) {
                System.out.println(string2 + " writing log bin data to " + string3);
            }
            Date date = new Date();
            printStream.println(string2 + " Log Binned Degree Distribution ratio\t " + this.lbratio + "\t " + this.DAVersion + "\t " + date);
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 0; i < this.ddlbarr.size(); ++i) {
                d3 = this.ddlbarr.get(i);
                if (!(d3 > 0.0)) continue;
                d2 = this.btokarr.get(i);
                d = this.ddlbsizearr.get(i);
                d4 += d3 * d;
                d5 += d2 * d3 * d;
            }
            printStream.println(string2 + " N=\t " + this.Nvertices + "\t E= \t " + this.Nedges + "\t (from bins): \t Tot.Vertices \t" + d4 + "\t Tot.Edges \t" + d5);
            printStream.println(string2 + " k   \t   n(k)   \t   +/-   \t bin size dk \t gamma(k) \t n(k)*dk \t k*n(k)*dk \t log10(k)  \t log10(n(k))");
            double d6 = 0.0;
            double d7 = 0.0;
            for (int i = 0; i < this.ddlbarr.size(); ++i) {
                d3 = this.ddlbarr.get(i);
                if (!(d3 > 0.0)) continue;
                d2 = this.btokarr.get(i);
                double d8 = this.ddlberrarr.get(i);
                d = this.ddlbsizearr.get(i);
                printStream.print(d2 + "\t " + d3 + "\t " + d8 + "\t " + d);
                if (d6 > 0.0 && d7 > 0.0) {
                    printStream.print("\t " + -Math.log(d6 / d3) / Math.log(d7 / d2));
                }
                printStream.print("\t" + d3 * d + "\t" + d2 * d3 * d);
                if (d2 > 0.0) {
                    printStream.print("\t" + Math.log10(d2));
                } else {
                    printStream.print("\t ");
                }
                if (d3 > 0.0) {
                    printStream.print("\t" + Math.log10(d3));
                } else {
                    printStream.print("\t ");
                }
                printStream.println();
                d6 = d3;
                d7 = d2;
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Close Error " + string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string3);
        }
        if (this.infolevel > 0) {
            System.out.println("\n Finished Log Bin Output to " + string);
        }
    }

    public void FileOutputTotDD(String string, String string2) {
        String string3 = this.dirname + string;
        this.FileOutputTotDD(string3, string2, "\t");
    }

    public void FileOutputTotDD(String string, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (this.infolevel > 0) {
                System.out.println(string2 + " writing total DD data to  " + string3 + string);
            }
            Date date = new Date();
            printStream.println(string2 + " Total Degree Distribution for  " + string3 + this.nruns + string3 + "  runs of  " + string3 + string + string3 + "  " + this.DAVersion + string3 + "  " + date + " ");
            printStream.println(string2 + "k " + string3 + " <n(k)> " + string3 + " +/- " + string3 + " gamma(k)");
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this.totddarr.size(); ++i) {
                double d3 = this.totddarr.get(i) / (double)this.nruns;
                double d4 = this.nruns > 1 ? Math.sqrt((this.totdd2arr.get(i) - d3 * d3 * (double)this.nruns) / (double)(this.nruns * (this.nruns - 1))) : 0.0;
                if (!(d3 > 0.0)) continue;
                printStream.print(i + string3 + "  " + d3 + string3 + "  " + d4);
                if (d > 0.0 && d2 > 0.0) {
                    printStream.print(string3 + "  " + -Math.log(d / d3) / Math.log(d2 / (double)i));
                }
                printStream.println();
                d = d3;
                d2 = i;
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Close Error " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string);
        }
    }

    void FileOutputDistanceStats(String string, String string2) {
        String string3 = this.dirname + string;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (this.infolevel > 0) {
                System.out.println(string2 + " writing total DD data to \t" + string);
            }
            Date date = new Date();
            printStream.println(string2 + " Total Distance stats for \t" + this.diameter.number + "\t runs of \t" + string + "\t " + this.DAVersion + "\t " + date + " ");
            printStream.println(string2 + "Extremes of diameter: \t" + this.diameterbigmin + " \t " + this.diameterbigmin);
            this.diameter.print(printStream, "diameter");
            this.totdistance.print(printStream, "totdistance");
            this.onesdistance.print(printStream, "onesdistance");
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Close Error " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string);
        }
    }

    void FileOutputDistanceStatsExcel(String string, String string2) {
        String string3 = this.dirname + string;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (this.infolevel > 0) {
                System.out.println(string2 + " writing total DD data to \t" + string);
            }
            Date date = new Date();
            printStream.print(date + "\t " + string + " \t" + this.diameter.number);
            this.totdistance.printExcel(printStream, "totdistance");
            this.onesdistance.printExcel(printStream, "onesdistance");
            this.diameter.printExcel(printStream, "diameter");
            printStream.println();
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Close Error " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string);
        }
    }

    public void getFileList(String string) {
        File file = new File(this.dirname);
        if (!file.isDirectory()) {
            System.out.println(this.dirname + " not a directory");
            return;
        }
        if (this.infolevel > 0) {
            System.out.println("Looking at directory " + this.dirname);
        }
        OnlyOneParamSet onlyOneParamSet = new OnlyOneParamSet(this.nameroot, string);
        this.filelist = file.list(onlyOneParamSet);
        if (this.infolevel > 0) {
            System.out.println("Found  " + this.filelist.length + " files with extension " + string);
        }
        this.filenamerootlist = new String[this.filelist.length];
        for (int i = 0; i < this.filelist.length; ++i) {
            this.filenamerootlist[i] = this.getFileNameRoot(this.filelist[i], string);
            if (this.infolevel <= 0) continue;
            System.out.println(this.filelist[i] + "\t " + this.filenamerootlist[i]);
        }
    }

    public String getFileNameRoot(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    public void getDegreeDistribution(DoubleArrayList doubleArrayList) {
        this.kmin = 99999999;
        this.kcont = 99999999;
        this.kmax = -1;
        int n = doubleArrayList.size();
        this.ddarr = new DoubleArrayList(n);
        for (int i = 0; i < n; ++i) {
            double d = doubleArrayList.get(i);
            this.ddarr.add(d);
            if (i < this.kmin && d > 0.0) {
                this.kmin = i;
            }
            if (i > this.kmin && i < this.kcont && d == 0.0) {
                this.kcont = i;
            }
            if (i <= this.kmax || !(d > 0.0)) continue;
            this.kmax = i;
        }
    }

    public void getDegreeDistribution(IntArrayList intArrayList) {
        this.kmin = 99999999;
        this.kcont = 99999999;
        this.kmax = -1;
        int n = intArrayList.size();
        this.ddarr = new DoubleArrayList(n);
        for (int i = 0; i < n; ++i) {
            int n2 = intArrayList.get(i);
            this.ddarr.add((double)n2);
            if (i < this.kmin && n2 > 0) {
                this.kmin = i;
            }
            if (i > this.kmin && i < this.kcont && n2 == 0) {
                this.kcont = i;
            }
            if (i <= this.kmax || n2 <= 0) continue;
            this.kmax = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDDDataOld(String string, String string2) {
        TextReader textReader;
        String string3 = this.dirname + string;
        if (this.infolevel > 0) {
            System.out.println("Starting to Degree Distribution data from " + string3);
        }
        int n = 0;
        try {
            textReader = new TextReader(new FileReader(string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can't find file " + string);
            return 1;
        }
        try {
            if (this.infolevel > 0) {
                System.out.println(" File: " + string);
            }
            while (textReader.peek() == string2.charAt(0)) {
                String string4 = textReader.getln();
                if (this.infolevel <= 0) continue;
                System.out.println(string4);
            }
            this.ddarr = new DoubleArrayList();
            int n2 = 0;
            this.kmin = 99999999;
            this.kcont = 99999999;
            this.kmax = -1;
            while (!textReader.eof()) {
                int n3 = textReader.getInt();
                double d = textReader.getDouble();
                if (n3 < this.kmin && d > 0.0) {
                    this.kmin = n3;
                }
                if (n3 > this.kmin && n3 < this.kcont && d == 0.0) {
                    this.kcont = n3;
                }
                if (n3 > this.kmax && d > 0.0) {
                    this.kmax = n3;
                }
                while (n2 < n3) {
                    ++n2;
                    this.ddarr.add(0.0);
                }
                this.ddarr.add(d);
                ++n2;
            }
            if (this.infolevel > 0) {
                System.out.println("Finished " + string + "\t kmin,kcont,kmax = \t" + this.kmin + "\t " + this.kcont + "\t " + this.kmax);
            }
        }
        catch (TextReader.Error error) {
            System.out.println("Input Error: " + error.getMessage());
            n = 2;
        }
        finally {
            textReader.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDDData(String string, String string2) {
        TextReader textReader;
        String string3 = this.dirname + string;
        if (this.infolevel > 0) {
            System.out.println("Starting to Degree Distribution data from " + string3);
        }
        int n = 0;
        try {
            textReader = new TextReader(new FileReader(string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can't find file " + string);
            return 1;
        }
        try {
            if (this.infolevel > 0) {
                System.out.println(" File: " + string);
            }
            while (textReader.peek() == string2.charAt(0)) {
                String string4 = textReader.getln();
                if (this.infolevel <= 0) continue;
                System.out.println(string4);
            }
            this.ddarr = new DoubleArrayList();
            int n2 = 0;
            this.kmin = 99999999;
            this.kcont = 99999999;
            this.kmax = -1;
            while (!textReader.eof()) {
                double d;
                int n3 = (int)(0.5 + textReader.getDouble());
                double d2 = d = -99999.0;
                int n4 = 2;
                while (!textReader.eoln()) {
                    d2 = textReader.getDouble();
                    if (n4 == this.choosecolumnnumber) {
                        d = d2;
                    }
                    ++n4;
                }
                if (n3 < this.minDegreeRead) {
                    d = 0.0;
                }
                if (d < -99998.0) {
                    System.out.println("Error in getDDData at k=" + n3);
                    int n5 = 3;
                    return n5;
                }
                if (n3 < this.kmin && d > 0.0) {
                    this.kmin = n3;
                }
                if (n3 > this.kmin && n3 < this.kcont && d == 0.0) {
                    this.kcont = n3;
                }
                if (n3 > this.kmax && d > 0.0) {
                    this.kmax = n3;
                }
                while (n2 < n3) {
                    ++n2;
                    this.ddarr.add(0.0);
                }
                this.ddarr.add(d);
                ++n2;
            }
            if (this.infolevel > 0) {
                System.out.println("Finished " + string + "\t kmin,kcont,kmax = \t" + this.kmin + "\t " + this.kcont + "\t " + this.kmax);
            }
        }
        catch (TextReader.Error error) {
            if (this.infolevel > 0) {
                System.out.println("Input Error: " + error.getMessage());
            }
            n = 2;
        }
        finally {
            textReader.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDistStats(String string, String string2) {
        TextReader textReader;
        String string3 = this.dirname + string;
        if (this.infolevel > 0) {
            System.out.println("Starting to get Distance Statistics from " + string3);
        }
        int n = 0;
        try {
            textReader = new TextReader(new FileReader(string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can't find file " + string);
            return 1;
        }
        try {
            if (this.infolevel > 0) {
                System.out.println(" File: " + string);
            }
            while (textReader.peek() == string2.charAt(0)) {
                String string4 = textReader.getln();
                if (this.infolevel <= 0) continue;
                System.out.println(string4);
            }
            this.diametermax = textReader.getInt();
            this.diametermin = textReader.getInt();
            this.diameterav = textReader.getDouble();
            this.diametererr = textReader.getDouble();
            this.diametersigma = textReader.getlnDouble();
            this.totdistanceav = textReader.getDouble();
            this.totdistanceerr = textReader.getDouble();
            this.totdistancesigma = textReader.getlnDouble();
            this.onesdistanceav = textReader.getDouble();
            this.onesdistanceerr = textReader.getDouble();
            this.onesdistancesigma = textReader.getDouble();
            if (this.infolevel > 0) {
                System.out.println("Finished " + string);
            }
        }
        catch (TextReader.Error error) {
            System.out.println("Input Error: " + error.getMessage());
            n = 2;
        }
        finally {
            textReader.close();
        }
        return n;
    }

    void setDiameterData(int n, int n2, double d, double d2, double d3) {
        this.diametermax = n;
        this.diametermin = n2;
        this.diameterav = d;
        this.diametererr = d2;
        this.diametersigma = d3;
    }

    void setTotalDistanceData(double d, double d2, double d3) {
    }

    void setOneDistanceData(double d, double d2, double d3) {
    }

    public int ParamParse(String[] stringArray) {
        block10: for (int i = 0; i < stringArray.length; ++i) {
            if (this.infolevel > 0) {
                System.out.println("Parameter " + i + " is " + stringArray[i]);
            }
            if (stringArray[i].length() < 2) {
                System.out.println("\n*** Argument " + i + " is too short");
                return 1;
            }
            if (stringArray[i].charAt(0) != '-') {
                System.out.println("\n*** Argument " + i + " does not start with -");
                return 2;
            }
            switch (stringArray[i].charAt(1)) {
                case 'f': {
                    this.nameroot = stringArray[i].substring(2);
                    continue block10;
                }
                case 'd': {
                    this.dirname = stringArray[i].substring(2);
                    continue block10;
                }
                case 'e': {
                    this.inputddext = stringArray[i].substring(2);
                    continue block10;
                }
                case 'r': {
                    this.lbratio = Double.parseDouble(stringArray[i].substring(2));
                    continue block10;
                }
                case 'c': {
                    this.choosecolumnnumber = Integer.parseInt(stringArray[i].substring(2));
                    continue block10;
                }
                case 'n': {
                    this.NormaliseDD = stringArray[i].charAt(2) == 'y';
                    continue block10;
                }
                case 'o': {
                    this.outputcontrol = Integer.parseInt(stringArray[i].substring(2));
                    continue block10;
                }
                case 'x': {
                    this.minDegreeRead = Integer.parseInt(stringArray[i].substring(2));
                    continue block10;
                }
                default: {
                    System.out.println("\n*** Argument " + i + " not known, usage:");
                    this.Usage();
                    return 3;
                }
            }
        }
        File file = new File(this.dirname);
        if (!file.isDirectory()) {
            System.out.println(this.dirname + " is not a directory");
            return 1;
        }
        return 0;
    }

    void processAll(String string, String string2, String string3, boolean bl) {
        int n = (int)((this.lbratio - 1.0) * 1000.0 + 0.5);
        this.getFileList(this.inputddext);
        if (this.filelist.length == 0) {
            System.out.println(" *** No " + this.inputddext + " files found");
            return;
        }
        String string4 = this.NormaliseDD ? "norm" : "";
        for (int i = 0; i < this.filelist.length; ++i) {
            String string5 = this.filelist[i];
            String string6 = this.filenamerootlist[i];
            if (this.getDDData(string5, string) != 0) continue;
            this.processOneDD(string6, string, string2, string3, bl);
        }
        this.calcLBtot();
        this.FileOutputLogBinDD(this.nameroot + "lb" + string4 + n + ".tot" + string3, string);
        this.FileOutputTotDD(this.nameroot + string4 + ".tot" + string2, string);
    }

    public void addOneDD(IntArrayList intArrayList, String string, String string2, String string3, String string4, boolean bl) {
        this.getDegreeDistribution(intArrayList);
        this.processOneDD(string, string2, string3, string4, bl);
    }

    void processOneDD(String string, String string2, String string3, String string4, boolean bl) {
        String string5;
        int n = (int)((this.lbratio - 1.0) * 1000.0 + 0.5);
        String string6 = string5 = this.NormaliseDD ? "norm" : "";
        if (this.NormaliseDD) {
            this.calcNumbers(this.ddarr);
            this.renormaliseDD();
        }
        if (bl) {
            this.calcLBind();
            this.FileOutputLogBinDD(string + "lb" + string5 + n + "." + string4, string2);
        }
        this.updateTotDD();
    }

    void processDistanceAll(String string, String string2) {
        this.getFileList(this.inputdiststatsext);
        if (this.filelist.length == 0) {
            System.out.println(" *** No " + this.inputdiststatsext + " files found");
            return;
        }
        for (int i = 0; i < this.filelist.length; ++i) {
            String string3 = this.filelist[i];
            String string4 = this.filenamerootlist[i];
            if (this.getDistStats(string3, string) != 0) continue;
            this.showDistStats();
            if (this.diameterbigmax > this.diametermax) {
                this.diameterbigmax = this.diametermax;
            }
            if (this.diameterbigmin < this.diametermin) {
                this.diameterbigmin = this.diametermin;
            }
            this.diameter.update(this.diameterav);
            this.totdistance.update(this.totdistanceav);
            this.onesdistance.update(this.onesdistanceav);
        }
        this.diameter.print("diameter");
        if (this.infolevel > 0) {
            System.out.println("Extremes of diameter: \t" + this.diameterbigmin + " \t " + this.diameterbigmin);
        }
        this.totdistance.print("totdistance");
        this.onesdistance.print("onesdistance");
        this.FileOutputDistanceStats(this.nameroot + ".tot" + string2, string);
        this.FileOutputDistanceStatsExcel(this.nameroot + ".totxls" + string2, string);
    }

    public void processOne(String string, String string2) {
        int n = (int)((this.lbratio - 1.0) * 1000.0 + 0.5);
        String string3 = this.NormaliseDD ? "norm" : "";
        this.calcNumbers(this.ddarr);
        if (this.NormaliseDD) {
            this.renormaliseDD();
        }
        this.calcLBind();
        this.FileOutputLogBinDD(this.nameroot + "lb" + string3 + n + "." + string2, string);
    }

    public void renormaliseDD() {
        if (this.Nvertices > 0L) {
            for (int i = 0; i < this.ddarr.size(); ++i) {
                this.ddarr.set(i, this.ddarr.get(i) / (double)this.Nvertices);
            }
        }
    }

    public void showDDData() {
        System.out.println(" Individual degree distribution");
        System.out.println(" k  \t   n(k) ");
        for (int i = 0; i < this.ddarr.size(); ++i) {
            double d = this.ddarr.get(i);
            if (!(d > 0.0)) continue;
            System.out.println(i + "\t " + d);
        }
    }

    public void showDistStats() {
        System.out.println(" Individual Distance Stats");
        System.out.println("Diameter max, min, big max, big min \t " + this.diametermax + " \t " + this.diametermin + " \t " + this.diameterbigmax + " \t " + this.diameterbigmin);
        System.out.println("Diameter av, err, sigma \t " + this.diameterav + " \t " + this.diametererr + " \t " + this.diametersigma);
        System.out.println("Tot Distance av, err, sigma \t " + this.totdistanceav + " \t " + this.totdistanceerr + " \t " + this.totdistancesigma);
        System.out.println("One Sample distance av, err, sigma \t " + this.onesdistanceav + " \t " + this.onesdistanceerr + " \t " + this.onesdistancesigma);
    }

    public void showTotDDData() {
        System.out.println(" Total degree distribution");
        System.out.println(" k  \t   n(k)  \t   n^2(k)");
        for (int i = 0; i < this.totddarr.size(); ++i) {
            System.out.println(i + "\t " + this.totddarr.get(i) + "\t " + this.totdd2arr.get(i));
        }
    }

    public void showLBData() {
        System.out.println(" Individual log binned degree distribution");
        System.out.println(" b  \t k  \t   n(k)  \t +/-  \t bin size");
        for (int i = 0; i < this.ddlbarr.size(); ++i) {
            System.out.println(i + "\t " + this.btokarr.get(i) + "\t " + this.ddlbarr.get(i) + "\t " + this.ddlberrarr.get(i) + "\t " + this.ddlbsizearr.get(i));
        }
    }

    public int updateTotDD() {
        double d;
        int n;
        int n2 = this.totddarr.size() < this.ddarr.size() ? this.totddarr.size() : this.ddarr.size();
        for (n = 0; n < n2; ++n) {
            d = this.ddarr.get(n);
            double d2 = this.totddarr.get(n) + d;
            double d3 = this.totdd2arr.get(n) + d * d;
            this.totddarr.set(n, d2);
            this.totdd2arr.set(n, d3);
            if (n < this.totkmin && d2 > 0.0) {
                this.totkmin = n;
            }
            if (n > this.totkmin && n < this.kcont && d2 == 0.0) {
                this.totkcont = n;
            }
            if (n <= this.totkmax || !(d2 > 0.0)) continue;
            this.totkmax = n;
        }
        while (n < this.ddarr.size()) {
            d = this.ddarr.get(n);
            this.totddarr.add(d);
            this.totdd2arr.add(d * d);
            if (n < this.totkmin && d > 0.0) {
                this.totkmin = n;
            }
            if (n > this.totkmin && n < this.kcont && d == 0.0) {
                this.totkcont = n;
            }
            if (n > this.totkmax && d > 0.0) {
                this.totkmax = n;
            }
            ++n;
        }
        ++this.nruns;
        return 0;
    }

    public void Usage() {
        DistributionAnalysis distributionAnalysis = new DistributionAnalysis();
        System.out.println("...............................................................................");
        System.out.println("Usage: ");
        System.out.println("DistributionAnalysis <options> ");
        System.out.println(" where options are -<char><value> separated by space as follows ");
        System.out.println("  -f<nameroot>       Sets root of input and output files to be nameroot, default " + distributionAnalysis.nameroot);
        System.out.println("  -d<dirname>        Sets directory name, default " + distributionAnalysis.dirname);
        System.out.println("  -e<inputddext>     Extension of input degree distribution files, default " + distributionAnalysis.inputddext);
        System.out.println("  -c#                Choose column # of data, default " + distributionAnalysis.choosecolumnnumber);
        System.out.println("  -r#                Ratio of upper to lower bin positions, default " + distributionAnalysis.lbratio);
        System.out.println("  -n<y|n>            Normalise n(k) to p(k), yes or no, default " + (distributionAnalysis.NormaliseDD ? "yes" : "no"));
        System.out.println("  -x#                Minumum degree analysed, default " + distributionAnalysis.minDegreeRead);
        System.out.println(" -o<int> output modes , default " + distributionAnalysis.outputcontrol);
        System.out.println("  o modes: (o& 1) ? Degree distribution analysis on : (off)");
        System.out.println("         : (o& 2) ? Distance statistics on : (off)");
        System.out.println("...............................................................................");
    }

    public void print() {
        System.out.println("\n-------------------------------------------------------");
        System.out.println("                        Filename root:\t " + this.nameroot);
        System.out.println("                       Directory name:\t " + this.dirname);
        System.out.println("                       Data in column:\t " + this.choosecolumnnumber);
        System.out.println("                        Log Bin ratio:\t " + this.lbratio);
        System.out.println("              Input DD file extension:\t " + this.inputddext);
        System.out.println("               Normalise n(k) to p(k):\t " + (this.NormaliseDD ? "yes" : "no"));
        System.out.println("-------------------------------------------------------");
    }

    public void listdir() {
        File file = new File(this.dirname);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
    }

    public class OneParamStatistics {
        double minimum = 9999999.0;
        double maximum = 0.0;
        double average = 0.0;
        double error = 0.0;
        double sigma = 0.0;
        double sigma2 = 0.0;
        double total = 0.0;
        double totalsquares = 0.0;
        int number = 0;

        public void update(double d) {
            ++this.number;
            this.total += d;
            this.totalsquares += d * d;
            if (d < this.minimum) {
                this.minimum = d;
            }
            if (d > this.maximum) {
                this.maximum = d;
            }
            this.average = this.total / (double)this.number;
            this.sigma2 = this.totalsquares / (double)this.number - this.average * this.average;
            this.sigma = this.sigma2 > 0.0 ? Math.sqrt(this.totalsquares / (double)this.number - this.average * this.average) : 0.0;
            this.error = this.number > 1 ? this.sigma / Math.sqrt(this.number - 1) : 0.0;
        }

        public void print(String string) {
            System.out.println(this.minimum + " <= " + string + " <= " + this.maximum);
            System.out.println("<" + string + "> = " + this.average + " +/- " + this.error);
            System.out.println("           sigma = " + this.sigma + ", samples = " + this.number);
        }

        public void print(PrintStream printStream, String string) {
            printStream.println(this.minimum + " <= " + string + " <= " + this.maximum);
            printStream.println("<" + string + "> = " + this.average + " +/- " + this.error);
            printStream.println("           sigma = " + this.sigma + ", samples = " + this.number);
        }

        public void printExcel(PrintStream printStream, String string) {
            printStream.print(" \t" + string + " \t" + this.average + " \t" + this.error + " \t" + this.sigma + " \t" + this.minimum + " \t " + this.maximum + " \t" + this.number);
        }
    }

    public class OnlyOneParamSet
    implements FilenameFilter {
        String ext;
        String header;

        public OnlyOneParamSet(String string, String string2) {
            this.ext = string2;
            this.header = string;
        }

        public boolean accept(File file, String string) {
            return string.endsWith(this.ext) & string.startsWith(this.header);
        }
    }
}

