/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import cern.colt.list.IntArrayList;

public class ValueRange {
    private int minimum;
    private int bottomMaximum;
    private int interval;
    private int topMinimum;
    private int maximum;
    private IntArrayList value;

    public ValueRange() {
    }

    public ValueRange(int n, int n2, int n3, int n4, int n5) {
        this.minimum = n;
        this.maximum = n5;
        this.bottomMaximum = n2;
        this.interval = n3;
        this.topMinimum = n4;
    }

    public ValueRange(ValueRange valueRange) {
        this.maximum = valueRange.maximum;
        this.bottomMaximum = valueRange.bottomMaximum;
        this.interval = valueRange.interval;
        this.topMinimum = valueRange.topMinimum;
    }

    public void setMinimum(int n) {
        this.minimum = n;
    }

    public void setBottomMaximum(int n) {
        this.bottomMaximum = n;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public void setTopMinimum(int n) {
        this.topMinimum = n;
    }

    public void setMaximum(int n) {
        this.maximum = n;
    }

    private void correctValues() {
        this.bottomMaximum = Math.min(Math.max(this.bottomMaximum, this.minimum), this.maximum - 1);
        this.topMinimum = Math.max(Math.min(this.topMinimum, this.maximum), this.minimum + 1);
        if (this.interval < 1) {
            this.interval = this.maximum - this.minimum;
        }
    }

    public void create() {
        int n;
        this.correctValues();
        this.value = new IntArrayList();
        for (n = this.minimum; n <= this.bottomMaximum; ++n) {
            this.value.add(n);
        }
        for (n = ((n - this.minimum - 1) / this.interval + 1) * this.interval + this.minimum; n < this.topMinimum; n += this.interval) {
            this.value.add(n);
        }
        for (n = this.topMinimum; n <= this.maximum; ++n) {
            this.value.add(n);
        }
    }

    public int get(int n) {
        return this.value.get(n);
    }

    public int getNumberValues() {
        return this.value.size();
    }

    public int getMaximum() {
        return this.maximum;
    }
}

