/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

public class StatisticalQuantity {
    String Version = "StatisticalQuantity:0901123";
    private String name = "";
    double maximum;
    double minimum;
    int count;
    private double average;
    private double sigma;
    private double error;
    private double secondmoment;
    private boolean updatestatistics;
    private final int maximumOrder;
    private double[] powerTotal;
    private int warningCount;

    public StatisticalQuantity() {
        this.maximumOrder = 3;
        this.setDefaultValues(7.0E99, -7.0E99);
    }

    public StatisticalQuantity(int n) {
        this.maximumOrder = 3;
        this.setDefaultValues(7.0E99, -7.0E99);
        this.warningCount = n;
    }

    public StatisticalQuantity(double d, double d2) {
        this.maximumOrder = 3;
        this.setDefaultValues(d2, d);
    }

    public StatisticalQuantity(double d, double d2, int n) {
        this.maximumOrder = n < 3 ? 3 : n;
        this.setDefaultValues(d2, d);
    }

    public void setDefaultValues(double d, double d2) {
        this.warningCount = 10;
        this.count = 0;
        this.average = 0.0;
        this.secondmoment = 0.0;
        this.sigma = 0.0;
        this.error = 0.0;
        this.maximum = d2;
        this.minimum = d;
        this.updatestatistics = false;
        this.powerTotal = new double[this.maximumOrder];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void add(double d) {
        this.updatestatistics = true;
        double d2 = 1.0;
        boolean bl = this.count > 0 && Math.abs(d) > this.powerTotal[0] * 1.0E-7;
        for (int i = 0; i < this.maximumOrder; ++i) {
            int n = i;
            this.powerTotal[n] = this.powerTotal[n] + (d2 *= d);
            if (!bl || this.warningCount <= 0 || !(Math.abs(d2) < this.powerTotal[i] * 1.0E-7)) continue;
            System.err.println("!!! value " + d + " gives x^" + i + " of " + d2 + " which is too small for current total this power of " + this.powerTotal[i]);
            --this.warningCount;
        }
        ++this.count;
        if (this.count > 1) {
            if (this.maximum < d) {
                this.maximum = d;
            }
            if (this.minimum > d) {
                this.minimum = d;
            }
        } else {
            this.maximum = d;
            this.minimum = d;
        }
    }

    public double getAverage() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.average;
    }

    public int getCount() {
        return this.count;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getSecondMoment() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.secondmoment;
    }

    public double getMoment(int n) {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        if (n > 0 && n <= this.maximumOrder && this.count > 0) {
            return this.powerTotal[n - 1] / (double)this.count;
        }
        return -1.0;
    }

    public double getSigma() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.sigma;
    }

    public boolean testAverage(double d, double d2, double d3) {
        boolean bl = false;
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        if (Math.abs(this.average) < d3) {
            if (this.error < d2) {
                bl = true;
            }
        } else if (this.error < d * this.average) {
            bl = true;
        }
        return bl;
    }

    public double getError() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.error;
    }

    private void calcStatistics() {
        if (!this.updatestatistics) {
            return;
        }
        if (this.count == 0) {
            return;
        }
        this.average = this.powerTotal[0] / (double)this.count;
        this.secondmoment = this.powerTotal[1] / (double)this.count;
        if (this.count > 1) {
            double d = this.secondmoment - this.average * this.average;
            this.sigma = d < 0.0 ? 0.0 : Math.sqrt(d);
            this.error = this.sigma / Math.sqrt(this.count);
        } else {
            this.sigma = 0.0;
            this.error = 0.0;
        }
        this.updatestatistics = false;
    }

    public String labelString(String string) {
        String string2 = (this.name.length() == 0 ? "" : this.name + " ") + "Average" + string + "Error" + string + "Maximum" + string + "Minimum" + string + "Count";
        return string2;
    }

    public String toString(String string) {
        String string2 = this.getAverage() + string + this.getError() + string + this.maximum + string + this.minimum + string + this.count;
        return string2;
    }

    public String avErrString(String string) {
        return this.getAverage() + string + this.getError();
    }
}

