/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import java.math.BigInteger;

public class StatQuant {
    private int maximum = 0;
    private int minimum = 0;
    private int count = 0;
    private BigInteger total = new BigInteger("0");
    private BigInteger squaretotal = new BigInteger("0");
    private double average = 0.0;
    private double sigma = 0.0;
    private double error = 0.0;
    private double secondmoment = 0.0;
    private boolean updatestatistics = false;

    public void add(int n) {
        Integer n2 = new Integer(n);
        this.updatestatistics = true;
        BigInteger bigInteger = new BigInteger(n2.toString());
        this.total = this.total.add(bigInteger);
        bigInteger = bigInteger.multiply(bigInteger);
        this.squaretotal = this.squaretotal.add(bigInteger);
        ++this.count;
        if (this.count > 1) {
            if (this.maximum < n) {
                this.maximum = n;
            }
            if (this.minimum > n) {
                this.minimum = n;
            }
        } else {
            this.maximum = n;
            this.minimum = n;
        }
    }

    public double getAverage() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.average;
    }

    public int getCount() {
        return this.count;
    }

    public double getSecondMoment() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.secondmoment;
    }

    public double getSigma() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.sigma;
    }

    public double getError() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.error;
    }

    private void calcStatistics() {
        if (!this.updatestatistics) {
            return;
        }
        this.average = this.total.doubleValue() / (double)this.count;
        this.secondmoment = this.squaretotal.doubleValue() / (double)this.count;
        if (this.count > 1) {
            this.sigma = Math.sqrt(this.secondmoment - this.average * this.average);
            this.error = this.sigma / Math.sqrt(this.count);
        } else {
            this.sigma = 0.0;
            this.error = 0.0;
        }
        this.updatestatistics = false;
    }
}

