/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import DataAnalysis.MutualInformation;
import DataAnalysis.StatisticalQuantity;

public class MutualInformationStatistics {
    StatisticalQuantity mutualInformation;
    StatisticalQuantity jointEntropy;
    StatisticalQuantity redundancyNormalised;
    StatisticalQuantity universalMetric;
    StatisticalQuantity universalMetricNormalised;

    public MutualInformationStatistics() {
        this.reset();
    }

    public void reset() {
        this.mutualInformation = new StatisticalQuantity();
        this.jointEntropy = new StatisticalQuantity();
        this.redundancyNormalised = new StatisticalQuantity();
        this.universalMetric = new StatisticalQuantity();
        this.universalMetricNormalised = new StatisticalQuantity();
        this.mutualInformation.setName("I(X,Y)");
        this.jointEntropy.setName("H(X,Y)");
        this.redundancyNormalised.setName("R(X,Y)/R_max");
        this.universalMetric.setName("d(x,y)");
        this.universalMetricNormalised.setName("d(x,y)/H(x,y)");
    }

    public void add(MutualInformation mutualInformation) {
        this.mutualInformation.add(mutualInformation.getMutualInformation());
        this.jointEntropy.add(mutualInformation.getJointEntropy());
        this.redundancyNormalised.add(mutualInformation.getRedundancyNormalised());
        this.universalMetric.add(mutualInformation.getUniversalMetric());
        this.universalMetricNormalised.add(mutualInformation.getUniversalMetricNormalised());
    }

    public StatisticalQuantity getMutualInformation() {
        return this.mutualInformation;
    }

    public StatisticalQuantity getJointEntropy() {
        return this.jointEntropy;
    }

    public StatisticalQuantity getRedundancyNormalised() {
        return this.redundancyNormalised;
    }

    public StatisticalQuantity getUniversalMetric() {
        return this.universalMetric;
    }

    public StatisticalQuantity getUniversalMetricNormalised() {
        return this.universalMetricNormalised;
    }

    public String toLabel(String string) {
        String string2 = this.getMutualInformation().labelString(string) + string + this.getJointEntropy().labelString(string) + string + this.getRedundancyNormalised().labelString(string) + string + this.getUniversalMetric().labelString(string) + string + this.getUniversalMetricNormalised().labelString(string);
        return string2;
    }

    public String toString(String string) {
        String string2 = this.getMutualInformation().toString(string) + string + this.getJointEntropy().toString(string) + string + this.getRedundancyNormalised().toString(string) + string + this.getUniversalMetric().toString(string) + string + this.getUniversalMetricNormalised().toString(string);
        return string2;
    }

    public String averagesLabel(String string) {
        String string2 = this.getMutualInformation().getName() + string + this.getJointEntropy().getName() + string + this.getRedundancyNormalised().getName() + string + this.getUniversalMetric().getName() + string + this.getUniversalMetricNormalised().getName();
        return string2;
    }

    public String averagesString(String string) {
        String string2 = this.getMutualInformation().getAverage() + string + this.getJointEntropy().getAverage() + string + this.getRedundancyNormalised().getAverage() + string + this.getUniversalMetric().getAverage() + string + this.getUniversalMetricNormalised().getAverage();
        return string2;
    }
}

