/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class MutualInformation {
    static final double DUNSET = -9.7538642E7;
    private String name1 = "Set 1";
    private String name2 = "Set 2";
    double[] p1;
    int n1;
    String[] elementNames1;
    double[] p2;
    int n2;
    String[] elementNames2;
    double[][] pjd;
    private double mutualInformation = -9.7538642E7;
    private double entropyOne = -9.7538642E7;
    private double entropyTwo = -9.7538642E7;
    public static final double TOLERANCE = 1.0E-6;

    public MutualInformation(int n, int n2) {
        this.initialise(n, n2);
    }

    public MutualInformation(int n, int n2, String string, String string2) {
        this.initialise(n, n2);
        this.setNames(string, string2);
    }

    public MutualInformation(MutualInformation mutualInformation, boolean bl, boolean bl2) {
        if (bl2) {
            this.initialise(mutualInformation.getOrderOne(), mutualInformation.getOrderTwo());
        } else {
            this.n1 = mutualInformation.getOrderOne();
            this.n2 = mutualInformation.getOrderTwo();
        }
        this.setNames(mutualInformation.getName1(), mutualInformation.getName2());
        this.entropyOne = mutualInformation.getEntropyOne();
        this.entropyTwo = mutualInformation.getEntropyTwo();
        this.mutualInformation = mutualInformation.getMutualInformation();
    }

    private void initialise(int n, int n2) {
        this.n1 = n;
        this.n2 = n2;
        this.p1 = new double[this.n1];
        this.p2 = new double[this.n2];
        this.pjd = new double[this.n1][this.n2];
    }

    public void setMarginalProbabilityOneQuick(int n, double d) {
        this.p1[n] = d;
    }

    public void setMarginalProbabilityTwoQuick(int n, double d) {
        this.p2[n] = d;
    }

    public void setJointProbabilityQuick(int n, int n2, double d) {
        this.pjd[n][n2] = d;
    }

    public void increaseMarginalProbabilityOneQuick(int n, double d) {
        int n2 = n;
        this.p1[n2] = this.p1[n2] + d;
    }

    public void increaseMarginalProbabilityTwoQuick(int n, double d) {
        int n2 = n;
        this.p2[n2] = this.p2[n2] + d;
    }

    public void increaseJointProbabilityQuick(int n, int n2, double d) {
        double[] dArray = this.pjd[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    public double getJointProbabilityQuick(int n, int n2) {
        return this.pjd[n][n2];
    }

    public int getOrderOne() {
        return this.n1;
    }

    public int getOrderTwo() {
        return this.n2;
    }

    public void setNames(String string, String string2) {
        this.name1 = string;
        this.name2 = string2;
    }

    public String getName1() {
        return this.name1;
    }

    public String getName2() {
        return this.name2;
    }

    public boolean setElementNames1(String[] stringArray) {
        if (stringArray.length != this.n1) {
            System.err.println("*** element names of set one not set since lengths differ " + stringArray.length + " != " + this.n1);
            return false;
        }
        this.elementNames1 = new String[this.n1];
        for (int i = 0; i < this.n1; ++i) {
            this.elementNames1[i] = stringArray[i];
        }
        return true;
    }

    public boolean setElementNames2(String[] stringArray) {
        if (stringArray.length != this.n2) {
            System.err.println("*** element names of set two not set since lengths differ " + stringArray.length + " != " + this.n2);
            return false;
        }
        this.elementNames2 = new String[this.n2];
        for (int i = 0; i < this.n2; ++i) {
            this.elementNames2[i] = stringArray[i];
        }
        return true;
    }

    public double getMutualInformation() {
        if (this.mutualInformation == -9.7538642E7) {
            this.calculate();
        }
        return this.mutualInformation;
    }

    public double getEntropyOne() {
        if (this.entropyOne == -9.7538642E7) {
            this.calculate();
        }
        return this.entropyOne;
    }

    public double getEntropyTwo() {
        if (this.entropyTwo == -9.7538642E7) {
            this.calculate();
        }
        return this.entropyTwo;
    }

    public double getEntropyOneOverMax() {
        if (this.entropyOne == -9.7538642E7) {
            this.calculate();
        }
        return this.entropyOne / this.getEntropyOneMaximum();
    }

    public double getEntropyTwoOverMax() {
        if (this.entropyTwo == -9.7538642E7) {
            this.calculate();
        }
        return this.entropyTwo / this.getEntropyTwoMaximum();
    }

    public double getEntropyOneMaximum() {
        if (this.n1 > 0) {
            return Math.log(this.n1);
        }
        return this.n1;
    }

    public double getEntropyTwoMaximum() {
        if (this.n2 > 0) {
            return Math.log(this.n2);
        }
        return this.n2;
    }

    public double getJointEntropy() {
        if (this.mutualInformation == -9.7538642E7) {
            this.calculate();
        }
        return this.entropyOne + this.entropyTwo - this.mutualInformation;
    }

    public double getConditionalEntropyOne() {
        if (this.mutualInformation == -9.7538642E7) {
            this.calculate();
        }
        return this.entropyOne - this.mutualInformation;
    }

    public double getConditionalEntropyTwo() {
        if (this.mutualInformation == -9.7538642E7) {
            this.calculate();
        }
        return this.entropyTwo - this.mutualInformation;
    }

    public double getUniversalMetric() {
        if (this.mutualInformation == -9.7538642E7) {
            this.calculate();
        }
        return this.entropyOne + this.entropyTwo - 2.0 * this.mutualInformation;
    }

    public double getUniversalMetricNormalised() {
        if (this.mutualInformation == -9.7538642E7) {
            this.calculate();
        }
        return this.getUniversalMetric() / this.getJointEntropy();
    }

    public double getRedundancy() {
        if (this.mutualInformation == -9.7538642E7) {
            this.calculate();
        }
        return this.mutualInformation / (this.entropyOne + this.entropyTwo);
    }

    public double getRedundancyNormalised() {
        if (this.mutualInformation == -9.7538642E7) {
            this.calculate();
        }
        return this.mutualInformation / Math.min(this.entropyOne, this.entropyTwo);
    }

    public double calculate() {
        try {
            this.mutualInformation = 0.0;
            this.entropyOne = 0.0;
            this.entropyTwo = 0.0;
            double d = -1.0;
            double d2 = -1.0;
            double d3 = -1.0;
            for (int i = 0; i < this.n1; ++i) {
                d2 = this.p1[i];
                if (d2 > 1.0E-6) {
                    this.entropyOne -= d2 * Math.log(d2);
                }
                for (int j = 0; j < this.n2; ++j) {
                    d3 = this.p2[j];
                    if (i == 0 && d3 > 1.0E-6) {
                        this.entropyTwo -= d3 * Math.log(d3);
                    }
                    if ((d = this.pjd[i][j]) < 1.0E-6) continue;
                    this.mutualInformation += this.pjd[i][j] * Math.log(this.pjd[i][j] / (d2 * d3));
                }
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("calculateMutualInformation failed, error " + runtimeException);
            this.entropyOne = -9.7538642E7;
            this.entropyTwo = -9.7538642E7;
            this.mutualInformation = -9.7538642E7;
        }
        return this.mutualInformation;
    }

    public int checkNormalisations() {
        return this.checkNormalisations(1.0E-6);
    }

    public int checkNormalisations(double d) {
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.n1; ++n) {
            d2 += this.p1[n];
            for (int i = 0; i < this.n2; ++i) {
                d4 += this.pjd[n][i];
                if (n != 0) continue;
                d3 += this.p2[i];
            }
        }
        n = 0;
        if (Math.abs(d2 - 1.0) > d) {
            ++n;
        }
        if (Math.abs(d3 - 1.0) > d) {
            n += 2;
        }
        if (Math.abs(d4 - 1.0) > d) {
            n += 4;
        }
        return n;
    }

    public String checkNormalisationsString(int n) {
        if (n == 0) {
            return "Normalisation of probabilities OK";
        }
        String string = "Normalisation of probability failure: ";
        if ((n & 1) > 0) {
            string = "marginal probability of community one, ";
        }
        if ((n & 2) > 0) {
            string = "marginal probability of community two, ";
        }
        if ((n & 4) > 0) {
            string = "joint probability, ";
        }
        return string;
    }

    public int checkConsistentcy() {
        return this.checkConsistentcy(1.0E-6);
    }

    public int checkConsistentcy(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.n1; ++i) {
            d2 = 0.0;
            for (int j = 0; j < this.n2; ++j) {
                d2 += this.pjd[i][j];
            }
            if (!(Math.abs(d2 - this.p1[i]) > d)) continue;
            return -1;
        }
        double d3 = 0.0;
        for (int i = 0; i < this.n2; ++i) {
            d3 = 0.0;
            for (int j = 0; j < this.n1; ++j) {
                d3 += this.pjd[j][i];
            }
            if (!(Math.abs(d3 - this.p2[i]) > d)) continue;
            return -2;
        }
        return 0;
    }

    public String toStringBasic(String string) {
        return this.name1 + string + this.name2 + string + this.n1 + string + this.n2;
    }

    public static String toStringBasicLabel(String string) {
        return "Name X" + string + "Name Y" + string + "|X|" + string + "|Y|";
    }

    public String toStringShort(String string) {
        String string2 = this.getMutualInformation() + string + this.getUniversalMetric() + string + this.getUniversalMetricNormalised() + string + this.getJointEntropy();
        return string2;
    }

    public static String toStringShortLabelDescriptive(String string) {
        String string2 = "Mutual Information" + string + "Universal Metric" + string + "Universal Metric Normalised" + string + "Joint Entropy";
        return string2;
    }

    public static String toStringShortLabel(String string) {
        String string2 = "I(X,Y)" + string + "d(X,Y)" + string + "d(X,Y)/H(X,Y)" + string + "H(X,Y)";
        return string2;
    }

    public String toString(String string) {
        String string2 = this.getMutualInformation() + string + this.getEntropyOne() + string + this.getEntropyTwo() + string + this.getJointEntropy() + string + this.getRedundancyNormalised() + string + this.getUniversalMetric() + string + this.getUniversalMetricNormalised() + string + this.getEntropyOneOverMax() + string + this.getEntropyTwoOverMax() + string + Math.log(this.n1 / this.n2);
        return string2;
    }

    public static String toStringLabelDescriptive(String string) {
        String string2 = "Mutual Information" + string + "Entropy One" + string + "Entropy Two" + string + "Joint Entropy" + string + "Normalised Redundancy" + string + "Universal Metric" + string + "Universal Metric Normalised" + string + "Entropy 1/max" + string + "Entropy 2/max" + string + "ln(|X|/|Y|)";
        return string2;
    }

    public static String toStringLabel(String string) {
        String string2 = "I(X,Y)" + string + "H(X)" + string + "H(Y)" + string + "H(X,Y)" + string + "R(X,Y)/R_max" + string + "d(X,Y)" + string + "d(X,Y)/H(X,Y)" + string + "H(X)/ln(|X|)" + string + "H(Y)/ln(|Y|)" + string + "ln(|X|/|Y|)";
        return string2;
    }

    public void printJointProbability(PrintStream printStream, String string, boolean bl, boolean bl2) {
        int n;
        boolean bl3;
        boolean bl4;
        if (bl) {
            bl4 = bl2;
            bl3 = true;
            if (this.elementNames2 == null) {
                bl3 = false;
                bl4 = true;
            }
            printStream.print("X\\Y" + string);
            for (n = 0; n < this.n2; ++n) {
                printStream.print("Y" + (bl4 ? "." + n : "") + (bl3 ? "." + this.elementNames2[n] : "") + string);
            }
            printStream.println();
        }
        bl4 = true;
        bl3 = bl2;
        if (this.elementNames1 == null) {
            bl4 = false;
            bl3 = true;
        }
        for (n = 0; n < this.n1; ++n) {
            if (bl) {
                printStream.print("X" + (bl3 ? "." + n : "") + (bl4 ? "." + this.elementNames1[n] : Integer.valueOf(n)) + string);
            }
            for (int i = 0; i < this.n2; ++i) {
                printStream.print(this.pjd[n][i] + string);
            }
            printStream.println();
        }
    }

    public void printSummary(PrintStream printStream, String string, String string2, boolean bl) {
        printStream.println(string + MutualInformation.toStringBasicLabel(string2) + (bl ? string2 + MutualInformation.toStringLabel(string2) : ""));
        printStream.println(string + this.toStringBasic(string2) + (bl ? string2 + this.toString(string2) : ""));
    }

    public void printToFile(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string4 = string + (bl2 ? "mijp.dat" : "mi.dat");
        if (bl5) {
            System.out.println("Writing JointProbability to file " + string4);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string4);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printSummary(printStream, string2, string3, bl);
            if (bl2) {
                this.printJointProbability(printStream, string3, bl3, bl4);
            }
            if (bl5) {
                System.err.println("Finished writing JointProbability to file " + string4);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + string4 + ", " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + string4 + ", " + fileNotFoundException.getMessage());
            return;
        }
    }
}

