/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class LogBin {
    String LBVersion = "LogBin060607";
    String SEP = "\t";
    String dataName = "UNKNOWN";
    DoubleArrayList bToXValueArr;
    DoubleArrayList bToXMinArr;
    int numberBins = -1;
    DoubleArrayList dataLogBinList;
    DoubleArrayList dataLogBinErrorList;
    DoubleArrayList dataLogBinSizeList;
    double lbratio = -1.0;
    int infolevel = 1;
    double totalNumberInBins = 0.0;
    double totalSizeInBins = 0.0;

    private void initialise() {
        this.dataLogBinList = new DoubleArrayList();
        this.dataLogBinErrorList = new DoubleArrayList();
        this.dataLogBinSizeList = new DoubleArrayList();
        this.bToXValueArr = new DoubleArrayList();
        this.bToXMinArr = new DoubleArrayList();
    }

    public int calcLogBinAny(IntArrayList intArrayList, int n, int n2, int n3, double d) {
        if (d <= 1.0) {
            return -1;
        }
        this.lbratio = d;
        this.initialise();
        int n4 = n2;
        if (intArrayList.size() <= n4) {
            n4 = intArrayList.size() - 1;
        }
        int n5 = n;
        while (n5 <= n4) {
            int n6 = (int)((double)n5 * this.lbratio) + 1;
            if (n5 < 1) {
                n6 = 1;
            }
            this.bToXValueArr.add((double)(n6 - 1 + n5) / 2.0);
            int n7 = n6 - n5;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = n5; i < n6 && i <= n4; ++i) {
                double d4 = intArrayList.get(i);
                d2 += d4;
                d3 += d4 * d4;
            }
            this.dataLogBinList.add(d2 / (double)(n7 * n3));
            this.bToXMinArr.add((double)n5);
            double d5 = n7 > 1 ? (d3 - d2 * d2 / (double)n7) / (double)(n7 * (n7 - 1)) : -1.0;
            double d6 = d5 > 0.0 ? Math.sqrt(d5) : 0.0;
            this.dataLogBinErrorList.add(d6 / (double)n3);
            this.dataLogBinSizeList.add((double)n7);
            n5 = n6;
        }
        this.bToXMinArr.add((double)n5);
        return 0;
    }

    void FileOutputLogBinFreqData(String string, String string2, String string3) {
        this.FileOutputLogBinnedFreqData(string, string2, string3, true, true);
    }

    public void FileOutputLogBinnedFreqData(String string, String string2, String string3, boolean bl, boolean bl2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (this.infolevel > 0) {
                System.out.println(string2 + " writing log bin data to " + string);
            }
            if (bl) {
                Date date = new Date();
                printStream.println(string2 + " Log Binned Frequency Distribution ratio" + string3 + this.lbratio + string3 + " " + this.LBVersion + string3 + " " + date);
            }
            this.calcNumbersInBins();
            if (bl2) {
                printStream.println(string2 + "count k" + string3 + "   Freqency n(k)   " + string3 + "   +/-   " + string3 + " bin size dk " + string3 + " gamma(k) " + string3 + " n(k)*dk " + string3 + " k*n(k)*dk " + string3 + " log10(k)  " + string3 + " log10(n(k)) " + string3 + " Total Number (N)=" + string3 + " " + this.totalNumberInBins + "" + string3 + " Total Size (E)= " + string3 + " " + this.totalSizeInBins);
            }
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this.dataLogBinList.size(); ++i) {
                double d3 = this.dataLogBinList.get(i);
                if (!(d3 > 0.0)) continue;
                double d4 = this.bToXValueArr.get(i);
                double d5 = this.dataLogBinErrorList.get(i);
                double d6 = this.getBinSize(i);
                printStream.print(d4 + string3 + d3 + string3 + d5 + string3 + d6);
                if (d > 0.0 && d2 > 0.0) {
                    printStream.print(string3 + -Math.log(d / d3) / Math.log(d2 / d4));
                }
                printStream.print(string3 + d3 * d6 + string3 + d4 * d3 * d6);
                if (d4 > 0.0) {
                    printStream.print(string3 + Math.log10(d4));
                } else {
                    printStream.print(string3);
                }
                if (d3 > 0.0) {
                    printStream.print(string3 + Math.log10(d3));
                } else {
                    printStream.print(string3);
                }
                printStream.println();
                d = d3;
                d2 = d4;
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("File Close Error " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file " + string);
        }
        if (this.infolevel > 0) {
            System.out.println("\n Finished Log Bin Output to " + string);
        }
    }

    public double getBinSize(int n) {
        if (n >= this.dataLogBinList.size()) {
            return -1.0;
        }
        return this.bToXMinArr.get(n + 1) - this.bToXMinArr.get(n);
    }

    public int calcNumbersInBins() {
        this.totalNumberInBins = 0.0;
        this.totalSizeInBins = 0.0;
        for (int i = 0; i < this.dataLogBinList.size(); ++i) {
            double d = this.bToXValueArr.get(i);
            double d2 = this.dataLogBinList.get(i) * this.getBinSize(i);
            this.totalNumberInBins += d2;
            this.totalSizeInBins += d2 * d;
        }
        return 0;
    }
}

