/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import TimUtilities.TimMessage;
import cern.colt.list.IntArrayList;
import java.util.Random;

public class IntegerSequence {
    static final String VERSION = "DDStats260305";
    static final int MAXIMUMFNUMBER = 6;
    static final int maxStatisticsMode = 7;
    static final double DUNSET = -1.35798642E99;
    Random Rnd = new Random();
    int numberIndividuals = -99;
    int statisticsMode = 7;
    double statisticsError = 0.001;
    boolean initialised = false;
    int Nactive;
    int kmin;
    int kmax;
    int count;
    double dcount;
    IntArrayList nkvalue;
    IntArrayList nleqkvalue;
    int maxMoment;
    int[] kmoment;
    double[] FnNormalisation;
    int maxFnumber;
    private int nmoments;
    int S;
    TimMessage message = new TimMessage(-2);

    public IntegerSequence(IntegerSequence integerSequence) {
        this.initialiseBasicParameters(integerSequence.getMaximumMomentNumber(), integerSequence.getMaximumFNumber(), integerSequence.getCalculateMode());
    }

    public IntegerSequence(int n, int n2, int n3) {
        this.initialiseBasicParameters(n, n2, n3);
    }

    private void initialiseBasicParameters(int n, int n2, int n3) {
        this.maxMoment = n;
        this.maxFnumber = n2;
        this.setStatisticsMode(n3);
    }

    private void initialiseParameters() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        this.kmin = 20000000;
        this.kmax = -this.kmin;
        this.count = 0;
        this.dcount = this.count;
        this.Nactive = 0;
        this.S = 0;
        this.nmoments = Math.max(Math.max(this.maxMoment, this.maxFnumber), 2);
        int n = this.nmoments + 1;
        this.kmoment = new int[n];
        this.FnNormalisation = new double[n];
    }

    public void calcStats(int[] nArray) {
        int n;
        int n2;
        this.initialiseParameters();
        this.count = nArray.length;
        this.dcount = this.count;
        for (n2 = 0; n2 < this.count; ++n2) {
            int n3 = nArray[n2];
            this.kmin = Math.min(this.kmin, n3);
            this.kmax = Math.max(this.kmax, n3);
            if ((double)n3 > 1.0E-6) {
                double d = (double)n3 / this.dcount;
                this.S = (int)((double)this.S + d * Math.log(d));
                ++this.Nactive;
            }
            n = 1;
            int n4 = 0;
            while (n4 <= this.nmoments) {
                int n5 = n4++;
                this.kmoment[n5] = this.kmoment[n5] + n;
                n *= n3;
            }
        }
        n2 = 1;
        for (n = 0; n <= this.nmoments; ++n) {
            this.FnNormalisation[n] = n2;
            n2 *= this.kmoment[1] - n;
        }
        for (n = 0; n < this.count; ++n) {
            double d = (double)nArray[n] / (double)this.kmoment[1];
            if (!(d > 1.0E-6)) continue;
            this.S = (int)((double)this.S - d * Math.log(d));
        }
    }

    public double getMoment(int n) {
        if (n < 0 || n > this.nmoments) {
            throw new RuntimeException("Can not handle less than zero or more than " + this.nmoments);
        }
        return (double)this.kmoment[n] / this.dcount;
    }

    public double getF(int n) {
        if (n < 0 || n > 6) {
            throw new RuntimeException("Can not handle less than zero or more than 6");
        }
        return this.getUnnromalisedF(n) / this.FnNormalisation[n];
    }

    public double getUnnromalisedF(int n) {
        if (n < 0 || n > 6) {
            throw new RuntimeException("Can not handle less than zero or more than 6");
        }
        switch (n) {
            case 0: {
                return this.kmoment[0];
            }
            case 1: {
                return this.kmoment[1];
            }
            case 2: {
                return this.kmoment[2] - this.kmoment[1];
            }
            case 3: {
                return this.kmoment[3] - 3 * this.kmoment[2] + 2 * this.kmoment[1];
            }
            case 4: {
                return this.kmoment[4] - 6 * this.kmoment[3] + 11 * this.kmoment[2] - 6 * this.kmoment[1];
            }
            case 5: {
                return this.kmoment[5] - 10 * this.kmoment[4] + 35 * this.kmoment[3] - 50 * this.kmoment[2] + 24 * this.kmoment[1];
            }
            case 6: {
                return this.kmoment[6] - 15 * this.kmoment[5] + 85 * this.kmoment[4] - 225 * this.kmoment[3] + 274 * this.kmoment[2] - 120 * this.kmoment[1];
            }
        }
        System.out.println("Error in  getUnnromalisedFn, maxFnumber =" + this.maxFnumber + " wrong");
        return -1.35798642E99;
    }

    public int getMin() {
        return this.kmin;
    }

    public int getMax() {
        return this.kmax;
    }

    public int getNumber() {
        return this.count;
    }

    public int getTotalValue() {
        return this.kmoment[1];
    }

    public double getAverage() {
        return this.getMoment(1);
    }

    public double getAverageSquared() {
        double d = this.getMoment(1);
        return d * d;
    }

    public double getVariance() {
        return this.getMoment(2) - this.getAverageSquared();
    }

    public double getSigma() {
        return Math.sqrt(this.getVariance());
    }

    public double getError() {
        return this.getSigma() / Math.sqrt(this.count);
    }

    public double getzValue() {
        return this.getMoment(2) / this.getMoment(1) - 1.0;
    }

    public double getEntropy() {
        return this.S;
    }

    public String labelString(String string) {
        int n;
        int n2 = this.statisticsMode;
        String string2 = "";
        if ((n2 & 1) > 0) {
            string2 = string2 + "N" + string + "E" + string + "<k>" + string + "+/-" + string + "k_min" + string + "k_max" + string + "sigma" + string + "z" + string + "S" + string;
        }
        if ((n2 & 2) > 0) {
            for (n = 2; n <= this.maxMoment; ++n) {
                string2 = string2 + "mu[" + n + "]" + string;
            }
        }
        if ((n2 & 4) > 0) {
            for (n = 2; n <= this.maxFnumber; ++n) {
                string2 = string2 + "F[" + n + "]" + string;
            }
        }
        return string2;
    }

    public String toString(String string) {
        int n;
        int n2 = this.statisticsMode;
        String string2 = "";
        if ((n2 & 1) > 0) {
            string2 = string2 + this.getNumber() + string + this.getTotalValue() + string + this.getAverage() + string + this.getError() + string + this.getMin() + string + this.getMax() + string + this.getSigma() + string + this.getzValue() + string + this.getEntropy() + string;
        }
        if ((n2 & 2) > 0) {
            for (n = 2; n <= this.maxMoment; ++n) {
                string2 = string2 + this.getMoment(n) + string;
            }
        }
        if ((n2 & 4) > 0) {
            for (n = 2; n <= this.maxFnumber; ++n) {
                string2 = string2 + this.getF(n) + string;
            }
        }
        return string2;
    }

    private int setStatisticsMode(boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            n += 2;
        }
        if (bl3) {
            n += 4;
        }
        this.setStatisticsMode(n);
        return this.statisticsMode;
    }

    private int setStatisticsMode(int n) {
        this.statisticsMode = n;
        if (this.statisticsMode > 7) {
            this.message.printERROR("Statistics Mode " + this.statisticsMode + " too big, must be <" + 7);
        }
        if (this.statisticsMode < 0) {
            this.message.printERROR("Statistics Mode " + this.statisticsMode + " negative, must be positive");
        }
        return this.statisticsMode;
    }

    public String statisticsModeString(String string) {
        return IntegerSequence.statisticsModeString(this.statisticsMode, string);
    }

    public static String statisticsModeString(int n, String string) {
        String string2 = "";
        if ((n & 1) > 0) {
            string2 = string2 + "Basic Data" + string;
        }
        if ((n & 2) > 0) {
            string2 = string2 + "mu[n]" + string;
        }
        if ((n & 4) > 0) {
            string2 = string2 + "F[n]" + string;
        }
        return string2;
    }

    public int getCalculateMode() {
        return this.statisticsMode;
    }

    public int getMaximumMomentNumber() {
        return this.maxMoment;
    }

    public int getMaximumFNumber() {
        return this.maxFnumber;
    }
}

