/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import cern.colt.list.IntArrayList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class IntegerEvent {
    String SEP = "\t";
    String IEVersion = "IE060612";
    IntArrayList eventFreq = new IntArrayList();
    private int totalEvents = 0;
    private int totalSize = 0;
    private int infolevel = 1;
    boolean upDateStatistics = false;

    public void add(int n, int n2) {
        this.upDateStatistics = true;
        int n3 = this.eventFreq.size();
        if (n == 0 && n3 == 0) {
            this.eventFreq.add(n2);
            return;
        }
        for (int i = n3; i <= n; ++i) {
            this.eventFreq.add(0);
        }
        this.eventFreq.set(n, this.eventFreq.get(n) + n2);
    }

    public int getTotalSize() {
        if (this.upDateStatistics) {
            this.calcStatistics();
        }
        return this.totalSize;
    }

    public int getTotalEvents() {
        if (this.upDateStatistics) {
            this.calcStatistics();
        }
        return this.totalEvents;
    }

    private void calcStatistics() {
        this.totalEvents = 0;
        this.totalSize = 0;
        int n = 0;
        for (int i = 0; i < this.eventFreq.size(); ++i) {
            n = this.eventFreq.get(i);
            this.totalEvents += n;
            this.totalSize += n * i;
        }
        this.upDateStatistics = false;
    }

    void FileOutputIntegerCountData(String string, String string2, boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (this.infolevel > 0) {
                System.out.println(string2 + " writing integer count data to " + string);
            }
            Date date = new Date();
            this.calcStatistics();
            printStream.println(string2 + "Event Size k" + this.SEP + "Event Count n(k) " + this.SEP + " Total Events (N) =" + this.totalEvents + this.SEP + " Total Size (E)=" + this.totalSize + this.SEP + " Max Event Size =" + (this.eventFreq.size() - 1) + this.SEP + this.IEVersion + this.SEP + " " + date);
            for (int i = 0; i < this.eventFreq.size(); ++i) {
                int n = this.eventFreq.get(i);
                if (bl && n == 0) continue;
                printStream.println(i + this.SEP + n);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Close Error " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string);
        }
        if (this.infolevel > 0) {
            System.out.println("\n Finished Log Bin Output to " + string);
        }
    }
}

