/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import DataAnalysis.StatisticalQuantity;
import DataAnalysis.ValueRange;
import TimUtilities.TimIntegerArrayList;
import TimUtilities.TimMessage;
import cern.colt.list.IntArrayList;
import java.util.Random;

public class IntegerCountDistribution {
    static final String VERSION = "DDStats260305";
    static final int MAXIMUMFNUMBER = 6;
    static final int maxStatisticsMode = 255;
    Random Rnd = new Random();
    TimIntegerArrayList TimIAL = new TimIntegerArrayList();
    int numberIndividuals = -99;
    int statisticsMode = 255;
    double statisticsError = 0.001;
    boolean initialised = false;
    StatisticalQuantity Nactive;
    StatisticalQuantity kmax;
    StatisticalQuantity kav;
    StatisticalQuantity ksigma;
    ValueRange kvalue;
    StatisticalQuantity[] nkvalue;
    StatisticalQuantity[] nleqkvalue;
    int maxMoment;
    StatisticalQuantity[] mu;
    int maxFnumber;
    StatisticalQuantity[] Fn;
    StatisticalQuantity zStat;
    StatisticalQuantity Fkc;
    StatisticalQuantity S;
    int Y;
    StatisticalQuantity[] turnover;
    StatisticalQuantity[] degreeRank;
    TimMessage message = new TimMessage(-2);

    public IntegerCountDistribution(IntegerCountDistribution integerCountDistribution) {
        this.initialiseBasicParameters(integerCountDistribution.getMaximumMomentNumber(), integerCountDistribution.getMaximumFNumber(), integerCountDistribution.getkValue(), integerCountDistribution.Y, integerCountDistribution.getCalculateMode());
    }

    public IntegerCountDistribution(int n, int n2, ValueRange valueRange, int n3, int n4) {
        this.initialiseBasicParameters(n, n2, valueRange, n3, n4);
    }

    private void initialiseBasicParameters(int n, int n2, ValueRange valueRange, int n3, int n4) {
        this.maxMoment = n2;
        this.maxFnumber = n;
        this.kvalue = new ValueRange(valueRange);
        this.Y = n3;
        this.setStatisticsMode(n4);
    }

    private void initialisekValues() {
        int n = this.numberIndividuals;
        this.kvalue.setMinimum(0);
        this.kvalue.setMaximum(n);
        this.kvalue.create();
    }

    private void initialiseParameters() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        this.initialisekValues();
        this.Nactive = new StatisticalQuantity();
        this.kmax = new StatisticalQuantity();
        this.kav = new StatisticalQuantity();
        this.ksigma = new StatisticalQuantity();
        this.Fkc = new StatisticalQuantity();
        this.S = new StatisticalQuantity();
        int n = this.kvalue.getNumberValues();
        if ((this.statisticsMode & 4) > 0 || (this.statisticsMode & 8) > 0) {
            this.initialisekValues();
            if ((this.statisticsMode & 4) > 0) {
                this.nkvalue = new StatisticalQuantity[n];
            }
            if ((this.statisticsMode & 8) > 0) {
                this.nleqkvalue = new StatisticalQuantity[n];
            }
            double d = (double)this.numberIndividuals / (double)(n - 1);
            for (int i = 0; i < n; ++i) {
                if ((this.statisticsMode & 4) > 0) {
                    this.nkvalue[i] = new StatisticalQuantity();
                }
                if ((this.statisticsMode & 8) <= 0) continue;
                this.nleqkvalue[i] = new StatisticalQuantity();
            }
        }
        if ((this.statisticsMode & 0x20) > 0) {
            if (this.maxMoment > 6 || this.maxMoment < 2) {
                this.maxMoment = 6;
            }
            this.mu = new StatisticalQuantity[this.maxMoment + 1];
            for (int i = 0; i <= this.maxMoment; ++i) {
                this.mu[i] = new StatisticalQuantity();
            }
        } else {
            this.maxMoment = 2;
        }
        if ((this.statisticsMode & 2) > 0) {
            this.zStat = new StatisticalQuantity();
            if (this.maxFnumber > 6 || this.maxFnumber < 2) {
                this.maxFnumber = 6;
            }
            this.Fn = new StatisticalQuantity[this.maxFnumber + 1];
            for (int i = 0; i <= this.maxFnumber; ++i) {
                this.Fn[i] = new StatisticalQuantity();
            }
        }
    }

    public IntArrayList calcStats(int[] nArray) {
        IntArrayList intArrayList = new IntArrayList();
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            this.TimIAL.addExtendIntArrayList(intArrayList, n, 1);
        }
        this.calcStats(intArrayList);
        return intArrayList;
    }

    public void calcStats(IntArrayList intArrayList) {
        int n;
        int n2;
        int n3;
        this.initialiseParameters();
        int n4 = 0;
        int n5 = 1;
        int n6 = 0;
        int n7 = -1;
        int[] nArray = new int[1];
        int n8 = this.kvalue.getNumberValues();
        int n9 = Math.max(Math.max(this.maxMoment, this.maxFnumber), 2);
        int[] nArray2 = new int[n9 + 1];
        for (n3 = 0; n3 <= n9; ++n3) {
            nArray2[n3] = 0;
        }
        if ((this.statisticsMode & 8) > 0) {
            n7 = this.kvalue.getMaximum();
            nArray = new int[n7 + 1];
        }
        if ((this.statisticsMode & 4) > 0 || (this.statisticsMode & 8) > 0) {
            for (n3 = 0; n3 < n8; ++n3) {
                if (this.kvalue.get(n3) < intArrayList.size()) {
                    this.nkvalue[n3].add(intArrayList.get(this.kvalue.get(n3)));
                    continue;
                }
                this.nkvalue[n3].add(0.0);
            }
        }
        n3 = -1;
        double d = 0.0;
        int n10 = 0;
        int n11 = 0;
        for (n6 = 0; n6 < intArrayList.size(); ++n6) {
            n4 = intArrayList.get(n6);
            n5 = 1;
            n2 = 0;
            while (n2 <= n9) {
                int n12 = n2++;
                nArray2[n12] = nArray2[n12] + n4 * n5;
                n5 *= n6;
            }
            if (n6 > 0) {
                if (n6 > n3) {
                    n3 = n6;
                }
                d += (double)(n4 * n6) * Math.log(n6);
                n10 += n4;
                if ((this.statisticsMode & 8) <= 0 || n6 > n7) continue;
                nArray[n6] = nArray[n6 - 1] + n4;
                continue;
            }
            n11 += n4;
            if ((this.statisticsMode & 8) <= 0) continue;
            nArray[0] = n4;
        }
        n2 = nArray2[0];
        double d2 = n2;
        if ((this.statisticsMode & 8) > 0) {
            while (n6 <= n7) {
                if (n6 > 0) {
                    nArray[n6] = nArray[n6 - 1];
                } else {
                    nArray[0] = n4;
                }
                ++n6;
            }
            if (n2 != nArray[nArray.length - 1]) {
                this.message.printERROR(" in calcStats, number of artifacts " + n2 + " != " + nArray[nArray.length - 1]);
            }
        }
        int n13 = nArray2[1];
        double d3 = n13 / n2;
        this.Nactive.add(n10);
        this.kmax.add(n3);
        this.kav.add(d3);
        this.ksigma.add((double)nArray2[2] / d2 - d3 * d3);
        this.Fkc.add((double)nArray2[2] / (double)(n13 * n13));
        this.S.add(d);
        double d4 = 1.0;
        if ((this.statisticsMode & 8) > 0) {
            for (n = 0; n < this.kvalue.getNumberValues(); ++n) {
                if (this.kvalue.get(n) < nArray.length) {
                    this.nleqkvalue[n].add(nArray[this.kvalue.get(n)]);
                    continue;
                }
                this.nleqkvalue[n].add(0.0);
            }
        }
        if ((this.statisticsMode & 0x20) > 0) {
            for (n = 0; n <= this.maxMoment; ++n) {
                this.mu[n].add((double)nArray2[n] / d2);
            }
        }
        if ((this.statisticsMode & 2) > 0) {
            this.zStat.add((double)nArray2[2] / (d2 * d3) - 1.0);
            for (n = 0; n <= this.maxFnumber; ++n) {
                switch (n) {
                    case 0: {
                        this.Fn[n].add((double)nArray2[0] / d4);
                        break;
                    }
                    case 1: {
                        this.Fn[n].add((double)nArray2[1] / d4);
                        break;
                    }
                    case 2: {
                        this.Fn[n].add((double)(nArray2[2] - nArray2[1]) / d4);
                        break;
                    }
                    case 3: {
                        this.Fn[n].add((double)(nArray2[3] - 3 * nArray2[2] + 2 * nArray2[1]) / d4);
                        break;
                    }
                    case 4: {
                        this.Fn[n].add((double)(nArray2[4] - 6 * nArray2[3] + 11 * nArray2[2] - 6 * nArray2[1]) / d4);
                        break;
                    }
                    case 5: {
                        this.Fn[n].add((double)(nArray2[5] - 10 * nArray2[4] + 35 * nArray2[3] - 50 * nArray2[2] + 24 * nArray2[1]) / d4);
                        break;
                    }
                    case 6: {
                        this.Fn[n].add((double)(nArray2[6] - 15 * nArray2[5] + 85 * nArray2[4] - 225 * nArray2[3] + 274 * nArray2[2] - 120 * nArray2[1]) / d4);
                        break;
                    }
                    default: {
                        System.out.println("Error in calcStats, maxFnumber =" + this.maxFnumber + " wrong");
                    }
                }
                d4 *= (double)(nArray2[1] - n);
            }
        }
    }

    public boolean testSample(double d, double d2, double d3, double d4, double d5) {
        boolean bl = false;
        double d6 = Math.abs(d - d2);
        if (Math.abs(d) < d5) {
            if (d6 < d4) {
                bl = true;
            }
        } else if (d6 < d3 * d) {
            bl = true;
        }
        return bl;
    }

    public String labelString(String string) {
        int n;
        int n2 = this.statisticsMode;
        String string2 = "";
        String string3 = string + "+/-" + string;
        if ((n2 & 1) > 0) {
            string2 = string2 + "Nactive" + string3 + "kmax (av. over runs)" + string3 + "MAX k (all runs)" + string + "kav" + string3 + "ksigma" + string3 + "Fkc" + string3 + "S" + string3;
        }
        if ((n2 & 2) > 0) {
            string2 = string2 + "z" + string3;
            for (n = 2; n <= this.maxFnumber; ++n) {
                string2 = string2 + "F" + n + string3;
            }
        }
        if ((n2 & 4) > 0) {
            for (n = 0; n < this.kvalue.getNumberValues(); ++n) {
                string2 = string2 + "n(" + this.kvalue.get(n) + ")" + string3;
            }
        }
        if ((n2 & 8) > 0) {
            for (n = 0; n < this.kvalue.getNumberValues(); ++n) {
                string2 = string2 + "n<=(" + this.kvalue.get(n) + ")" + string3;
            }
        }
        if ((n2 & 0x20) > 0) {
            for (n = 2; n <= this.maxMoment; ++n) {
                string2 = string2 + "mu_" + n + string3;
            }
        }
        if ((n2 & 0x40) > 0) {
            string2 = string2 + "No.Comp." + string3 + "Av.Comp.Size" + string3 + "No.M.Comp." + string3 + "Av.M.Comp.Size" + string3 + "No.GCC Vert" + string3 + "GCC Diam." + string3 + "GCC Dist." + string3;
        }
        if ((n2 & 0x80) > 0) {
            for (n = 0; n < this.turnover.length; ++n) {
                string2 = string2 + "Y=" + (n + 1) + string3 + "k(" + (n + 1) + ")" + string3;
            }
        }
        return string2;
    }

    public String toString(String string) {
        int n;
        int n2 = this.statisticsMode;
        String string2 = "";
        if ((n2 & 1) > 0) {
            string2 = string2 + this.Nactive.avErrString(string) + string + this.kmax.avErrString(string) + string + this.kmax.getMaximum() + string + this.kav.avErrString(string) + string + this.ksigma.avErrString(string) + string + this.Fkc.avErrString(string) + string + this.S.avErrString(string) + string;
        }
        if ((n2 & 2) > 0) {
            string2 = string2 + this.zStat.avErrString(string) + string;
            for (n = 2; n <= this.maxFnumber; ++n) {
                string2 = string2 + this.Fn[n].avErrString(string) + string;
            }
        }
        if ((n2 & 4) > 0) {
            for (n = 0; n < this.kvalue.getNumberValues(); ++n) {
                string2 = string2 + this.nkvalue[n].avErrString(string) + string;
            }
        }
        if ((n2 & 8) > 0) {
            for (n = 0; n < this.kvalue.getNumberValues(); ++n) {
                string2 = string2 + this.nleqkvalue[n].avErrString(string) + string;
            }
        }
        if ((n2 & 0x20) > 0) {
            for (n = 2; n <= this.maxMoment; ++n) {
                string2 = string2 + this.mu[n].avErrString(string) + string;
            }
        }
        if ((n2 & 0x80) > 0) {
            for (n = 0; n < this.turnover.length; ++n) {
                string2 = string2 + this.turnover[n].avErrString(string) + string + this.degreeRank[n].avErrString(string) + string;
            }
        }
        return string2;
    }

    private int setStatisticsMode(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl3) {
            n += 2;
        }
        if (bl4) {
            n += 4;
        }
        if (bl5) {
            n += 8;
        }
        if (bl6) {
            n += 16;
        }
        if (bl2) {
            n += 32;
        }
        if (bl7) {
            n += 64;
        }
        if (bl8) {
            n += 128;
        }
        this.setStatisticsMode(n);
        return this.statisticsMode;
    }

    private int setStatisticsMode(int n) {
        this.statisticsMode = n;
        if (this.statisticsMode > 255) {
            this.message.printERROR("Statistics Mode " + this.statisticsMode + " too big, must be <" + 255);
        }
        if (this.statisticsMode < 0) {
            this.message.printERROR("Statistics Mode " + this.statisticsMode + " negative, must be positive");
        }
        return this.statisticsMode;
    }

    public String statisticsModeString(String string) {
        return IntegerCountDistribution.statisticsModeString(this.statisticsMode, string);
    }

    public static String statisticsModeString(int n, String string) {
        String string2 = "";
        if ((n & 1) > 0) {
            string2 = string2 + "Basic Data" + string;
        }
        if ((n & 2) > 0) {
            string2 = string2 + "z,F[n]" + string;
        }
        if ((n & 4) > 0) {
            string2 = string2 + "n(k)" + string;
        }
        if ((n & 8) > 0) {
            string2 = string2 + "n<=(k)" + string;
        }
        if ((n & 0x10) > 0) {
            string2 = string2 + "UNUSED" + string;
        }
        if ((n & 0x20) > 0) {
            string2 = string2 + "mu[n]" + string;
        }
        if ((n & 0x40) > 0) {
            string2 = string2 + "MR" + string;
        }
        if ((n & 0x80) > 0) {
            string2 = string2 + "TopY" + string;
        }
        return string2;
    }

    public int getCalculateMode() {
        return this.statisticsMode;
    }

    public ValueRange getkValue() {
        return this.kvalue;
    }

    public int getMaximumMomentNumber() {
        return this.maxMoment;
    }

    public int getMaximumFNumber() {
        return this.maxFnumber;
    }
}

