/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import DataAnalysis.DataRead;
import DataAnalysis.IntegerEvent;
import DataAnalysis.LogBin;
import DataAnalysis.StatisticalQuantity;
import cern.colt.list.DoubleArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class EventTimeSeries {
    static String ETSVersion = "ETS060613";
    String SEP = "\t";
    int infolevel = 1;
    int outputmode = 255;
    int tFileCol = 2;
    DoubleArrayList timeSeries;
    StatisticalQuantity[] timeSeriesBinFreq;
    double timeSeriesFreqMin;
    double binScale = 1.1;
    boolean logBinOn = true;
    int numberBins = 0;
    double timeSeriesMinimum = 1.0E99;
    double timeSeriesMaximum = -this.timeSeriesMinimum;
    IntegerEvent avalancheLength;
    IntegerEvent avalancheSize;
    double avBinScale = 3600.0;
    double avLogBinScale = 1.1;
    double diffLogBinScale = 1.1;
    String filename = "testtimes.dat";
    String inputdirname = "/PRG/networks/photogallery/input/";
    String outputdirname = "/PRG/networks/photogallery/output/";
    String labelLine = "gallery";

    public static void main(String[] stringArray) {
        String string;
        System.out.println("*** TimeSeries ***");
        DataRead dataRead = new DataRead();
        EventTimeSeries eventTimeSeries = new EventTimeSeries();
        if (eventTimeSeries.ParamParse(stringArray) > 0) {
            return;
        }
        String string2 = eventTimeSeries.outputdirname + eventTimeSeries.removeExtension(eventTimeSeries.filename);
        String string3 = "#";
        int n = 1;
        int[] nArray = new int[n];
        int n2 = 0;
        nArray[n2] = eventTimeSeries.tFileCol;
        dataRead.getData(eventTimeSeries.filename, eventTimeSeries.inputdirname, string3, eventTimeSeries.labelLine, n, nArray);
        System.out.println("!!! read " + dataRead.getTotalNumbersOfDataLines() + " lines");
        EventTimeSeries eventTimeSeries2 = new EventTimeSeries();
        if (eventTimeSeries.ParamParse(stringArray) > 0) {
            return;
        }
        eventTimeSeries2.calctimeSeriesDifference(dataRead.columnData[n2]);
        if ((eventTimeSeries.outputmode & 1) > 0) {
            string = string2 + "diffraw.dat";
            eventTimeSeries2.FileOutputTimeSeries(string, "#", false);
        }
        if ((eventTimeSeries.outputmode & 2) > 0) {
            eventTimeSeries2.timeSeries.sort();
            string = string2 + "diffrank.dat";
            eventTimeSeries2.FileOutputTimeSeries(string, "#", false);
        }
        String string4 = "";
        if ((eventTimeSeries.outputmode & 4) > 0) {
            eventTimeSeries2.logBinOn = true;
            eventTimeSeries2.binScale = eventTimeSeries.diffLogBinScale;
            eventTimeSeries2.calctimeSeriesFreq();
            string4 = string2 + "DiffLB" + eventTimeSeries2.binScale + "intervalfreq.dat";
            eventTimeSeries2.FileOutputTimeSeriesFreq(string4, " ");
        }
        eventTimeSeries.doAvalanche(string2, "#", dataRead.columnData[n2]);
    }

    public int findFirstIndex(double d, double d2) {
        int n = -1;
        for (int i = 0; i < this.timeSeries.size(); ++i) {
            double d3 = this.timeSeries.get(i);
            if (!(d3 > d) || !(d3 < d2)) continue;
            n = i;
            break;
        }
        return n;
    }

    public int copyTimeSeries(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        this.timeSeries = new DoubleArrayList();
        boolean bl = false;
        double d = doubleArrayList.get(0);
        this.timeSeries.add(d);
        this.timeSeriesMinimum = d;
        this.timeSeriesMaximum = d;
        double d2 = d;
        for (int i = 1; i < n; ++i) {
            d = doubleArrayList.get(i);
            this.timeSeries.add(d);
            this.timeSeriesMinimum = Math.min(this.timeSeriesMinimum, d);
            this.timeSeriesMaximum = Math.max(this.timeSeriesMaximum, d);
            if (d2 > d) {
                bl = true;
            }
            d2 = d;
        }
        if (bl) {
            this.timeSeries.sort();
        }
        if (this.timeSeriesMinimum < 0.0) {
            return -1;
        }
        return 0;
    }

    public int calctimeSeriesDifference(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        double d = doubleArrayList.get(0);
        double d2 = -1.0E-99;
        boolean bl = false;
        this.timeSeries = new DoubleArrayList();
        for (int i = 1; i < n; ++i) {
            double d3 = doubleArrayList.get(i);
            double d4 = d3 - d;
            this.timeSeries.add(d4);
            this.timeSeriesMinimum = Math.min(this.timeSeriesMinimum, d4);
            this.timeSeriesMaximum = Math.max(this.timeSeriesMaximum, d4);
            if (d2 > d4 && i > 1) {
                bl = true;
            }
            d2 = d4;
            d = d3;
        }
        if (bl) {
            this.timeSeries.sort();
        }
        if (this.timeSeriesMinimum < 0.0) {
            return -1;
        }
        return 0;
    }

    public int calctimeSeriesFreq() {
        double d = this.timeSeriesMinimum;
        if (this.logBinOn && d <= 0.0) {
            d = 1.0;
        }
        return this.calctimeSeriesFreq(d, this.timeSeriesMaximum);
    }

    public int calctimeSeriesFreq(double d, double d2) {
        if (this.logBinOn && this.binScale <= 1.0) {
            return -1;
        }
        if (d2 < d) {
            return -2;
        }
        if (this.logBinOn && d <= 0.0) {
            return -3;
        }
        int n = this.timeSeries.size();
        this.timeSeriesFreqMin = d;
        int n2 = this.calcNumberBins(d, d2);
        this.timeSeriesBinFreq = new StatisticalQuantity[n2];
        for (int i = 0; i < n2; ++i) {
            this.timeSeriesBinFreq[i] = new StatisticalQuantity();
        }
        for (int i = 0; i < n; ++i) {
            double d3 = this.timeSeries.get(i);
            int n3 = this.calcBin(d3);
            if (n3 >= n2) {
                System.out.println("*** Error in calctimeSeriesFreq(double tmin, double tmax)" + n3 + " " + this.numberBins);
                break;
            }
            this.timeSeriesBinFreq[n3].add(d3);
        }
        return 0;
    }

    public int calctimeSeriesAvalanches() {
        int n = this.timeSeriesBinFreq.length;
        this.avalancheLength = new IntegerEvent();
        this.avalancheSize = new IntegerEvent();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = this.timeSeriesBinFreq[i].count;
            if (n2 > 0) {
                n3 += n2;
                ++n4;
                continue;
            }
            if (n4 <= 0) continue;
            this.avalancheLength.add(n4, 1);
            this.avalancheSize.add(n3, 1);
            n3 = 0;
            n4 = 0;
        }
        return 0;
    }

    public double calcTimeFromBin(int n) {
        if (n < 0) {
            return 1.0E-96;
        }
        double d = this.logBinOn ? Math.pow(this.binScale, n) * this.timeSeriesMinimum : this.binScale * (double)n + this.timeSeriesMinimum;
        return d;
    }

    public int calcBin(double d) {
        int n = this.logBinOn ? (int)(Math.log(d / this.timeSeriesMinimum) / Math.log(this.binScale)) + 1 : (int)((d - this.timeSeriesMinimum) / this.binScale);
        if (n < 1) {
            n = 0;
        }
        if (n >= this.numberBins) {
            n = this.numberBins - 1;
        }
        return n;
    }

    public int calcNumberBins(double d, double d2) {
        int n = this.logBinOn ? (int)(Math.log(d2 / d) / Math.log(this.binScale)) + 1 : (int)((d2 - d) / this.binScale) + 1;
        if (n < 1) {
            n = 0;
        }
        this.numberBins = n + 2;
        return this.numberBins;
    }

    public int doAvalanche(String string, String string2, DoubleArrayList doubleArrayList) {
        LogBin logBin;
        this.copyTimeSeries(doubleArrayList);
        String string3 = string + "raw.dat";
        if ((this.outputmode & 8) > 0) {
            this.FileOutputTimeSeries(string3, string2, false);
        }
        this.logBinOn = false;
        this.binScale = this.avBinScale;
        this.calctimeSeriesFreq();
        string3 = string + this.avBinScale + "rawbinned.dat";
        if ((this.outputmode & 0x10) > 0) {
            this.FileOutputTimeSeriesFreq(string3, string2, true);
        }
        this.calctimeSeriesAvalanches();
        if ((this.outputmode & 0x20) > 0) {
            string3 = string + this.avBinScale + "avalanchelengths.dat";
            this.avalancheLength.FileOutputIntegerCountData(string3, "#", true);
            logBin = new LogBin();
            logBin.calcLogBinAny(this.avalancheSize.eventFreq, 0, this.avalancheSize.eventFreq.size() - 1, 1, this.avLogBinScale);
            string3 = string + this.avBinScale + "avsizeLB.dat";
            logBin.FileOutputLogBinFreqData(string3, string2, this.SEP);
        }
        if ((this.outputmode & 0x40) > 0) {
            string3 = string + this.avBinScale + "avalanchesizes.dat";
            this.avalancheSize.FileOutputIntegerCountData(string3, "#", true);
            logBin = new LogBin();
            logBin.calcLogBinAny(this.avalancheLength.eventFreq, 0, this.avalancheLength.eventFreq.size() - 1, 1, this.avLogBinScale);
            string3 = string + this.avBinScale + "avlengthLB.dat";
            logBin.FileOutputLogBinFreqData(string3, string2, this.SEP);
        }
        return 0;
    }

    void FileOutputTimeSeries(String string, String string2, boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (this.infolevel > 0) {
                System.out.println(string2 + " writing sorted time series to " + string);
            }
            Date date = new Date();
            printStream.println(string2 + "rank r" + this.SEP + "  t   " + this.SEP + string2 + " Sorted time series" + this.SEP + " No. Events =" + this.timeSeries.size() + this.SEP + ETSVersion + this.SEP + " " + date);
            int n = this.timeSeries.size();
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                n2 = bl ? i : n - i - 1;
                printStream.println(i + this.SEP + this.timeSeries.get(n2));
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Close Error " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string);
        }
        if (this.infolevel > 0) {
            System.out.println("\n Finished Log Bin Output to " + string);
        }
    }

    void FileOutputTimeSeriesFreq(String string, String string2) {
        this.FileOutputTimeSeriesFreq(string, string2, false);
    }

    void FileOutputTimeSeriesFreq(String string, String string2, boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (this.infolevel > 0) {
                System.out.println(string2 + " writing log binned time series to " + string);
            }
            Date date = new Date();
            printStream.println(string2 + "Bin No." + this.SEP + " bin t_min " + this.SEP + " bin t_max " + this.SEP + " Bin t " + this.SEP + " Normalised Freq " + this.SEP + "+/-" + this.SEP + this.timeSeriesBinFreq[0].labelString(this.SEP) + this.SEP + " No. Events =" + this.timeSeries.size() + this.SEP + " No. Bins =" + this.timeSeriesBinFreq.length + this.SEP + ETSVersion + this.SEP + " " + date);
            double d = 0.0;
            double d2 = this.timeSeriesFreqMin;
            double d3 = (d2 + d) / 2.0;
            int n = 0;
            double d4 = d2 - d;
            double d5 = (double)this.timeSeriesBinFreq[n].count / d4;
            double d6 = d5 < 1.0 ? 0.0 : Math.sqrt(this.timeSeriesBinFreq[n].count) / d4;
            printStream.println(n + this.SEP + d + this.SEP + d2 + this.SEP + (d2 + d) / 2.0 + this.SEP + d5 + this.SEP + d6 + this.SEP + this.timeSeriesBinFreq[n].toString(this.SEP));
            for (n = 1; n < this.timeSeriesBinFreq.length - 1; ++n) {
                d = d2;
                d2 = this.calcTimeFromBin(n);
                d3 = (d2 + d) / 2.0;
                d4 = d2 - d;
                d5 = (double)this.timeSeriesBinFreq[n].count / d4;
                if (d5 == 0.0) continue;
                d6 = d5 < 1.0 ? 0.0 : Math.sqrt(this.timeSeriesBinFreq[n].count) / d4;
                printStream.println(n + this.SEP + d + this.SEP + d2 + this.SEP + (d2 + d) / 2.0 + this.SEP + d5 + this.SEP + d6 + this.SEP + this.timeSeriesBinFreq[n].toString(this.SEP));
            }
            n = this.timeSeriesBinFreq.length - 1;
            d4 = d2 * (this.binScale - 1.0);
            d5 = (double)this.timeSeriesBinFreq[n].count / d4;
            d6 = d5 < 1.0 ? 0.0 : Math.sqrt(this.timeSeriesBinFreq[n].count) / d4;
            printStream.println(n + this.SEP + d2 + this.SEP + " " + this.SEP + ">" + d2 + this.SEP + d5 + this.SEP + d6 + this.SEP + this.timeSeriesBinFreq[n].toString(this.SEP));
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Close Error " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string);
        }
        if (this.infolevel > 0) {
            System.out.println("\n Finished Log Bin Output to " + string);
        }
    }

    public String removeExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public int ParamParse(String[] stringArray) {
        block7: for (int i = 0; i < stringArray.length; ++i) {
            if (this.infolevel > 0) {
                System.out.println("Parameter " + i + " is " + stringArray[i]);
            }
            if (stringArray[i].length() < 2) {
                System.out.println("\n*** Argument " + i + " is too short");
                return 1;
            }
            if (stringArray[i].charAt(0) != '-') {
                System.out.println("\n*** Argument " + i + " does not start with -");
                return 2;
            }
            switch (stringArray[i].charAt(1)) {
                case 'b': {
                    if (stringArray[i].charAt(2) == 'a') {
                        this.avBinScale = Double.parseDouble(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) == 'b') {
                        this.avLogBinScale = Double.parseDouble(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) != 'd') continue block7;
                    this.diffLogBinScale = Double.parseDouble(stringArray[i].substring(3));
                    continue block7;
                }
                case 'c': {
                    this.tFileCol = Integer.parseInt(stringArray[i].substring(2));
                    continue block7;
                }
                case 'd': {
                    if (stringArray[i].charAt(2) == 'i') {
                        this.inputdirname = stringArray[i].substring(3);
                    }
                    if (stringArray[i].charAt(2) != 'o') continue block7;
                    this.outputdirname = stringArray[i].substring(3);
                    continue block7;
                }
                case 'f': {
                    this.filename = stringArray[i].substring(2);
                    continue block7;
                }
                default: {
                    System.out.println("\n*** Argument " + i + " not known, usage:");
                    this.Usage();
                    return 3;
                }
                case 'o': {
                    this.outputmode = Integer.parseInt(stringArray[i].substring(2));
                }
            }
        }
        File file = new File(this.inputdirname);
        if (!file.isDirectory()) {
            System.out.println(this.inputdirname + " for file input is not a directory");
            return 1;
        }
        file = new File(this.outputdirname);
        if (!file.isDirectory()) {
            System.out.println(this.outputdirname + " for file output is not a directory");
            return 1;
        }
        return 0;
    }

    public void Usage() {
        EventTimeSeries eventTimeSeries = new EventTimeSeries();
        System.out.println("...............................................................................");
        System.out.println("Usage: ");
        System.out.println("DistributionAnalysis <options> ");
        System.out.println(" where options are -<char><value> separated by space as follows ");
        System.out.println("  -ba#                Bin width for times pre avalanche calculations, default " + eventTimeSeries.avBinScale);
        System.out.println("  -bb#                Bin width for log binning avalanche calculations, default " + eventTimeSeries.avLogBinScale);
        System.out.println("  -bd#                Bin width for log binning time differences, default " + eventTimeSeries.diffLogBinScale);
        System.out.println("  -c#                Choose column # of data, default " + eventTimeSeries.tFileCol);
        System.out.println("  -f<nameroot>       Input file name (used to provide root for outfiles), default " + eventTimeSeries.filename);
        System.out.println("  -di<inputdirname>  Sets name of input file directory , default " + eventTimeSeries.inputdirname);
        System.out.println("  -do<inputdirname>  Sets name of input file directory , default " + eventTimeSeries.outputdirname);
        System.out.println(" -o<int> output modes , default " + eventTimeSeries.outputmode);
        System.out.println("  o modes:  (o& 1) ? Raw Time differences    on : (off), default" + ((eventTimeSeries.outputmode & 1) > 0 ? "on" : "off"));
        System.out.println("            (o& 2) ? Ranked Time differences on : (off), default" + ((eventTimeSeries.outputmode & 2) > 0 ? "on" : "off"));
        System.out.println("            (o& 4) ? Log Binned differences  on : (off), default" + ((eventTimeSeries.outputmode & 4) > 0 ? "on" : "off"));
        System.out.println("            (o& 8) ? Raw Times               on : (off), default" + ((eventTimeSeries.outputmode & 8) > 0 ? "on" : "off"));
        System.out.println("           (o& 16) ? Times in Bins           on : (off), default" + ((eventTimeSeries.outputmode & 0x10) > 0 ? "on" : "off"));
        System.out.println("           (o& 32) ? Avalanche lengths       on : (off), default" + ((eventTimeSeries.outputmode & 0x20) > 0 ? "on" : "off"));
        System.out.println("           (o& 64) ? Avalanche sizes         on : (off), default" + ((eventTimeSeries.outputmode & 0x40) > 0 ? "on" : "off"));
        System.out.println("...............................................................................");
    }
}

