/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import DataAnalysis.MutualInformation;
import DataAnalysis.StatisticalQuantity;

public class EntropyStatistics {
    StatisticalQuantity order;
    StatisticalQuantity entropy;
    StatisticalQuantity entropyOverMaximum;
    String name = "";

    public EntropyStatistics(String string) {
        this.name = string;
        this.reset();
    }

    public void reset() {
        this.order = new StatisticalQuantity();
        this.entropy = new StatisticalQuantity();
        this.entropyOverMaximum = new StatisticalQuantity();
        this.order.setName(this.name + "Order_n");
        this.entropy.setName(this.name + "S");
        this.entropyOverMaximum.setName(this.name + "S/ln(n)");
    }

    public void addOne(MutualInformation mutualInformation) {
        this.entropy.add(mutualInformation.getEntropyOne());
        this.order.add(mutualInformation.getOrderOne());
        this.entropyOverMaximum.add(mutualInformation.getEntropyOneOverMax());
    }

    public void addTwo(MutualInformation mutualInformation) {
        this.entropy.add(mutualInformation.getEntropyTwo());
        this.order.add(mutualInformation.getOrderTwo());
        this.entropyOverMaximum.add(mutualInformation.getEntropyTwoOverMax());
    }

    public StatisticalQuantity getOrder() {
        return this.order;
    }

    public StatisticalQuantity getEntropy() {
        return this.entropy;
    }

    public StatisticalQuantity getEntropyOverMaximum() {
        return this.entropyOverMaximum;
    }

    public String toLabel(String string) {
        String string2 = this.getOrder().labelString(string) + string + this.getEntropy().labelString(string) + string + this.getEntropyOverMaximum().labelString(string);
        return string2;
    }

    public String toString(String string) {
        String string2 = this.getOrder().toString(string) + string + this.getEntropy().toString(string) + string + this.getEntropyOverMaximum().toString(string);
        return string2;
    }

    public String averagesLabel(String string) {
        String string2 = this.getOrder().getName() + string + this.getEntropy().getName() + string + this.getEntropyOverMaximum().getName();
        return string2;
    }

    public String averagesString(String string) {
        String string2 = this.getOrder().getAverage() + string + this.getEntropy().getAverage() + string + this.getEntropyOverMaximum().getAverage();
        return string2;
    }
}

