/*
 * Decompiled with CFR 0.152.
 */
package DataAnalysis;

import DataAnalysis.StatisticalQuantity;
import JavaNotes.TextReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class DataAverage {
    String DAVersion = "DataAverage050601";
    String SEP = "\t";
    String nameroot = "test";
    String dirname = "/PRG/networks/DataAnalysis/output/";
    String inputFileExtension = ".tdata.dat";
    int MaxColumnsToBeRead = 20;
    int[] columnsToBeRead = new int[this.MaxColumnsToBeRead];
    int numberColumnsToBeRead;
    String[] columnLabel;
    String labelLine = "#t";
    int totalNumbersOfDataLines;
    int MaxNumberValues;
    int[] xValue;
    StatisticalQuantity[][] yValue;
    int infolevel = 2;
    int outputcontrol = 255;
    String[] filelist;
    String[] filenamerootlist;

    public DataAverage() {
        this.columnsToBeRead[0] = 0;
        this.numberColumnsToBeRead = 1;
        this.columnLabel = new String[this.MaxColumnsToBeRead];
        this.MaxNumberValues = 1000;
        this.totalNumbersOfDataLines = -1;
    }

    public static void main(String[] stringArray) {
        DataAverage dataAverage = new DataAverage();
        int n = dataAverage.ParamParse(stringArray);
        dataAverage.printParameters();
        if (n != 0) {
            return;
        }
        dataAverage.processAll("#");
        dataAverage.FileOutputParameters("#");
        dataAverage.FileOutputTotalData("#");
        System.out.println("**** Finished Data Average ***\n");
    }

    void FileOutputParameters(String string) {
        String string2 = this.dirname + this.nameroot + "_info.dat";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            Date date = new Date();
            this.printParameters(printStream);
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    void FileOutputTotalData(String string) {
        String string2 = this.inputFileExtension;
        int n = this.inputFileExtension.lastIndexOf(46);
        if (n >= 0) {
            string2 = this.inputFileExtension.substring(0, n);
        }
        String string3 = this.dirname + this.nameroot + string2 + ".TOT.dat";
        try {
            int n2;
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (this.infolevel > 0) {
                System.out.println(string + " writing averaged data to " + this.SEP + string3);
            }
            Date date = new Date();
            printStream.println(string + " Averaged data for " + this.SEP + this.filelist.length + this.SEP + " files of " + this.SEP + this.nameroot + "*" + this.inputFileExtension + this.SEP + this.DAVersion + this.SEP + date + " ");
            printStream.print(this.columnLabel[0] + this.SEP);
            for (n2 = 1; n2 < this.numberColumnsToBeRead; ++n2) {
                printStream.print(this.columnLabel[n2] + " Av" + this.SEP + this.columnLabel[n2] + " Sigma" + this.SEP + this.columnLabel[n2] + " min" + this.SEP + this.columnLabel[n2] + " max" + this.SEP);
            }
            printStream.println();
            for (n2 = 0; n2 < this.totalNumbersOfDataLines; ++n2) {
                printStream.print(this.xValue[n2] + this.SEP);
                for (int i = 1; i < this.numberColumnsToBeRead; ++i) {
                    printStream.print(this.yValue[n2][i - 1].getAverage() + this.SEP + this.yValue[n2][i - 1].getSigma() + this.SEP + this.yValue[n2][i - 1].minimum + this.SEP + this.yValue[n2][i - 1].maximum + this.SEP);
                }
                printStream.println();
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Close Error " + string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string3);
        }
    }

    public void getFileList(String string) {
        File file = new File(this.dirname);
        if (!file.isDirectory()) {
            System.out.println(this.dirname + " not a directory");
            return;
        }
        if (this.infolevel > 0) {
            System.out.println("Looking at directory " + this.dirname);
        }
        OnlyOneParamSet onlyOneParamSet = new OnlyOneParamSet(this.nameroot, string);
        this.filelist = file.list(onlyOneParamSet);
        if (this.infolevel > 0) {
            System.out.println("Found  " + this.filelist.length + " files with extension " + string);
        }
        this.filenamerootlist = new String[this.filelist.length];
        for (int i = 0; i < this.filelist.length; ++i) {
            this.filenamerootlist[i] = this.getFileNameRoot(this.filelist[i], string);
            if (this.infolevel <= 0) continue;
            System.out.println(this.filelist[i] + "\t " + this.filenamerootlist[i]);
        }
    }

    public String getFileNameRoot(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getData(String string, String string2, boolean bl) {
        TextReader textReader;
        String string3 = this.dirname + string;
        if (this.infolevel > 1) {
            System.out.println("Starting to read from " + string3);
        }
        int n = 100;
        String[] stringArray = new String[n];
        int n2 = 0;
        if (bl) {
            this.xValue = new int[this.MaxNumberValues];
            this.yValue = new StatisticalQuantity[this.MaxNumberValues][this.numberColumnsToBeRead - 1];
        }
        try {
            textReader = new TextReader(new FileReader(string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can't find file " + string);
            return 1;
        }
        try {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (!textReader.eof()) {
                int n6;
                int n7;
                ++n3;
                n5 = 0;
                while (!textReader.eoln()) {
                    stringArray[n5] = textReader.getWord();
                    ++n5;
                }
                if (n5 == 0) continue;
                if (stringArray[0].startsWith(this.labelLine)) {
                    if (!bl) continue;
                    this.columnLabel[0] = stringArray[0];
                    for (n7 = 1; n7 < this.numberColumnsToBeRead; ++n7) {
                        n6 = this.columnsToBeRead[n7];
                        if (n6 >= n5) {
                            this.printWarning(" in getData too few columns in label line at line " + n3 + ", colno=" + n5 + ", c=" + n6);
                        }
                        this.columnLabel[n7] = stringArray[n6];
                    }
                    System.out.println(" --- Label line is line number " + n3);
                    continue;
                }
                if (stringArray[0].startsWith(string2)) continue;
                if (n5 >= n) {
                    this.printWarning(" in getData too many columns at line " + n3 + ", colno=" + n5 + ", numberDataColumns=" + n);
                }
                if (n5 >= n) {
                    this.printWarning(" in getData too many columns at line " + n3 + ", colno=" + n5 + ", numberDataColumns=" + n);
                }
                int n8 = Integer.parseInt(stringArray[this.columnsToBeRead[0]]);
                if (bl) {
                    this.xValue[n4] = n8;
                } else if (this.xValue[n4] != n8) {
                    this.printError(" in getData wrong value of x line " + n3 + " data entry number " + n4 + ", found " + n8 + " should be " + this.xValue[n4]);
                    n7 = 3;
                    return n7;
                }
                for (n7 = 1; n7 < this.numberColumnsToBeRead; ++n7) {
                    n6 = this.columnsToBeRead[n7];
                    if (n6 >= n5) {
                        this.printWarning(" in getData too few columns at line " + n3 + ", colno=" + n5 + ", c=" + n6);
                    }
                    double d = Double.parseDouble(stringArray[n6]);
                    if (bl) {
                        this.yValue[n4][n7 - 1] = new StatisticalQuantity();
                        this.yValue[n4][n7 - 1].add(d);
                        continue;
                    }
                    this.yValue[n4][n7 - 1].add(d);
                }
                ++n4;
            }
            if (bl) {
                this.totalNumbersOfDataLines = n4;
                System.out.println("Read " + this.totalNumbersOfDataLines + " lines of data");
            }
            if (this.totalNumbersOfDataLines != n4) {
                this.printError(" in getData found " + n4 + " data lines but wanted " + this.totalNumbersOfDataLines + " lines of data");
            }
        }
        catch (TextReader.Error error) {
            if (this.infolevel > 0) {
                System.out.println("Input Error: " + error.getMessage());
            }
            n2 = 2;
        }
        finally {
            textReader.close();
        }
        return n2;
    }

    public int ParamParse(String[] stringArray) {
        block9: for (int i = 0; i < stringArray.length; ++i) {
            if (this.infolevel > 0) {
                System.out.println("Parameter " + i + " is " + stringArray[i]);
            }
            if (stringArray[i].length() < 2) {
                System.out.println("\n*** Argument " + i + " is too short");
                return 1;
            }
            if (stringArray[i].charAt(0) != '-') {
                System.out.println("\n*** Argument " + i + " does not start with -");
                return 2;
            }
            switch (stringArray[i].charAt(1)) {
                case 'c': {
                    if (stringArray[i].charAt(2) == 'x') {
                        this.columnsToBeRead[0] = Integer.parseInt(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) != 'y') continue block9;
                    this.columnsToBeRead[this.numberColumnsToBeRead++] = Integer.parseInt(stringArray[i].substring(3));
                    continue block9;
                }
                case 'd': {
                    this.dirname = stringArray[i].substring(2);
                    continue block9;
                }
                case 'e': {
                    this.inputFileExtension = stringArray[i].substring(2);
                    continue block9;
                }
                case 'f': {
                    this.nameroot = stringArray[i].substring(2);
                    continue block9;
                }
                case 'l': {
                    this.labelLine = stringArray[i].substring(2);
                    continue block9;
                }
                case 'o': {
                    this.outputcontrol = Integer.parseInt(stringArray[i].substring(2));
                    continue block9;
                }
                case 'x': {
                    this.MaxNumberValues = Integer.parseInt(stringArray[i].substring(2));
                    continue block9;
                }
                default: {
                    System.out.println("\n*** Argument " + i + " not known, usage:");
                    this.Usage();
                    return 3;
                }
            }
        }
        File file = new File(this.dirname);
        if (!file.isDirectory()) {
            System.out.println(this.dirname + " is not a directory");
            return 1;
        }
        return 0;
    }

    void processAll(String string) {
        this.getFileList(this.inputFileExtension);
        if (this.filelist.length == 0) {
            System.out.println(" *** No " + this.inputFileExtension + " files found");
            return;
        }
        for (int i = 0; i < this.filelist.length; ++i) {
            String string2 = this.filelist[i];
            String string3 = this.filenamerootlist[i];
            if (this.getData(string2, string, i == 0) == 0) continue;
        }
    }

    public void Usage() {
        DataAverage dataAverage = new DataAverage();
        System.out.println("...............................................................................");
        System.out.println("Usage: ");
        System.out.println("DataAverage <options> ");
        System.out.println(" where options are -<char><value> separated by space as follows ");
        System.out.println("  -f<nameroot>       Sets root of input and output files to be nameroot, default " + dataAverage.nameroot);
        System.out.println("  -d<dirname>        Sets directory name, default " + dataAverage.dirname);
        System.out.println("  -e<inputFileExtension>     Extension of input files, default " + dataAverage.inputFileExtension);
        System.out.println("  -cx#                Choose column # of x data, only one accepted. ");
        System.out.println("  -cy#                Choose column # of y data, may repeat many times. ");
        System.out.println("                      *** note columns are numbered starting from 0. ");
        System.out.println("  -x#                Maximum number of data lines, default " + dataAverage.MaxNumberValues);
        System.out.println("...............................................................................");
    }

    public void printParameters() {
        this.printParameters(System.out);
    }

    public void printParameters(PrintStream printStream) {
        Date date = new Date();
        printStream.println("\n------------------------------------------------------- " + this.DAVersion + this.SEP + date);
        printStream.println("                        Filename root: " + this.SEP + this.nameroot);
        printStream.println("                       Directory name: " + this.SEP + this.dirname);
        printStream.println("                 Input file extension: " + this.SEP + this.inputFileExtension);
        printStream.println("                        Lines of Data: " + this.SEP + this.totalNumbersOfDataLines);
        printStream.println("                   Columns of of Data: " + this.SEP + this.numberColumnsToBeRead);
        printStream.print("                      Data in columns: " + this.SEP);
        for (int i = 0; i < this.numberColumnsToBeRead; ++i) {
            printStream.print(this.columnsToBeRead[i] + this.SEP);
        }
        printStream.println();
        printStream.println("-------------------------------------------------------");
    }

    public void listdir() {
        File file = new File(this.dirname);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
    }

    public void printError(String string) {
        this.printLine(System.out, "*** " + string);
    }

    public void printWarning(String string) {
        if (this.infolevel > 0) {
            this.printLine(System.out, "--- " + string);
        }
    }

    public void printLine(PrintStream printStream, String string) {
        printStream.println(string);
    }

    public class OneParamStatistics {
        double minimum = 9999999.0;
        double maximum = 0.0;
        double average = 0.0;
        double error = 0.0;
        double sigma = 0.0;
        double sigma2 = 0.0;
        double total = 0.0;
        double totalsquares = 0.0;
        int number = 0;

        public void update(double d) {
            ++this.number;
            this.total += d;
            this.totalsquares += d * d;
            if (d < this.minimum) {
                this.minimum = d;
            }
            if (d > this.maximum) {
                this.maximum = d;
            }
            this.average = this.total / (double)this.number;
            this.sigma2 = this.totalsquares / (double)this.number - this.average * this.average;
            this.sigma = this.sigma2 > 0.0 ? Math.sqrt(this.totalsquares / (double)this.number - this.average * this.average) : 0.0;
            this.error = this.number > 1 ? this.sigma / Math.sqrt(this.number - 1) : 0.0;
        }

        public void print(String string) {
            System.out.println(this.minimum + " <= " + string + " <= " + this.maximum);
            System.out.println("<" + string + "> = " + this.average + " +/- " + this.error);
            System.out.println("           sigma = " + this.sigma + ", samples = " + this.number);
        }

        public void print(PrintStream printStream, String string) {
            printStream.println(this.minimum + " <= " + string + " <= " + this.maximum);
            printStream.println("<" + string + "> = " + this.average + " +/- " + this.error);
            printStream.println("           sigma = " + this.sigma + ", samples = " + this.number);
        }

        public void printExcel(PrintStream printStream, String string) {
            printStream.print(" \t" + string + " \t" + this.average + " \t" + this.error + " \t" + this.sigma + " \t" + this.minimum + " \t " + this.maximum + " \t" + this.number);
        }
    }

    public class OnlyOneParamSet
    implements FilenameFilter {
        String ext;
        String header;

        public OnlyOneParamSet(String string, String string2) {
            this.ext = string2;
            this.header = string;
        }

        public boolean accept(File file, String string) {
            return string.endsWith(this.ext) & string.startsWith(this.header);
        }
    }
}

