/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import JavaNotes.TextReader;
import TimGraph.Community.Partition;
import TimGraph.Community.VertexPartition;
import TimGraph.Coordinate;
import TimGraph.DegreeDistribution;
import TimGraph.EdgeValue;
import TimGraph.OutputMode;
import TimGraph.RandomWalk;
import TimGraph.Rank;
import TimGraph.VertexLabel;
import TimGraph.algorithms.LineGraphProjector;
import TimGraph.io.FileInput;
import TimGraph.io.FileOutput;
import TimGraph.io.GraphViz;
import TimGraph.io.InputFileType;
import TimUtilities.FileUtilities.FileNameSequence;
import TimUtilities.NumbersToString;
import TimUtilities.StringUtilities.Filters.StringFilter;
import TimUtilities.TimMessage;
import TimUtilities.TimTime;
import TimUtilities.TimTiming;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class timgraph {
    static final String VERSION = "tg110504";
    static final int MININT = Integer.MAX_VALUE;
    static final int MAXINT = Integer.MIN_VALUE;
    boolean DEBUG = false;
    public static final String SEP = "\t ";
    public static final String NONAME = "timgraph";
    public static final String COMMENTCHARACTER = "#";
    public static final char TIMGRAPH_ARGUMENT = '-';
    public static final char[] NOT_TIMGRAPH_ARGUMENT = new char[]{'*', '^', ':'};
    static NumbersToString n2s = new NumbersToString();
    static final int MAXEDGETARGET = Integer.MAX_VALUE;
    static final int MAXEDGESOURCE = 0x7FFFFFFE;
    public static final int IUNSET = -135798642;
    public static final double DUNSET = -3.57986421E8;
    public static final String SUNSET = "UNSET";
    Date date = new Date();
    TimTiming timing = new TimTiming();
    public RandomWalk randomWalk;
    public Random Rnd;
    private int TotalNumberVertices = 0;
    private int TotalNumberStubs = 0;
    private double TotalWeight = -3.57986421E8;
    private double degreeSecondMoment = -3.57986421E8;
    private int TotalNumberTriangles = -135798642;
    private int TotalNumberSquares = -135798642;
    private double ccGlobal = -3.57986421E8;
    IntArrayList[] vertexList;
    IntArrayList[] vertexSourceList;
    private boolean vertexEdgeListOn = false;
    IntArrayList[] vertexEdgeList;
    IntArrayList[] vertexInEdgeList;
    VertexLabel[] vertexLabelList;
    IntArrayList[] strengthlist;
    IntArrayList[] rvertexList;
    int[] stubSourceList;
    EdgeValue[] edgeValuetList;
    int[] edgerandomlist;
    boolean directedGraph = false;
    boolean vertexlabels = false;
    boolean weightedEdges = false;
    boolean labelledEdges = false;
    boolean selfLoops = true;
    boolean multiEdge = true;
    private boolean bipartiteGraph = false;
    private int numberVertexType1 = -1;
    private String nameVertexType1 = "Type1";
    private int numberVertexType2 = -1;
    private String nameVertexType2 = "Type2";
    protected VertexLabel minimumVertexLabel = null;
    protected VertexLabel maximumVertexLabel = null;
    protected EdgeValue minimumEdgeValue = null;
    protected EdgeValue maximumEdgeValue = null;
    DegreeDistribution DDtotal;
    DegreeDistribution DDin;
    DegreeDistribution DDout;
    DegreeDistribution DD1total;
    DegreeDistribution DD2total;
    int LogBinVerticesMinimum = 99;
    IntArrayList weightdarr = new IntArrayList();
    IntArrayList rddarr = new IntArrayList();
    int maxmoment = 10;
    int weightmaximum = -1;
    int maxonewalk = -2;
    int[] vertexdistance;
    IntArrayList distancedist;
    DoubleArrayList ringdegree;
    int[] vertexComponent;
    IntArrayList componentSize;
    IntArrayList componentEdges;
    IntArrayList componentmu2;
    IntArrayList componentSource;
    IntArrayList componentDist;
    int componentsize;
    int componentSizeMax;
    int componentSourceMax;
    int componentDiameterMax;
    int componentGCCIndex;
    double componentGCCDist;
    int componentSingleNumber;
    int diameter;
    double distanceaverage = 0.0;
    double distanceerror = 0.0;
    double distancesigma = 0.0;
    int nsamples;
    DoubleArrayList avdistancedist;
    double onesdistanceav = 0.0;
    double onesdistanceerror = 0.0;
    double onesdistancesigma = 0.0;
    DoubleArrayList totdistancedist;
    DoubleArrayList totdistance2dist;
    double totdistanceaverage = 0.0;
    double totdistanceerror = 0.0;
    double totdistancesigma = 0.0;
    IntArrayList diameterdist;
    int diametermax;
    int diametermin;
    double diameteraverage;
    double diametererror;
    double diametersigma;
    double DijkstraMaxDist;
    double MAXDISTANCE = 1.0E99;
    double[][] distance;
    int CCnsamples;
    double CCaverage;
    double CCerror;
    double CCsigma;
    int CCEdgensamples;
    double CCEdgeaverage;
    double CCEdgeerror;
    double CCEdgesigma;
    double averagesteplength;
    public FileNameSequence inputName;
    public InputFileType inputFileType = new InputFileType(0);
    public static final String[] pajekColour = new String[]{"White", "Yellow", "Pink", "Cyan", "Orange", "Magenta", "Purple", "Green", "Blue", "Brown", "Black"};
    public FileNameSequence outputName;
    private int maximumVertices = 1000;
    private int maximumStubs = 1000;
    int maximumconnectivity = 1000;
    double connectivity = 2.0;
    double maxexpectededges = (double)this.maximumVertices * this.connectivity * 2.0;
    double maxexpectedvertices = this.maximumVertices;
    int numevents = 0;
    double averageWalkLength = 1.0;
    int maxWalkLength = (int)(this.averageWalkLength + 0.5) * 3;
    double rankingProbabilityLengthScale = -1.0;
    public int binomialNumber = 1;
    int numruns = 1;
    double probnewvertex = 1.0;
    double probpp = 1.0;
    double probpr = 0.0;
    double probpra = 0.0;
    double probqp = 1.0;
    double probqra = 0.0;
    int initialgraph = 1;
    int initialConnectivity = -1;
    int initialVertices = -1;
    int initialXsize = -1;
    int initialYsize = -1;
    int initialEdges = -1;
    TimMessage message = new TimMessage(0);
    public int infoLevel;
    public OutputMode outputControl;
    boolean WeightCalcOn = true;
    double logbinratio = 1.1;
    boolean SourceVertex = true;
    int randomWalkMode = 1;
    int edgegenerator = 0;

    public timgraph() {
        this.initialiseRandomGenerator();
        this.initialiseSomeParameters("test", System.getProperty("user.dir"), 0, 0);
    }

    public timgraph(String[] args) {
        this.initialiseRandomGenerator();
        this.initialiseSomeParameters("test", System.getProperty("user.dir"), 0, 0);
        this.parseParam(args);
    }

    public timgraph(long rndseed) {
        this.Rnd = new Random(rndseed);
        this.initialiseSomeParameters("test", System.getProperty("user.dir"), 0, 0);
    }

    public timgraph(String namert, String dnameroot, int infol, int outputc) {
        this.initialiseRandomGenerator();
        this.initialiseSomeParameters(namert, dnameroot, infol, outputc);
        if (this.infoLevel > 2) {
            System.out.println("Uses time to seed Rnd");
        }
    }

    public timgraph(String namert, String dnameroot, int infol, int outputc, boolean makeDirected, boolean makeLabelled, boolean makeWeighted, boolean makeVertexEdgeList, int maxVertices, int maxEdges) {
        this.initialiseRandomGenerator();
        this.initialiseSomeParameters(namert, dnameroot, infol, outputc);
        if (this.infoLevel > 0) {
            System.out.println("Uses time to seed Rnd");
        }
        this.maximumVertices = maxVertices;
        this.maximumStubs = maxEdges;
        this.directedGraph = makeDirected;
        this.vertexlabels = makeLabelled;
        this.weightedEdges = makeWeighted;
        this.vertexEdgeListOn = makeVertexEdgeList;
        this.setNetwork();
    }

    public timgraph(String namert, String dname, int infol, int outputc, boolean makeDirected, boolean makeLabelled, boolean makeWeighted, int maxVertices, int[] stubList) {
        this.initialiseRandomGenerator();
        this.directedGraph = makeDirected;
        this.vertexlabels = makeLabelled;
        this.weightedEdges = makeWeighted;
        this.maximumVertices = maxVertices;
        this.maximumStubs = stubList.length >> 1 << 1;
        this.directedGraph = makeDirected;
        this.vertexlabels = false;
        this.weightedEdges = makeWeighted;
        boolean shuffleOn = true;
        this.setNetwork(this.maximumVertices, stubList, shuffleOn);
    }

    public timgraph(timgraph oldtg, int maxVertices, int maxStubs, boolean makeUndirected, boolean makeUnlabelled, boolean reverseDirection) {
        int v;
        this.initialiseRandomGenerator();
        this.infoLevel = oldtg.infoLevel;
        if (this.infoLevel > 0) {
            System.out.println("Uses time to seed Rnd");
        }
        boolean result = false;
        this.vertexlabels = oldtg.vertexlabels;
        if (makeUnlabelled) {
            this.vertexlabels = false;
        }
        this.directedGraph = oldtg.directedGraph;
        if (makeUndirected) {
            this.directedGraph = false;
        }
        this.inputName = new FileNameSequence(oldtg.inputName);
        this.outputName = new FileNameSequence(oldtg.outputName);
        int TNV = oldtg.TotalNumberVertices;
        int TNS = oldtg.TotalNumberStubs;
        this.setNetwork(Math.max(TNV, maxVertices), Math.max(TNS, maxStubs));
        this.outputControl = new OutputMode(oldtg.outputControl);
        this.vertexList = new IntArrayList[TNV];
        if (this.vertexEdgeListOn) {
            this.vertexEdgeList = new IntArrayList[TNV];
            if (this.directedGraph) {
                this.vertexInEdgeList = new IntArrayList[TNV];
            }
        }
        if (this.directedGraph) {
            this.vertexSourceList = new IntArrayList[TNV];
        }
        if (this.vertexlabels) {
            this.vertexLabelList = new VertexLabel[TNV];
            if (oldtg.minimumVertexLabel != null) {
                this.minimumVertexLabel = new VertexLabel(this.minimumVertexLabel);
            }
            if (oldtg.maximumVertexLabel != null) {
                this.maximumVertexLabel = new VertexLabel(this.maximumVertexLabel);
            }
        }
        this.TotalNumberVertices = 0;
        if (this.vertexlabels) {
            for (v = 0; v < TNV; ++v) {
                this.addVertex(oldtg.vertexLabelList[v]);
            }
        } else {
            for (v = 0; v < TNV; ++v) {
                this.addVertex();
            }
        }
        this.stubSourceList = new int[TNS];
        this.TotalNumberStubs = 0;
        int v1 = -1;
        int v2 = -1;
        EdgeValue w1 = new EdgeValue();
        EdgeValue w2 = new EdgeValue();
        if (this.weightedEdges) {
            int e = 0;
            while (e < oldtg.TotalNumberStubs) {
                v1 = oldtg.stubSourceList[e];
                w1 = oldtg.edgeValuetList[e++];
                v2 = oldtg.stubSourceList[e];
                w2 = oldtg.edgeValuetList[e++];
                if (reverseDirection) {
                    this.addEdge(v2, v1, w1);
                    continue;
                }
                this.addEdge(v1, v2, w1);
            }
        } else {
            int e = 0;
            while (e < oldtg.TotalNumberStubs) {
                v1 = oldtg.stubSourceList[e++];
                v2 = oldtg.stubSourceList[e++];
                if (reverseDirection) {
                    this.addEdge(v2, v1);
                    continue;
                }
                this.addEdge(v1, v2);
            }
        }
        if (TNS != this.TotalNumberStubs) {
            result = true;
            System.out.println("*** Total Number Edges wrong in timgraph constructor");
        }
        if (this.bipartiteGraph) {
            this.setBipartite(oldtg.getNumberVerticesType1(), oldtg.getNumberVerticesType2(), oldtg.getNameVerticesType1(), oldtg.getNameVerticesType2());
        }
        if (oldtg.vertexEdgeListOn) {
            this.createVertexGlobalEdgeList();
        }
    }

    public timgraph(timgraph oldtg, int[] partition, int numberPartitions, boolean makeUndirected, boolean makeUnweighted) {
        this.infoLevel = oldtg.infoLevel;
        this.vertexEdgeListOn = true;
        this.initialiseRandomGenerator();
        this.directedGraph = oldtg.directedGraph;
        if (makeUndirected) {
            this.directedGraph = false;
        }
        this.weightedEdges = !makeUnweighted;
        this.vertexlabels = false;
        this.inputName = new FileNameSequence(oldtg.inputName);
        this.outputName = new FileNameSequence(oldtg.outputName);
        this.maximumVertices = numberPartitions;
        this.maximumStubs = this.directedGraph ? this.maximumVertices * this.maximumVertices * 2 : this.maximumVertices * (this.maximumVertices + 1);
        this.setNetwork();
        for (int v = 0; v < numberPartitions; ++v) {
            this.addVertex();
        }
        this.TotalNumberStubs = 0;
        int s = -1;
        int t = -1;
        int cs = -1;
        int ct = -1;
        double w = 1.0;
        for (int e = 0; e < oldtg.TotalNumberStubs; ++e) {
            s = oldtg.getVertexFromEdge(e++);
            t = oldtg.getVertexFromEdge(e);
            cs = partition[s];
            ct = partition[t];
            if (this.weightedEdges) {
                double d = w = oldtg.weightedEdges ? oldtg.getEdgeWeight(e) : 1.0;
                if (!oldtg.isDirected() && cs == ct && s != t) {
                    w += w;
                }
                this.increaseEdgeWeight(cs, ct, w);
                continue;
            }
            this.addEdgeUnique(cs, ct);
        }
    }

    public timgraph(timgraph oldtg, boolean makeUndirected, boolean makeUnweighted, boolean useSelfLoops, boolean makeUnlabelled, boolean reverseDirection) {
        int v;
        if (!oldtg.isVertexEdgeListOn()) {
            System.err.println("*** timgraph Line Graph constructor needs vertexEdgeList to be on.");
        }
        this.infoLevel = oldtg.infoLevel;
        this.vertexEdgeListOn = true;
        this.initialiseRandomGenerator();
        this.directedGraph = oldtg.directedGraph;
        if (makeUndirected) {
            this.directedGraph = false;
        }
        this.weightedEdges = !makeUnweighted;
        this.vertexlabels = false;
        this.inputName = new FileNameSequence(oldtg.inputName);
        this.outputName = new FileNameSequence(oldtg.outputName);
        int noselfloops = 1;
        if (useSelfLoops) {
            noselfloops = 0;
        }
        this.maximumVertices = oldtg.getNumberStubs() / 2;
        this.maximumStubs = 0;
        if (this.directedGraph) {
            for (v = 0; v < oldtg.getNumberVertices(); ++v) {
                this.maximumStubs += oldtg.getVertexInDegree(v) * oldtg.getVertexOutDegree(v);
            }
        } else {
            for (v = 0; v < oldtg.getNumberVertices(); ++v) {
                int k = oldtg.getVertexDegree(v);
                this.maximumStubs += k * (k - noselfloops) / 2;
            }
        }
        this.maximumStubs *= 2;
        this.setNetwork();
        for (v = 0; v < this.maximumVertices; ++v) {
            this.addVertex();
        }
        this.TotalNumberStubs = 0;
        int e1 = -1;
        int e2 = -1;
        double w = 1.0;
        if (oldtg.isDirected()) {
            int kin = -1;
            int kout = -1;
            for (int v2 = 0; v2 < oldtg.getNumberVertices(); ++v2) {
                kin = oldtg.getVertexDegree(v2);
                if (kin < 1 || (kout = oldtg.getVertexDegree(v2)) < 1) continue;
                if (this.weightedEdges) {
                    w = 1.0 / Math.sqrt((double)kin * (double)kout);
                }
                for (int ei = 0; ei < oldtg.vertexInEdgeList[v2].size(); ++ei) {
                    e1 = oldtg.vertexInEdgeList[v2].get(ei);
                    for (int eo = 0; eo < oldtg.vertexEdgeList[v2].size(); ++eo) {
                        e2 = oldtg.vertexEdgeList[v2].get(eo);
                        if (this.weightedEdges) {
                            this.increaseEdgeWeight(e1 / 2, e2 / 2, w);
                            continue;
                        }
                        this.addEdgeUnique(e1 / 2, e2 / 2);
                    }
                }
            }
        } else {
            int kv = -1;
            for (int v3 = 0; v3 < oldtg.getNumberVertices(); ++v3) {
                kv = oldtg.getVertexDegree(v3);
                if (kv < 1 + noselfloops) continue;
                if (this.weightedEdges) {
                    w = 1.0 / (double)(kv - noselfloops);
                }
                for (int ei = 0; ei < oldtg.vertexEdgeList[v3].size(); ++ei) {
                    e1 = oldtg.vertexEdgeList[v3].get(ei);
                    for (int eo = ei + noselfloops; eo < oldtg.vertexEdgeList[v3].size(); ++eo) {
                        e2 = oldtg.vertexEdgeList[v3].get(eo);
                        if (this.weightedEdges) {
                            this.increaseEdgeWeight(e1 / 2, e2 / 2, w);
                            continue;
                        }
                        this.addEdgeUnique(e1 / 2, e2 / 2);
                    }
                }
            }
        }
    }

    private void initialiseRandomGenerator() {
        this.Rnd = new Random();
        if (this.infoLevel > 2) {
            System.out.println("Uses time to seed Rnd");
        }
    }

    public void initialiseSomeParameters(String namert, String dnameroot, int infol, int outputc) {
        String drt = FileNameSequence.makeDirectory((String)dnameroot);
        this.initialiseSomeParameters(namert, drt, namert, drt, infol, outputc);
    }

    public void initialiseSomeParameters(String innamert, String indname, String outnamert, String outdname, int infol, int outputc) {
        this.inputName = new FileNameSequence(indname, "input/", innamert, "");
        this.outputName = new FileNameSequence(outdname, "output/", outnamert, "");
        this.infoLevel = infol;
        this.message.setInformationLevel(infol);
        this.outputControl = new OutputMode(outputc);
    }

    public void createVertexGlobalEdgeList() {
        int s;
        this.vertexEdgeListOn = true;
        this.vertexEdgeList = new IntArrayList[this.maximumVertices];
        for (s = 0; s < this.TotalNumberVertices; ++s) {
            this.vertexEdgeList[s] = new IntArrayList(this.getVertexDegree(s));
        }
        if (this.directedGraph) {
            this.vertexInEdgeList = new IntArrayList[this.maximumVertices];
            for (s = 0; s < this.TotalNumberVertices; ++s) {
                this.vertexInEdgeList[s] = new IntArrayList(this.getVertexInDegree(s));
            }
        }
        s = -1;
        int t = -1;
        for (int e = 0; e < this.TotalNumberStubs; ++e) {
            s = this.stubSourceList[e];
            this.vertexEdgeList[s].add(e);
            t = this.stubSourceList[++e];
            if (this.directedGraph) {
                this.vertexInEdgeList[t].add(e);
                continue;
            }
            this.vertexEdgeList[t].add(e);
        }
    }

    public String informationString() {
        return "timgraph version tg110504 on " + this.date;
    }

    public static void main(String[] args) {
        System.out.println("\n***********************************************************");
        timgraph tg = new timgraph();
        if (tg.DEBUG) {
            tg.testtimgraph();
        } else {
            System.out.println("       STARTING " + tg.informationString());
            if (tg.parseParam(args) > 0) {
                return;
            }
        }
        tg.doOneRun(0);
        tg.OutputGraphInfo(System.out, COMMENTCHARACTER, 0.0);
        tg.generalOutput(COMMENTCHARACTER, 0.0);
    }

    public void testtimgraph() {
        System.out.println(" ### TESTING timgraph version tg110504 on " + this.date);
        System.out.println(" ###  ");
        String[] arg = new String[]{"-gn-5", "-gv27", "-gm1", "-e0", "-o8", "-xi2"};
        if (this.parseParam(arg) > 0) {
            return;
        }
    }

    public void doOneRun() {
        this.doOneRun(0);
    }

    public void doOneRun(int mode) {
        if (this.infoLevel > 1) {
            this.printParam();
        }
        this.setNetwork(this.initialgraph);
        if (this.infoLevel > 0) {
            this.printParam();
        }
        switch (mode) {
            case 1: {
                this.numevents -= this.TotalNumberVertices;
                break;
            }
        }
        this.calcNumberVertices();
        this.calcNumberEdges();
        double walktimetaken = -1.0;
        if (this.numevents > 0) {
            this.initialEdges = this.TotalNumberStubs;
            this.initialVertices = this.TotalNumberVertices;
            walktimetaken = this.addAll(0.01);
            if (this.infoLevel > -2) {
                System.out.println("--- Finished " + this.outputName.getNameRootFullPath() + " in " + walktimetaken + "sec.");
            }
            if (this.infoLevel > -1) {
                int finaledges = this.calcNumberEdges();
                int finalvertices = this.calcNumberVertices();
                int addedvertices = finalvertices - this.initialVertices;
                int addededges = finaledges - this.initialEdges;
                System.out.println("    " + addedvertices + " vertices added, " + NumbersToString.toString((double)(this.probnewvertex * (double)this.numevents), (int)2) + " expected, " + NumbersToString.toString((double)(100.0 - 100.0 * (double)addedvertices / (this.probnewvertex * (double)this.numevents)), (int)2) + "% deviation.");
                System.out.println("    " + addededges + " stubs added, requested " + NumbersToString.toString((double)(this.connectivity * (double)this.numevents * 2.0), (int)2) + ", " + NumbersToString.toString((double)(100.0 - 100.0 * (double)addededges / (this.connectivity * (double)this.numevents * 2.0)), (int)2) + "% failed.");
                System.out.println(" Average step length " + this.averagesteplength);
            }
        } else if (this.infoLevel > 0) {
            System.out.println("--- No vertices added to initial graph ---");
        }
        this.generalOutput(COMMENTCHARACTER, walktimetaken);
    }

    public void generalOutput(String cc, double timetaken) {
        if (this.infoLevel > -1) {
            this.OutputGraphInfo(System.out, "-  ", timetaken);
        }
        this.FileOutputGraphInfo(cc, timetaken);
        this.calcMinMaxVertexLabel();
        if (this.outputControl.componentsOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Component analysis ");
            }
            this.timing.setInitialTime();
            this.calcComponents();
            if (this.infoLevel > -1) {
                this.printComponentInfo();
            }
            this.FileOutputComponentInfo(cc, false, false);
            if (this.infoLevel > -1) {
                System.out.println(" Component analysis took " + this.timing.runTimeString());
            }
        }
        if (this.outputControl.distancesOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Distance sample randomly ");
            }
            this.timing.setInitialTime();
            int minsample = 100;
            if (minsample > this.numevents) {
                minsample = this.numevents / 2;
            }
            this.calcDistanceSample(0.01, minsample, this.numevents);
            if (this.infoLevel > -1) {
                this.printDistanceTotalDistribution(false);
            }
            this.FileOutputDistanceTotalDistribution(cc);
            this.FileOutputDistanceStatistics(cc);
            if (this.infoLevel > -1) {
                System.out.print(" Distance sample took " + this.timing.runTimeString());
            }
        }
        if (this.outputControl.clusteringOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Cluster Coefficient randomly ");
            }
            this.timing.setInitialTime();
            this.calcCCSample(0.01, 1000, this.numevents);
            this.calcCCEdgeSample(0.01, 1000, this.numevents);
            if (this.infoLevel > -1) {
                this.printCC();
            }
            this.FileOutputCC(cc);
            if (this.infoLevel > -1) {
                System.out.print(" Cluster Coefficient sample took " + this.timing.runTimeString());
            }
        }
        if (this.outputControl.degreeDistributionOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Degree distribution ");
            }
            this.timing.setInitialTime();
            this.calcDegreeDistribution();
            if (this.infoLevel > -1) {
                System.out.println("*** Total Degree Distribution");
            }
            if (this.infoLevel > -1) {
                this.DDtotal.outputInformation(System.out, "... ", SEP, 3);
            }
            this.FileOutputDegreeDistribution(cc, false, true);
            if (this.TotalNumberVertices >= this.LogBinVerticesMinimum) {
                this.FileOutputLogBinnedDegreeDistribution(cc, 1.1, true, true);
            }
        }
        if (this.outputControl.pajekFileOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Pajek file output ");
            }
            this.timing.setInitialTime();
            FileOutput fo = new FileOutput(this);
            fo.pajek();
            if (this.infoLevel > -1) {
                System.out.print(" Pajek File output took " + this.timing.runTimeString());
            }
        }
        if (this.outputControl.rankingOn) {
            if (this.averageWalkLength < 0.0) {
                this.averageWalkLength = this.diameter;
            }
            if (this.averageWalkLength < 2.0) {
                this.averageWalkLength = 2.0;
            }
            if (this.rankingProbabilityLengthScale < 0.0) {
                this.rankingProbabilityLengthScale = this.distanceaverage;
            }
            if (this.rankingProbabilityLengthScale < 2.0) {
                this.rankingProbabilityLengthScale = 2.0;
            }
            int totalNumberaverageWalkLength = this.TotalNumberStubs * 100;
            int startVertex = -1;
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Random Walk Ranking file output ");
            }
            if (this.infoLevel > -1) {
                System.out.println("randomWalkMode, averageWalkLength, rankingProbabilityLengthScale, totalNumberaverageWalkLength, startVertex = \t " + this.randomWalkMode + SEP + this.averageWalkLength + SEP + this.rankingProbabilityLengthScale + SEP + totalNumberaverageWalkLength + SEP + startVertex);
            }
            this.timing.setInitialTime();
            this.DoRandomWalk(totalNumberaverageWalkLength, startVertex);
            if (this.TotalNumberStubs < 40) {
                this.FileOutputNetwork(true, true, true);
            } else {
                this.FileOutputVertices(false, false, false);
            }
            if (this.vertexlabels) {
                this.FileOutputPajekVertexData();
            }
            if (this.infoLevel > -1) {
                System.out.print(" Random Walk Ranking file output took " + this.timing.runTimeString());
            }
        }
        if (this.outputControl.adjacencyFileOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Adjacency file output ");
            }
            this.timing.setInitialTime();
            FileOutput fo = new FileOutput(this);
            fo.adjacencyMatrix(SEP, true, true);
            if (this.infoLevel > -1) {
                System.out.print(" Adjacency File output took " + this.timing.runTimeString());
            }
        }
    }

    double DoRun(double eventnotefactor) {
        System.out.println("--- Starting doRun ");
        boolean StartWalkWithVertex = (this.randomWalkMode & 1) > 0;
        boolean always_new_walk_start = (this.randomWalkMode & 2) > 0;
        boolean markov_walk = (this.randomWalkMode & 4) > 0;
        boolean random_connectivity = (this.randomWalkMode & 8) > 0;
        boolean alwaysnewvertex = true;
        if (this.probnewvertex < 1.0) {
            alwaysnewvertex = false;
        }
        if (this.infoLevel > 2) {
            this.printParam();
            System.out.println("StartWalkWithVertex, always_new_walk_start, markov_walk, random_connectivity " + StartWalkWithVertex + SEP + always_new_walk_start + SEP + markov_walk + SEP + random_connectivity);
        }
        double connectivityprob = (this.connectivity - 1.0) / this.connectivity;
        int[] destvert = new int[this.maximumconnectivity];
        int[] destVertAWL = new int[this.maximumconnectivity];
        int actualaverageWalkLength = (int)(this.averageWalkLength + 0.5);
        int actualconnectivity = (int)(this.connectivity + 0.5);
        int initialedges = this.TotalNumberStubs;
        this.initialVertices = this.TotalNumberVertices;
        boolean goodevents = false;
        Runtime rt = Runtime.getRuntime();
        int eventnote = this.numevents + 1;
        if (eventnotefactor > 0.0) {
            eventnote = (int)((double)this.numevents * eventnotefactor);
        }
        if (eventnote < 1) {
            eventnote = 1;
        }
        double walkprob = this.averageWalkLength / (1.0 + this.averageWalkLength);
        int totalactualaverageWalkLength = 0;
        int totalactualconnectivity = 0;
        int walkvertex = 0;
        int newvertex = 0;
        this.maxonewalk = -1;
        int maxoneconnect = -1;
        boolean newvertexthistime = false;
        this.timing.setInitialTime();
        for (int i = 0; i < this.numevents; ++i) {
            int k;
            if (random_connectivity) {
                actualconnectivity = 1;
                while (this.Rnd.nextDouble() < connectivityprob) {
                    ++actualconnectivity;
                }
            }
            totalactualconnectivity += actualconnectivity;
            if (maxoneconnect < actualconnectivity) {
                maxoneconnect = actualconnectivity;
            }
            if (actualconnectivity > this.maximumconnectivity) {
                actualconnectivity = this.maximumconnectivity;
                System.out.println("!!! WARNING in DoRun attempted actual connectivity of " + actualconnectivity + ", limited to the maximum of " + this.maximumconnectivity);
            }
            if (this.TotalNumberStubs + actualconnectivity >= this.maximumStubs || this.TotalNumberVertices >= this.maximumVertices) break;
            for (k = 0; k < actualconnectivity; ++k) {
                if (always_new_walk_start || k == 0) {
                    walkvertex = StartWalkWithVertex ? this.Rnd.nextInt(this.TotalNumberVertices) : this.stubSourceList[this.Rnd.nextInt(this.TotalNumberStubs)];
                }
                if (markov_walk) {
                    actualaverageWalkLength = 0;
                    while (this.Rnd.nextDouble() < walkprob) {
                        ++actualaverageWalkLength;
                    }
                }
                totalactualaverageWalkLength += actualaverageWalkLength;
                if (this.maxonewalk < actualaverageWalkLength) {
                    this.maxonewalk = actualaverageWalkLength;
                }
                for (int s = 0; s < actualaverageWalkLength && this.vertexList[walkvertex].size() > 0; ++s) {
                    walkvertex = this.vertexList[walkvertex].getQuick(this.Rnd.nextInt(this.vertexList[walkvertex].size()));
                }
                destvert[k] = walkvertex;
                if (!this.weightedEdges) continue;
                destVertAWL[k] = actualaverageWalkLength;
            }
            if (alwaysnewvertex || this.Rnd.nextDouble() < this.probnewvertex) {
                this.vertexList[this.TotalNumberVertices] = new IntArrayList();
                ++this.TotalNumberVertices;
                newvertexthistime = true;
            } else {
                newvertex = this.SourceVertex ? this.Rnd.nextInt(this.TotalNumberVertices) : this.stubSourceList[this.Rnd.nextInt(this.TotalNumberStubs)];
                newvertexthistime = false;
            }
            for (k = 0; k < actualconnectivity; ++k) {
                int v2 = destvert[k];
                this.vertexList[newvertex].add(v2);
                this.vertexList[v2].add(newvertex);
                if (this.weightedEdges) {
                    this.edgeValuetList[this.TotalNumberStubs] = newvertexthistime ? new EdgeValue(1, destVertAWL[k]) : new EdgeValue(2, destVertAWL[k]);
                }
                this.stubSourceList[this.TotalNumberStubs++] = newvertex;
                if (this.weightedEdges) {
                    this.edgeValuetList[this.TotalNumberStubs] = newvertexthistime ? new EdgeValue(1, destVertAWL[k]) : new EdgeValue(2, destVertAWL[k]);
                }
                this.stubSourceList[this.TotalNumberStubs++] = v2;
            }
        }
        this.timing.setCurrentTime();
        int addedvertices = this.TotalNumberVertices - this.initialVertices;
        int addededges = this.TotalNumberStubs - initialedges;
        System.out.println("Added " + addedvertices + " vertices and " + addededges + " edges in " + this.timing.runTimeString());
        double averagenewconnectivity = (double)addededges / ((double)addedvertices * 2.0);
        System.out.println("Average new connectivity = " + NumbersToString.toString((double)averagenewconnectivity, (int)3) + ", largest one connectivity = " + maxoneconnect);
        this.averagesteplength = 2.0 * (double)totalactualaverageWalkLength / (double)addededges;
        System.out.println("average step = " + NumbersToString.toString((double)this.averagesteplength, (int)3) + ", longest single walk  = " + this.maxonewalk);
        if (this.infoLevel > 1) {
            long currentmem = rt.freeMemory();
            long totalmem = rt.totalMemory();
            System.out.println("\nFree memory " + currentmem + " out of " + totalmem + " total");
            int finaledges = this.TotalNumberStubs;
            int finalvertices = this.TotalNumberVertices;
            int totvertices = finalvertices - this.initialVertices;
            int totedges = finaledges - initialedges;
            System.out.println("*** Finished Run in " + this.timing.runTimeString());
            System.out.println("    " + this.numevents + " events.");
            System.out.println("    " + (finalvertices - this.initialVertices) + " vertices added.");
            System.out.println("    " + (finaledges - initialedges) + " edges added, expected " + (double)goodevents * this.connectivity);
        }
        return 0.0;
    }

    public void initialiseRandomWalk(int randomWalkMode, double averageWalkLength, double maxWalkLength) {
        this.randomWalk = new RandomWalk(this, randomWalkMode, averageWalkLength, maxWalkLength);
    }

    public double DoRandomWalk(int totalNumberaverageWalkLength, int startVertex) {
        Runtime rt = Runtime.getRuntime();
        if (this.infoLevel > 0) {
            System.out.println("--- Starting DoRandomWalk ");
        }
        boolean StartWalkWithVertex = (this.randomWalkMode & 1) > 0;
        boolean always_new_walk_start = (this.randomWalkMode & 2) > 0;
        boolean markov_walk = (this.randomWalkMode & 4) > 0;
        boolean StartWalkWithFixedVertex = true;
        boolean binomialDistribution = (this.randomWalkMode & 0x10) > 0;
        double walkprob = this.averageWalkLength / (1.0 + this.averageWalkLength);
        this.maxWalkLength = (int)(this.averageWalkLength + 0.5) * 3;
        int intAverageWalkLength = (int)(this.averageWalkLength + 0.5);
        if (markov_walk) {
            this.maxWalkLength = totalNumberaverageWalkLength;
        }
        this.maxonewalk = -1;
        double rankingProbability = this.rankingProbabilityLengthScale / (1.0 + this.rankingProbabilityLengthScale);
        if (startVertex >= this.TotalNumberVertices) {
            System.out.println("*** Error startVertex " + startVertex + ">=" + this.TotalNumberVertices + " TotalNumberVertices");
            return -1.0;
        }
        if (startVertex < 0) {
            StartWalkWithFixedVertex = false;
        }
        if (this.infoLevel > 2) {
            this.printParam();
            System.out.println("StartWalkWithVertex, always_new_walk_start, markov_walk, random_connectivity " + StartWalkWithVertex + SEP + markov_walk);
        }
        int e = -1;
        int degree = -1;
        int walkvertex = 0;
        if (this.vertexlabels) {
            for (int v = 0; v < this.TotalNumberVertices; ++v) {
                this.vertexLabelList[v].setRank(new Rank());
            }
        }
        int stepOnWalk = -1;
        double diffuseValue = 1.0;
        int numberWalks = 0;
        this.timing.setInitialTime();
        for (int event = 0; event < totalNumberaverageWalkLength; ++event) {
            if (stepOnWalk < 0) {
                ++numberWalks;
                stepOnWalk = markov_walk ? (binomialDistribution ? this.getRandomBinomial(this.averageWalkLength, this.binomialNumber) : this.getRandomMarkov(walkprob, this.binomialNumber)) : intAverageWalkLength;
                diffuseValue = 1.0;
                if (always_new_walk_start || degree < 1) {
                    if (StartWalkWithVertex) {
                        walkvertex = StartWalkWithFixedVertex ? (walkvertex = startVertex) : this.Rnd.nextInt(this.TotalNumberVertices);
                    } else {
                        e = this.directedGraph ? this.makeEven(this.Rnd.nextInt(this.TotalNumberStubs)) : this.Rnd.nextInt(this.TotalNumberStubs);
                        walkvertex = this.stubSourceList[e];
                    }
                }
                if (this.maxonewalk < stepOnWalk) {
                    this.maxonewalk = stepOnWalk;
                }
            } else {
                --stepOnWalk;
                diffuseValue *= rankingProbability;
                walkvertex = this.vertexList[walkvertex].getQuick(this.Rnd.nextInt(degree));
            }
            degree = this.vertexList[walkvertex].size();
            if (this.vertexlabels) {
                this.vertexLabelList[walkvertex].rank.updateRanking(stepOnWalk, diffuseValue);
            }
            if (degree != 0) continue;
            stepOnWalk = -1;
        }
        this.timing.setCurrentTime();
        String rts = this.timing.runTimeString();
        this.averagesteplength = numberWalks > 0 ? (double)(totalNumberaverageWalkLength / numberWalks) : (double)(-totalNumberaverageWalkLength);
        System.out.println("No. walks \t " + numberWalks + SEP + " average step = " + SEP + NumbersToString.toString((double)this.averagesteplength, (int)3) + SEP + " longest single walk " + SEP + this.maxonewalk);
        if (this.infoLevel > 1) {
            long currentmem = rt.freeMemory();
            long totalmem = rt.totalMemory();
            System.out.println("\nFree memory " + currentmem + " out of " + totalmem + " total");
            System.out.println("*** Finished DoRandomWalk in " + rts);
        }
        return this.timing.elapsedTime();
    }

    public VertexLabel getMinimumVertexLabel() {
        return this.minimumVertexLabel;
    }

    public VertexLabel getMaximumVertexLabel() {
        return this.maximumVertexLabel;
    }

    public int getMinimumVertexNumber() {
        if (this.minimumVertexLabel != null && this.minimumVertexLabel.hasNumber()) {
            return this.minimumVertexLabel.getNumber();
        }
        return -135798642;
    }

    public int getMaximumVertexNumber() {
        if (this.maximumVertexLabel != null && this.maximumVertexLabel.hasNumber()) {
            return this.maximumVertexLabel.getNumber();
        }
        return -135798642;
    }

    public Coordinate getMinimumVertexCoordinate() {
        if (this.minimumVertexLabel != null && this.minimumVertexLabel.hasPosition()) {
            return this.minimumVertexLabel.getPosition();
        }
        return null;
    }

    public Coordinate getMaximumVertexCoordinate() {
        if (this.maximumVertexLabel != null && this.maximumVertexLabel.hasPosition()) {
            return this.maximumVertexLabel.getPosition();
        }
        return null;
    }

    public void calcMinimumVertexLabel() {
        if (!this.isVertexLabelled()) {
            this.minimumVertexLabel = null;
            return;
        }
        this.minimumVertexLabel = new VertexLabel();
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            this.vertexLabelList[v].setMinimum(this.minimumVertexLabel);
        }
    }

    public void calcMaximumVertexLabel() {
        if (!this.isVertexLabelled()) {
            this.maximumVertexLabel = null;
            return;
        }
        this.maximumVertexLabel = new VertexLabel();
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            this.vertexLabelList[v].setMaximum(this.maximumVertexLabel);
        }
    }

    public void calcMinMaxVertexLabel() {
        this.calcMinimumVertexLabel();
        this.calcMaximumVertexLabel();
    }

    public EdgeValue getMinimumEdgeValue() {
        return this.minimumEdgeValue;
    }

    public EdgeValue getMaximumEdgeValue() {
        return this.maximumEdgeValue;
    }

    public double getMinimumEdgeWeight() {
        if (this.minimumEdgeValue != null && this.minimumEdgeValue.hasWeight()) {
            return this.minimumEdgeValue.getWeight();
        }
        return -3.57986421E8;
    }

    public double getMaximumEdgeWeight() {
        if (this.maximumEdgeValue != null && this.maximumEdgeValue.hasWeight()) {
            return this.maximumEdgeValue.getWeight();
        }
        return -3.57986421E8;
    }

    public int getMinimumEdgeLabel() {
        if (this.minimumEdgeValue != null && this.minimumEdgeValue.hasLabel()) {
            return this.minimumEdgeValue.getLabel();
        }
        return -135798642;
    }

    public int getMaximumEdgeLabel() {
        if (this.maximumEdgeValue != null && this.maximumEdgeValue.hasLabel()) {
            return this.maximumEdgeValue.getLabel();
        }
        return -135798642;
    }

    public void calcMinimumEdgeValue() {
        if (!this.isWeighted()) {
            this.minimumEdgeValue = null;
            return;
        }
        this.minimumEdgeValue = new EdgeValue();
        for (int s = 0; s < this.TotalNumberStubs; ++s) {
            this.edgeValuetList[s].setMinimum(this.minimumEdgeValue);
        }
    }

    public void calcMaximumEdgeValue() {
        if (!this.isWeighted()) {
            this.maximumEdgeValue = null;
            return;
        }
        this.maximumEdgeValue = new EdgeValue();
        for (int s = 0; s < this.TotalNumberStubs; ++s) {
            this.edgeValuetList[s].setMaximum(this.maximumEdgeValue);
        }
    }

    public void adjustZeroWalkWeights() {
        int zerowalkweight = this.maxonewalk * 2 + 1;
        for (int e = 0; e < this.TotalNumberStubs; ++e) {
            if (this.edgeValuetList[e].weight != 0.0) continue;
            this.edgeValuetList[e].weight += (double)zerowalkweight;
        }
    }

    public void printWalkInfo(int eventcounter, int initialvertices, int initialedges, long initialmem, Runtime rt, int eventnote, int infoLevel) {
        if (infoLevel > 1) {
            this.calcNumberVertices();
        }
        this.calcNumberEdges();
        if (infoLevel > 0 && (eventcounter + 1) % eventnote == 0) {
            System.out.print(".");
            if ((eventcounter + 1) % (10 * eventnote) == 0) {
                long currentmem = rt.freeMemory();
                long totalmem = rt.totalMemory();
                int edgessofar = this.TotalNumberStubs - initialedges;
                double edgefraction = (double)edgessofar / ((double)(2 * this.numevents) * this.connectivity);
                double timeleftpred = this.timing.elapsedTime() * (1.0 / (edgefraction * edgefraction) - 1.0);
                System.out.println(" M:" + (totalmem - currentmem) + "/" + totalmem + ", " + this.timing.runTimeString() + " - " + TimTiming.runTimeString((double)timeleftpred) + " )");
                System.out.println("           Ev:" + eventcounter + "/" + this.numevents + ", V:" + (this.TotalNumberVertices - initialvertices) + ", E:" + edgessofar + "/" + (double)(2 * eventcounter) * this.connectivity + ", (Tot " + (int)(0.5 + edgefraction * 100.0) + "% ?)");
            }
        }
    }

    double DoER(double eventnotefactor) {
        System.out.println("--- Starting doER ");
        int[] destvert = new int[this.maximumconnectivity];
        int actualaverageWalkLength = (int)(this.averageWalkLength + 0.5);
        int actualconnectivity = (int)(this.connectivity + 0.5);
        int initialedges = this.TotalNumberStubs;
        this.initialVertices = this.TotalNumberVertices;
        boolean goodevents = false;
        Runtime rt = Runtime.getRuntime();
        int eventnote = this.numevents + 1;
        if (eventnotefactor > 0.0) {
            eventnote = (int)((double)this.numevents * eventnotefactor);
        }
        if (eventnote < 1) {
            eventnote = 1;
        }
        long initialtime = System.currentTimeMillis();
        int maxoneconnect = -1;
        for (int i = 0; i < this.numevents; ++i) {
            this.addVertex();
        }
        int addedvertices = this.TotalNumberVertices - this.initialVertices;
        int ne = (int)(this.connectivity * (double)this.numevents);
        for (int i = 0; i < ne; ++i) {
            int sv = this.Rnd.nextInt(this.TotalNumberVertices);
            int tv = this.Rnd.nextInt(this.TotalNumberVertices);
            if (this.weightedEdges) {
                this.addEdge(sv, tv, new EdgeValue(1, 1.0));
                continue;
            }
            this.addEdge(sv, tv);
        }
        int addededges = this.TotalNumberStubs - initialedges;
        long finaltime = System.currentTimeMillis();
        double totsec = n2s.TruncDecimal((double)(finaltime - initialtime) / 1000.0, 2);
        System.out.println("Added " + addedvertices + " vertices and " + addededges + " edges in " + totsec + "sec");
        double averagenewconnectivity = (double)addededges / ((double)addedvertices * 2.0);
        System.out.println("Average new connectivity = " + NumbersToString.toString((double)averagenewconnectivity, (int)3) + ", largest one connectivity = " + maxoneconnect);
        if (this.infoLevel > 1) {
            long currentmem = rt.freeMemory();
            long totalmem = rt.totalMemory();
            System.out.println("\nFree memory " + currentmem + " out of " + totalmem + " total");
            int finaledges = this.TotalNumberStubs;
            int finalvertices = this.TotalNumberVertices;
            int totvertices = finalvertices - this.initialVertices;
            int totedges = finaledges - initialedges;
            System.out.println("*** Finished Run in " + this.timing.runTimeString());
            System.out.println("    " + this.numevents + " events.");
            System.out.println("    " + (finalvertices - this.initialVertices) + " vertices added.");
            System.out.println("    " + (finaledges - initialedges) + " edges added, expected " + (double)goodevents * this.connectivity);
        }
        return totsec;
    }

    double DoBPCopyModel(double eventnotefactor) {
        if (!this.bipartiteGraph) {
            System.out.println("--- not a bipartite graph for DoBPCopyModel ");
            return -1.0;
        }
        System.out.println("--- Starting DoBPCopyModel ");
        double probprapp = this.probpra + this.probpp;
        double probprprapp = probprapp + this.probpr;
        Runtime rt = Runtime.getRuntime();
        int eventnote = this.numevents + 1;
        if (eventnotefactor > 0.0) {
            eventnote = (int)((double)this.numevents * eventnotefactor);
        }
        if (eventnote < 1) {
            eventnote = 1;
        }
        long initialtime = System.currentTimeMillis();
        this.initialVertices = this.TotalNumberVertices;
        int initialedges = this.TotalNumberStubs;
        int ne = this.numevents;
        for (int i = 0; i < ne; ++i) {
            int e = this.Rnd.nextInt(this.TotalNumberStubs) >> 1 << 1;
            if ((e & 1) == 1) {
                System.out.println("ERROR edge not even in DoBPCopyModel");
            }
            if (this.stubSourceList[e] >= this.numberVertexType1) {
                System.out.println("ERROR edge source not type 2");
            }
            int eventtype = 0;
            double eventvalue = this.Rnd.nextDouble();
            if (eventvalue < this.probpp) {
                ++eventtype;
            }
            if (eventvalue < probprapp) {
                ++eventtype;
            }
            if (eventvalue < probprprapp) {
                ++eventtype;
            }
            int vnew = -1;
            switch (eventtype) {
                case 0: {
                    System.out.println(" ... pbar event new type 2 vertex, " + eventtype);
                    vnew = this.addVertex();
                    ++this.numberVertexType2;
                    break;
                }
                case 1: {
                    System.out.println("... pr event random type 2 vertex, " + eventtype);
                    vnew = this.Rnd.nextInt(this.numberVertexType2) + this.numberVertexType1;
                    break;
                }
                case 2: 
                case 3: {
                    System.out.println("... Preferential attachment, copying, " + eventtype);
                    int enew = this.Rnd.nextInt(this.TotalNumberStubs) | 1;
                    vnew = this.stubSourceList[enew];
                    if (vnew >= this.numberVertexType1) break;
                    --vnew;
                }
            }
            if (vnew < 1) {
                System.out.println("--- vnew <0 in DoBPCopyModel ");
                return -1.0;
            }
            if (vnew < this.numberVertexType1) {
                System.out.println("ERROR new vertex not type 2");
            }
            this.rewireEdgeTarget(e, vnew);
        }
        int addedvertices = this.TotalNumberVertices - this.initialVertices;
        int addededges = this.TotalNumberStubs - initialedges;
        long finaltime = System.currentTimeMillis();
        double totsec = n2s.TruncDecimal((double)(finaltime - initialtime) / 1000.0, 2);
        System.out.println("Added " + addedvertices + " vertices and " + addededges + " edges in " + totsec + "sec");
        if (this.infoLevel > 1) {
            long currentmem = rt.freeMemory();
            long totalmem = rt.totalMemory();
            System.out.println("\nFree memory " + currentmem + " out of " + totalmem + " total");
            int finaledges = this.TotalNumberStubs;
            int finalvertices = this.TotalNumberVertices;
            int totvertices = finalvertices - this.initialVertices;
            int totedges = finaledges - initialedges;
            System.out.println("*** Finished Run in " + this.timing.runTimeString());
            System.out.println("    " + this.numevents + " events.");
            System.out.println("    " + (finalvertices - this.initialVertices) + " vertices added.");
            System.out.println("    " + (finaledges - initialedges) + " edges added");
        }
        return totsec;
    }

    double addAll(double eventnotefactor) {
        double result = -1.0;
        switch (this.edgegenerator) {
            case 0: {
                result = this.DoRun(eventnotefactor);
                break;
            }
            case 1: {
                result = this.DoER(eventnotefactor);
                break;
            }
            default: {
                System.out.println(" *** Edge generator " + this.edgegenerator + " unknown ***");
            }
        }
        return result;
    }

    private void addVertexBasic() {
        this.vertexList[this.TotalNumberVertices] = new IntArrayList();
        if (this.directedGraph) {
            this.vertexSourceList[this.TotalNumberVertices] = new IntArrayList();
        }
        if (this.vertexEdgeListOn) {
            this.vertexEdgeList[this.TotalNumberVertices] = new IntArrayList();
            if (this.directedGraph) {
                this.vertexInEdgeList[this.TotalNumberVertices] = new IntArrayList();
            }
        }
        if (this.vertexlabels) {
            this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel();
        }
    }

    public int addVertex() {
        this.addVertexBasic();
        if (this.vertexlabels) {
            this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel(this.TotalNumberVertices);
        }
        return this.TotalNumberVertices++;
    }

    public int addVertex(VertexLabel vlabel) {
        this.addVertexBasic();
        this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel(vlabel);
        return this.TotalNumberVertices++;
    }

    public int addVertex(double strength, Coordinate position) {
        this.addVertexBasic();
        String vname = "(" + position.x + "," + position.y + ")";
        this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel(vname, strength, position);
        return this.TotalNumberVertices++;
    }

    public int addVertex(String name) {
        this.addVertexBasic();
        this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel(name, this.TotalNumberVertices);
        return this.TotalNumberVertices++;
    }

    public int addVertex(String name, int number) {
        this.addVertexBasic();
        this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel(name, number);
        return this.TotalNumberVertices++;
    }

    private void addEdgeSourceBasic(int v1, int v2) {
        this.vertexList[v1].add(v2);
        if (this.vertexEdgeListOn) {
            this.vertexEdgeList[v1].add(this.TotalNumberStubs);
        }
        this.stubSourceList[this.TotalNumberStubs] = v1;
    }

    private void addEdgeTargetBasic(int v1, int v2) {
        if (!this.directedGraph) {
            this.vertexList[v2].add(v1);
        } else {
            this.vertexSourceList[v2].add(v1);
        }
        if (this.vertexEdgeListOn) {
            if (this.directedGraph) {
                this.vertexInEdgeList[v2].add(this.TotalNumberStubs);
            } else {
                this.vertexEdgeList[v2].add(this.TotalNumberStubs);
            }
        }
        this.stubSourceList[this.TotalNumberStubs] = v2;
    }

    public void addEdge(int v1, int v2) {
        if (v1 == v2 && !this.selfLoops) {
            return;
        }
        this.addEdgeSourceBasic(v1, v2);
        if (this.weightedEdges) {
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue();
        }
        ++this.TotalNumberStubs;
        this.addEdgeTargetBasic(v1, v2);
        if (this.weightedEdges) {
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue();
        }
        ++this.TotalNumberStubs;
    }

    public void addEdgeUnweighted(int v1, int v2) {
        if (v1 == v2 && !this.selfLoops) {
            return;
        }
        this.addEdgeSourceBasic(v1, v2);
        ++this.TotalNumberStubs;
        this.addEdgeTargetBasic(v1, v2);
        ++this.TotalNumberStubs;
    }

    public void addEdge(int v1, int v2, EdgeValue edgeweight) {
        if (v1 == v2 && !this.selfLoops) {
            return;
        }
        this.addEdgeSourceBasic(v1, v2);
        this.edgeValuetList[this.TotalNumberStubs++] = edgeweight;
        this.addEdgeTargetBasic(v1, v2);
        this.edgeValuetList[this.TotalNumberStubs++] = edgeweight;
    }

    public void addEdge(int v1, int v2, double edgeweight) {
        EdgeValue ew = new EdgeValue(edgeweight);
        this.addEdge(v1, v2, ew);
    }

    public void addEdge(int v1, int v2, EdgeValue edgeweight1, EdgeValue edgeweight2) {
        if (!this.weightedEdges) {
            System.err.println("*** Adding weighted edge when it is not a weighted graph);");
        }
        this.addEdgeSourceBasic(v1, v2);
        this.edgeValuetList[this.TotalNumberStubs++] = edgeweight1;
        this.addEdgeTargetBasic(v1, v2);
        this.edgeValuetList[this.TotalNumberStubs++] = edgeweight2;
    }

    public void increaseEdgeWeight(int s, int t, double dw) {
        if (s == t && !this.selfLoops) {
            return;
        }
        int e = this.getFirstEdgeGlobal(s, t);
        if (e < 0) {
            if (this.weightedEdges) {
                this.addEdge(s, t, dw);
            } else {
                this.addEdge(s, t);
            }
        } else if (this.weightedEdges) {
            this.edgeValuetList[e++].weight += dw;
        }
        if (this.infoLevel > 2) {
            System.out.print("Edge from " + s + " to " + t);
            if (this.weightedEdges) {
                if (e < 1) {
                    e = this.TotalNumberStubs - 1;
                }
                System.out.println(", edge index " + (e - 1) + ", has had weight increased by " + dw + " to become " + this.edgeValuetList[e - 1].weight);
                System.out.print("Edge from " + s + " to " + t);
                System.out.println(", edge index " + e + ", has had weight increased by " + dw + " to become " + this.edgeValuetList[e].weight);
            } else {
                System.out.println(" now exists.");
            }
        }
    }

    public int addEdgeUnique(int s, int t) {
        if (s == t && !this.selfLoops) {
            return -1;
        }
        if (!this.edgeExists(s, t)) {
            this.addEdge(s, t);
            return this.TotalNumberStubs;
        }
        return -1;
    }

    public void addEdgeWithTests(int s, int t, double dw) {
        if (!this.weightedEdges) {
            this.addEdgeWithTests(s, t);
            return;
        }
        if (this.multiEdge) {
            this.addEdge(s, t, dw);
        } else {
            this.increaseEdgeWeight(s, t, dw);
        }
    }

    public int addEdgeWithTests(int s, int t) {
        if (!this.multiEdge) {
            return this.addEdgeUnique(s, t);
        }
        this.addEdge(s, t);
        return this.TotalNumberStubs;
    }

    public boolean edgeExists(int s, int t) {
        return this.getFirstEdgeLocal(s, t) >= 0;
    }

    public int copySomeEdges(timgraph oldtg, int[] keepedgelist, int TNS) {
        int TNV = oldtg.TotalNumberVertices;
        int result = 0;
        this.stubSourceList = new int[TNS];
        this.TotalNumberStubs = 0;
        int e = 0;
        while (e < oldtg.TotalNumberStubs) {
            if (keepedgelist[e] != 0) {
                this.stubSourceList[this.TotalNumberStubs++] = oldtg.stubSourceList[e++];
                this.stubSourceList[this.TotalNumberStubs++] = oldtg.stubSourceList[e++];
                continue;
            }
            e += 2;
        }
        if (TNS != this.TotalNumberStubs) {
            result = 1;
            System.out.println("*** Total Number Edges wrong in copySomeEdges");
        }
        this.TotalNumberVertices = TNV;
        this.vertexList = new IntArrayList[TNV];
        this.vertexEdgeListOn = false;
        for (int v = 0; v < TNV; ++v) {
            this.vertexList[v] = new IntArrayList();
        }
        int e2 = 0;
        while (e2 < TNS) {
            int v1 = this.stubSourceList[e2++];
            int v2 = this.stubSourceList[e2++];
            this.vertexList[v1].add(v2);
            this.vertexList[v2].add(v1);
        }
        return result;
    }

    public int copyLabelledRandomEdges(timgraph oldtg, int TNS, int keeplabel) {
        int e;
        int n;
        int TNV = oldtg.TotalNumberVertices;
        int oldTNSo2 = oldtg.TotalNumberStubs / 2;
        int result = 0;
        this.stubSourceList = new int[TNS];
        if (this.weightedEdges) {
            this.edgeValuetList = new EdgeValue[TNS];
        }
        this.TotalNumberStubs = 0;
        for (n = 0; this.TotalNumberStubs < TNS && n != oldTNSo2; ++n) {
            e = oldtg.edgerandomlist[n] * 2;
            if (oldtg.edgeValuetList[e].label != keeplabel) continue;
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue(oldtg.edgeValuetList[e]);
            this.stubSourceList[this.TotalNumberStubs++] = oldtg.stubSourceList[e++];
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue(oldtg.edgeValuetList[e]);
            this.stubSourceList[this.TotalNumberStubs++] = oldtg.stubSourceList[e];
        }
        if (TNS != this.TotalNumberStubs) {
            result = -1;
        }
        for (n = 0; this.TotalNumberStubs < TNS && n != oldTNSo2; ++n) {
            e = oldtg.edgerandomlist[n] * 2;
            if (oldtg.edgeValuetList[e].label == keeplabel) continue;
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue(oldtg.edgeValuetList[e]);
            this.stubSourceList[this.TotalNumberStubs++] = oldtg.stubSourceList[e++];
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue(oldtg.edgeValuetList[e]);
            this.stubSourceList[this.TotalNumberStubs++] = oldtg.stubSourceList[e];
        }
        if (TNS != this.TotalNumberStubs) {
            result = -2;
        }
        this.TotalNumberVertices = TNV;
        this.vertexList = new IntArrayList[TNV];
        for (int v = 0; v < TNV; ++v) {
            this.vertexList[v] = new IntArrayList();
        }
        this.vertexEdgeListOn = false;
        e = 0;
        while (e < this.TotalNumberStubs) {
            int v1 = this.stubSourceList[e++];
            int v2 = this.stubSourceList[e++];
            this.vertexList[v1].add(v2);
            this.vertexList[v2].add(v1);
        }
        return result;
    }

    public void calcRandomEdgeOrder() {
        int e;
        int TNSo2 = this.TotalNumberStubs / 2;
        if (this.edgerandomlist == null) {
            this.edgerandomlist = new int[TNSo2];
        }
        for (e = 0; e < TNSo2; ++e) {
            this.edgerandomlist[e] = e;
        }
        for (e = 0; e < TNSo2; ++e) {
            int e2 = this.Rnd.nextInt(TNSo2);
            if (e2 == e) continue;
            int eb = this.edgerandomlist[e2];
            this.edgerandomlist[e2] = this.edgerandomlist[e];
            this.edgerandomlist[e] = eb;
        }
    }

    public void calcReverseEdgeOrder() {
        int TNSo2 = this.TotalNumberStubs / 2;
        for (int e = 0; e < TNSo2 / 2; ++e) {
            int e2 = TNSo2 - 1 - e;
            int eb = this.edgerandomlist[e2];
            this.edgerandomlist[e2] = this.edgerandomlist[e];
            this.edgerandomlist[e] = eb;
        }
    }

    public void calcRandomEdgeWeightOrder(int criteria) {
        int TNSo2 = this.TotalNumberStubs / 2;
        if (this.edgerandomlist == null) {
            this.edgerandomlist = new int[TNSo2];
        }
        for (int e = 0; e < TNSo2; ++e) {
            this.edgerandomlist[e] = e;
        }
        for (int e = 0; e < TNSo2; ++e) {
            int e2 = this.Rnd.nextInt(TNSo2);
            if (e2 == e) continue;
            int eb = this.edgerandomlist[e2];
            this.edgerandomlist[e2] = this.edgerandomlist[e];
            this.edgerandomlist[e] = eb;
        }
        if (criteria > -1) {
            this.QuickSort(criteria, this.edgerandomlist, 0, TNSo2 - 1);
        }
    }

    private void QuickSort(int criteria, int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            EdgeValue mid = this.edgeValuetList[a[(lo0 + hi0) / 2] * 2];
            while (lo <= hi) {
                while (lo < hi0 && this.compareWeights(criteria, this.edgeValuetList[a[lo] * 2], mid)) {
                    ++lo;
                }
                while (hi > lo0 && this.compareWeights(criteria, mid, this.edgeValuetList[a[hi] * 2])) {
                    --hi;
                }
                if (lo > hi) continue;
                int T = a[lo];
                a[lo] = a[hi];
                a[hi] = T;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.QuickSort(criteria, a, lo0, hi);
            }
            if (lo < hi0) {
                this.QuickSort(criteria, a, lo, hi0);
            }
        }
    }

    public boolean compareWeights(int criteria, EdgeValue ew1, EdgeValue ew2) {
        double value = -1.0;
        switch (criteria) {
            case 0: {
                value = ew1.weight - ew2.weight;
                break;
            }
            case 1: {
                value = ew2.weight - ew1.weight;
                break;
            }
            case 2: {
                value = ew1.label - ew2.label;
                break;
            }
            case 3: {
                value = ew2.label - ew1.label;
                break;
            }
            default: {
                System.out.println("*** ERROR in compareWeights, criteria " + criteria + "unknown");
            }
        }
        return value > 0.0;
    }

    public void randomiseGraph() {
        int success = -1;
        for (int s1 = 0; s1 < this.TotalNumberStubs; ++s1) {
            success = -1;
            while (success < 0) {
                success = this.rewireEdgePair(s1, this.Rnd.nextInt(this.TotalNumberStubs));
            }
        }
        if (this.vertexEdgeListOn) {
            this.createVertexGlobalEdgeList();
        }
    }

    public int rewireEdgePair(int e1, int e2) {
        if (e1 >= this.TotalNumberStubs || e2 >= this.TotalNumberStubs) {
            return -1;
        }
        if (e1 < 0 || e2 < 0) {
            return -2;
        }
        int edge1 = e1 >> 1;
        int edge2 = e2 >> 1;
        if (edge1 == edge2) {
            return -3;
        }
        int e1s = e1;
        int e2s = e2;
        if (this.directedGraph) {
            e1s = edge1 << 1;
            e2s = edge2 << 1;
        }
        int e1t = e1s ^ 1;
        int e2t = e2s ^ 1;
        int v1s = this.stubSourceList[e1s];
        int v1t = this.stubSourceList[e1t];
        int v2s = this.stubSourceList[e2s];
        int v2t = this.stubSourceList[e2t];
        if (this.infoLevel > 1) {
            System.out.println(v1s + SEP + v1t + SEP + v2s + SEP + v2t);
        }
        int vn1t = this.vertexList[v1s].indexOfFromTo(v1t, 0, this.vertexList[v1s].size() - 1);
        int vn1s = this.vertexList[v1t].indexOfFromTo(v1s, 0, this.vertexList[v1t].size() - 1);
        int vn2t = this.vertexList[v2s].indexOfFromTo(v2t, 0, this.vertexList[v2s].size() - 1);
        int vn2s = this.vertexList[v2t].indexOfFromTo(v2s, 0, this.vertexList[v2t].size() - 1);
        if (this.infoLevel > 1) {
            System.out.println(vn1s + SEP + vn1t + SEP + vn2s + SEP + vn2t);
            System.out.println(this.vertexList[v1s]);
            System.out.println(this.vertexList[v1t]);
            System.out.println(this.vertexList[v2s]);
            System.out.println(this.vertexList[v2t]);
        }
        boolean choice = this.Rnd.nextBoolean();
        int success = 0;
        if (choice) {
            if (v1s == v2t || v2s == v1t) {
                return -3;
            }
            this.stubSourceList[e1s] = v2s;
            this.stubSourceList[e2s] = v1s;
            this.vertexList[v1s].set(vn1t, v2t);
            this.vertexList[v1t].set(vn1s, v2s);
            this.vertexList[v2s].set(vn2t, v1t);
            this.vertexList[v2t].set(vn2s, v1s);
            success = 3;
        } else {
            if (v1s == v2s || v2t == v1t) {
                return -4;
            }
            this.stubSourceList[e2s] = v1t;
            this.stubSourceList[e1t] = v2s;
            this.vertexList[v1s].set(vn1t, v2s);
            this.vertexList[v1t].set(vn1s, v2t);
            this.vertexList[v2s].set(vn2t, v1s);
            this.vertexList[v2t].set(vn2s, v1t);
            success = 4;
        }
        return success;
    }

    public int rewireEdgeTarget(int e, int vnew) {
        System.out.println(" e, vnew " + e + " : " + vnew);
        if (e >= this.TotalNumberStubs || e < 0) {
            return -1;
        }
        int efixed = e;
        int emove = efixed ^ 1;
        int vmove = this.stubSourceList[emove];
        int vfixed = this.stubSourceList[efixed];
        this.vertexList[vmove].delete(vfixed);
        this.vertexList[vnew].add(vfixed);
        int vminfixed = this.vertexList[vfixed].indexOf(vmove);
        this.vertexList[vfixed].set(vminfixed, vnew);
        this.stubSourceList[emove] = vnew;
        System.out.println("efixed :emove = vfixed - vmove -> vnew  |  " + efixed + ":" + emove + " = " + vfixed + " - " + vmove + " -> " + vnew);
        return 0;
    }

    public double calcAverage(int v, int n) {
        return (double)v / (double)n;
    }

    public double calcAverage(long v, long n) {
        return (double)v / (double)n;
    }

    public double calcError(long v, long v2, long n) {
        return this.calcError((double)v, (double)v2, (double)n);
    }

    public double calcError(int v, int v2, int n) {
        return this.calcError((double)v, (double)v2, (double)n);
    }

    public double calcError(double v, double v2, double n) {
        if (n > 1.0) {
            return this.calcSigma(v, v2, n) / Math.sqrt(n - 1.0);
        }
        return 0.0;
    }

    public double calcSigma(double v, double v2, double n) {
        return Math.sqrt((v2 - v * v / n) / n);
    }

    public int calcNumberVertices() {
        int n;
        for (n = 0; n < this.vertexList.length && this.vertexList[n] != null; ++n) {
        }
        if (this.TotalNumberVertices != n) {
            System.out.println("*** Error in calcNumberVertices, number of vertices inconsistent");
            System.out.println("     TNV=" + this.TotalNumberVertices + ", calc = " + n);
        }
        return n;
    }

    public int calcNumberEdges() {
        int neout = 0;
        int nein = 0;
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            if (this.vertexList[v] != null) {
                neout += this.vertexList[v].size();
            }
            if (!this.directedGraph || this.vertexSourceList[v] == null) continue;
            nein += this.vertexSourceList[v].size();
        }
        if (this.TotalNumberStubs != nein + neout) {
            System.out.println("*** Error in calcNumberEdges, number of edges inconsistent");
            System.out.println("     TNS=" + this.TotalNumberStubs + ", calc out = " + neout + ", in = " + nein);
        }
        return nein + neout;
    }

    private void calcDistanceNext(int distance, int maxDistance, int componentNumber, IntArrayList olddistancevlist) {
        int v;
        IntArrayList distancevlist = new IntArrayList(100);
        int count = 0;
        int degree = 0;
        long totdistdegree = 0L;
        for (int vod = 0; vod < olddistancevlist.size() && this.vertexdistance[v = olddistancevlist.get(vod)] <= -1; ++vod) {
            this.vertexdistance[v] = distance;
            this.vertexComponent[v] = componentNumber;
            ++count;
            degree = this.vertexList[v].size();
            totdistdegree += (long)degree;
            for (int n = 0; n < degree; ++n) {
                int vn = this.vertexList[v].get(n);
                if (this.vertexdistance[vn] >= -1) continue;
                this.vertexdistance[vn] = -1;
                distancevlist.add(vn);
            }
        }
        this.distancedist.add(count);
        this.componentsize += count;
        if (distancevlist.size() > 0 && distance < maxDistance) {
            this.calcDistanceNext(distance + 1, maxDistance, componentNumber, distancevlist);
        }
    }

    private void calcDistanceOne(int vertex, int maxDistance) {
        this.vertexdistance = new int[this.TotalNumberVertices];
        this.vertexComponent = new int[this.TotalNumberVertices];
        this.distancedist = new IntArrayList();
        IntArrayList distancevlist = new IntArrayList(100);
        distancevlist.add(vertex);
        int componentNumber = 1;
        this.componentsize = 0;
        for (int u = 0; u < this.TotalNumberVertices; ++u) {
            this.vertexdistance[u] = -999999;
        }
        this.vertexdistance[vertex] = -1;
        this.calcDistanceNext(0, maxDistance, componentNumber, distancevlist);
        this.diameter = this.distancedist.size() - 1;
        int dt = 0;
        int d2t = 0;
        int count = 0;
        for (int d = 1; d < this.distancedist.size(); ++d) {
            int n = this.distancedist.get(d);
            count += n;
            dt += n * d;
            d2t += n * d * d;
        }
        if (count > 0) {
            this.distanceaverage = this.calcAverage(dt, count);
            this.distanceerror = this.calcError(dt, d2t, count);
            this.distancesigma = this.calcSigma(dt, d2t, count);
        } else {
            this.distanceaverage = 0.0;
            this.distanceerror = 0.0;
            this.distancesigma = 0.0;
        }
    }

    private void calcDistanceNextComponent(int vertex, int maxDistance) {
        this.componentSource.add(vertex);
        int componentNumber = this.componentSource.size() - 1;
        this.distancedist = new IntArrayList();
        IntArrayList distancevlist = new IntArrayList(100);
        distancevlist.add(vertex);
        this.componentsize = 0;
        if (this.vertexdistance[vertex] > -99) {
            System.out.println("*** Error in calcDistanceNextComponent ");
        }
        this.vertexdistance[vertex] = -1;
        this.calcDistanceNext(0, maxDistance, componentNumber, distancevlist);
        this.componentSize.add(this.componentsize);
        if (this.componentSizeMax < this.componentsize) {
            this.componentSizeMax = this.componentsize;
            this.componentSourceMax = vertex;
            this.componentDiameterMax = this.distancedist.size() - 1;
            this.componentGCCIndex = componentNumber;
        }
        this.componentDist.add(this.distancedist.size() - 1);
        if (this.infoLevel > 1) {
            System.out.println("Finished looking at component " + this.componentSize.size() + " around vertex " + vertex);
        }
    }

    public void calcComponents() {
        int u;
        this.vertexdistance = new int[this.TotalNumberVertices];
        this.vertexComponent = new int[this.TotalNumberVertices];
        this.distancedist = new IntArrayList();
        this.componentSize = new IntArrayList();
        this.componentSource = new IntArrayList();
        this.componentDist = new IntArrayList();
        IntArrayList distancevlist = new IntArrayList(100);
        this.componentSizeMax = -1;
        this.componentSourceMax = -1;
        this.componentGCCDist = -1.0;
        this.componentGCCIndex = -1;
        this.componentSingleNumber = -1;
        for (u = 0; u < this.TotalNumberVertices; ++u) {
            this.vertexdistance[u] = -999999;
            this.vertexComponent[u] = -999999;
        }
        for (u = 0; u < this.TotalNumberVertices; ++u) {
            if (this.vertexComponent[u] >= 0) continue;
            this.calcDistanceNextComponent(u, this.TotalNumberVertices);
        }
        int count = 0;
        this.componentSingleNumber = 0;
        for (int c = 0; c < this.componentSize.size(); ++c) {
            count += this.componentSize.get(c);
            if (this.componentSize.get(c) != 1) continue;
            ++this.componentSingleNumber;
        }
        if (count != this.TotalNumberVertices) {
            System.out.println("!!! Warning components have total " + count + " out of " + this.TotalNumberVertices + " vertices");
        }
        count = 0;
        int dist = 0;
        for (int u2 = 0; u2 < this.TotalNumberVertices; ++u2) {
            if (this.vertexComponent[u2] != this.componentGCCIndex) continue;
            dist += this.vertexdistance[u2];
            ++count;
        }
        if (count != this.componentSizeMax) {
            System.out.println("!!! Warning GCC component has total " + count + " vertices but recorded as " + this.componentSizeMax + " vertices");
        }
        if (this.componentSizeMax > 0) {
            this.componentGCCDist = dist / this.componentSizeMax;
        }
    }

    public void calcRing(int vertex, int maxDistance) {
        this.vertexdistance = new int[this.TotalNumberVertices];
        this.vertexComponent = new int[this.TotalNumberVertices];
        this.distancedist = new IntArrayList();
        this.componentSize = new IntArrayList();
        this.componentSource = new IntArrayList();
        this.componentDist = new IntArrayList();
        IntArrayList distancevlist = new IntArrayList(100);
        this.componentSizeMax = -1;
        this.componentSourceMax = -1;
        this.componentGCCDist = -1.0;
        this.componentGCCIndex = -1;
        this.componentSingleNumber = -1;
        for (int u = 0; u < this.TotalNumberVertices; ++u) {
            this.vertexdistance[u] = -999999;
            this.vertexComponent[u] = -999999;
        }
        this.calcDistanceNextComponent(vertex, maxDistance);
        int count = 0;
        int dist = 0;
        for (int u = 0; u < this.TotalNumberVertices; ++u) {
            if (this.vertexComponent[u] != this.componentGCCIndex) continue;
            dist += this.vertexdistance[u];
            ++count;
        }
        if (count != this.componentSizeMax) {
            System.out.println("!!! Warning GCC component has total " + count + " vertices but recorded as " + this.componentSizeMax + " vertices");
        }
        if (this.componentSizeMax > 0) {
            this.componentGCCDist = dist / this.componentSizeMax;
        }
    }

    public TreeSet<Integer> getGCC() {
        return this.getComponent(this.componentGCCIndex);
    }

    public TreeSet<Integer> getComponent(int componentNumber) {
        TreeSet<Integer> component = new TreeSet<Integer>();
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            if (this.vertexComponent[v] != componentNumber) continue;
            component.add(v);
        }
        return component;
    }

    public int getVertexComponentLabel(int v) {
        return this.vertexComponent[v];
    }

    public TreeSet<Integer> getRing(int vertex, int maxDistance) {
        this.calcDistanceOne(vertex, maxDistance);
        TreeSet<Integer> ring = new TreeSet<Integer>();
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            if (this.vertexdistance[v] < 0) continue;
            ring.add(v);
        }
        return ring;
    }

    public TreeSet<Integer> getEdgeSubGraph(Set<Integer> labelSet) {
        if (!this.weightedEdges) {
            throw new IllegalArgumentException("*** getEdgeSubGraph needed edges to have labels");
        }
        TreeSet<Integer> vertexSubSet = new TreeSet<Integer>();
        for (int e = 0; e < this.TotalNumberStubs; e += 2) {
            if (!labelSet.contains(this.edgeValuetList[e].label)) continue;
            vertexSubSet.add(this.stubSourceList[e]);
            vertexSubSet.add(this.stubSourceList[e + 1]);
        }
        return vertexSubSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDijkstra() {
        int metricNumber = 0;
        double degree = -1.0;
        double totdistdegree = 0.0;
        this.DijkstraMaxDist = 0.0;
        this.distance = new double[this.TotalNumberVertices][this.TotalNumberVertices];
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            int mdv = v;
            double mindistance = this.MAXDISTANCE;
            boolean[] notVisited = new boolean[this.TotalNumberVertices];
            for (int i = 0; i < this.TotalNumberVertices; ++i) {
                this.distance[v][i] = this.MAXDISTANCE;
                notVisited[i] = true;
            }
            this.distance[v][v] = 0.0;
            for (int n = 0; n < this.TotalNumberVertices; ++n) {
                mindistance = this.MAXDISTANCE;
                for (int j = 0; j < this.TotalNumberVertices; ++j) {
                    if (!notVisited[j] || !(this.distance[v][j] < mindistance)) continue;
                    mindistance = this.distance[v][j];
                    mdv = j;
                }
                if (mindistance == this.MAXDISTANCE) break;
                notVisited[mdv] = false;
                degree = this.vertexList[mdv].size();
                totdistdegree += degree;
                int e = 0;
                while ((double)e < degree) {
                    int vn = this.vertexList[mdv].get(e);
                    double newdist = this.MAXDISTANCE * 1.0001;
                    switch (metricNumber) {
                        default: 
                    }
                    newdist = mindistance + 0.0;
                    if (this.distance[v][vn] > newdist) {
                        this.distance[v][vn] = newdist;
                    }
                    ++e;
                }
            }
            if (!(this.DijkstraMaxDist < mindistance)) continue;
            this.DijkstraMaxDist = mindistance;
        }
    }

    void calcRingParameters(int sourcevertex) {
        this.vertexdistance = new int[this.TotalNumberVertices];
        this.vertexComponent = new int[this.TotalNumberVertices];
        this.distancedist = new IntArrayList();
        this.componentSize = new IntArrayList();
        this.componentSource = new IntArrayList();
        this.componentDist = new IntArrayList();
        IntArrayList distancevlist = new IntArrayList(100);
        for (int u = 0; u < this.TotalNumberVertices; ++u) {
            this.vertexdistance[u] = -999999;
            this.vertexComponent[u] = -999999;
        }
        this.calcDistanceNextComponent(sourcevertex, this.TotalNumberVertices + 1);
        this.ringdegree = new DoubleArrayList();
        for (int u = 0; u < this.TotalNumberVertices; ++u) {
            if (this.vertexComponent[u] < 0) continue;
            int udist = this.vertexdistance[u];
            int udegree = this.vertexList[u].size();
            while (this.ringdegree.size() <= udist) {
                this.ringdegree.add(0.0);
            }
            double nd = this.ringdegree.get(udist);
            this.ringdegree.set(udist, nd + (double)udegree);
        }
        for (int rd = 0; rd < this.ringdegree.size(); ++rd) {
            this.ringdegree.set(rd, this.ringdegree.get(rd) / (double)this.distancedist.get(rd));
        }
    }

    void updateRingStats(int vertexdist, int vertexdegree) {
        while (this.ringdegree.size() < vertexdist) {
            this.ringdegree.add(0.0);
        }
        this.ringdegree.get(vertexdist);
    }

    public void calcDistanceSample(double fracerror, int minimumsamples, int maximumsamples) {
        boolean doall = false;
        int minsamples = minimumsamples;
        int maxsamples = maximumsamples;
        if (fracerror > 1.0) {
            doall = true;
            maxsamples = this.TotalNumberVertices;
            minsamples = this.TotalNumberVertices;
        }
        this.totdistancedist = new DoubleArrayList(100);
        this.totdistance2dist = new DoubleArrayList(100);
        this.nsamples = 0;
        int totdiam = 0;
        int totdiam2 = 0;
        this.totdistanceaverage = 0.0;
        this.totdistanceerror = 0.0;
        this.totdistancesigma = 0.0;
        this.diameteraverage = 0.0;
        this.diametersigma = 0.0;
        this.diametererror = 0.0;
        this.diametermin = 9999999;
        DoubleArrayList avdistancedist = new DoubleArrayList();
        IntArrayList diameterdist = new IntArrayList();
        double onesavdt = 0.0;
        double onesavd2t = 0.0;
        do {
            int d;
            ++this.nsamples;
            if (doall) {
                this.calcDistanceOne(this.nsamples - 1, this.TotalNumberVertices + 1);
            } else if (this.nsamples == 1 || this.componentSourceMax < 0) {
                this.calcDistanceOne(this.Rnd.nextInt(this.TotalNumberVertices), this.TotalNumberVertices + 1);
            } else {
                this.calcDistanceOne(this.componentSourceMax, this.TotalNumberVertices + 1);
            }
            avdistancedist.add(this.distanceaverage);
            onesavdt += this.distanceaverage;
            onesavd2t += this.distanceaverage * this.distanceaverage;
            double n = 0.0;
            double n2 = 0.0;
            int dmax = this.distancedist.size();
            int dmaxb = this.totdistancedist.size();
            if (dmaxb < dmax) {
                dmax = dmaxb;
            }
            for (d = 0; d < dmax; ++d) {
                n = this.distancedist.get(d);
                n2 = n * n;
                this.totdistancedist.set(d, n += this.totdistancedist.get(d));
                this.totdistance2dist.set(d, n2 += this.totdistance2dist.get(d));
            }
            for (d = dmax; d < this.distancedist.size(); ++d) {
                n = this.distancedist.get(d);
                n2 = n * n;
                this.totdistancedist.add(n);
                this.totdistance2dist.add(n2);
            }
            double dt = 0.0;
            double d2t = 0.0;
            double count = 0.0;
            for (int d2 = 1; d2 < this.totdistancedist.size(); ++d2) {
                n = this.totdistancedist.get(d2);
                count += n;
                dt += n * (double)d2;
                d2t += n * (double)d2 * (double)d2;
            }
            this.totdistanceaverage = dt / count;
            this.totdistanceerror = this.calcError(dt, d2t, count);
            this.totdistancesigma = this.calcSigma(dt, d2t, count);
            totdiam += this.diameter;
            totdiam2 += this.diameter * this.diameter;
            diameterdist.add(this.diameter);
            if (this.diametermin > this.diameter) {
                this.diametermin = this.diameter;
            }
            this.diameteraverage = this.calcAverage(totdiam, this.nsamples);
            this.diametererror = this.calcError(totdiam, totdiam2, this.nsamples);
            this.diametersigma = this.calcSigma(totdiam, totdiam2, this.nsamples);
        } while (this.nsamples < maxsamples && (this.totdistanceerror > this.totdistanceaverage * fracerror || this.nsamples < minsamples));
        this.onesdistanceav = onesavdt / (double)this.nsamples;
        this.onesdistanceerror = this.calcError(onesavdt, onesavd2t, (double)this.nsamples);
        this.onesdistancesigma = this.calcSigma(onesavdt, onesavd2t, this.nsamples);
        this.diametermax = this.totdistancedist.size() - 1;
    }

    double calcCCOneOld(int v) {
        int nedgepairs = 0;
        int ntriangles = 0;
        if (v < 0 || v >= this.TotalNumberVertices) {
            System.out.println("*** Error in calcCCOne vertex " + v + " invalid with " + this.TotalNumberVertices + " total vertices");
            return -2.0;
        }
        int vlsize = this.vertexList[v].size();
        if (vlsize < 2) {
            return -1.0;
        }
        for (int e1 = 0; e1 < vlsize - 1; ++e1) {
            int v1 = this.vertexList[v].get(e1);
            int s1 = this.vertexList[v1].size();
            block1: for (int e2 = e1 + 1; e2 < vlsize; ++e2) {
                int ss;
                int vd;
                int vs;
                ++nedgepairs;
                int v2 = this.vertexList[v].get(e2);
                int s2 = this.vertexList[v2].size();
                if (s1 < s2) {
                    vs = v1;
                    vd = v2;
                    ss = s1;
                } else {
                    vs = v2;
                    vd = v1;
                    ss = s2;
                }
                for (int e3 = 0; e3 < ss; ++e3) {
                    if (this.vertexList[vs].get(e3) != vd) continue;
                    ++ntriangles;
                    continue block1;
                }
            }
        }
        return (double)ntriangles / (double)nedgepairs;
    }

    double calcCCOne(int v) {
        int nedgepairs = 0;
        int ntriangles = 0;
        if (v < 0 || v >= this.TotalNumberVertices) {
            throw new RuntimeException("*** Error in calcCCOne vertex " + v + " invalid with " + this.TotalNumberVertices + " total vertices");
        }
        int vlsize = this.vertexList[v].size();
        if (vlsize < 2) {
            return -1.0;
        }
        for (int e1 = 0; e1 < vlsize - 1; ++e1) {
            int v1 = this.vertexList[v].get(e1);
            int s1 = this.vertexList[v1].size();
            for (int e2 = e1 + 1; e2 < vlsize; ++e2) {
                ++nedgepairs;
                int v2 = this.vertexList[v].get(e2);
                for (int e3 = 0; e3 < s1; ++e3) {
                    if (this.vertexList[v1].get(e3) != v2) continue;
                    ++ntriangles;
                }
            }
        }
        return (double)ntriangles / (double)nedgepairs;
    }

    int calcTriangles(int v) {
        boolean nedgepairs = false;
        int ntriangles = 0;
        if (v < 0 || v >= this.TotalNumberVertices) {
            throw new RuntimeException("*** Error in calcTriangles vertex " + v + " invalid with " + this.TotalNumberVertices + " total vertices");
        }
        int vlsize = this.vertexList[v].size();
        if (vlsize < 2) {
            return 0;
        }
        for (int e1 = 0; e1 < vlsize - 1; ++e1) {
            int v1 = this.vertexList[v].get(e1);
            int s1 = this.vertexList[v1].size();
            for (int e2 = e1 + 1; e2 < vlsize; ++e2) {
                int v2 = this.vertexList[v].get(e2);
                for (int e3 = 0; e3 < s1; ++e3) {
                    if (this.vertexList[v1].get(e3) != v2) continue;
                    ++ntriangles;
                }
            }
        }
        return ntriangles;
    }

    int[] calcTrianglesSquares(int v) {
        int[] result = new int[]{0, 0};
        int v3 = -1;
        if (v < 0 || v >= this.TotalNumberVertices) {
            throw new RuntimeException("*** Error in calcSquares vertex " + v + " invalid with " + this.TotalNumberVertices + " total vertices");
        }
        int vlsize = this.vertexList[v].size();
        if (vlsize < 2) {
            return result;
        }
        for (int e1 = 0; e1 < vlsize - 1; ++e1) {
            int v1 = this.vertexList[v].get(e1);
            int s1 = this.vertexList[v1].size();
            IntArrayList v1nn = this.vertexList[v1];
            for (int e2 = e1 + 1; e2 < vlsize; ++e2) {
                int v2 = this.vertexList[v].get(e2);
                for (int e3 = 0; e3 < s1; ++e3) {
                    v3 = this.vertexList[v1].get(e3);
                    if (v3 == v2) {
                        result[0] = result[0] + 1;
                        continue;
                    }
                    if (v3 == v || !this.vertexList[v2].contains(v3)) continue;
                    result[1] = result[1] + 1;
                }
            }
        }
        return result;
    }

    public void calcCCSample(double fracerror, int minimumsamples, int maximumsamples) {
        boolean doall = false;
        int minsamples = minimumsamples;
        int maxsamples = maximumsamples;
        if (fracerror >= 1.0) {
            doall = true;
            maxsamples = this.TotalNumberVertices;
            minsamples = this.TotalNumberVertices;
        }
        int nattempts = 0;
        this.CCnsamples = 0;
        this.CCaverage = 0.0;
        this.CCerror = 0.0;
        this.CCsigma = 0.0;
        double CCt = 0.0;
        double CC2t = 0.0;
        do {
            double CC = doall ? this.calcCCOne(nattempts) : this.calcCCOne(this.Rnd.nextInt(this.TotalNumberVertices));
            ++nattempts;
            if (CC < 0.0) continue;
            ++this.CCnsamples;
            this.CCaverage = (CCt += CC) / (double)this.CCnsamples;
            this.CCerror = this.calcError(CCt, CC2t += CC * CC, (double)this.CCnsamples);
            this.CCsigma = this.calcSigma(CCt, CC2t, this.CCnsamples);
            if (nattempts >= maxsamples) break;
        } while (this.CCerror > this.CCaverage * fracerror || nattempts < minsamples);
    }

    int unweightedEdgeSource(int e) {
        if (e % 2 == 1) {
            return e - 1;
        }
        return e;
    }

    double calcCCEdgeOne(int e) {
        int v2;
        int v1;
        boolean nedgepairs = false;
        int ntriangles = 0;
        if (e < 0 || e >= this.TotalNumberStubs) {
            System.out.println("*** Error in calcCCOne vertex " + e + " invalid with " + this.TotalNumberStubs + " total edges");
            return -2.0;
        }
        int es = e / 2 * 2;
        int vs = this.stubSourceList[es];
        int vt = this.stubSourceList[es + 1];
        int vssize = this.vertexList[vs].size();
        int vtsize = this.vertexList[vt].size();
        if (vssize == 0 && vtsize == 0) {
            return -1.0;
        }
        for (int e1 = 0; e1 < vssize - 1; ++e1) {
            v1 = this.vertexList[vs].get(e1);
            for (int e2 = 0; e2 < vtsize; ++e2) {
                v2 = this.vertexList[vt].get(e2);
                if (v1 != v2) continue;
                ++ntriangles;
            }
        }
        int vtemp = vs;
        vs = vt;
        vt = vtemp;
        vssize = this.vertexList[vs].size();
        vtsize = this.vertexList[vt].size();
        if (vssize == 0 && vtsize == 0) {
            return -1.0;
        }
        for (int e1 = 0; e1 < vssize - 1; ++e1) {
            v1 = this.vertexList[vs].get(e1);
            for (int e2 = 0; e2 < vtsize; ++e2) {
                v2 = this.vertexList[vt].get(e2);
                if (v1 != v2) continue;
                ++ntriangles;
            }
        }
        return (double)ntriangles / ((double)vtsize * (double)vssize);
    }

    public void calcCCEdgeSample(double fracerror, int minimumsamples, int maximumsamples) {
        boolean doall = false;
        int minsamples = minimumsamples;
        int maxsamples = maximumsamples;
        if (fracerror >= 1.0) {
            doall = true;
            maxsamples = this.TotalNumberStubs;
            minsamples = this.TotalNumberStubs;
        }
        int nattempts = 0;
        this.CCEdgensamples = 0;
        this.CCEdgeaverage = 0.0;
        this.CCEdgeerror = 0.0;
        this.CCEdgesigma = 0.0;
        double CCt = 0.0;
        double CC2t = 0.0;
        if (this.TotalNumberStubs == 0) {
            return;
        }
        do {
            double CC = doall ? this.calcCCEdgeOne(nattempts) : this.calcCCEdgeOne(this.Rnd.nextInt(this.TotalNumberStubs));
            ++nattempts;
            if (CC < 0.0) continue;
            ++this.CCEdgensamples;
            this.CCEdgeaverage = (CCt += CC) / (double)this.CCEdgensamples;
            this.CCEdgeerror = this.calcError(CCt, CC2t += CC * CC, (double)this.CCEdgensamples);
            this.CCEdgesigma = this.calcSigma(CCt, CC2t, this.CCEdgensamples);
            if (nattempts >= maxsamples) break;
        } while (this.CCerror > this.CCaverage * fracerror || nattempts < minsamples);
    }

    public double calcDegreeFirstMoment() {
        return (double)this.TotalNumberStubs / (double)this.TotalNumberVertices;
    }

    public double getDegreeFirstMoment() {
        return this.calcDegreeFirstMoment();
    }

    public double getAverageDegree() {
        if (this.TotalNumberVertices == 1) {
            return -3.57986421E8;
        }
        if (this.directedGraph) {
            return (double)this.getNumberEdges() / (double)this.TotalNumberVertices;
        }
        return (double)this.TotalNumberStubs / (double)this.TotalNumberVertices;
    }

    public double getDegreeSecondMoment() {
        if (this.degreeSecondMoment < 0.0) {
            this.calcDegreeSecondMoment();
        }
        return this.degreeSecondMoment;
    }

    public double calcDegreeSecondMoment() {
        int k2 = 0;
        int k = 0;
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            k = this.getVertexDegree(v);
            k2 += k * k;
        }
        this.degreeSecondMoment = (double)k2 / (double)this.TotalNumberVertices;
        return this.degreeSecondMoment;
    }

    public void calcDegreeDistribution() {
        this.calcDegreeDistributionUnipartite();
        this.calcDegreeDistributionBipartite();
    }

    public void calcDegreeDistributionBipartite() {
        String name = this.inputName.getNameRoot();
        if (!this.bipartiteGraph) {
            return;
        }
        this.DD1total = new DegreeDistribution(name + "Type1Total");
        this.DD1total.calcDegreeDistribution(this.vertexList, 0, this.numberVertexType1);
        this.DD2total = new DegreeDistribution(name + "Type2Total");
        this.DD2total.calcDegreeDistribution(this.vertexList, this.numberVertexType1, this.TotalNumberVertices);
    }

    public void calcDegreeDistributionUnipartite() {
        String name = this.inputName.getNameRoot();
        if (this.directedGraph) {
            this.DDout = new DegreeDistribution(name + "Out");
            this.DDout.calcDegreeDistribution(this.vertexList, this.TotalNumberVertices);
            this.DDin = new DegreeDistribution(name + "In");
            this.DDin.calcDegreeDistribution(this.vertexSourceList, this.TotalNumberVertices);
            int maximum = Math.max(this.DDin.maximum, this.DDout.maximum);
            this.DDtotal = new DegreeDistribution(name + "Total", maximum);
            this.DDtotal.calcDegreeDistribution(this.vertexList, this.vertexSourceList, this.TotalNumberVertices);
        } else {
            this.DDtotal = new DegreeDistribution(name + "Total");
            this.DDtotal.calcDegreeDistribution(this.vertexList, this.TotalNumberVertices);
        }
    }

    void ordervertexList() {
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            if (this.vertexList[v] == null) {
                System.out.println("In ordervertexList null vertexList " + v);
                return;
            }
            int k = this.vertexList[v].size();
            for (int e1 = 0; e1 < k; ++e1) {
                int v1 = this.vertexList[v].get(e1);
                for (int e2 = e1; e2 < k; ++e2) {
                    if (v1 <= this.vertexList[v].get(e2)) continue;
                    v1 = this.vertexList[v].get(e2);
                    this.vertexList[v].set(e2, this.vertexList[v].get(e1));
                    this.vertexList[v].set(e1, v1);
                }
            }
        }
    }

    void calcMultipleLinkDistribution() {
        this.ordervertexList();
        this.weightmaximum = -1;
        this.weightdarr = new IntArrayList();
        this.weightdarr.add(0);
        this.rddarr = new IntArrayList();
        this.rddarr.add(0);
        this.rvertexList = new IntArrayList[this.maximumVertices];
        this.strengthlist = new IntArrayList[this.maximumVertices];
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            this.rvertexList[v] = new IntArrayList();
            this.strengthlist[v] = new IntArrayList();
            if (this.vertexList[v] == null) {
                this.addExtendIntArrayList(this.weightdarr, 0, 1);
                break;
            }
            int k = this.vertexList[v].size();
            int v1 = this.vertexList[v].get(0);
            int count = 1;
            for (int e1 = 1; e1 < k; ++e1) {
                int v2 = this.vertexList[v].get(e1);
                if (v1 == v2) {
                    ++count;
                    continue;
                }
                this.strengthlist[v].add(count);
                this.rvertexList[v].add(v1);
                this.addExtendIntArrayList(this.weightdarr, count, 1);
                v1 = v2;
                count = 1;
            }
            this.strengthlist[v].add(count);
            this.rvertexList[v].add(v1);
            this.addExtendIntArrayList(this.weightdarr, count, 1);
            this.addExtendIntArrayList(this.rddarr, this.rvertexList[v].size(), 1);
        }
        this.weightmaximum = this.weightdarr.size();
    }

    void calcReducedWeightDistribution() {
        this.weightmaximum = -1;
        this.weightdarr = new IntArrayList();
        this.weightdarr.add(0);
        this.strengthlist = new IntArrayList[this.maximumVertices];
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            this.rvertexList[v] = new IntArrayList();
            this.strengthlist[v] = new IntArrayList();
            if (this.vertexList[v] == null) {
                this.addExtendIntArrayList(this.weightdarr, 0, 1);
                break;
            }
            int k = this.vertexList[v].size();
            int v1 = this.vertexList[v].get(0);
            int count = 1;
            for (int e1 = 1; e1 < k; ++e1) {
                int v2 = this.vertexList[v].get(e1);
                if (v1 == v2) {
                    ++count;
                    continue;
                }
                this.strengthlist[v].add(count);
                this.rvertexList[v].add(v1);
                this.addExtendIntArrayList(this.weightdarr, count, 1);
                v1 = v2;
                count = 1;
            }
            this.strengthlist[v].add(count);
            this.rvertexList[v].add(v1);
            this.addExtendIntArrayList(this.weightdarr, count, 1);
            this.addExtendIntArrayList(this.rddarr, this.rvertexList[v].size(), 1);
        }
        this.weightmaximum = this.weightdarr.size();
    }

    public void calcStrength() {
        if (!this.vertexlabels) {
            System.err.println("!!! WARNING calcStrength() requires vertex labels to be on");
            return;
        }
        if (!this.weightedEdges) {
            for (int v = 0; v < this.TotalNumberVertices; ++v) {
                this.vertexLabelList[v].setStrength(this.getVertexDegree(v));
            }
            this.TotalWeight = this.TotalNumberStubs;
            return;
        }
        if (this.vertexEdgeListOn) {
            this.TotalWeight = 0.0;
            double s = -1.0;
            for (int v = 0; v < this.TotalNumberVertices; ++v) {
                s = this.getVertexOutStrength(v);
                this.vertexLabelList[v].setStrength(s);
                this.TotalWeight += s;
            }
            return;
        }
        this.calcStrengthDirectly();
    }

    public void calcStrengthDirectly() {
        if (!this.vertexlabels) {
            System.out.println("!!! WARNING calcStrengthDirectly() requires vertex labels to be on");
            return;
        }
        if (!this.weightedEdges) {
            for (int v = 0; v < this.TotalNumberVertices; ++v) {
                this.vertexLabelList[v].setStrength(this.getVertexDegree(v));
            }
            this.TotalWeight = this.TotalNumberStubs;
            return;
        }
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            this.vertexLabelList[v].setStrength(0.0);
        }
        int s = -1;
        int t = -1;
        double w = -1.0;
        this.TotalWeight = 0.0;
        for (int e = 0; e < this.TotalNumberStubs; ++e) {
            w = this.edgeValuetList[e].weight;
            this.TotalWeight += w;
            s = this.stubSourceList[e++];
            this.vertexLabelList[s].addStrength(w);
            if (this.isDirected() || s == (t = this.stubSourceList[e])) continue;
            this.vertexLabelList[t].addStrength(w);
        }
    }

    public void calcTotalWeight() {
        if (this.isWeighted()) {
            this.TotalWeight = 0.0;
            double w = -1.0;
            int s = -1;
            int t = -1;
            for (int e = 0; e < this.TotalNumberStubs; ++e) {
                s = this.stubSourceList[e];
                w = this.edgeValuetList[e++].weight;
                this.TotalWeight += w;
                if (this.isDirected() || s == (t = this.stubSourceList[e])) continue;
                this.TotalWeight += w;
            }
        } else {
            this.TotalWeight = this.TotalNumberStubs / 2;
        }
    }

    public int calcTrianglesTotal() {
        int t = 0;
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            t += this.calcTriangles(v);
        }
        this.TotalNumberTriangles = t / 3;
        return this.TotalNumberTriangles;
    }

    public int calcTrianglesSquaresTotal() {
        int s = 0;
        int t = 0;
        int[] res = new int[]{0, 0};
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            res = this.calcTrianglesSquares(v);
            t += res[0];
            s += res[1];
        }
        this.TotalNumberTriangles = t / 3;
        this.TotalNumberSquares = s / 4;
        return this.TotalNumberTriangles;
    }

    public int getNumberTriangles() {
        if (this.TotalNumberTriangles < 0) {
            return this.calcTrianglesTotal();
        }
        return this.TotalNumberTriangles;
    }

    public int getNumberSquares() {
        if (this.TotalNumberSquares < 0) {
            return this.calcTrianglesSquaresTotal();
        }
        return this.TotalNumberSquares;
    }

    public double getCCGlobal() {
        if (this.ccGlobal < 0.0) {
            return this.calcCCGlobal();
        }
        return this.ccGlobal;
    }

    public double calcCCGlobal() {
        try {
            int t = this.getNumberTriangles() / this.TotalNumberVertices;
            this.ccGlobal = (double)(6 * t) / (this.getDegreeSecondMoment() - this.getDegreeFirstMoment());
        }
        catch (RuntimeException e) {
            this.ccGlobal = Double.NaN;
        }
        return this.ccGlobal;
    }

    public void calcRanking() {
        if (this.averageWalkLength < 0.0) {
            this.averageWalkLength = this.diameter;
        }
        if (this.averageWalkLength < 2.0) {
            this.averageWalkLength = 2.0;
        }
        if (this.rankingProbabilityLengthScale < 0.0) {
            this.rankingProbabilityLengthScale = this.distanceaverage;
        }
        if (this.rankingProbabilityLengthScale < 2.0) {
            this.rankingProbabilityLengthScale = 2.0;
        }
        int totalNumberaverageWalkLength = this.TotalNumberStubs * 100;
        int startVertex = -1;
        if (this.infoLevel > -2) {
            System.out.println("randomrandomWalk.randomWalkMode, averageWalkLength, rankingProbabilityLengthScale, totalNumberaverageWalkLength, startVertex = \t " + this.randomWalkMode + SEP + this.averageWalkLength + SEP + this.rankingProbabilityLengthScale + SEP + totalNumberaverageWalkLength + SEP + startVertex);
        }
        this.DoRandomWalk(totalNumberaverageWalkLength, startVertex);
        this.calcMaximumVertexLabel();
    }

    void addExtendIntArrayList(IntArrayList ial, int index, int value) {
        int size = ial.size();
        if (index == 0 && size == 0) {
            ial.add(value);
            return;
        }
        for (int i = size; i <= index; ++i) {
            ial.add(0);
        }
        ial.set(index, ial.get(index) + value);
    }

    public boolean isWeighted() {
        return this.weightedEdges;
    }

    public boolean isEdgeLabelled() {
        return this.labelledEdges;
    }

    public boolean isMultiEdge() {
        return this.multiEdge;
    }

    public boolean isSelfLooped() {
        return this.selfLoops;
    }

    public boolean isDirected() {
        return this.directedGraph;
    }

    public boolean isVertexEdgeListOn() {
        return this.vertexEdgeListOn;
    }

    public boolean isVertexLabelled() {
        return this.vertexlabels;
    }

    public boolean hasVertexPositions() {
        if (!this.vertexlabels) {
            return false;
        }
        if (this.vertexLabelList == null) {
            return false;
        }
        return this.vertexLabelList[0].hasPosition();
    }

    public boolean hasVertexNames() {
        if (!this.vertexlabels) {
            return false;
        }
        if (this.vertexLabelList == null) {
            return false;
        }
        return this.vertexLabelList[0].hasName();
    }

    public boolean isBipartite() {
        return this.bipartiteGraph;
    }

    public boolean checkSelfLoops() {
        for (int s = 0; s < this.TotalNumberStubs; ++s) {
            if (!this.isStubSelfLoop(s)) continue;
            return true;
        }
        return false;
    }

    public boolean checkNegativeWeights() {
        if (!this.weightedEdges) {
            return false;
        }
        for (int s = 0; s < this.TotalNumberStubs; ++s) {
            if (!(this.getEdgeWeight(s) < 0.0)) continue;
            return true;
        }
        return false;
    }

    public boolean checkMultiEdges() {
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            if (this.getFirstEdgeLocal(v, v) < 0) continue;
            return true;
        }
        return false;
    }

    public boolean isType1(int v) {
        return this.bipartiteGraph && v < this.numberVertexType1;
    }

    public boolean isType2(int v) {
        return this.bipartiteGraph && v >= this.numberVertexType1;
    }

    public boolean isInfoLeveLGreaterThan(int i) {
        return this.infoLevel > i;
    }

    public void setWeightedEdges(boolean b) {
        this.weightedEdges = b;
    }

    public void setLabelledEdges(boolean b) {
        this.labelledEdges = b;
    }

    public void setMultiEdge(boolean b) {
        this.multiEdge = b;
    }

    public void setSelfLoops(boolean b) {
        this.selfLoops = b;
    }

    public void setDirectedGraph(boolean b) {
        this.directedGraph = b;
    }

    public void setVertexEdgeList(boolean b) {
        this.vertexEdgeListOn = b;
    }

    public void setVertexlabels(boolean b) {
        this.vertexlabels = b;
    }

    public void setGraphProperties(boolean makeDirected, boolean makeLabelled, boolean makeWeighted, boolean makeVertexEdgeList) {
        this.directedGraph = makeDirected;
        this.vertexlabels = makeLabelled;
        this.weightedEdges = makeWeighted;
        this.vertexEdgeListOn = makeVertexEdgeList;
    }

    public void setBipartite(int n1, int n2) {
        this.numberVertexType1 = n1;
        this.numberVertexType2 = n2;
    }

    public void setBipartite(int n1, int n2, String name1, String name2) {
        this.numberVertexType1 = n1;
        this.numberVertexType2 = n2;
        this.setBipartiteVertexNames(name1, name2);
        this.bipartiteGraph = true;
    }

    public void setBipartiteVertexNames(String name1, String name2) {
        this.nameVertexType1 = name1;
        this.nameVertexType2 = name2;
    }

    public void setNameRoot(String root) {
        this.inputName.setNameRoot(root);
        this.outputName.setNameRoot(root);
    }

    public void addToNameRoot(String add) {
        this.inputName.setNameRoot(this.inputName.getNameRoot() + add);
        this.outputName.setNameRoot(this.outputName.getNameRoot() + add);
    }

    public int getNumberVertices() {
        return this.TotalNumberVertices;
    }

    public int getNumberVerticesType1() {
        return this.numberVertexType1;
    }

    public int getNumberVerticesType2() {
        return this.numberVertexType2;
    }

    public String getNameVerticesType1() {
        return this.nameVertexType1;
    }

    public String getNameVerticesType2() {
        return this.nameVertexType2;
    }

    public int getNumberStubs() {
        return this.TotalNumberStubs;
    }

    public int getNumberEdges() {
        return this.TotalNumberStubs >> 1;
    }

    public double getTotalWeight() {
        if (this.TotalWeight == -3.57986421E8) {
            this.calcTotalWeight();
        }
        return this.TotalWeight;
    }

    public int getNumberDistinctEdges() {
        return this.directedGraph ? this.TotalNumberStubs : this.TotalNumberStubs / 2;
    }

    public int getInformationLevel() {
        return this.infoLevel;
    }

    public void setInformationLevel(int il) {
        this.infoLevel = il;
    }

    public int getRandomEdge() {
        return this.Rnd.nextInt(this.TotalNumberStubs);
    }

    public int getFirstEdgeGlobal(int s, int t) {
        int e;
        for (e = 0; e < this.vertexList[s].size() && this.vertexList[s].getQuick(e) != t; ++e) {
        }
        if (e == this.vertexList[s].size()) {
            return -1;
        }
        return this.vertexEdgeList[s].get(e);
    }

    public double getAdjacencyMatrixEntry(int s, int t) {
        double adjacencyMatrixEntry = 0.0;
        for (int n = 0; n < this.vertexList[s].size(); ++n) {
            if (this.vertexList[s].getQuick(n) != t) continue;
            adjacencyMatrixEntry += this.getEdgeWeight(this.vertexEdgeList[s].get(n));
        }
        return adjacencyMatrixEntry;
    }

    public int getGlobalEdgeFromLocal(int s, int elocal) {
        return this.vertexEdgeList[s].get(elocal);
    }

    public int getFirstEdgeLocal(int s, int t) {
        for (int e = 0; e < this.vertexList[s].size(); ++e) {
            if (this.vertexList[s].getQuick(e) != t) continue;
            return e;
        }
        return -1;
    }

    public int getNextEdgeLocal(int einitial, int s, int t) {
        if (einitial < 0 || einitial >= this.vertexList[s].size()) {
            return -2;
        }
        for (int e = einitial; e < this.vertexList[s].size(); ++e) {
            if (this.vertexList[s].getQuick(e) != t) continue;
            return e;
        }
        return -1;
    }

    public int getEdge(int v, int localEdgeIndex) {
        return this.vertexEdgeList[v].getQuick(localEdgeIndex);
    }

    public int getInEdge(int v, int localEdgeIndex) {
        return this.vertexInEdgeList[v].getQuick(localEdgeIndex);
    }

    public String getEdgeLabelString(int e) {
        return Integer.toString(this.getEdgeLabel(e));
    }

    public int getEdgeLabel(int e) {
        if (!this.weightedEdges) {
            return e / 2;
        }
        int i = this.edgeValuetList[e].label;
        if (i == -98542182) {
            return e / 2;
        }
        return i;
    }

    public int getEdgeLabelSimple(int e) {
        if (!this.weightedEdges) {
            return -98542182;
        }
        return this.edgeValuetList[e].label;
    }

    public int getEdgeLabelOrZero(int e, int noLabelValue) {
        if (!this.weightedEdges) {
            return noLabelValue;
        }
        int i = this.edgeValuetList[e].label;
        if (i == -98542182) {
            return noLabelValue;
        }
        return i;
    }

    public int getRandomVertex() {
        return this.Rnd.nextInt(this.TotalNumberVertices);
    }

    public int getRandomNeighbour(int v) {
        int totalnn = this.vertexList[v].size();
        if (totalnn > 0) {
            return this.vertexList[v].get(this.Rnd.nextInt(this.vertexList[v].size()));
        }
        return -1;
    }

    public int getRandomVertexFromEdge() {
        return this.stubSourceList[this.Rnd.nextInt(this.TotalNumberStubs)];
    }

    public int getSourceRandomEdge() {
        int e = this.Rnd.nextInt(this.TotalNumberStubs);
        int s = e - e % 2;
        return this.stubSourceList[s];
    }

    public int getTargetRandomEdge() {
        int e = this.Rnd.nextInt(this.TotalNumberStubs);
        int t = e - e % 2 + 1;
        return this.stubSourceList[t];
    }

    public int getOtherStubFromEdge(int e) {
        return e ^ 1;
    }

    public int getStubType1(int s) {
        if (this.stubSourceList[s] < this.numberVertexType1) {
            return s;
        }
        int s1 = this.getOtherStubFromEdge(s);
        if (this.stubSourceList[s1] < this.numberVertexType1) {
            return s1;
        }
        System.err.println("Stub " + s + " has no type one vertices");
        return -135798642;
    }

    public int getStubType2(int s) {
        if (this.stubSourceList[s] >= this.numberVertexType1) {
            return s;
        }
        int s1 = this.getOtherStubFromEdge(s);
        if (this.stubSourceList[s1] >= this.numberVertexType1) {
            return s1;
        }
        System.err.println("Stub " + s + " has no type two vertices");
        return -135798642;
    }

    public int getVertexFromEdge(int s) {
        return this.stubSourceList[s];
    }

    public int getOtherVertexFromEdge(int e) {
        return this.stubSourceList[e ^ 1];
    }

    public int getSourceVertexFromEdge(int e) {
        int s = e >> 1 << 1;
        return this.stubSourceList[s];
    }

    public int getTargetVertexFromEdge(int e) {
        int t = e | 1;
        return this.stubSourceList[t];
    }

    public int getVertexFromName(String vertexName) {
        int vertex;
        if (!this.vertexlabels) {
            throw new IllegalArgumentException("graph with labelled vertices needed to find named vertex.");
        }
        for (vertex = 0; vertex < this.getNumberVertices() && !this.getVertexName(vertex).equalsIgnoreCase(vertexName); ++vertex) {
        }
        if (vertex == this.getNumberVertices()) {
            System.err.println("*** NOT FOUND VERTEX " + vertexName);
        }
        return vertex;
    }

    public TreeMap<String, Integer> getVertexNameIndexMap() {
        if (!this.vertexlabels) {
            throw new IllegalArgumentException("graph with labelled vertices needed to find named vertex.");
        }
        TreeMap<String, Integer> nameToIndex = new TreeMap<String, Integer>();
        for (int vertex = 0; vertex < this.getNumberVertices(); ++vertex) {
            nameToIndex.put(this.getVertexName(vertex), vertex);
        }
        return nameToIndex;
    }

    public int getVertexDegree(int v) {
        if (this.vertexList[v] == null) {
            return 0;
        }
        return this.vertexList[v].size();
    }

    public String getVertexName(int v) {
        if (!this.vertexlabels) {
            return Integer.toString(v);
        }
        String s = this.vertexLabelList[v].getName();
        if (s.equals("")) {
            return Integer.toString(v);
        }
        return s;
    }

    public String[] getVertexNameArray() {
        String[] nameArray = new String[this.TotalNumberVertices];
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            nameArray[v] = this.getVertexName(v);
        }
        return nameArray;
    }

    public int getVertexNumber(int v, int noNumber) {
        if (!this.vertexlabels) {
            return noNumber;
        }
        VertexLabel vl = this.vertexLabelList[v];
        if (vl.hasNumber()) {
            return vl.getNumber();
        }
        return noNumber;
    }

    public Coordinate getVertexPosition(int v) {
        if (!this.vertexlabels) {
            return null;
        }
        VertexLabel vl = this.vertexLabelList[v];
        if (vl.hasPosition()) {
            return vl.getPosition();
        }
        return null;
    }

    public VertexLabel getVertexLabel(int v) {
        if (this.vertexlabels) {
            return this.vertexLabelList[v];
        }
        return null;
    }

    public int getVertexOutDegree(int v) {
        if (this.vertexList[v] == null) {
            return 0;
        }
        return this.vertexList[v].size();
    }

    public int getVertexInDegree(int v) {
        if (this.vertexSourceList[v] == null) {
            return 0;
        }
        return this.vertexSourceList[v].size();
    }

    public double getVertexOutStrength(int v) {
        if (!this.weightedEdges) {
            return this.getVertexOutDegree(v);
        }
        int edge = -1;
        double s = 0.0;
        for (int e = 0; e < this.vertexEdgeList[v].size(); ++e) {
            edge = this.vertexEdgeList[v].get(e);
            s += this.edgeValuetList[edge].weight;
        }
        return s;
    }

    public double getVertexSelfLoopStrength(int v) {
        if (!this.weightedEdges) {
            return this.getVertexOutDegree(v);
        }
        int edge = -1;
        double str = 0.0;
        for (int e = 0; e < this.vertexEdgeList[v].size(); ++e) {
            edge = this.vertexEdgeList[v].get(e);
            if (!this.isStubSelfLoop(edge)) continue;
            str += this.weightedEdges ? this.edgeValuetList[edge].weight : 1.0;
        }
        return str;
    }

    public boolean isStubSelfLoop(int stub) {
        return this.stubSourceList[stub] == this.stubSourceList[stub ^ 1];
    }

    public double getVertexInStrength(int v) {
        if (!this.directedGraph) {
            return this.getVertexOutStrength(v);
        }
        if (!this.weightedEdges) {
            return this.getVertexInDegree(v);
        }
        int edge = -1;
        double s = 0.0;
        for (int e = 0; e < this.vertexInEdgeList[v].size(); ++e) {
            edge = this.vertexInEdgeList[v].get(e);
        }
        return s += this.edgeValuetList[edge].weight;
    }

    public int[] getStubSourceList() {
        return this.stubSourceList;
    }

    public double getEdgeWeightQuick(int e) {
        return this.edgeValuetList[e].weight;
    }

    public double getEdgeWeight(int e) {
        return this.weightedEdges ? this.edgeValuetList[e].weight : 1.0;
    }

    public double getEdgeWeightSlow(int e) {
        if (e < 0 || e >= this.TotalNumberStubs) {
            return -3.57986421E8;
        }
        return this.weightedEdges ? this.edgeValuetList[e].weight : 1.0;
    }

    public EdgeValue getEdgeWeightAll(int e) {
        return this.edgeValuetList[e];
    }

    public int getNeighbour(int v, int e) {
        if (e < this.vertexList[v].size() && e >= 0) {
            return this.vertexList[v].get(e);
        }
        return -1;
    }

    public int getNeighbourQuick(int v, int e) {
        return this.vertexList[v].get(e);
    }

    public int getInitialVertices() {
        return this.initialVertices;
    }

    public void setInitialVertices(int iv) {
        this.initialVertices = iv;
    }

    public int getMaximumStubs() {
        return this.maximumStubs;
    }

    public void setMaximumStubs(int n) {
        this.maximumStubs = n;
    }

    public int getMaximumVertices() {
        return this.maximumVertices;
    }

    public void setMaximumVertices(int n) {
        this.maximumVertices = n;
    }

    public void setNumberEvents(int ne) {
        this.numevents = ne;
    }

    public void setVertexNumber(int v, int n) {
        if (this.vertexLabelList[v] == null) {
            this.vertexLabelList[v] = new VertexLabel(n);
        } else {
            this.vertexLabelList[v].setNumber(n);
        }
    }

    public void setVertexNumbers(int n) {
        if (!this.vertexlabels) {
            this.vertexlabels = true;
            this.vertexLabelList = new VertexLabel[this.TotalNumberVertices];
        }
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            this.setVertexNumber(v, n);
        }
    }

    public void setVertexNumberQuick(int v, int n) {
        this.vertexLabelList[v].setNumber(n);
    }

    public void setVertexPositionQuick(int v, Coordinate c) {
        this.vertexLabelList[v].setPosition(c);
    }

    public void setVertexLabelQuick(int v, VertexLabel label) {
        this.vertexLabelList[v] = label;
    }

    public void setEdgeLabelQuick(int e, int l) {
        this.edgeValuetList[e].label = l;
    }

    public void setEdgeLabels(Partition c) {
        if (c.getNumberElements() != this.getNumberEdges()) {
            throw new RuntimeException("partition has " + c.getNumberElements() + " elements which is not equal to number of edges " + this.getNumberEdges());
        }
        if (!this.weightedEdges) {
            this.weightedEdges = true;
            this.edgeValuetList = new EdgeValue[this.maximumStubs];
            for (int e = 0; e < this.TotalNumberStubs; ++e) {
                EdgeValue ew = new EdgeValue();
                this.edgeValuetList[e++] = ew;
                this.edgeValuetList[e] = ew;
            }
        }
        int[] cov = c.getCommunity();
        int e = 0;
        for (int v = 0; v < cov.length; ++v) {
            this.edgeValuetList[e++].setLabel(cov[v]);
            this.edgeValuetList[e++].setLabel(cov[v]);
        }
    }

    public void setEdgeLabels(int value) {
        if (!this.weightedEdges) {
            this.weightedEdges = true;
            this.labelledEdges = true;
            this.edgeValuetList = new EdgeValue[this.maximumStubs];
            for (int e = 0; e < this.TotalNumberStubs; ++e) {
                EdgeValue ew = new EdgeValue(value);
                this.edgeValuetList[e++] = ew;
                this.edgeValuetList[e] = ew;
            }
            return;
        }
        this.labelledEdges = true;
        for (int e = 0; e < this.TotalNumberStubs; ++e) {
            EdgeValue ew = this.edgeValuetList[e++];
            ew.setLabel(value);
        }
    }

    public void setEdgeWeights(int value) {
        if (!this.weightedEdges) {
            this.weightedEdges = true;
            this.labelledEdges = false;
            this.edgeValuetList = new EdgeValue[this.maximumStubs];
        }
        for (int e = 0; e < this.TotalNumberStubs; ++e) {
            EdgeValue ew = this.edgeValuetList[e];
            if (ew == null) {
                ew = new EdgeValue(value);
            } else {
                ew.weight = value;
            }
            this.edgeValuetList[e++] = ew;
            this.edgeValuetList[e] = ew;
        }
    }

    public void setVertexNumbers(VertexPartition vp) {
        if (vp.getNumberElements() != this.TotalNumberVertices) {
            throw new RuntimeException("Wrong number of elements in vertex partition " + vp.getName() + ", " + vp.getNumberElements());
        }
        if (!this.vertexlabels) {
            this.initialiseVertexLabels();
        }
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            this.vertexLabelList[v].setNumber(vp.getCommunity(v));
        }
    }

    public void initialiseVertexLabels() {
        this.vertexlabels = true;
        this.vertexLabelList = new VertexLabel[this.maximumVertices];
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            this.vertexLabelList[v] = new VertexLabel();
        }
    }

    public void setVertexPositionsFromPartition(VertexPartition vp, double smallScale, double bigScale) {
        if (vp.getNumberElements() != this.TotalNumberVertices) {
            throw new RuntimeException("Wrong number of elements in vertex partition " + vp.getName() + ", " + vp.getNumberElements());
        }
        if (!this.vertexlabels) {
            this.initialiseVertexLabels();
        }
        vp.setCommunityLocalLabel();
        vp.analyse();
        double nc = vp.getNumberCommunities();
        double ncc = -3.57986421E8;
        int c = -135798642;
        double smallf = -3.57986421E8;
        double bigf = -3.57986421E8;
        double x = -3.57986421E8;
        double y = -3.57986421E8;
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            c = vp.getCommunity(v);
            ncc = vp.getNumberElementsInCommunity(c);
            smallf = (double)vp.getCommunityLocalLabel(v) / ncc;
            bigf = (double)c / nc;
            x = Math.cos(smallf * 2.0 * Math.PI) * smallScale + Math.cos(bigf * 2.0 * Math.PI) * bigScale;
            y = Math.sin(smallf * 2.0 * Math.PI) * smallScale + Math.sin(bigf * 2.0 * Math.PI) * bigScale;
            this.setVertexPositionQuick(v, new Coordinate(x, y));
        }
    }

    public void setVertexPositions(ArrayList<Double> x, ArrayList<Double> y) {
        if (x.size() != this.TotalNumberVertices || y.size() != this.TotalNumberVertices) {
            throw new RuntimeException("Wrong number of x or y coordinates, found " + x.size() + ", " + y.size());
        }
        if (!this.vertexlabels) {
            this.initialiseVertexLabels();
        }
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            this.vertexLabelList[v].setPosition(x.get(v), y.get(v));
        }
    }

    public void setVertexPositions(ArrayList<String> coord) {
        if (coord.size() != 2 * this.TotalNumberVertices) {
            throw new RuntimeException("Wrong number of x and  y coordinates, found " + coord.size());
        }
        if (!this.vertexlabels) {
            this.initialiseVertexLabels();
        }
        int c = 0;
        double x = -3.57986421E8;
        double y = -3.57986421E8;
        String xstring = SUNSET;
        String ystring = SUNSET;
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            xstring = coord.get(c++);
            ystring = coord.get(c++);
            try {
                x = Double.parseDouble(xstring);
                y = Double.parseDouble(ystring);
            }
            catch (Exception e) {
                System.err.println("!!! WARNING setVertexPositions found vertex " + v + " coordinates " + xstring + ", " + ystring);
                x = -3.57986421E8;
                y = -3.57986421E8;
            }
            this.vertexLabelList[v].setPosition(x, y);
        }
    }

    public void setVertexPositionsFromFile(String fullFileName, String cc, int xColumn, int yColumn, boolean headerOn, boolean infoOn) {
        int[] columnReadList = new int[]{xColumn, yColumn};
        boolean forceLowerCase = false;
        ArrayList<String> coord = FileInput.readStringColumnsFromFile(fullFileName, cc, columnReadList, forceLowerCase, headerOn, infoOn);
        this.setVertexPositions(coord);
    }

    public void setVertexNames(ArrayList<String> nameList) {
        if (nameList.size() != this.TotalNumberVertices) {
            throw new RuntimeException("Wrong number of names, found " + nameList.size());
        }
        if (!this.vertexlabels) {
            this.initialiseVertexLabels();
        }
        int c = 0;
        String name = SUNSET;
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            try {
                name = nameList.get(c++);
            }
            catch (Exception e) {
                System.err.println("!!! WARNING setVertexNamess found vertex " + v + " name " + name);
                name = SUNSET;
            }
            this.vertexLabelList[v].setName(name);
        }
    }

    public void setVertexNamesFromFile(String ext, String cc, int nameColumn, boolean headerOn, boolean infoOn) {
        String fullFileName = this.inputName.getNameRootFullPath() + ext;
        int[] columnReadList = new int[]{nameColumn};
        boolean forceLowerCase = false;
        ArrayList<String> nameList = FileInput.readStringColumnsFromFile(fullFileName, cc, columnReadList, forceLowerCase, headerOn, infoOn);
        this.setVertexNames(nameList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inputSimpleNetwork(String fileName, Character CC, int sourceColumn, int targetColumn, int weightColumn) {
        TextReader data;
        this.message.println(0, "Starting to search for range of vertex numbers in " + fileName);
        String tempstring = "";
        int column = -1;
        int numberEdges = 0;
        int linenumber = 0;
        boolean result = false;
        String param = "";
        int source = -2;
        int target = -2;
        double weight = -2.0;
        int minSource = Integer.MIN_VALUE;
        int maxSource = -2147483647;
        int minTarget = Integer.MIN_VALUE;
        int maxTarget = Integer.MAX_VALUE;
        try {
            data = new TextReader((Reader)new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            this.message.printWarning(-1, "Can't find file " + fileName);
            return 1;
        }
        try {
            while (!data.eof()) {
                ++linenumber;
                column = 0;
                Character datatype = Character.valueOf(data.peek());
                if (datatype == CC) {
                    tempstring = data.getln();
                    this.message.println(2, linenumber + ": Comment: " + tempstring);
                    continue;
                }
                source = -1;
                target = -1;
                while (!data.eoln()) {
                    if (column == sourceColumn) {
                        source = data.getInt();
                        continue;
                    }
                    if (column == targetColumn) {
                        target = data.getInt();
                        continue;
                    }
                    if (column == weightColumn) {
                        weight = data.getDouble();
                        continue;
                    }
                    param = data.getWord();
                }
                ++numberEdges;
                minSource = Math.min(minSource, source);
                maxSource = Math.max(maxSource, source);
                minTarget = Math.min(minTarget, source);
                maxTarget = Math.max(maxTarget, source);
            }
            this.message.println(0, "Finished reading from " + fileName);
        }
        catch (TextReader.Error e) {
            this.message.printERROR("Input Error: line " + linenumber + ", " + e.getMessage());
            result = true;
        }
        finally {
            data.close();
        }
        int minVertex = Math.min(minSource, minTarget);
        int maxVertex = Math.max(maxSource, maxTarget);
        int numberVertices = maxVertex - minVertex + 1;
        this.message.println(0, "Finished reading from " + fileName);
        this.message.println(0, "Found " + numberVertices + " vertices and " + numberEdges + " edges");
        this.inputSimpleNetwork(fileName, CC, sourceColumn, targetColumn, weightColumn, minVertex, numberVertices);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inputSimpleNetwork(String fileName, Character CC, int sourceColumn, int targetColumn, int weightColumn, int minVertex, int numberVertices) {
        TextReader data;
        this.message.println(0, "Starting to read edges and weights from " + fileName);
        String tempstring = "";
        int column = -1;
        int linenumber = 0;
        int result = 0;
        String param = "";
        int source = -2;
        int target = -2;
        double weight = -2.0;
        int minSource = Integer.MIN_VALUE;
        int maxSource = -2147483647;
        int minTarget = Integer.MIN_VALUE;
        int maxTarget = Integer.MAX_VALUE;
        try {
            data = new TextReader((Reader)new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            this.message.printWarning(-1, "Can't find file " + fileName);
            return 1;
        }
        try {
            while (!data.eof()) {
                ++linenumber;
                Character datatype = Character.valueOf(data.peek());
                if (datatype == CC) {
                    tempstring = data.getln();
                    this.message.println(2, linenumber + ": Comment: " + tempstring);
                    continue;
                }
                column = 0;
                source = -1;
                target = -1;
                while (!data.eoln()) {
                    if (column == sourceColumn) {
                        source = data.getInt();
                        continue;
                    }
                    if (column == targetColumn) {
                        target = data.getInt();
                        continue;
                    }
                    if (column == weightColumn) {
                        weight = data.getDouble();
                        continue;
                    }
                    param = data.getWord();
                }
                minSource = Math.min(minSource, source);
                maxSource = Math.max(maxSource, source);
                minTarget = Math.min(minTarget, source);
                maxTarget = Math.max(maxTarget, source);
                this.message.printERROR("Line " + linenumber + " of unknowntype");
                result = -1;
            }
            this.message.println(0, "Finished reading from " + fileName);
        }
        catch (TextReader.Error e) {
            this.message.printERROR("Input Error: " + e.getMessage());
            result = 1;
        }
        finally {
            data.close();
        }
        return 0;
    }

    public void FileOutputDegreeDistribution(String cc, boolean normalise, boolean headersOn) {
        String extension = normalise ? ".Jndd.dat" : ".Jdd.dat";
        this.outputName.setNameEnd(extension);
        this.DDtotal.FileOutputDegreeDistribution(this.outputName.getFullFileName(), cc, SEP, normalise, headersOn);
        if (this.directedGraph) {
            this.outputName.setNameEnd("IN" + extension);
            this.DDin.FileOutputDegreeDistribution(this.outputName.getFullFileName(), cc, SEP, normalise, headersOn);
            this.outputName.setNameEnd("OUT" + extension);
            this.DDout.FileOutputDegreeDistribution(this.outputName.getFullFileName(), cc, SEP, normalise, headersOn);
        }
        if (this.bipartiteGraph) {
            this.outputName.setNameEnd(this.nameVertexType1 + extension);
            this.DD1total.FileOutputDegreeDistribution(this.outputName.getFullFileName(), cc, SEP, normalise, headersOn);
            this.outputName.setNameEnd(this.nameVertexType2 + extension);
            this.DD2total.FileOutputDegreeDistribution(this.outputName.getFullFileName(), cc, SEP, normalise, headersOn);
        }
    }

    public void FileOutputLogBinnedDegreeDistribution(String cc, double lbratio, boolean infoOn, boolean headersOn) {
        String extension = "lbdd.dat";
        this.outputName.setNameEnd(extension);
        this.DDtotal.FileOutputLogBinnedDegreeDistribution(this.outputName.getFullFileName(), cc, SEP, lbratio, infoOn, headersOn);
        if (this.directedGraph) {
            this.outputName.setNameEnd("IN" + extension);
            this.DDin.FileOutputLogBinnedDegreeDistribution(this.outputName.getFullFileName(), cc, SEP, lbratio, infoOn, headersOn);
            this.outputName.setNameEnd("OUT" + extension);
            this.DDout.FileOutputLogBinnedDegreeDistribution(this.outputName.getFullFileName(), cc, SEP, lbratio, infoOn, headersOn);
        }
        if (this.bipartiteGraph) {
            this.outputName.setNameEnd(this.nameVertexType1 + extension);
            this.DD1total.FileOutputLogBinnedDegreeDistribution(this.outputName.getFullFileName(), cc, SEP, lbratio, infoOn, headersOn);
            this.outputName.setNameEnd(this.nameVertexType2 + extension);
            this.DD2total.FileOutputLogBinnedDegreeDistribution(this.outputName.getFullFileName(), cc, SEP, lbratio, infoOn, headersOn);
        }
    }

    void printDegreeDistribution(String cc, boolean normalise) {
        this.DDtotal.print(cc, SEP, normalise);
        if (this.directedGraph) {
            this.DDin.print(cc, SEP, normalise);
            this.DDout.print(cc, SEP, normalise);
        }
        if (this.bipartiteGraph) {
            this.DD1total.print(cc, SEP, normalise);
            this.DD2total.print(cc, SEP, normalise);
        }
    }

    void FileOutputReducedDegreeDistribution(String cc, boolean normalise) {
        String extension = normalise ? ".Jnrdd.dat" : ".Jrdd.dat";
        this.outputName.setNameEnd(extension);
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(this.outputName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            int n = 0;
            double p = 0.0;
            PS.println(cc + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            PS.println(cc + " No. vertices: " + SEP + this.TotalNumberVertices + " No. edges: " + SEP + this.TotalNumberStubs);
            if (this.TotalNumberVertices < 1) {
                return;
            }
            if (normalise) {
                PS.println(cc + " k " + SEP + "rp(k)    Reduced Normalised Degree Distribution ");
            } else {
                PS.println(cc + " k " + SEP + "rn(k)     Reduced Unnormalised Degree Distribution ");
            }
            for (int k = 0; k < this.rddarr.size(); ++k) {
                if (normalise) {
                    p = (double)this.rddarr.get(k) / (double)this.TotalNumberVertices;
                    if (!(p > 0.0)) continue;
                    PS.println(k + SEP + p);
                    continue;
                }
                n = (int)((double)this.rddarr.get(k) + 0.5);
                if (n <= 0) continue;
                PS.println(k + SEP + n);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing reduced degree distribution to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error with " + filenamecomplete);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    void FileOutputWeightDistribution(String cc, boolean normalise) {
        String extension = normalise ? ".Jnwd.dat" : ".Jwd.dat";
        this.outputName.setNameEnd(extension);
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            int n = 0;
            PS.println(cc + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            PS.println(cc + " No. vertices: " + SEP + this.TotalNumberVertices + " No. edges: " + SEP + this.TotalNumberStubs);
            PS.println(cc + SEP + this.weightmaximum + SEP + " = weightmaximum");
            if (normalise) {
                PS.println(cc + " w " + SEP + "p(w)    Normalised Weight Distribution ");
            } else {
                PS.println(cc + " w " + SEP + "w(w)     Unnormalised Weight Distribution ");
            }
            for (int w = 0; w < this.weightdarr.size(); ++w) {
                if (normalise) {
                    double p = (double)this.weightdarr.get(w) / (double)this.TotalNumberVertices;
                    if (!(p > 0.0)) continue;
                    PS.println(w + SEP + p);
                    continue;
                }
                n = (int)((double)this.weightdarr.get(w) + 0.5);
                if (n <= 0) continue;
                PS.println(w + SEP + n);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing weight distribution to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error with " + filenamecomplete);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    void FileOutputComponentDistributionOLD(String cc) {
        this.outputName.setNameEnd(".Jcompdist.dat");
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            boolean n = false;
            PS.println(cc + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            PS.println(cc + " No. vertices: " + SEP + this.TotalNumberVertices + " No. edges: " + SEP + this.TotalNumberStubs);
            PS.println(cc + " walk mode: " + SEP + this.randomWalk.randomWalkMode);
            PS.println(cc + "Number of Components " + SEP + this.componentSize.size());
            PS.println(cc + " c" + SEP + "n(c)" + SEP + "v in c" + SEP + "diam_min");
            for (int c = 0; c < this.componentSize.size(); ++c) {
                PS.println(c + SEP + this.componentSize.get(c) + SEP + this.componentSource.get(c) + SEP + this.componentDist.get(c));
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing component distribution data to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void FileOutputComponentDistribution(String cc) {
        this.outputName.setNameEnd(".Jcompdist.dat");
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            this.printComponentDistribution(PS);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing component information to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void FileOutputVertexToComponentList(String cc) {
        this.outputName.setNameEnd(".Jv2comp.dat");
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            this.printVertexToComponentList(PS);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing component information to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void FileOutputComponentInfo(String cc) {
        this.FileOutputComponentInfo(cc, false, false);
    }

    public void FileOutputComponentInfo(String cc, boolean componentDistribution, boolean vertexToComponent) {
        this.outputName.setNameEnd(".Jcompinfo.dat");
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            this.printComponentInfo(PS, componentDistribution, vertexToComponent);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing component information to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    void FileOutputRingInfo(String cc, int source) {
        this.outputName.setNameEnd(".Jrinfo.dat");
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            this.printRingInfo(PS, source);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing ring information to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void FileOutputDistanceTotalDistribution(String cc) {
        this.outputName.setNameEnd(".Jtotdistd.dat");
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printDistanceTotalDistribution(PS, cc);
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
        if (this.infoLevel > -2) {
            System.out.println("Finished writing total distance data to " + filenamecomplete);
        }
    }

    public void printDistanceTotalDistribution(PrintStream PS, String cc) {
        PS.println(cc + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
        PS.println(cc + " No. vertices: " + SEP + this.TotalNumberVertices + " No. edges: " + SEP + this.TotalNumberStubs);
        PS.println(cc + " walk mode: " + SEP + (this.randomWalk == null ? " NOT DEFINED" : Integer.valueOf(this.randomWalk.randomWalkMode)));
        PS.println(cc + "diameter maximum, minimum, average " + SEP + this.diametermax + SEP + this.diametermin + SEP + this.diameteraverage + SEP + " +/- " + this.diametererror + SEP + ", sigma " + this.diametersigma);
        PS.println(cc + "average distance " + SEP + this.totdistanceaverage + SEP + " +/- " + SEP + this.totdistanceerror + ", sigma " + SEP + this.totdistancesigma);
        PS.println(cc + "Average distance from one vertex " + SEP + this.onesdistanceav + SEP + " +/- " + SEP + this.onesdistanceerror + SEP + ", sigma=" + SEP + this.onesdistancesigma);
        PS.println(cc + " d" + SEP + " n(d) " + SEP + " n2(d) " + SEP + "<n(d)>" + SEP + " +/- " + SEP + "[" + this.nsamples + " samples]");
        for (int d = 0; d < this.totdistancedist.size(); ++d) {
            double n = this.totdistancedist.get(d);
            double n2 = this.totdistance2dist.get(d);
            double nav = n / (double)this.nsamples;
            double naverr = this.calcError(n, n2, (double)this.nsamples);
            PS.println(d + SEP + n + SEP + n2 + SEP + nav + SEP + naverr);
        }
    }

    public void FileOutputCC(String cc) {
        this.outputName.setNameEnd(".JCCd.dat");
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            boolean n = false;
            PS.println(cc + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            PS.println(cc + " No. vertices: " + SEP + this.TotalNumberVertices + " No. edges: " + SEP + this.TotalNumberStubs);
            PS.println(cc + " walk mode: " + SEP + this.randomWalkMode);
            PS.println(cc + "Average CC " + SEP + this.CCaverage + SEP + " +/- " + SEP + this.CCerror + ", sigma " + SEP + this.CCsigma);
            PS.println(cc + "Average Edge CC " + SEP + this.CCEdgeaverage + SEP + " +/- " + SEP + this.CCEdgeerror + ", sigma " + SEP + this.CCEdgesigma);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing average CC info to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void FileOutputDistanceStatistics(String cc) {
        this.outputName.setNameEnd(".Jdiststat.dat");
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            PS.println(cc + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            PS.println(this.diametermax + SEP + this.diametermin + SEP + this.diameteraverage + SEP + this.diametererror + SEP + this.diametersigma + SEP + cc + "diameter maximum, minimum, average , error in av, sigma for average");
            PS.println(this.totdistanceaverage + SEP + this.totdistanceerror + SEP + this.totdistancesigma + SEP + cc + " average distance over all paths:  average, error, sigma");
            PS.println(this.onesdistanceav + SEP + this.onesdistanceerror + SEP + this.onesdistancesigma + SEP + cc + " average distance from one vertex: average, error, sigma");
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing distance statistics to " + filenamecomplete);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    void FileOutputGraphInfo(String cc, double timetaken) {
        if (this.outputControl.getNumber() == 0) {
            return;
        }
        this.outputName.setNameEnd(".Jinfo.dat");
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.OutputGraphInfo(PS, cc, timetaken);
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing general graph info to " + filenamecomplete);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void outputGraph(String CC) {
        this.calcDegreeDistribution();
        this.printDegreeDistribution(CC, false);
        this.FileOutputDegreeDistribution(CC, false, true);
        if (this.TotalNumberVertices >= this.LogBinVerticesMinimum) {
            this.FileOutputLogBinnedDegreeDistribution(CC, 1.1, true, true);
        }
        FileOutput fo = new FileOutput(this);
        fo.pajek();
        this.calcDistanceSample(0.01, 10, 100);
        this.FileOutputDistanceStatistics(CC);
        this.FileOutputDistanceTotalDistribution(CC);
        this.calcComponents();
        this.FileOutputComponentDistribution(CC);
        this.calcRanking();
        boolean printTriangles = true;
        if (this.TotalNumberStubs < 40) {
            this.FileOutputNetwork(true, true, true);
        } else {
            this.FileOutputVertices(false, false, false);
        }
        this.FileOutputPajekVertexData();
        this.calcCCEdgeSample(0.01, 100, 10000);
        this.FileOutputCC(CC);
        this.FileOutputGraphInfo(CC, 0.0);
    }

    public void OutputGraphInfo(PrintStream PS, String cc, double timetaken) {
        this.printWalkGraphInfo(PS, cc, timetaken);
    }

    public void printWalkGraphInfo(PrintStream PS, String cc, double timetaken) {
        if (this.infoLevel < 0) {
            return;
        }
        PS.println(cc + " timgraph.java" + SEP + "version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
        PS.println(cc + "Graph type:" + SEP + this.graphType(SEP));
        this.printRandomWalkMode(PS, cc);
        if (timetaken >= 0.0) {
            PS.println(timetaken + SEP + cc + " Time taken sec. ");
        }
        PS.println(this.numevents + SEP + cc + " Number of events");
        PS.println(this.probnewvertex + SEP + cc + " input probability of new vertex ");
        PS.println(this.TotalNumberVertices + SEP + cc + " actual No. vertices");
        PS.println(this.TotalNumberStubs + SEP + cc + " actual No. edges");
        PS.println(this.connectivity + SEP + cc + " k: input average degree requested");
        PS.println(this.averageWalkLength + SEP + cc + " averageWalkLength: number of random walk averageWalkLength on average");
        PS.println(this.binomialNumber + SEP + cc + " no. of dice used in binomial random numbers generator");
        PS.println(this.averagesteplength + SEP + cc + " average no. averageWalkLength per walk");
        PS.println(this.edgegenerator + SEP + cc + "edge generator");
        PS.println(this.randomWalkMode + SEP + cc + "walk mode");
        if (this.vertexlabels && this.minimumVertexLabel.hasPosition()) {
            PS.println(this.minimumVertexLabel.position.printString(SEP) + SEP + cc + "minimum vertex coordinate");
        }
        if (this.vertexlabels && this.maximumVertexLabel.hasPosition()) {
            PS.println(this.maximumVertexLabel.position.printString(SEP) + SEP + cc + "maximum vertex coordinate");
        }
        PS.println(this.initialgraph + SEP + cc + " initial graph type " + this.initialGraphString(this.initialgraph));
        PS.println(this.initialConnectivity + SEP + cc + " initial graph Connectivity");
        PS.println(this.initialVertices + SEP + cc + " initial graph Vertices");
        PS.println(this.initialXsize + SEP + cc + " initial graph X size");
        PS.println(this.initialYsize + SEP + cc + " initial graph Y size");
        PS.println(this.initialEdges + SEP + cc + " initial graph Edges ");
    }

    public void printGeneralGraphInfo(PrintStream PS, String cc) {
        PS.println(cc + " timgraph.java" + SEP + "version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
        PS.println(cc + "Graph type:" + SEP + this.graphType(SEP));
        PS.println(this.numevents + SEP + cc + " Number of events");
        PS.println(this.probnewvertex + SEP + cc + " input probability of new vertex ");
        PS.println(this.TotalNumberVertices + SEP + cc + " actual No. vertices");
        if (this.bipartiteGraph) {
            PS.println(this.numberVertexType1 + cc + " No. " + this.nameVertexType1 + " (type 1) vertices");
        }
        if (this.bipartiteGraph) {
            PS.println(this.numberVertexType2 + cc + " No. " + this.nameVertexType2 + " (type 2) vertices");
        }
        PS.println(this.TotalNumberStubs + SEP + cc + " actual No. edges");
        PS.println(this.connectivity + SEP + cc + " k: input average degree requested");
        PS.println(this.averageWalkLength + SEP + cc + " averageWalkLength: number of random walk averageWalkLength on average");
        PS.println(this.averagesteplength + SEP + cc + " average no. averageWalkLength per walk");
        PS.println(this.edgegenerator + SEP + cc + "edge generator");
        if (this.vertexlabels) {
            PS.println(this.minimumVertexLabel.position.printString(SEP) + SEP + cc + "minimum vertex coordinate");
        }
        if (this.vertexlabels) {
            PS.println(this.maximumVertexLabel.position.printString(SEP) + SEP + cc + "maximum vertex coordinate");
        }
    }

    public String graphType(String separator) {
        String s = "";
        s = this.directedGraph ? "directed" : "undirected";
        s = this.vertexlabels ? s + separator + "vertex labels" : s + separator + "no vertex labels";
        s = this.weightedEdges ? s + separator + "edge weights" : s + separator + "no edge weights";
        s = this.bipartiteGraph ? s + separator + "bipartite" : s + separator + "unipartite";
        return s;
    }

    public void FileOutputGraphVizOld() {
        GraphViz gv = new GraphViz();
        this.outputName.setNameEnd(".gv");
        String filenamecomplete = this.outputName.getFullFileName();
        if (this.infoLevel > -2) {
            System.out.println("Writing GraphViz file to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            gv.output(PS, this, true);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing GraphViz file to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + filenamecomplete);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    void FileOutputPajekOLD() {
        this.outputName.setNameEnd(".net");
        String filenamecomplete = this.outputName.getFullFileName();
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            PS.println("*Vertices " + this.TotalNumberVertices);
            for (int v = 1; v <= this.TotalNumberVertices; ++v) {
                PS.print(v);
                if (this.vertexlabels) {
                    PS.print(" " + this.vertexLabelList[v - 1].pajekString(this.minimumVertexLabel.position, this.maximumVertexLabel.position));
                }
                PS.println();
            }
            if (this.directedGraph) {
                PS.println("*Arcs");
            } else {
                PS.println("*Edges");
            }
            for (int e = 0; e < this.TotalNumberStubs; e += 2) {
                PS.print(this.stubSourceList[e] + 1 + "   " + (this.stubSourceList[e + 1] + 1));
                if (this.weightedEdges) {
                    PS.println("  " + this.edgeValuetList[e].weight + "  c " + this.getPajekColour(this.edgeValuetList[e].label));
                    continue;
                }
                PS.println();
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing Pajek file to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void FileOutputPajekVertexData() {
        for (int param = 0; param < 3; ++param) {
            this.FileOutputPajekVertexVector(param);
            this.FileOutputPajekVertexPartition(param, 10);
        }
    }

    void FileOutputPajekVertexVector(int param) {
        this.outputName.setNameEnd("ERROR");
        switch (param) {
            case 2: {
                this.outputName.setNameEnd("value2.vec");
                break;
            }
            case 1: {
                this.outputName.setNameEnd("value.vec");
                break;
            }
            case 0: {
                this.outputName.setNameEnd("visits.vec");
            }
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.outputName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println("*Vertices " + this.TotalNumberVertices);
            double maxRankVisits = this.maximumVertexLabel.getRank().visits;
            double maxRankValue = this.maximumVertexLabel.getRank().value;
            double maxRankValue2 = this.maximumVertexLabel.getRank().value2;
            block14: for (int v = 1; v <= this.TotalNumberVertices; ++v) {
                switch (param) {
                    case 0: {
                        PS.println(" " + (double)this.vertexLabelList[v - 1].rank.visits / maxRankVisits);
                        continue block14;
                    }
                    case 1: {
                        PS.println(" " + this.vertexLabelList[v - 1].rank.value / maxRankValue);
                        continue block14;
                    }
                    case 2: {
                        PS.println(" " + this.vertexLabelList[v - 1].rank.value2 / maxRankValue2);
                    }
                }
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex info to Pajek style file " + this.outputName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + this.outputName.getFullFileName());
            return;
        }
    }

    void FileOutputPajekVertexPartition(int param, int scale) {
        this.outputName.setNameEnd("ERROR");
        switch (param) {
            case 2: {
                this.outputName.setNameEnd("value2.clu");
                break;
            }
            case 1: {
                this.outputName.setNameEnd("value.clu");
                break;
            }
            case 0: {
                this.outputName.setNameEnd("visits.clu");
            }
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.outputName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println("*Vertices " + this.TotalNumberVertices);
            double maxRankVisits = this.maximumVertexLabel.getRank().visits;
            double maxRankValue = this.maximumVertexLabel.getRank().value;
            double maxRankValue2 = this.maximumVertexLabel.getRank().value2;
            block14: for (int v = 1; v <= this.TotalNumberVertices; ++v) {
                switch (param) {
                    case 0: {
                        PS.println(" " + (int)(0.5 + (double)(scale * this.vertexLabelList[v - 1].rank.visits) / maxRankVisits));
                        continue block14;
                    }
                    case 1: {
                        PS.println(" " + (int)(0.5 + (double)scale * this.vertexLabelList[v - 1].rank.value / maxRankValue));
                        continue block14;
                    }
                    case 2: {
                        PS.println(" " + (int)(0.5 + (double)scale * this.vertexLabelList[v - 1].rank.value2 / maxRankValue2));
                    }
                }
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex info to Pajek style file " + this.outputName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + this.outputName.getFullFileName());
            return;
        }
    }

    void FileOutputPajekUnweighted() {
        this.outputName.setNameEnd("w.net");
        String filenamecomplete = this.outputName.getFullFileName();
        int numberColours = pajekColour.length + 1;
        try {
            int v;
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            PS.println("*Vertices " + this.TotalNumberVertices);
            for (v = 1; v <= this.TotalNumberVertices; ++v) {
                PS.println(v);
            }
            PS.println("*Arcs");
            for (v = 0; v < this.TotalNumberVertices; ++v) {
                for (int e = 0; e < this.rvertexList[v].size(); ++e) {
                    int ew = this.strengthlist[v].get(e);
                    int ec = ew % (numberColours + 1);
                    PS.println(v + 1 + "   " + (this.rvertexList[v].get(e) + 1) + "   " + ew + "  c " + this.getPajekColour(ew));
                }
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing weighted Pajek file to " + filenamecomplete);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public String getPajekColour(int c) {
        if (c <= 0) {
            return pajekColour[0];
        }
        return pajekColour[1 + (c - 1) % (pajekColour.length - 1)];
    }

    public static boolean isTIMGRAPH_ARGUMENT(String s) {
        return s.charAt(0) == '-';
    }

    public static boolean isOtherArgument(String s) {
        for (int c = 0; c < NOT_TIMGRAPH_ARGUMENT.length; ++c) {
            if (s.charAt(0) != NOT_TIMGRAPH_ARGUMENT[c]) continue;
            return true;
        }
        return false;
    }

    public static String otherArguments(String sep) {
        String s = "" + NOT_TIMGRAPH_ARGUMENT[0];
        for (int c = 1; c < NOT_TIMGRAPH_ARGUMENT.length; ++c) {
            s = s + sep + NOT_TIMGRAPH_ARGUMENT[c];
        }
        return s;
    }

    public int parseParam(String[] ArgList) {
        if (this.infoLevel > -1) {
            for (int j = 0; j < ArgList.length; ++j) {
                System.out.println("Argument " + j + " = " + ArgList[j]);
            }
        }
        int i = -1;
        try {
            for (i = 0; i < ArgList.length; ++i) {
                this.parseParam(ArgList[i]);
            }
        }
        catch (RuntimeException e) {
            System.err.println(" parseParameter problem at argument " + i + ": " + e.getMessage());
            this.printUsage();
            throw new RuntimeException("parseParameter problem: " + e.getMessage());
        }
        if (!this.inputName.testDirectoryRoot()) {
            throw new IllegalArgumentException("*** Error input directory root " + this.inputName.getDirectoryRoot() + " is not a directory");
        }
        if (!this.inputName.testDirectoryFull()) {
            throw new IllegalArgumentException("*** Error full input directory " + this.inputName.getDirectoryFull() + " is not a directory");
        }
        if (!this.outputName.testDirectoryRoot()) {
            throw new IllegalArgumentException("*** Error output directory root " + this.outputName.getDirectoryRoot() + " is not a directory");
        }
        if (!this.outputName.testDirectoryFull()) {
            throw new IllegalArgumentException("*** Error full output directory " + this.outputName.getDirectoryFull() + " is not a directory");
        }
        this.parseParameterFile();
        return 0;
    }

    public void parseParameterFile() {
        FileNameSequence parameterFileName = new FileNameSequence(this.inputName);
        parameterFileName.setNameEnd("param.dat");
        if (parameterFileName.testFullFileName()) {
            ArrayList<String> words = FileInput.readStringList(parameterFileName.getFullFileName());
            if (this.infoLevel > -1) {
                for (int count = 0; count < words.size(); ++count) {
                    System.out.println("File Argument " + count + " = " + words.get(count));
                }
            }
            for (String p : words) {
                this.parseParam(p);
            }
        } else if (this.infoLevel > -1) {
            System.out.println(" Parameter file " + parameterFileName.getFullFileName() + " not found");
        }
    }

    private void parseParam(String argument) {
        if (timgraph.isOtherArgument(argument)) {
            System.out.println("!!! Ignoring argument \"" + argument + "\" as it starts with character indicating a different class argument " + argument);
            return;
        }
        if (!timgraph.isTIMGRAPH_ARGUMENT(argument)) {
            throw new IllegalArgumentException("*** Argument \"" + argument + "\" does not start with " + timgraph.otherArguments(", ") + " or " + '-');
        }
        switch (argument.charAt(1)) {
            case 'e': {
                this.numevents = Integer.parseInt(argument.substring(2));
                break;
            }
            case 'f': {
                if (argument.charAt(2) == 'i') {
                    if (argument.charAt(3) == 'n' && !this.inputName.setFullFileName(argument.substring(4), InputFileType.extensionList)) {
                        throw new IllegalArgumentException("*** Full file name \"" + argument.substring(4) + "\" does not have recognised ending\n" + InputFileType.listAllExtensions(" - ", "\n"));
                    }
                    if (argument.charAt(3) == 'r') {
                        this.inputName.setNameRoot(argument.substring(4));
                    }
                    if (argument.charAt(3) == 'd') {
                        this.inputName.setDirectoryRoot(argument.substring(4));
                    }
                    if (argument.charAt(3) == 's') {
                        this.inputName.setDirectoryEnd(argument.substring(4));
                    }
                    if (argument.charAt(3) == 'e') {
                        this.inputName.setNameEnd(argument.substring(4));
                    }
                }
                if (argument.charAt(2) != 'o') break;
                if (argument.charAt(3) == 'n') {
                    this.outputName.setFullFileNameNoEnding(argument.substring(4));
                }
                if (argument.charAt(3) == 'r') {
                    this.outputName.setNameRoot(argument.substring(4));
                }
                if (argument.charAt(3) == 'd') {
                    this.outputName.setDirectoryRoot(argument.substring(4));
                }
                if (argument.charAt(3) == 's') {
                    this.outputName.setDirectoryEnd(argument.substring(4));
                }
                if (argument.charAt(3) != 'e') break;
                this.outputName.setNameEnd(argument.substring(4));
                break;
            }
            case 'g': {
                if (argument.charAt(2) == 'v') {
                    if (argument.charAt(3) == 'e') {
                        boolean bl = this.vertexEdgeListOn = argument.charAt(4) == 't';
                    }
                    if (argument.charAt(3) == 'l') {
                        boolean bl = this.vertexlabels = argument.charAt(4) == 't';
                    }
                    if (argument.charAt(3) == 'v') {
                        this.initialVertices = Integer.parseInt(argument.substring(4));
                    }
                }
                if (argument.charAt(2) == 'e') {
                    if (argument.charAt(3) == 'l') {
                        boolean bl = this.labelledEdges = argument.charAt(4) == 't';
                    }
                    if (argument.charAt(3) == 'm') {
                        boolean bl = this.multiEdge = argument.charAt(4) == 't';
                    }
                    if (argument.charAt(3) == 's') {
                        boolean bl = this.selfLoops = argument.charAt(4) == 't';
                    }
                    if (argument.charAt(3) == 'w') {
                        boolean bl = this.weightedEdges = argument.charAt(4) == 't';
                    }
                }
                if (argument.charAt(2) == 'b') {
                    boolean bl = this.bipartiteGraph = argument.charAt(3) == 't';
                }
                if (argument.charAt(2) == '1') {
                    this.nameVertexType1 = argument.substring(3);
                }
                if (argument.charAt(2) == '2') {
                    this.nameVertexType2 = argument.substring(3);
                }
                if (argument.charAt(2) == 'd') {
                    boolean bl = this.directedGraph = argument.charAt(3) == 't';
                }
                if (argument.charAt(2) == 'n') {
                    this.initialgraph = Integer.parseInt(argument.substring(3));
                }
                if (argument.charAt(2) == 'm') {
                    this.initialConnectivity = Integer.parseInt(argument.substring(3));
                }
                if (argument.charAt(2) == 'x') {
                    this.initialXsize = Integer.parseInt(argument.substring(3));
                }
                if (argument.charAt(2) != 'y') break;
                this.initialYsize = Integer.parseInt(argument.substring(3));
                break;
            }
            case 'k': {
                this.connectivity = Double.parseDouble(argument.substring(2)) / 2.0;
                break;
            }
            case 'l': {
                if (argument.charAt(2) == 'w') {
                    this.averageWalkLength = Double.parseDouble(argument.substring(3));
                }
                if (argument.charAt(2) != 'r') break;
                this.rankingProbabilityLengthScale = Double.parseDouble(argument.substring(3));
                break;
            }
            case 'm': {
                this.connectivity = Double.parseDouble(argument.substring(2));
                System.err.println("!!! Warning: Argument " + argument + " is -im is deprecated, use -k for degree instead");
                break;
            }
            case 'o': {
                this.outputControl.set(Integer.parseInt(argument.substring(2)));
                break;
            }
            case 'p': {
                this.probnewvertex = Double.parseDouble(argument.substring(2));
                break;
            }
            case 'v': {
                if (argument.charAt(2) == 'w') {
                    this.randomWalk.randomWalkMode = Integer.parseInt(argument.substring(3));
                }
                if (argument.charAt(2) == 'e') {
                    this.edgegenerator = Integer.parseInt(argument.substring(3));
                }
                if (argument.charAt(2) != 'e') break;
                this.binomialNumber = Integer.parseInt(argument.substring(3));
                break;
            }
            case 'x': {
                if (argument.charAt(2) == 'i') {
                    this.infoLevel = Integer.parseInt(argument.substring(3));
                    this.message.setInformationLevel(this.infoLevel);
                }
                if (argument.charAt(2) == 'v') {
                    this.maximumVertices = Integer.parseInt(argument.substring(3));
                }
                if (argument.charAt(2) != 'e') break;
                this.maximumStubs = Integer.parseInt(argument.substring(3));
                break;
            }
            case '?': {
                this.printUsage();
                System.exit(1);
            }
            default: {
                throw new IllegalArgumentException("Unknown argument \"" + argument + "\"");
            }
        }
    }

    public void printUsage() {
        this.printUsage(System.out);
    }

    public void printUsage(PrintStream PS) {
        timgraph temp = new timgraph();
        RandomWalk rw = new RandomWalk(temp);
        PS.println("OPTIONS for timgraph version tg110504\n");
        PS.println(" -e<int> number of events (time steps), default " + temp.numevents);
        PS.println(" -f?n<FullName> full filename, directories optional, ?=i input or ?=o output, default input=" + temp.inputName.getNameRoot() + ", output=" + temp.outputName.getNameRoot());
        PS.println(" -f?r<NameRoot> root of filename, ?=i input or ?=o output, default input=" + temp.inputName.getNameRoot() + ", output=" + temp.outputName.getNameRoot());
        PS.println(" -f?e<Ending>  ending used for files, ?=i input or ?=o output, default  input=" + temp.inputName.getNameEnd() + ", output=" + temp.outputName.getNameEnd());
        PS.println(" -f?s<SubDirName>  sub directory using forward slashes for ?=i input or ?=o output, default  input=" + temp.inputName.getDirectoryEnd() + ", output=" + temp.outputName.getDirectoryEnd());
        PS.println(" -f?d<DirName>  root of directory using forward slashes for ?=i input or ?=o output, default  input=" + temp.inputName.getDirectoryRoot() + ", output=" + temp.outputName.getDirectoryRoot());
        PS.println("                full file names are DirName/SubDirName/NameRootEnding");
        PS.println(" -gb<String> make a bipartite graph, \"t\"=true, otherwise false, default " + temp.isDirected());
        PS.println(" -g1<String> name of type one vertices in a bipartite graph, default " + temp.getNameVerticesType1());
        PS.println(" -g2<String> name of type two vertices in a bipartite graph, default " + temp.getNameVerticesType2());
        PS.println(" -gd<String> make a directed graph, \"t\"=true, otherwise false, default " + temp.isDirected());
        PS.println(" -gn<int> initial graph, default " + temp.initialgraph);
        PS.println(" -gm<int> connectivity m for initial graph, default " + temp.initialConnectivity);
        PS.println(" -gve<String> for each vertex create a list of incident edges by their global label, \"t\"=true, otherwise false, default " + temp.isVertexEdgeListOn());
        PS.println(" -gvl<String> use vertex labels, \"t\"=true, otherwise false, default " + temp.isVertexLabelled());
        PS.println(" -gvv<int> number vertices for initial graph, default " + temp.initialVertices);
        PS.println(" -gel<String> make a edges labelled, \"t\"=true, otherwise false, default " + temp.isEdgeLabelled());
        PS.println(" -gem<String> allow multi edges, \"t\"=true, otherwise false, default " + temp.isMultiEdge());
        PS.println(" -ges<String> allow self loops, \"t\"=true, otherwise false, default " + temp.isSelfLooped());
        PS.println(" -gew<String> make a weighted graph, \"t\"=true, otherwise false, default " + temp.isWeighted());
        PS.println(" -gx<int> x dimension for initial graph (-1 = make square or cube root of size), default " + temp.initialXsize);
        PS.println(" -gy<int> y dimension for initial graph (-1 = make equal to x dimension), default " + temp.initialYsize);
        PS.println(" -k<float> average degree, default " + temp.connectivity / 2.0);
        PS.println(" -lr<float> average walk length equivalent for ranking prob.(<0 = diameter/2), default " + temp.rankingProbabilityLengthScale);
        PS.println(" -lw<float> average walk length for random walks (<0 = diameter/2), default " + temp.averageWalkLength);
        PS.println(" -o<int> output modes (see below), default " + temp.outputControl);
        PS.println(" -p<float> probability in walks of adding a new vertex per event, default " + temp.probnewvertex);
        PS.println(" -ve<int> edge generator: 0 Walk, 1 ER, default " + temp.edgegenerator);
        PS.println(" -vw<int> walk modes (see below), default " + rw.randomWalkMode);
        PS.println(" -vn<int> binomial distribution integer, default " + temp.binomialNumber);
        PS.println(" -xe<maxEdges>     maximum no. edges,                   default " + temp.maximumStubs);
        PS.println(" -xi<infoLevel>    level for information, >0 debugging, default " + temp.infoLevel);
        PS.println(" -xv<maxVertices>  maximum no. vertices,                default " + temp.maximumVertices);
        PS.println("gn graph types:");
        PS.println("          0= empty no vertices, no edges");
        PS.println("         +1= one initial vertex with no edges");
        PS.println("         +2= two edges between two initial vertices");
        PS.println("         +3= one edge between two initial vertices");
        PS.println("       4..9= various small fixed graphs");
        PS.println("         99= read in from file");
        PS.println("         -1= line of numevents vertices and 2*gm neighbours");
        PS.println("         -2= ring of numevents vertices and 2*gm neighbours");
        PS.println("         -3= 2-dimensional lattice of side approx sqrt(numevents) vertices and 4*gm neighbours");
        PS.println("         -4= 2-dimensional torus of side approx sqrt(numevents) vertices and 4*gm neighbours");
        PS.println("         -5= 3-dimensional lattice of side approx sqrt(numevents) vertices and 4*gm neighbours");
        PS.println("         -6= 3-dimensional torus of side approx sqrt(numevents) vertices and 4*gm neighbours");
        PS.println("        -11= line of gx complete subgraphs connected to 2*gm nearest neighbour communities");
        PS.println("        -12= ring of gx complete subgraphs connected to 2*gm nearest neighbour communities");
        PS.println("vw modes: (vw& 1) ? Starts walks from random vertex : (end of random edge)");
        PS.println("        : (vw& 2) ? Starts new walk for every edge : (only for every event)");
        PS.println("        : (vw& 4) ? Markovian walk, yes : (or no)");
        PS.println("        : (vw& 8) ? Random number edges per vertex, yes : (or no)");
        PS.println("        : (vw&16) ? Binomial (Markovian) walk length distribution, yes : (or no)");
        PS.println("Default modes are:");
        rw.printAllModes(PS, "        : ");
        PS.println(" o modes:");
        temp.outputControl.printUsage(PS, "         ");
        PS.print("Default outputs are:");
        temp.outputControl.printMode(PS, "");
        PS.print("Deprecated :");
        PS.println(" -m<float> average connectivity, default " + temp.connectivity);
    }

    void printReducedDegreeDistribution() {
        int nk = 0;
        System.out.println("Reduced Degree Distribution");
        System.out.println(" k \t  n(k)");
        for (int k = 0; k < this.rddarr.size(); ++k) {
            nk = this.rddarr.get(k);
            if (nk <= 0) continue;
            System.out.println(k + SEP + nk);
        }
    }

    void printWeightDistribution() {
        int nw = 0;
        System.out.println("Weight Distribution");
        System.out.println(" w \t  n(w)");
        for (int w = 0; w < this.weightdarr.size(); ++w) {
            nw = this.weightdarr.get(w);
            if (nw <= 0) continue;
            System.out.println(w + SEP + nw);
        }
    }

    void printDistanceDistribution(boolean distributionshow) {
        System.out.println("diameter \t " + this.diameter);
        System.out.println("Distance Distribution [one sample]");
        System.out.println("From totals: average distance \t " + NumbersToString.toString((double)this.distanceaverage, (int)2) + SEP + " +/- " + SEP + NumbersToString.toString((double)this.distanceerror, (int)2) + ", sigma " + SEP + NumbersToString.toString((double)this.distancesigma, (int)2));
        System.out.println("Average distance from one vertex \t " + NumbersToString.toString((double)this.onesdistanceav, (int)2) + SEP + " +/- " + SEP + NumbersToString.toString((double)this.onesdistanceerror, (int)2) + SEP + ", sigma=" + SEP + NumbersToString.toString((double)this.onesdistancesigma, (int)2));
        System.out.println("Diameter \t " + NumbersToString.toString((double)this.diameter, (int)2) + SEP + " +/- " + SEP + NumbersToString.toString((double)this.diametererror, (int)2) + SEP + ", sigma " + SEP + NumbersToString.toString((double)this.diametersigma, (int)2));
        if (distributionshow) {
            System.out.println(" d\t n(d)");
            for (int d = 0; d < this.distancedist.size(); ++d) {
                System.out.println(d + SEP + this.distancedist.get(d));
            }
        }
    }

    public void printComponentInfo() {
        this.printComponentInfo(System.out);
    }

    public void printComponentInfo(PrintStream PS) {
        this.printComponentInfo(PS, true, false);
    }

    public void printComponentInfo(PrintStream PS, boolean componentDistribution, boolean vertexToComponent) {
        PS.println("Number of Components \t " + this.componentSize.size());
        PS.println("     Vertices in GCC \t " + this.componentSizeMax);
        PS.println("     Diameter of GCC \t " + this.componentDiameterMax);
        PS.println(" Av. Distance of GCC \t " + this.componentGCCDist);
        PS.println("   GCC Component No. \t " + this.componentGCCIndex);
        if (componentDistribution) {
            this.printComponentDistribution(PS);
        }
        if (vertexToComponent) {
            this.printVertexToComponentList(PS);
        }
    }

    void printVertexToComponentList(PrintStream PS) {
        PS.println("v\t c");
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            PS.println(v + SEP + this.getVertexComponentLabel(v));
        }
    }

    void printComponentDistribution(PrintStream PS) {
        PS.println(" c\t n(c)\t v in c\t diam_min");
        int count = 0;
        for (int c = 0; c < this.componentSize.size(); ++c) {
            PS.println(c + SEP + this.componentSize.get(c) + SEP + this.componentSource.get(c) + SEP + this.componentDist.get(c));
            count += this.componentSize.get(c);
        }
        PS.println("Tot\t " + count);
    }

    public int getNumberComponents() {
        return this.componentSize.size();
    }

    public double getAverageComponentSize() {
        return (double)this.TotalNumberVertices / (double)this.componentSize.size();
    }

    public int getNumberSingleComponents() {
        return this.componentSingleNumber;
    }

    public double getAverageMultiComponentSize() {
        int nmc = this.componentSize.size() - this.componentSingleNumber;
        if (nmc > 0) {
            return (double)(this.TotalNumberVertices - this.componentSingleNumber) / (double)nmc;
        }
        return nmc;
    }

    public int getNumberMultiComponents() {
        return this.componentSize.size() - this.componentSingleNumber;
    }

    public int getNumberGCCVertices() {
        return this.componentSizeMax;
    }

    public int getGCCDiameter() {
        return this.componentDiameterMax;
    }

    public double getGCCDistance() {
        return this.componentGCCDist;
    }

    public String componentInfoString(String sep) {
        return this.componentSize.size() + sep + this.componentSizeMax + sep + this.componentDiameterMax + sep + this.componentGCCDist;
    }

    public String componentInfoStringLabel(String sep) {
        return "No.Comp." + sep + "No.GCC Vert" + sep + "GCC Diam." + sep + "GCC Dist.";
    }

    void printComponentDistribution() {
        this.printComponentDistribution(System.out);
    }

    void printRingInfo(PrintStream PS, int source) {
        PS.println("Ring source \t " + source + SEP + " degree" + SEP + this.vertexList[source].size());
        PS.println("Ring diameter \t " + (this.distancedist.size() - 1));
        PS.println("ring\t n(r)\t <k(r)>\t Edges");
        int count = 0;
        double edge = 0.0;
        int nv = 0;
        double deg = 0.0;
        for (int r = 0; r < this.distancedist.size(); ++r) {
            nv = this.distancedist.get(r);
            deg = this.ringdegree.get(r);
            count += nv;
            edge += (double)nv * deg;
            PS.println(r + SEP + nv + SEP + deg + SEP + NumbersToString.toString((double)((double)nv * deg), (int)1));
        }
        PS.println("Total Vertices\t " + count + SEP + ", Total Edges " + NumbersToString.toString((double)edge, (int)2) + ", Average degree " + edge / (double)count);
    }

    void printDistanceTotalDistribution(boolean distributionshow) {
        System.out.println("Distance Distribution [" + this.totdistancedist.get(0) + " samples]");
        System.out.println("diameter maximum, minimum, average \t " + NumbersToString.toString((double)this.diametermax, (int)2) + SEP + NumbersToString.toString((double)this.diametermin, (int)2) + SEP + NumbersToString.toString((double)this.diameteraverage, (int)2) + SEP + ", sigma= " + NumbersToString.toString((double)this.diametersigma, (int)2));
        System.out.println("average distance \t " + NumbersToString.toString((double)this.totdistanceaverage, (int)2) + SEP + ", sigma= " + SEP + NumbersToString.toString((double)this.totdistancesigma, (int)2));
        if (distributionshow) {
            System.out.println(" d\t n(d)\t  sum_sample (n(d))^2");
            for (int d = 0; d < this.totdistancedist.size(); ++d) {
                System.out.println(d + SEP + this.totdistancedist.get(d) + SEP + this.totdistance2dist.get(d));
            }
        }
    }

    void printDistanceList() {
        System.out.println(" v \t d");
        for (int v = 0; v < this.vertexdistance.length; ++v) {
            System.out.println(v + SEP + this.vertexdistance[v]);
        }
    }

    void printCC() {
        System.out.println("CC Values [" + this.CCnsamples + " samples]");
        System.out.println("average CC \t " + this.CCaverage + SEP + " +/- " + SEP + this.CCerror + SEP + ", sigma= " + SEP + this.CCsigma);
        System.out.println("Edge CC Values [" + this.CCEdgensamples + " samples]");
        System.out.println("average Edge CC \t " + this.CCEdgeaverage + SEP + " +/- " + SEP + this.CCEdgeerror + SEP + ", sigma= " + SEP + this.CCEdgesigma);
    }

    public void printNetwork(boolean printNearestNeighbours) {
        boolean printTriangles = true;
        boolean printSquares = true;
        this.printVertices(System.out, printTriangles, printSquares, printNearestNeighbours);
        this.printEdges(System.out);
        System.out.println("***\t \t \t ***");
    }

    void FileOutputNetwork(boolean printTriangles, boolean printSquares, boolean printNearestNeighbours) {
        this.outputName.setNameEnd("net.dat");
        try {
            FileOutputStream fout = new FileOutputStream(this.outputName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            this.printVertices(PS, printTriangles, printSquares, printNearestNeighbours);
            this.printEdges(PS);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing Network list to " + this.outputName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + this.outputName.getFullFileName());
            return;
        }
    }

    void FileOutputVertices(boolean printTriangles, boolean printSquares, boolean printNearestNeighbours) {
        this.outputName.setNameEnd("vertices.dat");
        try {
            FileOutputStream fout = new FileOutputStream(this.outputName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            this.printVertices(PS, printTriangles, printSquares, printNearestNeighbours);
            if (this.infoLevel > -2) {
                System.err.println("Finished writing vertex information to " + this.outputName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file " + this.outputName.getFullFileName());
            return;
        }
    }

    public void printVertices(PrintStream PS, boolean printTriangles, boolean printSquares, boolean printNearestNeighbours) {
        this.printVertices(PS, "", SEP, printTriangles, printSquares, printNearestNeighbours);
    }

    public void printVertices(PrintStream PS, String cc, String sep, boolean printTriangles, boolean printSquares, boolean printNearestNeighbours) {
        PS.print(this.getVertexStringLabel(cc, sep, printTriangles, printSquares, false, this.weightedEdges, printNearestNeighbours));
        PS.println(sep + "No. Vertices = " + sep + this.TotalNumberVertices);
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            PS.println(this.getVertexString(cc, sep, v, -135798642, printTriangles, printSquares, this.weightedEdges, printNearestNeighbours));
        }
    }

    public void printVertices(PrintStream PS, String cc, String sep, VertexPartition vp, boolean printTriangles, boolean printSquares, boolean printName, boolean printNumber, boolean printPosition, boolean printStrength, boolean printRank, boolean printNearestNeighbours) {
        boolean printCommunityLabel = vp != null;
        PS.print(this.getVertexStringLabel(cc, sep, printTriangles, printSquares, printCommunityLabel, printName, printNumber, printPosition, printStrength, printRank, printNearestNeighbours));
        PS.println(sep + "No. Vertices = " + sep + this.TotalNumberVertices);
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            PS.println(this.getVertexString(cc, sep, v, printCommunityLabel ? vp.getCommunity(v) : -135798642, printTriangles, printSquares, printName, printNumber, printPosition, printStrength, printRank, printNearestNeighbours));
        }
    }

    public void printVertexCommunity(PrintStream PS, ArrayList<ArrayList<Integer>> vertexToCommunity) {
        String cc = "";
        String sep = SEP;
        int vertexPartition = -135798642;
        boolean printStrength = this.isWeighted();
        boolean printNearestNeighbours = false;
        boolean printTriangles = false;
        boolean printSquares = false;
        PS.println(this.getVertexStringLabel(cc, sep, printTriangles, printSquares, false, printStrength, printNearestNeighbours) + sep + "Community" + sep + "C.Frac.");
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            ArrayList<Integer> vc = vertexToCommunity.get(v);
            if (vc.size() > 0) {
                for (Integer c : vc) {
                    PS.println(this.getVertexString(cc, sep, v, vertexPartition, printTriangles, printSquares, printStrength, printNearestNeighbours) + sep + c + sep + 1.0 / (double)vc.size());
                }
                continue;
            }
            PS.println(this.getVertexString(cc, sep, v, vertexPartition, printTriangles, printSquares, printStrength, printNearestNeighbours) + sep + (-1 - v) + sep + "1.0");
        }
    }

    public String getVertexString(String cc, String sep, int v, int vc, boolean printTriangles, boolean printSquares, boolean printStrength, boolean printNearestNeighbours) {
        boolean printName = false;
        boolean printNumber = false;
        boolean printPosition = false;
        boolean printRank = false;
        if (this.isVertexLabelled()) {
            VertexLabel l = this.getVertexLabel(0);
            printName = l.hasName();
            printNumber = l.hasNumber();
            printPosition = l.hasPosition();
            printStrength = l.hasStrength();
            printRank = l.hasRank();
        }
        return this.getVertexString(cc, sep, v, vc, printTriangles, printSquares, printName, printNumber, printPosition, printStrength, printRank, printNearestNeighbours);
    }

    public String getVertexString(String cc, String sep, int v, int vc, boolean printTriangles, boolean printSquares, boolean printName, boolean printNumber, boolean printPosition, boolean printStrength, boolean printRank, boolean printNearestNeighbours) {
        String s = Integer.toString(v);
        if (vc != -135798642) {
            s = s + sep + vc;
        }
        s = s + sep + this.vertexList[v].size();
        if (printTriangles) {
            if (printSquares) {
                int[] res = this.calcTrianglesSquares(v);
                s = s + sep + res[0] + sep + res[1];
            } else {
                s = s + sep + this.calcTriangles(v);
            }
        }
        if (this.vertexlabels) {
            s = s + sep + this.vertexLabelList[v].printString(sep, printName, printNumber, printPosition, printStrength, printRank);
        } else if (printStrength) {
            s = s + sep + this.getVertexOutStrength(v);
        }
        if (printNearestNeighbours) {
            for (int e = 0; e < this.vertexList[v].size(); ++e) {
                s = s + sep + this.vertexList[v].get(e);
            }
        }
        return s;
    }

    public String getVertexStringLabel(String cc, String sep, boolean printTriangles, boolean printSquares, boolean printCommunityLabel, boolean printStrength, boolean printNearestNeighbours) {
        boolean printName = false;
        boolean printNumber = false;
        boolean printPosition = false;
        boolean printRank = false;
        if (this.isVertexLabelled()) {
            VertexLabel l = this.getVertexLabel(0);
            printName = l.hasName();
            printNumber = l.hasNumber();
            printPosition = l.hasPosition();
            printStrength = l.hasStrength();
            printRank = l.hasRank();
        }
        return this.getVertexStringLabel(cc, sep, printTriangles, printSquares, printCommunityLabel, printName, printNumber, printPosition, printStrength, printRank, printNearestNeighbours);
    }

    public String getVertexStringLabel(String cc, String sep, boolean printTriangles, boolean printSquares, boolean printCommunityLabel, boolean printName, boolean printNumber, boolean printPosition, boolean printStrength, boolean printRank, boolean printNearestNeighbours) {
        String s = "index";
        if (printCommunityLabel) {
            s = s + sep + "Community";
        }
        s = s + sep + "degree";
        if (printTriangles) {
            s = s + sep + "triangles";
            if (printSquares) {
                s = s + sep + "squares";
            }
        }
        if (this.vertexlabels) {
            s = s + sep + VertexLabel.labelString(sep, printName, printNumber, printPosition, printStrength, printRank);
        }
        if (printNearestNeighbours) {
            s = s + sep + "n.n.";
        }
        return s;
    }

    public void printEdges() {
        this.printEdges(System.out);
    }

    public void printEdges(PrintStream PS) {
        this.printEdges(PS, COMMENTCHARACTER, SEP, -3.57986421E8, true, true, true, true, true);
    }

    public void printEdgesSimple(PrintStream PS) {
        this.printEdges(PS, COMMENTCHARACTER, SEP, -3.57986421E8, true, false, true, false, false);
    }

    public void printEdges(PrintStream PS, String cc, String sep, double minWeight, boolean vertexNames, boolean infoOn, boolean headerOn, boolean edgeIndexOn, boolean edgeLabelOn) {
        boolean useLabels = vertexNames & this.vertexlabels;
        if (infoOn) {
            PS.println(cc + "Edges    = " + sep + this.TotalNumberStubs + sep + this.stubSourceList.length);
        }
        if (headerOn) {
            if (edgeIndexOn) {
                PS.print(" e1 " + sep + " e2" + sep);
            }
            PS.print(" Source " + sep + " Target ");
            if (this.weightedEdges) {
                PS.print(sep + "Weight");
            }
            if (this.weightedEdges && edgeLabelOn) {
                PS.print(sep + "Label");
            }
            PS.println();
        }
        double ew = 1.0;
        boolean testWeight = minWeight != -3.57986421E8;
        for (int e = 0; e < this.TotalNumberStubs; e += 2) {
            if (this.weightedEdges) {
                ew = this.edgeValuetList[e].weight;
                if (testWeight && ew < minWeight) continue;
            }
            if (edgeIndexOn) {
                PS.print(e + sep + (e + 1) + sep);
            }
            int s = this.stubSourceList[e];
            int t = this.stubSourceList[e + 1];
            if (useLabels) {
                PS.print(this.vertexLabelList[s].getName() + sep + this.vertexLabelList[t].getName());
            } else {
                PS.print(s + sep + t);
            }
            if (this.weightedEdges) {
                PS.print(sep + ew);
            }
            if (this.weightedEdges && edgeLabelOn) {
                PS.print(sep + this.edgeValuetList[e].label);
            }
            PS.println();
        }
    }

    public void printEdgeCommunityStats(PrintStream PS, String sep, boolean headerOn, boolean vertexNames, boolean splitBipartite, boolean outputType1) {
        if (!this.weightedEdges) {
            throw new IllegalArgumentException("*** printEdgeCommunityStats needed edges to have labels");
        }
        if (!this.vertexEdgeListOn) {
            throw new IllegalArgumentException("*** printEdgeCommunityStats needed vertexEdgeList");
        }
        if (headerOn) {
            PS.println(this.edgeCommunityStatsLabel(sep));
        }
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            if (this.bipartiteGraph && splitBipartite && (outputType1 ? this.isType2(v) : this.isType1(v))) continue;
            this.printEdgeCommunityStats(PS, sep, v, vertexNames);
        }
    }

    private void printEdgeCommunityStats(PrintStream PS, String sep, int v, boolean vertexNames) {
        int i;
        String name = "";
        name = vertexNames ? this.getVertexName(v) : name + v;
        int k = this.getVertexDegree(v);
        if (k == 0) {
            int c = -1 - v;
            int kc = 0;
            double sc = 0.0;
            double s = 0.0;
            double fsc = 1.0;
            double fkc = 1.0;
            double sEntropy = 0.0;
            PS.println(name + sep + c + sep + k + sep + kc + sep + fkc + sep + s + sep + sc + sep + fsc + sep + sEntropy);
            return;
        }
        IntArrayList edgesInCommunity = new IntArrayList(k);
        DoubleArrayList strengthInCommunity = new DoubleArrayList(k);
        TreeMap<Integer, Integer> communityToIndex = new TreeMap<Integer, Integer>();
        IntArrayList indexToCommunity = new IntArrayList(k);
        IntArrayList edgeList = this.vertexEdgeList[v];
        double s = 0.0;
        for (int ei = 0; ei < edgeList.size(); ++ei) {
            int e = edgeList.getQuick(ei);
            int c = this.edgeValuetList[e].label;
            double w = this.edgeValuetList[e].weight;
            s += w;
            if (communityToIndex.containsKey(c)) {
                int i2 = (Integer)communityToIndex.get(c);
                edgesInCommunity.setQuick(i2, edgesInCommunity.getQuick(i2) + 1);
                strengthInCommunity.setQuick(i2, strengthInCommunity.getQuick(i2) + w);
                continue;
            }
            communityToIndex.put(c, edgesInCommunity.size());
            indexToCommunity.add(c);
            edgesInCommunity.add(1);
            strengthInCommunity.add(w);
        }
        double kd = k;
        double sEntropy = 1.0;
        double sc = -1.0;
        for (i = 0; i < indexToCommunity.size(); ++i) {
            double p = strengthInCommunity.getQuick(i) / s;
            if (!(p > 1.0E-20)) continue;
            sEntropy += -p * Math.log(p);
        }
        for (i = 0; i < indexToCommunity.size(); ++i) {
            int c = indexToCommunity.get(i);
            int kc = edgesInCommunity.getQuick(i);
            sc = strengthInCommunity.getQuick(i);
            PS.println(name + sep + c + sep + k + sep + kc + sep + (double)kc / kd + sep + s + sep + sc + sep + sc / s + sep + sEntropy);
        }
    }

    private String edgeCommunityStatsLabel(String sep) {
        return "Name" + sep + "Community" + sep + "Degree k" + sep + "k in C." + sep + "Frac.k In C." + sep + "Strength" + sep + "S.in C." + sep + "Frac.S. in C." + sep + "S.Entropy";
    }

    public void printOrderedWeightedNetwork() {
        System.out.println("# Vertices = \t " + this.TotalNumberVertices + SEP + this.vertexList.length);
        System.out.println("# Edges    = \t " + this.TotalNumberStubs + SEP + this.stubSourceList.length);
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            System.out.println("Vertex " + v + " has degree " + this.vertexList[v].size() + " and is connected to:");
            for (int e = 0; e < this.vertexList[v].size(); ++e) {
                System.out.print(this.vertexList[v].get(e) + SEP);
            }
            System.out.println();
        }
        System.out.println("Edges ");
        System.out.print(" e1 \t  e2\t  Sou \t  Tar ");
        if (this.weightedEdges) {
            System.out.println("\t  Lab \t  Wei ");
        }
        for (int er = 0; er < this.TotalNumberStubs / 2; ++er) {
            int e = this.edgerandomlist[er] * 2;
            System.out.println(e + SEP + (e + 1) + SEP + this.stubSourceList[e] + SEP + this.stubSourceList[e + 1]);
            if (!this.weightedEdges) continue;
            System.out.println(SEP + this.edgeValuetList[e].label + SEP + this.edgeValuetList[e].weight);
        }
        System.out.println("***                      ***");
    }

    void printReducedNetwork() {
        System.out.println("*** Reduced Network Data ***");
        System.out.println("# Vertices = \t " + this.TotalNumberVertices);
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            System.out.println("Vertex " + v + " has reduced degree " + this.rvertexList[v].size() + " and strength" + this.vertexList[v].size() + " and is connected to:");
            for (int e = 0; e < this.rvertexList[v].size(); ++e) {
                System.out.print(this.rvertexList[v].get(e) + " (" + this.strengthlist[v].get(e) + ") " + SEP);
            }
            System.out.println();
        }
        System.out.println("\n***                      ***");
    }

    public void printParametersBasic() {
        this.printParametersBasic(System.out, "\t  ");
    }

    public void printParametersBasic(PrintStream PS, String sep) {
        TimTime t = new TimTime(sep);
        PS.println("Programme version " + sep + VERSION + sep + t.fullString(sep));
        PS.println(this.inputName.getNameRoot() + " initial Graph " + sep + this.initialgraph + sep + this.initialGraphString());
        PS.println("Number Vertices " + sep + this.TotalNumberVertices + sep + "Stubs" + sep + this.TotalNumberStubs + sep + "Total Weight" + sep + this.getTotalWeight());
        if (this.bipartiteGraph) {
            PS.println("Number " + this.nameVertexType1 + " (type 1) and " + this.nameVertexType2 + " (type 2) vertices" + sep + this.numberVertexType1 + sep + this.numberVertexType2);
        }
        PS.println("Average Out degree " + sep + this.calcDegreeFirstMoment() + sep + ", Second Moment of D.D." + sep + this.calcDegreeSecondMoment());
        PS.println("Total Number of Triangles " + sep + this.getNumberTriangles() + ", global clustering coefficient " + sep + this.getCCGlobal());
        PS.println(this.graphTypeString(sep));
        PS.println(this.stringOfChecks(sep));
    }

    public String stringOfChecks(String sep) {
        return "Dynamical checks:" + sep + " multi edges - " + sep + (this.checkMultiEdges() ? "yes" : "no") + sep + " negative weights - " + sep + (this.checkNegativeWeights() ? "yes" : "no") + sep + " self loops - " + sep + (this.checkSelfLoops() ? "yes" : "no");
    }

    public String stringDirected() {
        return (this.isDirected() ? "" : "un") + "directed";
    }

    public String stringWeighted() {
        return (this.isWeighted() ? "" : "un") + "weighted";
    }

    public String stringLabelled() {
        return "vertices " + (this.isVertexLabelled() ? "" : "un") + "labelled";
    }

    public String stringVertexEdgeList() {
        return " vertex->edge list " + (this.isVertexEdgeListOn() ? "on" : "off");
    }

    public String stringEdgeLabelled() {
        return "edges " + (this.isEdgeLabelled() ? "" : "un") + "labelled";
    }

    public String stringMultiEdge() {
        return "multiedges " + (this.isMultiEdge() ? "" : "not ") + "allowed";
    }

    public String stringSelfLoops() {
        return "self loops " + (this.isSelfLooped() ? "" : "not ") + "allowed";
    }

    public String stringBipartite() {
        return this.isBipartite() ? "bipartite" : "unipartite";
    }

    public String graphTypeString(String sep) {
        return this.stringDirected() + sep + this.stringWeighted() + sep + this.stringLabelled() + sep + this.stringEdgeLabelled() + sep + this.stringMultiEdge() + sep + this.stringSelfLoops() + sep + this.stringVertexEdgeList() + sep + this.stringBipartite();
    }

    public void printParam() {
        this.printParametersBasic();
        System.out.println("Walk has \t " + this.numevents + SEP + " events,  ");
        this.printRandomWalkMode();
        System.out.println(this.connectivity + SEP + " edges added per event, " + SEP + this.averageWalkLength + SEP + " averageWalkLength, " + SEP + this.probnewvertex + SEP + " new vertex prob.");
        System.out.println("Info level is \t " + this.infoLevel);
        System.out.println(this.binomialNumber + SEP + " no. of dice used in binomial random numbers generator");
        if (this.probnewvertex < 1.0) {
            System.out.print("Prob of new vertex is \t " + this.probnewvertex + SEP + " using old ");
            if (this.SourceVertex) {
                System.out.println("random vertices");
            } else {
                System.out.println("vertices at end of random edges");
            }
        }
        this.outputControl.printMode(System.out, "");
    }

    public void printRandomWalkMode() {
        this.printRandomWalkMode(System.out, "");
    }

    public void printRandomWalkMode(PrintStream PS, String cc) {
        if ((this.randomWalkMode & 1) > 0) {
            PS.println(cc + "   Start every walk from random vertex");
        } else {
            PS.println(cc + "   Start every walk from random end of random edge");
        }
        if ((this.randomWalkMode & 2) > 0) {
            PS.println(cc + "   Jump to new vertex when walk length reached (every new edge)");
        } else {
            PS.println(cc + "   Do not jump to new vertex when walk length reached (unless new event in walk graph creation or no exits in random walk");
        }
        if ((this.randomWalkMode & 4) > 0) {
            PS.println(cc + "   Walk length variable, average fixed");
        } else {
            PS.println(cc + "   Walk length fixed");
        }
        if ((this.randomWalkMode & 8) > 0) {
            PS.println(cc + "   No. of edges added to each new vertex variable, average fixed");
        } else {
            PS.println(cc + "   No. of edges added to each new vertex fixed");
        }
        if ((this.randomWalkMode & 0x10) > 0) {
            PS.println(cc + "   Binomial distributed walk lengths");
        } else {
            PS.println(cc + "   Markovian walk lengths");
        }
    }

    public void printEdgeGenerator(PrintStream PS) {
        System.out.print("Edge generator is \t " + this.edgegenerator);
        if (this.edgegenerator == 0) {
            PS.println("   Walk routine used");
        }
        if (this.edgegenerator == 1) {
            PS.println("   ER generator used");
        }
    }

    public String initialGraphString() {
        return this.initialGraphString(this.initialgraph);
    }

    public String initialGraphString(int n) {
        String s = "???";
        switch (n) {
            case 0: {
                s = "Empty";
                break;
            }
            case 1: {
                s = "One vertex, no edges";
                break;
            }
            case 2: {
                s = "Two vertices with two edges (both degree=2)";
                break;
            }
            case 3: {
                s = "Two vertices, one edge";
                break;
            }
            case 4: {
                s = "Four vertices, eight edges (all degrees=4)";
                break;
            }
            case 5: {
                s = "Two vertices, four edges (both degree=4)";
                break;
            }
            case 6: {
                s = "Five vertices, four edges (star shape)";
                break;
            }
            case 7: {
                s = "Five vertices, four edges";
                break;
            }
            case 8: {
                s = "BowTie - Five vertices, six edges (two triangles with common vertex)";
                break;
            }
            case 9: {
                s = "Long BowTie - Six vertices, seven edges (two triangles with edge between two of their vertices)";
                break;
            }
            case 10: {
                s = "Nuclear - seven vertices, nine edges (three triangles with single common vertex)";
                break;
            }
            case 99: {
                s = "Input graph from file of specified extension, input file name " + this.inputName.getFullFileName();
                break;
            }
            case 100: {
                s = "Graph constructed from algorithm, graph name " + this.inputName.getNameRoot();
                break;
            }
            case -1: {
                s = "Line";
                break;
            }
            case -2: {
                s = "Ring";
                break;
            }
            case -3: {
                s = "2D rectangular lattice";
                break;
            }
            case -4: {
                s = "2D Torus";
                break;
            }
            case -5: {
                s = "3D rectangular lattice";
                break;
            }
            case -6: {
                s = "3D Torus";
                break;
            }
            case -11: {
                s = "CaveMan Line";
                break;
            }
            case -12: {
                s = "CaveMan Ring";
                break;
            }
            case -13: {
                s = "CaveMan Common Vertex Line";
                break;
            }
            case -14: {
                s = "CaveMan Common Vertex Ring";
                break;
            }
            default: {
                s = "Unknown Type";
            }
        }
        return s;
    }

    public void setInitialGraph(int n) {
        this.initialgraph = n;
    }

    public void setInitialGraphExternalAlgorithm() {
        this.initialgraph = 100;
    }

    public void setNetworkInitialGraph(boolean checkOn) {
        this.setNetwork(this.initialgraph);
        if (checkOn) {
            this.calcNumberVertices();
            this.calcNumberEdges();
        }
    }

    public int setNetworkOnlyFromInputFile() {
        this.initialgraph = 99;
        int res = -1;
        if (!this.inputFileType.setFromExactName(this.inputName.getNameEnd())) {
            throw new RuntimeException("Input file extension " + this.inputName.getNameEnd() + " unknown");
        }
        System.out.println("Setting up from input file:- " + this.inputFileType.toLongString());
        switch (this.inputFileType.getNumber()) {
            case 0: {
                res = this.setNetworkPajek(this.inputName.getNameEnd(), this.directedGraph, this.weightedEdges);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return res;
            }
            case 1: {
                res = this.setNetworkEdgeList(this.inputName.getNameEnd(), this.directedGraph, this.weightedEdges, this.vertexlabels, this.labelledEdges, true);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return res;
            }
            case 2: {
                res = this.setNetworkEdgeList(this.inputName.getNameEnd(), this.directedGraph, this.weightedEdges, this.vertexlabels, this.labelledEdges, false);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return res;
            }
            case 3: {
                res = this.setNetworkGMLInput(this.inputName.getNameEnd(), this.weightedEdges, this.vertexlabels);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return res;
            }
            case 4: {
                res = this.setNetworkMatrixInput();
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return res;
            }
            case 5: {
                boolean intList = false;
                boolean bipartite = false;
                boolean forceLowerCase = true;
                boolean checkBipartite = false;
                res = this.setNetworkVertexNeighbourList(this.inputName.getNameEnd(), this.weightedEdges, this.directedGraph, this.multiEdge, this.vertexlabels, intList, bipartite, forceLowerCase, false, 1, null, null, null);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return res;
            }
            case 6: {
                boolean intList = false;
                boolean bipartite = true;
                boolean forceLowerCase = true;
                boolean checkBipartite = true;
                res = this.setNetworkVertexNeighbourList(this.inputName.getNameEnd(), this.weightedEdges, this.directedGraph, this.multiEdge, this.vertexlabels, intList, bipartite, forceLowerCase, false, 1, null, null, null);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return res;
            }
            case 7: {
                boolean columnHeaderOn = true;
                boolean rowLabelOn = true;
                boolean trimLabelWhiteSpaceOn = true;
                res = this.setNetworkMatrixInput(columnHeaderOn, rowLabelOn, trimLabelWhiteSpaceOn);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return res;
            }
        }
        return res;
    }

    public int setNetworkFromInputFile() {
        int xColumn = 1;
        int yColumn = 2;
        int nameColumn = 1;
        boolean headerOn = false;
        boolean infoOn = false;
        return this.setNetworkFromInputFile(xColumn, yColumn, nameColumn, headerOn, infoOn);
    }

    public int setNetworkFromInputFile(int xColumn, int yColumn, int nameColumn, boolean headerOn, boolean infoOn) {
        int res = this.setNetworkOnlyFromInputFile();
        String vertexPositionsFullFileName = this.inputName.getNameRootFullPath() + "inputXY.dat";
        try {
            this.setVertexPositionsFromFile(vertexPositionsFullFileName, COMMENTCHARACTER, xColumn, yColumn, headerOn, infoOn);
        }
        catch (Exception e) {
            System.out.println("Unable to set vertex coordinates from file " + vertexPositionsFullFileName + " - " + e);
        }
        try {
            this.setVertexNamesFromFile("inputNames.dat", COMMENTCHARACTER, nameColumn, headerOn, infoOn);
        }
        catch (Exception e) {
            System.out.println("Unable to set vertex names from file - " + e);
        }
        return res;
    }

    void setNetwork(int n) {
        if (this.infoLevel > -1) {
            System.out.println("Initial Graph Type " + n + ": " + this.initialGraphString(n));
        }
        if (n == 99) {
            this.setNetworkFromInputFile();
            return;
        }
        switch (n) {
            case -14: 
            case -13: {
                int cSize = this.initialVertices / this.initialXsize;
                this.initialEdges = (cSize * (cSize + 1) + 2 * this.initialConnectivity) * this.initialXsize + 1;
                break;
            }
            case -12: 
            case -11: {
                int cSize = this.initialVertices / this.initialXsize;
                this.initialEdges = (cSize * (cSize - 1) + 2 * this.initialConnectivity) * this.initialXsize;
                break;
            }
            case -6: 
            case -5: {
                this.initialEdges = this.initialVertices * 6 * this.initialConnectivity;
                break;
            }
            case -4: 
            case -3: {
                this.initialEdges = this.initialVertices * 4 * this.initialConnectivity;
                break;
            }
            case -2: 
            case -1: {
                this.initialEdges = this.initialVertices * 2 * this.initialConnectivity;
                break;
            }
            case 0: {
                this.initialVertices = 0;
                this.initialEdges = 0;
                break;
            }
            case 1: {
                this.initialVertices = 1;
                this.initialEdges = 0;
                break;
            }
            case 2: {
                this.initialVertices = 2;
                this.initialEdges = 4;
                break;
            }
            case 3: {
                this.initialVertices = 2;
                this.initialEdges = 2;
                break;
            }
            case 4: {
                this.initialVertices = 4;
                this.initialEdges = 8;
                break;
            }
            case 5: {
                this.initialVertices = 2;
                this.initialEdges = 8;
                break;
            }
            case 6: {
                this.initialVertices = 5;
                this.initialEdges = 8;
                break;
            }
            case 7: {
                this.initialVertices = 5;
                this.initialEdges = 8;
                break;
            }
            case 8: {
                this.initialVertices = 5;
                this.initialEdges = 12;
                break;
            }
            case 9: {
                this.initialVertices = 6;
                this.initialEdges = 14;
                break;
            }
            case 10: {
                this.initialVertices = 7;
                this.initialEdges = 18;
                break;
            }
            default: {
                System.err.println("***ERROR unknown initial graph type");
                return;
            }
        }
        this.maximumVertices = this.numevents + this.initialVertices;
        this.maxexpectedvertices = this.probnewvertex * (double)this.numevents + (double)this.initialVertices;
        this.maxexpectededges = (double)this.numevents * this.connectivity * 2.0 + (double)this.initialEdges;
        this.maximumStubs = (int)(this.maxexpectededges + 5.0 * Math.sqrt(this.maxexpectededges) + 0.5);
        if (this.infoLevel > -1) {
            System.out.println("Initial vertices and edges are " + this.initialVertices + SEP + this.initialEdges);
            System.out.println("Maximum vertices and edges are " + this.maximumVertices + SEP + this.maximumStubs);
        }
        if (n < 0) {
            switch (this.initialgraph) {
                case -1: {
                    this.setNetworkLine(false);
                    break;
                }
                case -2: {
                    this.setNetworkLine(true);
                    break;
                }
                case -3: {
                    this.setNetworkSquareLattice(false);
                    break;
                }
                case -4: {
                    this.setNetworkSquareLattice(true);
                    break;
                }
                case -5: {
                    this.setNetworkCubicLattice(false);
                    break;
                }
                case -6: {
                    this.setNetworkCubicLattice(true);
                    break;
                }
                case -11: {
                    this.setNetworkCaveManLine(false);
                    break;
                }
                case -12: {
                    this.setNetworkCaveManLine(true);
                    break;
                }
                case -13: {
                    this.setNetworkCaveManCommonVertex(false);
                    break;
                }
                case -14: {
                    this.setNetworkCaveManCommonVertex(true);
                }
            }
            this.initialEdges = this.TotalNumberStubs;
            this.initialVertices = this.TotalNumberVertices;
            return;
        }
        this.setNetwork();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                int v0 = this.addVertex();
                break;
            }
            case 3: {
                int v0 = this.addVertex();
                int v1 = this.addVertex();
                this.addEdge(v0, v1);
                break;
            }
            case 4: {
                int v0 = this.addVertex();
                int v1 = this.addVertex();
                int v2 = this.addVertex();
                int v3 = this.addVertex();
                this.addEdge(v0, v1);
                this.addEdge(v1, v0);
                this.addEdge(v1, v2);
                this.addEdge(v2, v3);
                this.addEdge(v3, v2);
                this.addEdge(v3, v0);
                this.addEdge(v0, v2);
                this.addEdge(v1, v3);
                break;
            }
            case 5: {
                int v0 = this.addVertex();
                int v1 = this.addVertex();
                this.addEdge(v0, v1);
                this.addEdge(v0, v1);
                this.addEdge(v1, v0);
                this.addEdge(v1, v0);
                break;
            }
            case 6: {
                int v0 = this.addVertex();
                int v1 = this.addVertex();
                int v2 = this.addVertex();
                int v3 = this.addVertex();
                int v4 = this.addVertex();
                this.addEdge(v0, v1);
                this.addEdge(v0, v2);
                this.addEdge(v0, v3);
                this.addEdge(v0, v4);
                break;
            }
            case 7: {
                int v0 = this.addVertex();
                int v1 = this.addVertex();
                int v2 = this.addVertex();
                int v3 = this.addVertex();
                int v4 = this.addVertex();
                this.addEdge(v0, v1);
                this.addEdge(v0, v2);
                this.addEdge(v0, v3);
                this.addEdge(v0, v4);
                break;
            }
            case 8: {
                int v0 = this.addVertex();
                int v1 = this.addVertex();
                int v2 = this.addVertex();
                int v3 = this.addVertex();
                int v4 = this.addVertex();
                this.addEdge(v0, v1);
                this.addEdge(v0, v2);
                this.addEdge(v1, v2);
                this.addEdge(v2, v3);
                this.addEdge(v2, v4);
                this.addEdge(v3, v4);
                break;
            }
            case 9: {
                int v0 = this.addVertex();
                int v1 = this.addVertex();
                int v2 = this.addVertex();
                int v3 = this.addVertex();
                int v4 = this.addVertex();
                int v5 = this.addVertex();
                this.addEdge(v0, v1);
                this.addEdge(v0, v2);
                this.addEdge(v1, v2);
                this.addEdge(v2, v5);
                this.addEdge(v5, v3);
                this.addEdge(v5, v4);
                this.addEdge(v3, v4);
                break;
            }
            case 10: {
                int v0 = this.addVertex();
                int v1 = this.addVertex();
                int v2 = this.addVertex();
                int v3 = this.addVertex();
                int v4 = this.addVertex();
                int v5 = this.addVertex();
                int v6 = this.addVertex();
                this.addEdge(v0, v1);
                this.addEdge(v0, v2);
                this.addEdge(v1, v2);
                this.addEdge(v0, v3);
                this.addEdge(v0, v4);
                this.addEdge(v3, v4);
                this.addEdge(v0, v5);
                this.addEdge(v0, v6);
                this.addEdge(v5, v6);
                break;
            }
            default: {
                int v0 = this.addVertex();
                int v1 = this.addVertex();
                this.addEdge(v0, v1);
                this.addEdge(v1, v0);
            }
        }
        if (this.weightedEdges) {
            for (int e = 0; e < this.TotalNumberStubs; ++e) {
                this.edgeValuetList[e] = new EdgeValue(0, 1.0);
            }
        }
        if (this.initialVertices != this.TotalNumberVertices) {
            System.out.println("*** ERROR initialVertices != TotalNumberVertices " + this.initialVertices + SEP + this.TotalNumberVertices);
        }
        if (this.initialEdges != this.TotalNumberStubs) {
            System.out.println("*** ERROR initialEdges    != TotalNumberEdges " + this.initialEdges + SEP + this.TotalNumberStubs);
        }
        this.initialEdges = this.TotalNumberStubs;
        this.initialVertices = this.TotalNumberVertices;
    }

    public void setNetworkWithVertices(int maxV, int maxS) {
        this.setNetwork(maxV, maxS);
        if (this.vertexlabels) {
            for (int v = 0; v < this.maximumVertices; ++v) {
                this.addVertex(new VertexLabel());
            }
        } else {
            for (int v = 0; v < this.maximumVertices; ++v) {
                this.addVertex();
            }
        }
    }

    public void setNetwork(int maxV, int maxS) {
        this.maximumVertices = maxV;
        this.maximumStubs = maxS;
        this.setNetwork();
    }

    public void setNetwork() {
        this.vertexList = new IntArrayList[this.maximumVertices];
        if (this.vertexEdgeListOn) {
            this.vertexEdgeList = new IntArrayList[this.maximumVertices];
            if (this.directedGraph) {
                this.vertexInEdgeList = new IntArrayList[this.maximumVertices];
            }
        }
        if (this.directedGraph) {
            this.vertexSourceList = new IntArrayList[this.maximumVertices];
        }
        if (this.vertexlabels) {
            this.vertexLabelList = new VertexLabel[this.maximumVertices];
        }
        this.TotalNumberVertices = 0;
        this.stubSourceList = new int[this.maximumStubs];
        if (this.weightedEdges) {
            this.edgeValuetList = new EdgeValue[this.maximumStubs];
        }
        this.TotalNumberStubs = 0;
    }

    public void setNetworkFromMatrix(double[][] matrix) {
        this.setNetworkFromMatrix(null, matrix);
    }

    public void setNetworkFromMatrix(String[] vertexName, double[][] matrix) {
        int v;
        int dimension = matrix[0].length;
        boolean useNames = false;
        if (vertexName != null) {
            useNames = true;
        }
        if (useNames && vertexName.length != dimension) {
            throw new RuntimeException("*** number of names " + vertexName.length + " does not match dimension of matrix " + dimension + " in setNetworkFromMatrix");
        }
        this.maximumVertices = dimension;
        this.maximumStubs = 0;
        int diagonalEntry = 0;
        int offDiagonalEntry = 0;
        boolean symm = true;
        for (int i = 0; i < dimension; ++i) {
            for (int j = 0; j < dimension; ++j) {
                if (matrix[i][j] != 0.0) {
                    if (i == j) {
                        ++diagonalEntry;
                    } else {
                        ++offDiagonalEntry;
                    }
                }
                if (this.isDirected() || !symm || matrix[i][j] == matrix[j][i]) continue;
                System.out.println("!!!Warning undirected graph by unsymmetrical matrix, entry " + i + ", " + j);
                symm = false;
            }
        }
        this.maximumStubs = this.isDirected() ? 2 * (offDiagonalEntry + diagonalEntry) : offDiagonalEntry + 2 * diagonalEntry;
        this.setNetwork();
        VertexLabel vl = new VertexLabel();
        if (this.vertexlabels) {
            for (v = 0; v < dimension; ++v) {
                if (useNames) {
                    vl.setName(vertexName[v]);
                } else {
                    vl.setName(Integer.toString(v));
                }
                this.addVertex(vl);
            }
        } else {
            for (v = 0; v < dimension; ++v) {
                this.addVertex();
            }
        }
        for (int s = 0; s < dimension; ++s) {
            int t;
            int n = t = this.isDirected() ? 0 : s;
            while (t < dimension) {
                if (matrix[s][t] != 0.0) {
                    if (this.isWeighted()) {
                        this.addEdge(s, t, matrix[s][t]);
                    } else {
                        this.addEdge(s, t);
                    }
                }
                ++t;
            }
        }
    }

    void setNetwork(int numberVertices, int[] stubList, boolean shuffleOn) {
        int v;
        this.setNetwork();
        if (this.vertexlabels) {
            for (v = 0; v < numberVertices; ++v) {
                this.addVertex(new VertexLabel());
            }
        } else {
            for (v = 0; v < numberVertices; ++v) {
                this.addVertex();
            }
        }
        int v1 = -1;
        int v2 = -1;
        EdgeValue w1 = new EdgeValue();
        EdgeValue w2 = new EdgeValue();
        int ne = stubList.length >> 1 << 1;
        if (shuffleOn) {
            double N = stubList.length;
            int value = -999;
            int r = -1;
            int i = 0;
            while ((double)i < N) {
                r = (int)(Math.random() * N);
                value = stubList[i];
                stubList[i] = stubList[r];
                stubList[r] = value;
                ++i;
            }
        }
        int e = 0;
        while (e < ne) {
            v1 = stubList[e++];
            v2 = stubList[e++];
            if (this.weightedEdges) {
                this.addEdge(v1, v2, w1, w2);
                continue;
            }
            this.addEdge(v1, v2);
        }
    }

    public int setNetworkPajek(String ext, boolean directed, boolean weighted) {
        FileInput input = new FileInput(this.infoLevel);
        return input.processPajekFile(this, ext, directed, weighted);
    }

    public int setNetworkEdgeList(String ext, boolean directed, boolean weighted, boolean vertexLabelled, boolean edgeLabelled, boolean intList) {
        FileInput input = new FileInput(this.infoLevel);
        if (intList) {
            return FileInput.processIntEdgeFile(this, ext, 1, 2, weighted ? 3 : -1, edgeLabelled ? 4 : -1, directed, vertexLabelled, this.infoLevel > 1);
        }
        return input.processStringEdgeFile(this, ext, 1, 2, weighted ? 3 : -1, edgeLabelled ? 4 : -1, directed, vertexLabelled);
    }

    public int setNetworkVertexNeighbourList(String ext, boolean weighted, boolean directed, boolean multiedge, boolean vertexLabelled, boolean intList, boolean bipartite, boolean forceLowerCase, boolean checkBipartite, int sampleFrequency, StringFilter stringFilterSource, StringFilter stringFilterTarget, TreeSet<String> filterL) {
        FileInput input = new FileInput(this.infoLevel);
        if (intList) {
            return -952384;
        }
        return input.processStringVertexNeighbourFile(this, ext, weighted, directed, this.multiEdge, vertexLabelled, bipartite, forceLowerCase, checkBipartite, sampleFrequency, stringFilterSource, stringFilterTarget, filterL);
    }

    public int setNetworkMatrixInput() {
        boolean headerOn = false;
        boolean rowLabelOn = false;
        boolean trimLabelWhiteSpaceOn = false;
        return this.setNetworkMatrixInput(headerOn, rowLabelOn, trimLabelWhiteSpaceOn);
    }

    public int setNetworkMatrixInput(boolean headerOn, boolean rowLabelOn, boolean trimLabelWhiteSpaceOn) {
        FileInput input = new FileInput(this.infoLevel);
        return input.processAdjacencyMatrixTabSeparated(this, headerOn, rowLabelOn, trimLabelWhiteSpaceOn);
    }

    public int setNetworkGMLInput(String ext, boolean weighted, boolean vertexLabelled) {
        FileInput input = new FileInput(this.infoLevel);
        return input.processGMLFile(this, ext, weighted, vertexLabelled);
    }

    public void setNetworkLine(boolean ring) {
        this.setNetworkLine(this.initialVertices, this.initialConnectivity, ring);
    }

    public void setNetworkLine(int nVertices, int m, boolean ring) {
        int e;
        if (nVertices > this.maximumVertices) {
            this.maximumVertices = nVertices;
        }
        if (this.maximumStubs < (e = nVertices * m * 2)) {
            this.maximumStubs = e;
        }
        this.setNetwork();
        for (int v = 0; v < nVertices; ++v) {
            this.addVertex();
        }
        int vn = -1;
        for (int v = 0; v < nVertices; ++v) {
            for (int n = 1; n <= m; ++n) {
                vn = v + n;
                if (vn >= nVertices && !ring) continue;
                this.addEdge(v, vn %= nVertices);
            }
        }
    }

    public void setNetworkSquareLattice(boolean periodic) {
        int xnumber = this.initialXsize;
        if (xnumber < 1) {
            xnumber = (int)(0.5 + Math.sqrt(this.initialVertices));
        }
        this.setNetworkSquareLattice(this.initialVertices, this.initialConnectivity, xnumber, periodic);
    }

    public void setNetworkSquareLattice(int nVertices, int m, int xLength, boolean periodic) {
        int v;
        int x1dim;
        if (nVertices > this.maximumVertices) {
            this.maximumVertices = nVertices;
        }
        if ((x1dim = xLength) > nVertices) {
            x1dim = (int)Math.sqrt(nVertices);
        }
        int zdim = (nVertices - 1) / x1dim + 1;
        int e = nVertices * m * 2;
        if (this.maximumStubs < e) {
            this.maximumStubs = e;
        }
        this.setNetwork();
        for (v = 0; v < nVertices; ++v) {
            this.addVertex();
        }
        v = -1;
        int vn = -1;
        int x1n = -1;
        int zn = -1;
        for (int z = 0; z < zdim; ++z) {
            for (int x1 = 0; x1 < x1dim; ++x1) {
                v = x1 + x1dim * z;
                if (v >= nVertices) {
                    return;
                }
                for (int n = 1; n <= m; ++n) {
                    x1n = x1 + n;
                    if ((x1n < x1dim || periodic) && ((vn = x1n % x1dim + x1dim * z) < nVertices || periodic)) {
                        this.addEdge(v, vn % nVertices);
                    }
                    if ((zn = z + n) >= zdim && !periodic || (vn = x1 + x1dim * (zn % zdim)) >= nVertices && !periodic) continue;
                    this.addEdge(v, vn % nVertices);
                }
            }
        }
    }

    public void setNetworkSquareLatticeOLD(int nVertices, int m, int xnumber, boolean periodic) {
        int v;
        if (nVertices > this.maximumVertices) {
            this.maximumVertices = nVertices;
        }
        int ynumber = (nVertices - 1) / xnumber + 1;
        int e = nVertices * m * 4;
        if (this.maximumStubs < e) {
            this.maximumStubs = e;
        }
        this.setNetwork();
        for (v = 0; v < nVertices; ++v) {
            this.addVertex();
        }
        v = -1;
        int vn = -1;
        int xn = -1;
        int yn = -1;
        for (int y = 0; y < ynumber; ++y) {
            for (int x = 0; x < xnumber; ++x) {
                v = x + y * xnumber;
                if (v > nVertices) continue;
                for (int n = 1; n <= m; ++n) {
                    xn = x + n;
                    if ((xn < xnumber || periodic) && ((vn = xn % xnumber + y * xnumber) < nVertices || periodic)) {
                        this.addEdge(v, vn % nVertices);
                    }
                    if ((vn = x + (y + n) * xnumber) >= nVertices && !periodic) continue;
                    this.addEdge(v, vn % nVertices);
                }
            }
        }
    }

    public void setNetworkCubicLattice(boolean periodic) {
        int xnumber = this.initialXsize;
        int ynumber = this.initialYsize;
        if (xnumber < 1) {
            xnumber = (int)(0.5 + Math.pow(this.initialVertices, 0.3333333333333));
        }
        if (ynumber < 1) {
            ynumber = xnumber;
        }
        if (this.initialXsize < 0) {
            xnumber = (int)(0.5 + Math.pow(this.initialVertices, 0.3333333333333));
        }
        this.setNetworkCubicLattice(this.initialVertices, this.initialConnectivity, xnumber, ynumber, periodic);
    }

    public void setNetworkCubicLattice(int nVertices, int m, int xLength, int yLength, boolean periodic) {
        int v;
        int x2dim;
        int x1dim;
        int x12dim;
        if (nVertices > this.maximumVertices) {
            this.maximumVertices = nVertices;
        }
        if ((x12dim = (x1dim = xLength) * (x2dim = yLength)) > nVertices) {
            x2dim = x1dim = (int)Math.sqrt(nVertices);
            x12dim = x1dim * x2dim;
        }
        int zdim = (nVertices - 1) / x12dim + 1;
        int e = nVertices * m * 4;
        if (this.maximumStubs < e) {
            this.maximumStubs = e;
        }
        this.setNetwork();
        for (v = 0; v < nVertices; ++v) {
            this.addVertex();
        }
        v = -1;
        int vn = -1;
        int x1n = -1;
        int x2n = -1;
        int zn = -1;
        for (int z = 0; z < zdim; ++z) {
            for (int x2 = 0; x2 < x2dim; ++x2) {
                for (int x1 = 0; x1 < x1dim; ++x1) {
                    v = x1 + x1dim * (x2 + z * x2dim);
                    if (v >= nVertices) {
                        return;
                    }
                    for (int n = 1; n <= m; ++n) {
                        x1n = x1 + n;
                        if ((x1n < x1dim || periodic) && ((vn = x1n % x1dim + x1dim * (x2 + z * x2dim)) < nVertices || periodic)) {
                            this.addEdge(v, vn % nVertices);
                        }
                        if (((x2n = x2 + n) < x2dim || periodic) && ((vn = x1 + x1dim * (x2n % x2dim + z * x2dim)) < nVertices || periodic)) {
                            this.addEdge(v, vn % nVertices);
                        }
                        if ((zn = z + n) >= zdim && !periodic || (vn = x1 + x1dim * (x2 + zn % zdim * x2dim)) >= nVertices && !periodic) continue;
                        this.addEdge(v, vn % nVertices);
                    }
                }
            }
        }
    }

    public void setNetworkCaveManLine(boolean ring) {
        this.setNetworkCaveManLine(this.initialVertices, this.initialXsize, this.initialConnectivity, ring);
    }

    public void setNetworkCaveManCommonVertex(boolean ring) {
        this.setNetworkCaveManLine(this.initialVertices, this.initialXsize, this.initialConnectivity, ring);
    }

    public void setNetworkCaveManLine(int nVertices, int nCommunities, int m, boolean ring) {
        if (nVertices > this.maximumVertices) {
            this.maximumVertices = nVertices;
        }
        int cSize = nVertices / nCommunities;
        nVertices = nCommunities * cSize;
        int e = (cSize * (cSize - 1) + 2 * m) * nCommunities;
        if (this.maximumStubs < e) {
            this.maximumStubs = e;
        }
        this.setNetwork();
        for (int v = 0; v < nVertices; ++v) {
            this.addVertex();
        }
        int vc = 0;
        for (int c = 0; c < nCommunities; ++c) {
            vc = c * cSize;
            for (int v1 = 0; v1 < cSize; ++v1) {
                for (int v2 = v1 + 1; v2 < cSize; ++v2) {
                    if (v1 == v2) continue;
                    this.addEdge(vc + v1, vc + v2);
                }
            }
            int vn = -1;
            for (int cnn = 1; cnn <= m; ++cnn) {
                vn = (c + cnn) * cSize + this.Rnd.nextInt(cSize);
                if (vn >= nVertices && !ring) continue;
                this.addEdge(vc + this.Rnd.nextInt(cSize), vn %= nVertices);
            }
        }
    }

    public void setNetworkCaveManCommonVertex(int nVertices, int nCommunities, int m, boolean ring) {
        if (nVertices > this.maximumVertices) {
            this.maximumVertices = nVertices;
        }
        int cSize = nVertices / nCommunities;
        nVertices = nCommunities * cSize + (ring ? 0 : 1);
        int e = cSize * (cSize + 1) * nCommunities;
        if (this.maximumStubs < e) {
            this.maximumStubs = e;
        }
        this.setNetwork();
        for (int v = 0; v < nVertices; ++v) {
            this.addVertex();
        }
        int vc = 0;
        int vs = 0;
        int v2 = 0;
        for (int c = 0; c < nCommunities; ++c) {
            vc = c * cSize;
            int vnext = vc + cSize + this.Rnd.nextInt(cSize);
            if (ring) {
                vnext %= nVertices;
            } else if (c >= nVertices) {
                vnext = nVertices - 1;
            }
            for (int v1 = 0; v1 <= cSize; ++v1) {
                int i = 0;
                while (i < m) {
                    vs = this.Rnd.nextInt(cSize + 1);
                    if (vs == cSize) {
                        vs = vnext;
                    }
                    v2 = (vc + vs) % nVertices;
                    this.addEdge(vc + v1, v2);
                    ++e;
                }
            }
        }
    }

    public timgraph projectSubgraph(String projStemName, TreeSet<Integer> sgvertexList, boolean makeDirected, boolean makeLabelled, boolean makeWeighted, boolean makeVertexEdgeList) {
        String extra;
        int stubs = 0;
        for (Integer v : sgvertexList) {
            stubs += this.getVertexDegree(v);
        }
        if (this.directedGraph) {
            stubs += stubs;
        }
        if ((extra = projStemName).length() == 0) {
            extra = "proj";
        }
        timgraph newtg = new timgraph(this.outputName.getNameRoot() + extra, this.outputName.getDirectoryRoot(), this.infoLevel, this.outputControl.getNumber(), makeDirected, makeLabelled, makeWeighted, makeVertexEdgeList, sgvertexList.size(), stubs);
        VertexLabel vl = new VertexLabel();
        TreeMap<Integer, Integer> oldToNew = new TreeMap<Integer, Integer>();
        for (Integer vold : sgvertexList) {
            oldToNew.put(vold, newtg.TotalNumberVertices);
            if (this.infoLevel > 1) {
                System.out.println("old=" + vold + "  new=" + newtg.TotalNumberVertices);
            }
            if (makeLabelled) {
                if (this.vertexlabels) {
                    vl = new VertexLabel(this.vertexLabelList[vold]);
                }
                vl.setNumber(vold);
                newtg.addVertex(vl);
                continue;
            }
            newtg.addVertex();
        }
        int s = -1;
        int t = -1;
        int ns = -1;
        int nt = -1;
        for (int e = 0; e < this.TotalNumberStubs; ++e) {
            s = this.stubSourceList[e];
            t = this.stubSourceList[++e];
            if (!sgvertexList.contains(s) || !sgvertexList.contains(t)) continue;
            ns = (Integer)oldToNew.get(s);
            nt = (Integer)oldToNew.get(t);
            if (this.infoLevel > 1) {
                System.out.println("old=" + s + " " + t + "   new=" + ns + " " + nt);
            }
            if (makeWeighted) {
                if (this.weightedEdges) {
                    newtg.addEdge(ns, nt, this.edgeValuetList[e]);
                    continue;
                }
                newtg.addEdge(ns, nt, new EdgeValue());
                continue;
            }
            newtg.addEdge(ns, nt);
        }
        return newtg;
    }

    void setBiPartite(int nvtype1, int nvtype2, String name1, String name2, int initialisationtype) {
        this.bipartiteGraph = true;
        this.numberVertexType1 = nvtype1;
        this.numberVertexType2 = nvtype2;
        this.initialVertices = nvtype1 + nvtype2;
        int maximumVertices = this.initialVertices + this.numevents;
        this.vertexList = new IntArrayList[maximumVertices];
        this.TotalNumberVertices = 0;
        this.stubSourceList = new int[this.maximumStubs];
        this.TotalNumberStubs = 0;
        for (int i = 0; i < this.initialVertices; ++i) {
            this.addVertex();
        }
        for (int i = 0; i < nvtype1; ++i) {
            int vt;
            int vs;
            switch (initialisationtype) {
                case 1: {
                    vs = i;
                    vt = this.Rnd.nextInt(nvtype2) + nvtype1;
                }
            }
            vs = i;
            vt = nvtype1 + i % nvtype2;
            this.addEdge(vs, vt);
        }
        if (this.numberVertexType1 + this.numberVertexType2 != this.TotalNumberVertices) {
            System.out.println("*** ERROR in setBiPartite: \n                 number of type1 + type 2 vertices  != TotalNumberVertices " + this.initialVertices + SEP + this.TotalNumberVertices);
        }
    }

    public timgraph makeIncidenceGraph() {
        return this.makeIncidenceGraph(this.directedGraph, this.vertexlabels, this.weightedEdges, this.vertexEdgeListOn);
    }

    public timgraph makeIncidenceGraph(boolean makeDirected, boolean makeLabelled, boolean makeWeighted, boolean makeVertexEdgeList) {
        timgraph ig = new timgraph(this.inputName.getNameRoot() + "Inc", this.inputName.getDirectoryRoot(), this.infoLevel, this.outputControl.getNumber());
        ig.setGraphProperties(makeDirected, makeLabelled, makeWeighted, makeVertexEdgeList);
        int nv1 = this.TotalNumberVertices;
        int nv2 = this.TotalNumberStubs / 2;
        int nv = nv1 + nv2;
        int ne = this.TotalNumberStubs * 2;
        if (this.infoLevel > 0) {
            System.out.println("#Type 1 =" + nv1 + ", #Type 2 =" + nv2 + ",  #stubs =" + ne);
        }
        ig.setBipartite(nv1, nv2, "OldVertices", "OldEdges");
        ig.setNetwork(nv, ne);
        for (int v = 0; v < nv1; ++v) {
            if (ig.vertexlabels) {
                if (this.isVertexLabelled()) {
                    ig.addVertex(this.vertexLabelList[v]);
                    continue;
                }
                ig.addVertex("v" + v, v);
                continue;
            }
            this.addVertex();
        }
        for (int e = 0; e < nv2; ++e) {
            if (ig.vertexlabels) {
                ig.addVertex("e" + e * 2);
                continue;
            }
            ig.addVertex();
        }
        if (ig.isWeighted()) {
            System.err.println("*** incidence graph not yet designed for weighted graphs, weighting switched off");
            ig.setWeightedEdges(false);
        }
        int s = -1;
        int t = -1;
        int ve = -1;
        for (int e = 0; e < this.TotalNumberStubs; ++e) {
            s = this.stubSourceList[e++];
            t = this.stubSourceList[e];
            ve = nv1 + e / 2;
            if (this.infoLevel > 0) {
                System.out.println("Old edge " + s + " " + t + ", adding to new edge vertex " + ve);
            }
            ig.addEdge(s, ve);
            ig.addEdge(t, ve);
        }
        return ig;
    }

    public timgraph makeLineGraph(int newtype, boolean makeUndirected) {
        int v;
        if (!this.isVertexEdgeListOn()) {
            throw new RuntimeException("*** makeLineGraph needs vertexEdgeList to be on.");
        }
        if (this.isWeighted()) {
            throw new RuntimeException("*** makeLineGraph does not yet consider weights.");
        }
        int type = 0;
        if (newtype > 0 && newtype < LineGraphProjector.lgExtensionList.length) {
            type = newtype;
        }
        timgraph tg = new timgraph();
        tg.infoLevel = this.infoLevel;
        tg.setVertexEdgeList(true);
        tg.directedGraph = this.directedGraph;
        if (makeUndirected) {
            tg.directedGraph = false;
        }
        tg.weightedEdges = type >= 2;
        tg.vertexlabels = false;
        tg.inputName = new FileNameSequence(this.inputName);
        tg.outputName = new FileNameSequence(this.outputName);
        tg.inputName.appendToNameRoot(LineGraphProjector.lgExtensionList[type]);
        tg.outputName.appendToNameRoot(LineGraphProjector.lgExtensionList[type]);
        int noselfloops = 1;
        int countfactor = -1;
        if (type == 1 || type == 3) {
            countfactor = 1;
            noselfloops = 0;
        }
        tg.maximumVertices = this.getNumberStubs() / 2;
        tg.maximumStubs = 0;
        if (tg.directedGraph) {
            for (v = 0; v < this.getNumberVertices(); ++v) {
                tg.maximumStubs += this.getVertexInDegree(v) * this.getVertexOutDegree(v);
            }
            tg.maximumStubs *= 2;
        } else {
            for (v = 0; v < this.getNumberVertices(); ++v) {
                int k = this.getVertexDegree(v);
                tg.maximumStubs += k * (k + countfactor);
            }
        }
        if (this.infoLevel > -1) {
            System.out.println("Predicting " + tg.maximumVertices + " vertices and " + tg.maximumStubs + " edges in line graph ");
        }
        tg.setNetwork();
        for (v = 0; v < tg.maximumVertices; ++v) {
            tg.addVertex();
        }
        int e1 = -1;
        int e2 = -1;
        double w = 1.0;
        if (this.isDirected()) {
            int kin = -1;
            int kout = -1;
            for (int v2 = 0; v2 < this.getNumberVertices(); ++v2) {
                kin = this.getVertexDegree(v2);
                if (kin < 1 || (kout = this.getVertexDegree(v2)) < 1) continue;
                if (tg.weightedEdges) {
                    w = 1.0 / (double)kout;
                }
                for (int ei = 0; ei < this.vertexInEdgeList[v2].size(); ++ei) {
                    e1 = this.vertexInEdgeList[v2].get(ei);
                    for (int eo = 0; eo < this.vertexEdgeList[v2].size(); ++eo) {
                        e2 = this.vertexEdgeList[v2].get(eo);
                        if (tg.weightedEdges) {
                            tg.increaseEdgeWeight(e1 / 2, e2 / 2, w);
                            continue;
                        }
                        tg.addEdgeUnique(e1 / 2, e2 / 2);
                    }
                }
            }
        } else {
            int kv = -1;
            for (int v3 = 0; v3 < this.getNumberVertices(); ++v3) {
                kv = this.getVertexDegree(v3);
                if (kv <= noselfloops) continue;
                if (tg.weightedEdges) {
                    w = 1.0 / (double)(kv - noselfloops);
                }
                for (int ei = 0; ei < this.vertexEdgeList[v3].size(); ++ei) {
                    e1 = this.vertexEdgeList[v3].get(ei);
                    for (int eo = ei + noselfloops; eo < this.vertexEdgeList[v3].size(); ++eo) {
                        e2 = this.vertexEdgeList[v3].get(eo);
                        if (tg.weightedEdges) {
                            tg.increaseEdgeWeight(e1 / 2, e2 / 2, w);
                            continue;
                        }
                        tg.addEdgeUnique(e1 / 2, e2 / 2);
                    }
                }
            }
        }
        return tg;
    }

    public timgraph makeConsolidated(double minWeight, boolean makeUndirected, boolean makeLabelled, boolean makeWeighted, boolean makeVertexEdgeList) {
        timgraph tg = new timgraph();
        tg.infoLevel = this.infoLevel;
        tg.setVertexEdgeList(makeVertexEdgeList);
        tg.directedGraph = this.directedGraph;
        if (makeUndirected) {
            tg.directedGraph = false;
        }
        tg.weightedEdges = true;
        tg.vertexlabels = makeLabelled;
        tg.inputName = new FileNameSequence(this.inputName);
        tg.outputName = new FileNameSequence(this.outputName);
        tg.maximumVertices = this.TotalNumberVertices;
        tg.maximumStubs = this.TotalNumberStubs;
        tg.setNetwork();
        for (int v = 0; v < tg.maximumVertices; ++v) {
            if (tg.vertexlabels) {
                if (this.isVertexLabelled()) {
                    tg.addVertex(this.vertexLabelList[v]);
                    continue;
                }
                tg.addVertex("v" + v, v);
                continue;
            }
            tg.addVertex();
        }
        int s = -1;
        int t = -1;
        int ns = -1;
        int nt = -1;
        double dw = -1.0;
        for (int e = 0; e < this.TotalNumberStubs; ++e) {
            dw = this.weightedEdges ? this.edgeValuetList[e].weight : 1.0;
            s = this.stubSourceList[e++];
            t = this.stubSourceList[e];
            if (makeUndirected && s > t) {
                tg.increaseEdgeWeight(t, s, dw);
                continue;
            }
            tg.increaseEdgeWeight(s, t, dw);
        }
        if (makeWeighted) {
            return tg;
        }
        return tg.makeUnweighted(minWeight, makeUndirected, makeLabelled, makeVertexEdgeList);
    }

    public timgraph makeUnweighted(double minWeight, boolean makeUndirected, boolean makeLabelled, boolean makeVertexEdgeList) {
        if (!this.weightedEdges) {
            System.err.println("*** timgraph makeUnweighted graph needs original to be weighted.");
            return null;
        }
        timgraph tg = new timgraph();
        tg.infoLevel = this.infoLevel;
        tg.setVertexEdgeList(makeVertexEdgeList);
        tg.directedGraph = this.directedGraph;
        if (makeUndirected) {
            tg.directedGraph = false;
        }
        tg.weightedEdges = false;
        tg.vertexlabels = makeLabelled;
        tg.inputName = new FileNameSequence(this.inputName);
        tg.outputName = new FileNameSequence(this.outputName);
        tg.maximumVertices = this.TotalNumberVertices;
        tg.maximumStubs = 0;
        for (int e = 0; e < this.TotalNumberStubs; ++e) {
            if (!(this.edgeValuetList[e].weight >= minWeight)) continue;
            ++tg.maximumStubs;
        }
        if (this.infoLevel > -1) {
            System.out.println("Predicting " + tg.maximumStubs + " edges in weight cut graph");
        }
        tg.setNetwork();
        for (int v = 0; v < tg.maximumVertices; ++v) {
            if (tg.vertexlabels) {
                if (this.isVertexLabelled()) {
                    tg.addVertex(this.vertexLabelList[v]);
                    continue;
                }
                tg.addVertex("v" + v, v);
                continue;
            }
            tg.addVertex();
        }
        int s = -1;
        int t = -1;
        for (int e = 0; e < this.TotalNumberStubs; ++e) {
            if (this.edgeValuetList[e].weight < minWeight) {
                ++e;
                continue;
            }
            s = this.stubSourceList[e++];
            if (this.edgeValuetList[e].weight < minWeight) continue;
            t = this.stubSourceList[e];
            tg.addEdgeUnweighted(s, t);
        }
        return tg;
    }

    public void makeUnlabelled() {
        this.vertexlabels = false;
        this.vertexLabelList = null;
    }

    public void makeLabelsUnnamed() {
        if (!this.vertexlabels) {
            return;
        }
        for (int v = 0; v < this.maximumVertices; ++v) {
            this.vertexLabelList[v].removeName();
        }
    }

    public timgraph makeRing(String vertexName, int maxDistance, boolean makeUndirected, boolean makeWeighted, boolean makeLabelled, boolean makeVertexEdgeList) {
        int vertex = this.getVertexFromName(vertexName);
        TreeSet<Integer> sgvertexList = this.getRing(vertex, maxDistance);
        if (this.infoLevel > 0) {
            System.out.println("Component of " + this.inputName.getNameRoot() + " centred on vertex " + vertexName + " number " + vertex + " upto distance " + maxDistance + " found " + sgvertexList.size() + " vertices");
        }
        timgraph newgraph = this.projectSubgraph("Ring", sgvertexList, makeUndirected, makeLabelled, makeWeighted, makeVertexEdgeList);
        return newgraph;
    }

    public timgraph makeEdgeSubGraph(String vertexName, boolean makeUndirected, boolean makeWeighted, boolean makeLabelled, boolean makeVertexEdgeList) {
        if (!this.vertexlabels) {
            throw new IllegalArgumentException("graph with labelled vertices needed to make a ring.");
        }
        int vertex = this.getVertexFromName(vertexName);
        HashMap<Integer, Integer> labelSet = this.getEdgeLabelMap(vertex);
        int numberLabels = labelSet.size();
        TreeSet<Integer> sgvertexList = this.getEdgeSubGraph(labelSet.keySet());
        if (this.infoLevel > 0) {
            System.out.println("Component of " + this.inputName.getNameRoot() + " centred on vertex " + vertexName + " number " + vertex + " had " + numberLabels + " different incident edge labels making subset of " + sgvertexList.size() + " vertices");
        }
        timgraph newgraph = this.projectSubgraph("proj", sgvertexList, makeUndirected, makeLabelled, makeWeighted, makeVertexEdgeList);
        newgraph.setNameRoot(newgraph.inputName.getNameRoot() + "_" + vertexName + "ESG");
        return newgraph;
    }

    public HashMap<Integer, Integer> getEdgeLabelMap(int vertex) {
        if (!this.vertexEdgeListOn) {
            throw new IllegalArgumentException("graph with vertex edge list needed in getEdgeLabelMap.");
        }
        if (!this.weightedEdges) {
            throw new IllegalArgumentException("graph with labelled edges needed in getEdgeLabelMap.");
        }
        HashMap<Integer, Integer> labelSet = new HashMap<Integer, Integer>();
        int numberLabels = 0;
        for (int ei = 0; ei < this.getVertexDegree(vertex); ++ei) {
            int e = this.vertexEdgeList[vertex].getQuick(ei);
            int l = this.edgeValuetList[e].label;
            if (labelSet.containsKey(l)) continue;
            labelSet.put(l, numberLabels++);
        }
        return labelSet;
    }

    public TreeSet<Integer> getEdgeLabelSet() {
        if (!this.vertexEdgeListOn) {
            throw new IllegalArgumentException("graph with vertex edge list needed in getEdgeLabelSet.");
        }
        if (!this.weightedEdges) {
            throw new IllegalArgumentException("graph with labelled edges needed in getEdgeLabelSet.");
        }
        TreeSet<Integer> labelSet = new TreeSet<Integer>();
        boolean numberLabels = false;
        for (int e = 0; e < this.TotalNumberStubs; e += 2) {
            labelSet.add(this.edgeValuetList[e].label);
        }
        return labelSet;
    }

    public void relabelEdges(Map<Integer, Integer> labelMap, int notFoundLabel) {
        for (int e = 0; e < this.TotalNumberStubs; e += 2) {
            int l = this.edgeValuetList[e].label;
            Integer newl = labelMap.get(l);
            if (newl == null) {
                newl = notFoundLabel;
            }
            this.edgeValuetList[e].label = newl;
        }
    }

    public int relabelEdges(String vertexName) {
        int vertex = this.getVertexFromName(vertexName);
        HashMap<Integer, Integer> labelSet = this.getEdgeLabelMap(vertex);
        this.relabelEdges(labelSet, labelSet.size());
        return labelSet.size();
    }

    public timgraph makeEdgeLabelToVertexSubGraph(double minimumValue, boolean normaliseOn, boolean useWeights, boolean makeUndirected, boolean makeWeighted, boolean makeLabelled, boolean makeVertexEdgeList) {
        if (!this.weightedEdges) {
            throw new IllegalArgumentException("graph with weighted edges needed to make a vertex set  sub graph based on edge communities.");
        }
        if (!this.vertexEdgeListOn) {
            throw new IllegalArgumentException("graph with vertexEdgeList needed to make a vertex set  sub graph based on edge communities.");
        }
        TreeSet<Integer> sgvertexList = this.edgeLabelToVertexSet(minimumValue, normaliseOn, useWeights);
        timgraph newgraph = this.projectSubgraph("proj", sgvertexList, makeUndirected, makeLabelled, makeWeighted, makeVertexEdgeList);
        newgraph.setNameRoot(newgraph.inputName.getNameRoot() + "_" + "EPTOVPSG");
        return newgraph;
    }

    private int edgeToVertexLabel(int v, double minimumValue, boolean normaliseOn, boolean useWeights) {
        int i;
        double MINNORM = 1.0E-6;
        int k = this.getVertexDegree(v);
        DoubleArrayList strengthInCommunity = new DoubleArrayList(k);
        TreeMap<Integer, Integer> communityToIndex = new TreeMap<Integer, Integer>();
        IntArrayList indexToCommunity = new IntArrayList(k);
        IntArrayList edgeList = this.vertexEdgeList[v];
        double s = 0.0;
        for (int ei = 0; ei < edgeList.size(); ++ei) {
            int e = edgeList.getQuick(ei);
            int c = this.edgeValuetList[e].label;
            double w = useWeights ? this.edgeValuetList[e].weight : 1.0;
            s += w;
            if (communityToIndex.containsKey(c)) {
                i = (Integer)communityToIndex.get(c);
                strengthInCommunity.setQuick(i, strengthInCommunity.getQuick(i) + w);
                continue;
            }
            communityToIndex.put(c, strengthInCommunity.size());
            indexToCommunity.add(c);
            strengthInCommunity.add(w);
        }
        if (s < 1.0E-6) {
            return -789456123;
        }
        int cbest = -789456123;
        if (!normaliseOn) {
            s = 1.0;
        }
        double vmaxValue = minimumValue * s;
        double kd = k;
        for (i = 0; i < indexToCommunity.size(); ++i) {
            int c = indexToCommunity.get(i);
            double sc = strengthInCommunity.getQuick(i);
            if (vmaxValue > sc || vmaxValue == sc && this.Rnd.nextDouble() < 0.5) continue;
            vmaxValue = sc;
            cbest = c;
        }
        return cbest;
    }

    public TreeSet<Integer> edgeLabelToVertexSet(double minimumValue, boolean normaliseOn, boolean useWeights) {
        TreeSet<Integer> vset = new TreeSet<Integer>();
        for (int v = 0; v < this.TotalNumberVertices; ++v) {
            int c = this.edgeToVertexLabel(v, minimumValue, normaliseOn, useWeights);
            if (c < 0) continue;
            vset.add(v);
        }
        return vset;
    }

    public int getRandomBinomial(double average, int N) {
        if (N < 1) {
            return (int)(average + 1.0E-6);
        }
        double total = 0.0;
        for (int n = 0; n < N; ++n) {
            total += this.Rnd.nextDouble();
        }
        return (int)(total * average / (double)N);
    }

    public int getRandomMarkov(double prob, int N) {
        if (N < 0) {
            return -N;
        }
        int n = 0;
        for (n = 0; n < N && !(this.Rnd.nextDouble() > prob); ++n) {
        }
        return n;
    }

    public double calcEllapsedTime(long initialtime) {
        return 1000.0 * (double)(System.currentTimeMillis() - initialtime);
    }

    public int makeEven(int value) {
        return value - (value | 1);
    }

    public class DegreeDistributionOLD {
        String name = "unspecified";
        IntArrayList ddarr;
        int minimum = 9999999;
        int maximum;
        int continuous = this.maximum = -1;
        int totalvertices = 0;
        int totaledges = 0;
        double average = 0.0;
        double secondmoment = 0.0;

        public DegreeDistributionOLD(String inputName) {
            this.ddarr = new IntArrayList();
            this.name = inputName;
        }

        public DegreeDistributionOLD(String inputName, int initialSize) {
            this.ddarr = new IntArrayList(initialSize);
            this.name = inputName;
        }

        void calcDegreeDistribution(IntArrayList[] vlist, int TNV) {
            this.maximum = -1;
            this.ddarr.add(0);
            for (int v = 0; v < TNV; ++v) {
                if (vlist[v] == null) {
                    this.ddarr.set(0, this.ddarr.get(0) + 1);
                    break;
                }
                int k = vlist[v].size();
                timgraph.this.addExtendIntArrayList(this.ddarr, k, 1);
            }
            this.calcValues();
            if (this.totalvertices != TNV) {
                System.out.println("*** Error in calcDegreeDistribution vertex totals mismatch");
                System.out.println("     TNV=" + timgraph.this.TotalNumberVertices + ", calc = " + this.totalvertices);
            }
        }

        void calcDegreeDistribution(IntArrayList[] vlist, IntArrayList[] vsourcelist, int TNV) {
            this.maximum = -1;
            this.ddarr.add(0);
            int k = -1;
            for (int v = 0; v < TNV; ++v) {
                k = 0;
                if (vlist[v] != null) {
                    k = vlist[v].size();
                }
                if (vsourcelist[v] != null) {
                    k += vsourcelist[v].size();
                }
                timgraph.this.addExtendIntArrayList(this.ddarr, k, 1);
            }
            this.calcValues();
            if (this.totalvertices != TNV) {
                System.out.println("*** Error in calcDegreeDistribution vertex totals mismatch");
                System.out.println("     TNV=" + timgraph.this.TotalNumberVertices + ", calc = " + this.totalvertices);
            }
        }

        void calcValues() {
            this.totalvertices = 0;
            this.totaledges = 0;
            int nk = 0;
            double nk2 = 0.0;
            this.continuous = this.maximum + 1;
            this.minimum = 0;
            while (this.ddarr.get(this.minimum) == 0) {
                ++this.minimum;
            }
            for (int k = this.minimum; k < this.ddarr.size(); ++k) {
                nk = this.ddarr.get(k);
                this.totalvertices += nk;
                this.totaledges += nk * k;
                nk2 += (double)(nk * k * k);
                if (nk == 0 && k < this.continuous) {
                    this.continuous = k;
                }
                if (nk <= 0) continue;
                this.maximum = k;
            }
            this.average = (double)this.totaledges / (double)this.totalvertices;
            this.secondmoment = nk2 / (double)this.totalvertices;
        }

        void printDegreeDistribution(String cc, boolean normalise) {
            this.outputDegreeDistribution(System.out, cc, normalise);
        }

        void FileOutputDegreeDistribution(String filenamecomplete, String cc, boolean normalise) {
            try {
                FileOutputStream fout = new FileOutputStream(filenamecomplete);
                PrintStream PS = new PrintStream(fout);
                this.outputDegreeDistribution(PS, cc, normalise);
                if (timgraph.this.infoLevel > -2) {
                    System.out.println("Finished writing " + this.name + " degree distribution to " + filenamecomplete);
                }
                try {
                    fout.close();
                }
                catch (IOException e) {
                    System.out.println("File Error with " + filenamecomplete);
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("Error opening output file " + filenamecomplete);
                return;
            }
        }

        void outputDegreeDistribution(PrintStream PS, String cc, boolean normalise) {
            double p = 0.0;
            int n = 0;
            PS.println(cc + " timgraph" + timgraph.SEP + "version " + timgraph.SEP + timgraph.VERSION + timgraph.SEP + " date " + timgraph.SEP + timgraph.this.date);
            this.outputInformation(PS, cc, 2);
            if (this.totalvertices < 1) {
                return;
            }
            if (normalise) {
                PS.println(cc + " k " + timgraph.SEP + "p(k)    Normalised " + this.name + " Degree Distribution (not reduced = strength)");
            } else {
                PS.println(cc + " k " + timgraph.SEP + "n(k)     Unnormalised " + this.name + " Degree Distribution  (not reduced = strength)");
            }
            for (int k = 0; k < this.ddarr.size(); ++k) {
                if (normalise) {
                    p = (double)this.ddarr.get(k) / (double)this.totalvertices;
                    if (!(p > 0.0)) continue;
                    PS.println(k + timgraph.SEP + p);
                    continue;
                }
                n = (int)((double)this.ddarr.get(k) + 0.5);
                if (n <= 0) continue;
                PS.println(k + timgraph.SEP + n);
            }
        }

        public void outputInformation(PrintStream PS, String cc, int dec) {
            PS.println(cc + "Degree" + timgraph.SEP + "distribution" + timgraph.SEP + this.name);
            PS.println(cc + timgraph.SEP + "Total Vertices" + timgraph.SEP + this.totalvertices + timgraph.SEP + "Total Edges" + timgraph.SEP + this.totaledges);
            PS.println(cc + timgraph.SEP + "k_min" + timgraph.SEP + "k_cont" + timgraph.SEP + "k_max" + timgraph.SEP + "<k>" + timgraph.SEP + "<k^2>");
            PS.println(cc + timgraph.SEP + this.minimum + timgraph.SEP + this.continuous + timgraph.SEP + this.maximum + timgraph.SEP + NumbersToString.toString((double)this.average, (int)dec) + timgraph.SEP + NumbersToString.toString((double)this.secondmoment, (int)dec));
        }
    }

    public class StatQuant {
        double total = 0.0;
        double squaretotal = 0.0;
        int count = 0;
        double average = 0.0;
        double sigma = 0.0;
        double error = 0.0;
        double secondmoment = 0.0;

        public void add(double x) {
            this.total += x;
            this.squaretotal += x * x;
            ++this.count;
            this.average = this.total / (double)this.count;
            this.secondmoment = this.squaretotal / (double)this.count;
            if (this.count > 1) {
                this.sigma = (this.secondmoment - this.average * this.average) / Math.sqrt(this.count - 1);
                this.error = this.sigma / Math.sqrt(this.count);
            } else {
                this.sigma = 0.0;
                this.error = 0.0;
            }
        }
    }
}

