/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.io.FileOutput;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import java.util.TreeSet;

public class WordAssociationClique {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public static void main(String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        String name = "SFWANPDFV05cons025";
        int ano = 0;
        if (args.length > ano && args[ano].charAt(0) == '*') {
            name = args[ano].substring(1, args[ano].length());
        }
        String wordName = "bright";
        if (args.length > ++ano && args[ano].charAt(0) == '*') {
            wordName = args[ano].substring(1, args[ano].length());
        }
        double min = 0.9;
        if (args.length > ++ano && args[ano].charAt(0) == '*') {
            min = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        boolean normaliseOn = min < 1.0;
        System.out.println("--- Looking at file name " + name + " for subgraph centred on word " + wordName + ", " + (normaliseOn ? "fractional " : "absolute ") + "cutoff " + min);
        String[] aList = new String[]{"-gvet", "-gdf", "-gewt", "-gelt", "-gvlt", "-fin" + name, "-fieinputELS.dat", "-gn99", "-e0", "-o11", "-xi0"};
        timgraph big = setnet.setUpNetwork(name, aList, infoLevel);
        if (infoLevel > 0 && big.getNumberVertices() < 20) {
            big.printNetwork(true);
        }
        TreeSet<Integer> labelSet = big.getEdgeLabelSet();
        int numberLabelsBig = labelSet.size();
        System.out.println("Network " + big.inputName.getNameRoot() + " has " + numberLabelsBig + " distinct labels");
        FileOutput fobig = new FileOutput(big);
        fobig.printEdges(true, false, false, false, true);
        fobig.graphMLEdgePartition(numberLabelsBig);
        tg = big.makeEdgeSubGraph(wordName, false, true, big.isVertexLabelled(), big.isVertexEdgeListOn());
        tg.printParametersBasic();
        if (infoLevel > 0 && tg.getNumberVertices() < 20) {
            tg.printNetwork(true);
        }
        int numberLabels = tg.relabelEdges(wordName);
        System.out.println("Network " + WordAssociationClique.tg.inputName.getNameRoot() + " has " + numberLabels + " distinct labels around word " + wordName);
        labelSet = tg.getEdgeLabelSet();
        int numberLabelsTotal = labelSet.size();
        System.out.println("Network " + WordAssociationClique.tg.inputName.getNameRoot() + " has " + numberLabelsTotal + " distinct labels ");
        FileOutput fo = new FileOutput(tg);
        fo.informationGeneral("", SEP);
        fo.printEdges(true, false, false, false, true);
        fo.graphMLEdgePartition(numberLabels);
        boolean splitBipartite = false;
        boolean outputType1 = false;
        fo.printEdgeCommunityStats(true, true, splitBipartite, outputType1);
        int imin = (int)(min * 1000.0);
        TreeSet<Integer> sgvertexList = tg.edgeLabelToVertexSet(min, normaliseOn, false);
        int vvv = tg.getVertexFromName(wordName);
        sgvertexList.add(vvv);
        timgraph newgraph = tg.projectSubgraph("", sgvertexList, tg.isDirected(), tg.isVertexLabelled(), tg.isWeighted(), tg.isVertexEdgeListOn());
        String ending = normaliseOn ? "f" + (int)(min * 1000.0) : "a" + min;
        newgraph.setNameRoot(newgraph.inputName.getNameRoot() + "_" + "EP2VC" + ending);
        labelSet = newgraph.getEdgeLabelSet();
        numberLabelsTotal = labelSet.size();
        System.out.println("Network " + newgraph.inputName.getNameRoot() + " has " + numberLabelsTotal + " distinct labels ");
        FileOutput fon = new FileOutput(newgraph);
        fon.informationGeneral("", SEP);
        fon.graphMLEdgePartition(numberLabels);
        splitBipartite = false;
        outputType1 = false;
        fon.printEdgeCommunityStats(true, true, splitBipartite, outputType1);
    }

    static {
        infoLevel = 2;
    }
}

