/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.Community;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.VertexPartition;
import TimGraph.io.FileOutput;
import TimGraph.run.LineGraphCommunities;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class VertexCommunities {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public VertexCommunities(timgraph newtg) {
        tg = newtg;
    }

    public static void usage(PrintStream PS) {
        char arg = timgraph.NOT_TIMGRAPH_ARGUMENT[0];
        PS.println("VertexCommunities " + arg + "<filename> " + arg + "<method> " + arg + "<lineGraphType> " + arg + "<quality> " + arg + "<lambda> -<timgraphArgument> ...");
        PS.println("Arguments for this class start with any of " + timgraph.otherArguments(", ") + ", but " + arg + " used for example here.");
        PS.println("First " + arg + " argument is the network number for the setup routine OR ? for this help");
        PS.println("Second " + arg + " argument is the method used to find communities, 0=Louvain/Greedy, 1= Simulated Annealing");
        PS.println("Third " + arg + " argument is definition of quality to use, 0=Q(A), 1=Q(A" + arg + "A-A)");
        PS.println("Fourth " + arg + " argument is type of quality class to use, 0=basic (dense matrix), 1=sparse matrix, 2=minimal memory ");
        PS.println("Fifth " + arg + " argument is value of lambda, scaling parameter of null model.");
        PS.println("Remaining arguments should start with a - and are parsed by <tt>timgraph</tt>.");
        SetUpNetwork.printNetworkTypes(PS, "", "  ");
    }

    public static void main(String[] args) {
        System.out.println("VertexCommunities Arguments :<networknumber> :<method> :<qualitydef> :<qualitytype> :<lambdaMin> :<lambdaMax> :<lambdaStep>");
        int n = 201;
        int ano = 0;
        if (args.length > ano) {
            if (timgraph.isOtherArgument(args[ano])) {
                if (args[ano].charAt(1) == '?') {
                    VertexCommunities.usage(System.out);
                    return;
                }
                n = Integer.parseInt(args[ano].substring(1, args[ano].length()));
            } else {
                n = 0;
            }
        }
        System.out.println("--- Using network  " + SetUpNetwork.typeString(n));
        int method = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            method = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Using community method " + LineGraphCommunities.COMMUNITYMETHOD[method]);
        int qdef = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            qdef = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[qdef]);
        int qualityType = 1;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            qualityType = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[qualityType]);
        double lambdaMin = 1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            lambdaMin = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double lambdaMax = lambdaMin + 1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            lambdaMax = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double minStep = 0.001;
        double lambdaStep = lambdaMax - lambdaMin;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            lambdaStep = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        if (Math.abs(lambdaStep) < minStep) {
            throw new RuntimeException("Step size must be greater than " + minStep + " in magnitude");
        }
        System.out.println("--- Modularity null model scaling lambda min, max step =" + lambdaMin + "  " + lambdaMax + "  " + lambdaStep);
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        tg = SetUpNetwork.setUpNetwork(n, args);
        tg.calcStrength();
        FileOutput fo = new FileOutput(tg);
        fo.fileName.setNameEnd("lambda_" + lambdaMin + "_" + lambdaMax + "_" + lambdaStep + ".dat");
        try {
            FileOutputStream fout = new FileOutputStream(fo.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            Community c = new Community(tg, qdef, lambdaMin, qualityType, infoLevel);
            PS.println("name\t" + c.informationNumbersLabel("", SEP));
            boolean graphMLOutput = false;
            for (double lambda = lambdaMin; lambda <= lambdaMax && !(lambda <= 0.0); lambda += lambdaStep) {
                System.out.println("-------------------------------------------------------");
                VertexPartition vp = VertexCommunities.calculateVertexPartition(tg, qdef, qualityType, lambda, method, infoLevel, graphMLOutput);
                PS.println(vp.getName() + SEP + vp.informationNumbers("", SEP));
            }
            if (infoLevel > -2) {
                System.out.println("Finished writing VP various lambda information file to " + fo.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fo.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public static VertexPartition calculateVertexPartition(timgraph tg, int qdef, int qualityType, double lambda, int method, int infoLevel, boolean graphMLOutput) {
        FileOutput fo = new FileOutput(tg);
        VertexPartition vp = VertexPartition.calculate(tg, qdef, qualityType, lambda, method, infoLevel);
        tg.setVertexNumbers(vp);
        fo.informationPartition(vp, "", SEP, true);
        fo.printPartitionStats(vp, "", SEP, true, true);
        fo.printVertices("", SEP, false, true, vp, false);
        fo.printVertices("", SEP, false, false, vp, true);
        fo.informationGeneral("", SEP);
        if (tg.outputControl.pajekFileOn) {
            fo.pajekPartition(vp.getName() + ".clu", vp);
        }
        if (graphMLOutput) {
            fo.graphMLVertexPartition(vp);
        }
        timgraph projg = vp.getVertexPartitionGraph();
        fo = new FileOutput(projg);
        fo.informationGeneral("", SEP);
        fo.graphML();
        return vp;
    }

    static {
        infoLevel = 0;
    }
}

