/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimUtilities.FileUtilities.FileNameSequence;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.TreeSet;

public class UniversityOrganisation {
    public static final String[] levelName = new String[]{"Faculty", "Department", "Section"};
    public static final String[] levelNamePlural = new String[]{"Faculties", "Departments", "Sections"};
    static final int NUMBERLEVELS = levelName.length;
    static final String NOUNIT = "(NO UNIT)";
    static final String NO_UNIT = "(NO_UNIT)";
    TreeSet<String> facultySet = new TreeSet();
    TreeSet<String> departmentSet = new TreeSet();
    TreeSet<String> sectionSet = new TreeSet();
    ArrayList<String> faculty;
    ArrayList<String> department;
    ArrayList<String> section;
    boolean fixedSections = false;
    int nMax = -1;
    int infoLevel = 0;

    public UniversityOrganisation() {
        this.facultySet.add(NOUNIT);
        this.departmentSet.add(NOUNIT);
        this.sectionSet.add(NOUNIT);
    }

    public void addSection(String newfaculty, String newdepartment, String newsection) {
        if (this.fixedSections) {
            throw new RuntimeException("Sections fixed, can not add more sections");
        }
        String sec = UniversityOrganisation.cleanUp(newsection);
        this.sectionSet.add(sec);
        String fac = UniversityOrganisation.cleanUp(newfaculty);
        this.facultySet.add(fac);
        String dept = UniversityOrganisation.cleanUp(newdepartment);
        if (dept.equals(NOUNIT) && !sec.equals(NOUNIT)) {
            dept = fac;
        }
        this.departmentSet.add(dept);
    }

    public static String cleanUp(String input) {
        if (input.length() == 0 || input.equals("")) {
            return NOUNIT;
        }
        if (input.charAt(0) < 'A') {
            if (input.charAt(input.length() - 1) < 'A') {
                return input.substring(1, input.length() - 1);
            }
            return input.substring(1);
        }
        return input;
    }

    public static String toFileName(String input) {
        String fn = UniversityOrganisation.cleanUp(input);
        fn = fn.replace(" ", "_");
        fn = fn.replace("&", "and");
        return fn;
    }

    public void finishSetUp() {
        this.fixedSections = true;
        this.nMax = this.sectionSet.size() * this.departmentSet.size() * this.facultySet.size();
        this.faculty = new ArrayList<String>(this.facultySet);
        this.department = new ArrayList<String>(this.departmentSet);
        this.section = new ArrayList<String>(this.sectionSet);
    }

    public int getNumber(int level) {
        switch (level) {
            case 0: {
                return this.faculty.size();
            }
            case 1: {
                return this.department.size();
            }
            case 2: {
                return this.section.size();
            }
        }
        return -1;
    }

    public int[] unitIndices(int n) {
        int nfaculty;
        int ndepartment;
        int nsection;
        if (n < 0) {
            throw new RuntimeException("Section index must not be negative");
        }
        if (n >= this.nMax) {
            throw new RuntimeException("Section index too large, maximum is " + this.nMax);
        }
        int[] s = new int[NUMBERLEVELS];
        s[2] = nsection = n % this.section.size();
        int nd = n / this.section.size();
        s[1] = ndepartment = nd % this.department.size();
        int nf = nd / this.department.size();
        s[0] = nfaculty = nf % this.department.size();
        return s;
    }

    public String getLevelName(int level) {
        if (level < 0 || level >= NUMBERLEVELS) {
            throw new RuntimeException("Level must not be negative or less than " + NUMBERLEVELS + ", given level " + level);
        }
        return levelName[level];
    }

    public String getLevelNamePlural(int level) {
        if (level < 0 || level >= NUMBERLEVELS) {
            throw new RuntimeException("Level must not be negative or less than " + NUMBERLEVELS + ", given level " + level);
        }
        return levelNamePlural[level];
    }

    public String getNameFromLocalIndex(int n, int level) {
        switch (level) {
            case 0: {
                return this.faculty.get(n);
            }
            case 1: {
                return this.department.get(n);
            }
            case 2: {
                return this.section.get(n);
            }
        }
        throw new RuntimeException("Level must not be negative or less than " + NUMBERLEVELS + ", given level " + level);
    }

    public String getNameFromGlobalIndex(int ng, int level) {
        int nl = this.getLocalIndexFromGlobal(ng, level);
        return this.getNameFromLocalIndex(nl, level);
    }

    public String[] getName(int n) {
        if (n < 0) {
            throw new RuntimeException("Section index must not be negative");
        }
        if (n >= this.nMax) {
            throw new RuntimeException("Section index too large, maximum is " + this.nMax);
        }
        int[] index = this.unitIndices(n);
        String[] s = new String[NUMBERLEVELS];
        for (int level = 0; level < NUMBERLEVELS; ++level) {
            s[level] = this.getNameFromGlobalIndex(n, level);
        }
        return s;
    }

    public String[] getName(int n, int maxLevel) {
        if (maxLevel < 0 || maxLevel >= NUMBERLEVELS) {
            throw new RuntimeException("Level must be between 0 and " + NUMBERLEVELS);
        }
        if (n < 0) {
            throw new RuntimeException("Section index must not be negative");
        }
        if (n >= this.nMax) {
            throw new RuntimeException("Section index too large, maximum is " + this.nMax);
        }
        int[] index = this.unitIndices(n);
        String[] s = new String[maxLevel + 1];
        for (int level = 0; level < maxLevel + 1; ++level) {
            s[level] = this.getNameFromGlobalIndex(n, level);
        }
        return s;
    }

    public int getLocalIndexFromGlobal(int n, int level) {
        if (n < 0) {
            throw new RuntimeException("Section index must not be negative");
        }
        if (n >= this.nMax) {
            throw new RuntimeException("Section index too large, maximum is " + this.nMax);
        }
        if (level < 0 || level >= NUMBERLEVELS) {
            throw new RuntimeException("Level must not be negative or less than " + NUMBERLEVELS + ", given level " + level);
        }
        int nl = n;
        for (int l = NUMBERLEVELS - 1; l > level; --l) {
            nl /= this.getNumber(l);
        }
        return nl % this.getNumber(level);
    }

    public boolean isInUnit(int nglobal, int nlocal, int level) {
        int nl = this.getLocalIndexFromGlobal(nglobal, level);
        return nl == nlocal;
    }

    public boolean testGlobalIndex(int n) {
        return n >= 0 && n < this.nMax;
    }

    public int getFilterFactor(int level) {
        int f = 1;
        for (int l = level + 1; l < levelName.length; ++l) {
            f *= this.getNumber(l);
        }
        return f;
    }

    public int getUnitIndex(String faculty, String department, String section) {
        String[] s = new String[]{faculty, department, section};
        return this.getUnitIndex(s);
    }

    public int getUnitIndex(String[] s) {
        if (s.length == 0) {
            return -2;
        }
        if (s.length > NUMBERLEVELS) {
            throw new RuntimeException("Section level " + s.length + "too large, maximum level is " + NUMBERLEVELS);
        }
        int nf = this.getSection(s[0], this.faculty);
        int nd = 0;
        if (s.length > 0) {
            nd = this.getSection(s[1], this.department);
        }
        int ns = 0;
        if (s.length > 1) {
            ns = this.getSection(s[2], this.section);
        }
        if (nd == 0 && ns > 0) {
            nd = nf;
        }
        if (nf < 0 || nd < 0 || ns < 0) {
            return -1;
        }
        return ns + this.section.size() * (nd + this.department.size() * nf);
    }

    private int getSection(String s, ArrayList<String> array) {
        String s2 = UniversityOrganisation.cleanUp(s);
        for (int n = 0; n < array.size(); ++n) {
            if (!array.get(n).equalsIgnoreCase(s2)) continue;
            return n;
        }
        return -1;
    }

    public String informationSetString(String sep) {
        return "Number Faculties " + sep + this.facultySet.size() + sep + "Number Departments" + sep + this.departmentSet.size() + sep + "Number Sections " + sep + this.sectionSet.size();
    }

    public String informationString(String sep) {
        return "Number Faculties " + sep + this.faculty.size() + sep + "Number Departments" + sep + this.department.size() + sep + "Number Sections " + sep + this.section.size();
    }

    public String levelNameString(String sep) {
        String s = levelName[0];
        for (int l = 1; l < levelName.length; ++l) {
            s = sep + levelName[l];
        }
        return s;
    }

    private void printNames(PrintStream PS, String sep, ArrayList<String> array, boolean headerOn, String levelName) {
        if (headerOn) {
            PS.println("Index" + sep + "Name" + (levelName.length() > 0 ? sep + "Level" : ""));
        }
        String levelString = "";
        if (levelName.length() > 0) {
            levelString = sep + levelName;
        }
        for (int n = 0; n < array.size(); ++n) {
            PS.println(n + sep + array.get(n) + levelString);
        }
    }

    public void printNames(PrintStream PS, String sep, int level, boolean headerOn, boolean levelOn) {
        if (headerOn) {
            PS.println("Index" + sep + "Name" + (levelOn ? sep + "Level" : ""));
        }
        switch (level) {
            case 0: {
                this.printNames(PS, sep, this.faculty, headerOn, levelOn ? "faculty" : "");
                return;
            }
            case 1: {
                this.printNames(PS, sep, this.department, headerOn, levelOn ? "department" : "");
                return;
            }
            case 2: {
                this.printNames(PS, sep, this.section, headerOn, levelOn ? "section" : "");
                return;
            }
        }
        throw new RuntimeException("level " + level + " unknown, must be between 0 and " + (NUMBERLEVELS - 1));
    }

    public void printAllNames(PrintStream PS, String sep, boolean headerOn, boolean levelOn) {
        if (headerOn) {
            PS.println("Index" + sep + "Name" + (levelOn ? sep + "Level" : ""));
        }
        for (int l = 0; l < NUMBERLEVELS; ++l) {
            this.printNames(PS, sep, l, false, levelOn);
        }
    }

    public void outputFile(FileNameSequence fns, String sep, boolean headerOn, boolean levelOn) {
        fns.setNameEnd("organisation.dat");
        this.outputFile(fns.getFullFileName(), sep, headerOn, levelOn);
    }

    public void outputFile(String fullfilename, String sep, boolean headerOn, boolean levelOn) {
        if (this.infoLevel > -2) {
            System.out.println("Writing list of all known units to " + fullfilename);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullfilename);
            PrintStream PS = new PrintStream(fout);
            this.printAllNames(PS, sep, headerOn, levelOn);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing list of all known units to " + fullfilename);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + fullfilename + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fullfilename + ", " + e.getMessage());
            return;
        }
    }
}

