/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.timgraph;
import TimUtilities.FileUtilities.FileOutput;
import TimUtilities.StringUtilities.Filters.ImperialPapersFilter;
import TimUtilities.StringUtilities.Filters.StringFilter;
import TimUtilities.StringUtilities.Filters.TextFileProcessor;
import java.util.TreeMap;

public class TitleProcessor {
    public static void process(timgraph tg, String basicFileName, boolean convertIgnoreColumn, int numberLinesToSkip, boolean showProcess) {
        String preStemmedFileName = tg.inputName.getDirectoryFull() + basicFileName + "ptinputBVNLS.dat";
        String outputroot = basicFileName + (convertIgnoreColumn ? "np" : "") + (numberLinesToSkip > 1 ? Integer.valueOf(numberLinesToSkip) : "") + "stem";
        String postStemmedFileName = tg.inputName.getDirectoryFull() + outputroot + "ptinputBVNLS.dat";
        TreeMap stemMap = new TreeMap();
        TreeMap acceptedCountMap = new TreeMap();
        int columnIgnored = 1;
        String sep = "\t";
        ImperialPapersFilter ipf = new ImperialPapersFilter(2, 3, true);
        TextFileProcessor.processWordListFile((String)preStemmedFileName, (String)postStemmedFileName, (int)columnIgnored, (boolean)convertIgnoreColumn, (String)"\t ", stemMap, acceptedCountMap, (StringFilter)ipf, (int)numberLinesToSkip, (boolean)false);
        System.out.println("Stemming file " + preStemmedFileName + ", taking every " + numberLinesToSkip + " lines only, paper gid " + (convertIgnoreColumn ? "converted to simple index" : "left as original string"));
        System.out.println("Applied " + ipf.description());
        System.out.println("Producing file " + postStemmedFileName);
        String outputFileName = tg.outputName.getDirectoryFull() + outputroot + "ptStemMap.dat";
        FileOutput.FileOutputMap((String)outputFileName, (String)sep, stemMap, (boolean)true);
        outputFileName = tg.outputName.getDirectoryFull() + outputroot + "ptRejectList.dat";
        ipf.FileOutputRejectedList(outputFileName, showProcess);
    }
}

