/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.run.BasicAnalysis;
import TimGraph.run.ImperialPapers.General;
import TimGraph.timgraph;
import java.io.PrintStream;
import java.util.TreeSet;

public class SetUpNetwork {
    public static final String SEP = "\t ";
    static int infoLevel = 0;
    static int outputControlNumber = 0;
    static int graphType = 0;
    static String dirRoot = System.getProperty("user.dir");
    static final String[] type = new String[]{"EcoOrg1", "RAEmanGCC", "RAEman", "ICteststempp", "ICstempp", "ICNSstemppUL", "ICNSnpstempp", "ICNSstempp", "ICpsectest", "ICpsec", "ICpdept", "ICteststemtt ", "ICstemttew0500", "ICstemttew0200", "ICstemtt", "ICNSstemttew2000", "ICNSstemttew1500", "ICNSstemttew1250", "ICNSstemttew1000", "ICNS10stemtt", "ICNSstemtt", "ICtestpt", "ICNStest2pt", "ICNSpttest", "ICpt", "ICstempt", "ICNS10stempt", "ICNSpt", "ICNSstempt", "hepphcit", "hepthcit", "FCommon", "CondMatGCC", "CondMat", "WordAssociationPDFV05Bright5", "WordAssociationPDFV05Bright4", "WordAssociationPDFV05Bright3", "WordAssociationPDFV05Bright2", "WordAssociationPDFV05Bright1", "WordAssociationPDFV05", "WordAssociationTest", "WordAssociationBright4", "WordAssociationBright3", "WordAssociationBright2", "WordAssociationBright1", "WordAssociation", "MacTutor", "NetScience", "NetScienceGCC", "NetScienceTest", "KarateClub", "KarateClubUCIuw", "KarateClubUCIw", "CaveMan4x8m1Ring", "CaveMan4x8m4Ring", "CaveMan8x4m1Ring", "CaveMan8x4m4Ring", "CaveManCV8x4m4Ring", "CaveManCV8x8m4Ring", "Line8K1", "Line8K2", "dBowTie", "LongBowTie", "BowTie", "(default) read in from specified file."};
    static final String[] longType = new String[]{"EcoOrg1", "RAEmanGCC GCC of Author-Author projection from Management RAE submissions", "RAEman Author-Author projection from Management RAE submissions", "ICteststempp Imperial test paper-paper weighted network", "ICstempp Imperial all paper-paper weighted network", "ICNSnpstempp Imperial Natural Sciences numbered papers all paper-paper unlabelled weighted network", "ICNSstempp Imperial Natural Sciences all paper-paper unlabelled weighted network", "ICNSstempp Imperial Natural Sciences all paper-paper weighted network", "ICpsectest Imperial paper-section test bipartite network", "ICpsec Imperial paper-section bipartite network", "ICpdeptImperial paper-dept bipartite network", "ICteststemtt Imperial test stemmed term-term weighted network", "ICstemttew0500 Imperial terms-terms weighted network, weights >= 4.0", "ICstemttew0200 Imperial terms-terms weighted network, weights >= 2.0", "ICstemtt Imperial all terms-terms weighted network", "ICNSstemttew2000 Imperial Natural Sciences terms-terms weighted network, weights >= 2.0", "ICNSstemttew1500 Imperial Natural Sciences terms-terms weighted network, weights >= 1.5", "ICNSstemttew1250 Imperial Natural Sciences terms-terms weighted network, weights >= 1.25", "ICNSstemttew1000 Imperial Natural Sciences terms-terms weighted network, weights >= 1.0", "ICNS10stemtt Imperial Natural Sciences 1 in 10 terms-terms weighted network", "ICNSstemtt Imperial Natural Sciences all terms-terms weighted network", "ICtestpt test file for Imperial papers-terms network", "ICNStest2pt test 2 file for Imperial Natural Sciences papers-terms network", "ICNSpttest test file for Imperial Natural Sciences papers-terms network", "ICpt Imperial papers-terms(unstemmed) network", "ICstempt Imperial papers-stemmed terms network", "ICNS10stempt Imperial Natural Sciences 1 in 10 papers-stemmed terms network", "ICNSpt Imperial Natural Sciences papers-terms(unstemmed) network", "ICNSstempt Imperial Natural Sciences papers-stemmed terms network", "hep-ph-citation, labels are randomly chosen permutation of 1..9999 numbers", "hep-th-citation labels are arXiv numbers", "Shaid's Fortran subroutine - common block bipartite network", "Newman's weighted author-author cond-mat based graph", "GCC of  Newman's weighted author-author cond-mat based graph", "WordAssociationBright5 in PDFV05 format (Words within 5 steps of Bright in South Florida data)", "WordAssociationBright4 in PDFV05 format (Words within 4 steps of Bright in South Florida data)", "WordAssociationBright3 in PDFV05 format (Words within 3 steps of Bright in South Florida data)", "WordAssociationBright2 in PDFV05 format (Words within 2 steps of Bright in South Florida data)", "WordAssociationBright1 in PDFV05 format (Words within 1 steps of Bright in South Florida data)", "WordAssociation in PDFV05 format", "WordAssociation Test (Some Aardvark connected words South Florida data)", "WordAssociationBright4 (Words within 4 steps of Bright in South Florida data)", "WordAssociationBright3 (Words within 3 steps of Bright in South Florida data)", "WordAssociationBright2 (Words within 2 steps of Bright in South Florida data)", "WordAssociationBright1 (Words within 1 steps of Bright in South Florida data)", "WordAssociation (South Florida data)", "MacTutor", "Newman's weighted author-author network science based graph", "GCC of Newman's weighted author-author network science based graph", "NetScience Test network", "Unweighted Zachary Karate Club from Newman", "Unweighted Zachary Karate Club from UCInet", "Weighted Zachary Karate Club from UCInet", "CaveMan4x8m1Ring", "CaveMan4x8m4Ring", "CaveMan8x4m1Ring", "CaveMan8x4m4Ring", "CaveManCV8x4m4Ring", "CaveManCV8x8m4Ring", "Line of eight vertices with connections to nearest-neighbours", "Line of eight vertices with connections to nearest-neighbours and next-nearest-neighbours", "directed Bow Tie", "Bow Tie with edge between two triangles, 6 vertices 7 edges", "Standard 5 vertex 6 edge Bow Tie graph", "(default) read in from file specified by timgrph arguments"};
    static final int[] typeNumber = new int[]{210, 201, 200, 149, 145, 142, 141, 140, 139, 131, 130, 129, 128, 127, 126, 125, 124, 123, 122, 121, 120, 119, 118, 117, 114, 113, 112, 111, 110, 101, 100, 90, 81, 80, 75, 74, 73, 72, 71, 70, 69, 64, 63, 62, 61, 60, 50, 40, 41, 42, 30, 31, 32, 20, 21, 22, 23, 24, 25, 11, 10, 3, 2, 1, 0};

    public SetUpNetwork(int infol) {
        infoLevel = infol;
    }

    public static void main(String[] args) {
        SetUpNetwork.printNetworkTypes(System.out, "", "\t");
    }

    public timgraph setUpNetwork(String name, String[] args, int infol) {
        timgraph tg = new timgraph(args);
        dirRoot = tg.inputName.getDirectoryRoot();
        SetUpNetwork.initialise(tg, name, args, infol);
        return tg;
    }

    public timgraph setUpNetwork(String name, String[] args) {
        timgraph tg = new timgraph(args);
        dirRoot = tg.inputName.getDirectoryRoot();
        SetUpNetwork.initialise(tg, name, args, 0);
        return tg;
    }

    public static timgraph setUpNetwork(int n, String[] args) {
        timgraph tg = new timgraph(args);
        graphType = n;
        if (args.length > 0 && args[0].charAt(0) == '*') {
            graphType = Integer.parseInt(args[0].substring(1, args[0].length()));
        }
        System.out.println("\n*** SetUpNetwork class, network type " + graphType + " = " + SetUpNetwork.typeString(graphType));
        dirRoot = tg.inputName.getDirectoryRoot();
        String rootName = "RAEman";
        boolean ICconvertPaperID = false;
        String ICDateString = "090729";
        boolean useGID = true;
        String ICDateStringnp = ICDateString + (useGID ? "" : "np");
        switch (graphType) {
            case 210: {
                rootName = "MATRIXSNAVSMSystem1";
                boolean makeDirected = false;
                boolean makeLabelled = true;
                boolean makeWeighted = true;
                boolean makeVertexEdgeList = true;
                boolean getGCC = graphType != 211;
                return SetUpNetwork.setUpELS(rootName, getGCC, infoLevel, outputControlNumber, makeDirected, makeLabelled, makeWeighted, makeVertexEdgeList);
            }
            case 200: 
            case 201: {
                rootName = "RAEman";
                boolean makeDirected = false;
                boolean makeLabelled = true;
                boolean makeWeighted = true;
                boolean makeVertexEdgeList = true;
                boolean getGCC = graphType != 200;
                return SetUpNetwork.setUpELS(rootName, getGCC, infoLevel, outputControlNumber, makeDirected, makeLabelled, makeWeighted, makeVertexEdgeList);
            }
            case 149: {
                SetUpNetwork.setUpICstem(tg, "ICtest", 1, "pp");
                break;
            }
            case 145: {
                SetUpNetwork.setUpICstem(tg, "IC" + ICDateStringnp, 1, true, "pp");
                break;
            }
            case 142: {
                String weightCut = "0010";
                SetUpNetwork.setUpICnpDateStemEW(tg, "ICNS" + ICDateStringnp, 1, "pp", "ew1000");
                break;
            }
            case 141: {
                SetUpNetwork.setUpICstem(tg, "ICNS" + ICDateStringnp, 1, true, "pp");
                break;
            }
            case 140: {
                SetUpNetwork.setUpICstem(tg, "ICNS" + ICDateStringnp, 1, "pp");
                break;
            }
            case 139: {
                SetUpNetwork.setUpICpunit(tg, "ICtest_psec");
                break;
            }
            case 131: {
                SetUpNetwork.setUpICpunit(tg, "IC20090521_psec");
                break;
            }
            case 130: {
                SetUpNetwork.setUpICpunit(tg, "IC20090521_pdept");
                break;
            }
            case 129: {
                SetUpNetwork.setUpICstem(tg, "ICtest", 1, "tt");
                break;
            }
            case 128: {
                SetUpNetwork.setUpICstem(tg, "IC" + ICDateStringnp, 1, "ttew0500");
                break;
            }
            case 127: {
                SetUpNetwork.setUpICstem(tg, "IC" + ICDateStringnp, 1, "ttew0200");
                break;
            }
            case 126: {
                SetUpNetwork.setUpICstem(tg, "IC" + ICDateStringnp, 1, "tt");
                break;
            }
            case 125: {
                SetUpNetwork.setUpICstem(tg, "ICNS" + ICDateStringnp, 1, "ttew2000");
                break;
            }
            case 124: {
                SetUpNetwork.setUpICstem(tg, "ICNS" + ICDateStringnp, 1, "ttew1500");
                break;
            }
            case 123: {
                SetUpNetwork.setUpICstem(tg, "ICNS" + ICDateStringnp, 1, "ttew1250");
                break;
            }
            case 122: {
                SetUpNetwork.setUpICstem(tg, "ICNS" + ICDateStringnp, 1, "ttew1000");
                break;
            }
            case 121: {
                SetUpNetwork.setUpICstem(tg, "ICNS" + ICDateStringnp, 10, "tt");
                break;
            }
            case 120: {
                SetUpNetwork.setUpICstem(tg, "ICNS" + ICDateStringnp, 1, "tt");
                break;
            }
            case 119: {
                SetUpNetwork.setUpICpt(tg, "ICteststem" + ICDateStringnp);
                break;
            }
            case 118: {
                SetUpNetwork.setUpICNStest2pt(tg);
                break;
            }
            case 117: {
                SetUpNetwork.setUpICNStestpt(tg);
                break;
            }
            case 114: {
                SetUpNetwork.filterStemICpt(tg, "IC" + ICDateString, ICconvertPaperID, 1);
                break;
            }
            case 113: {
                SetUpNetwork.setUpICpt(tg, "IC" + ICDateStringnp + "stem");
                break;
            }
            case 112: {
                SetUpNetwork.setUpICstem(tg, "ICNS" + ICDateStringnp, 10, "pt");
                break;
            }
            case 111: {
                SetUpNetwork.filterStemICpt(tg, "ICNS" + ICDateString, ICconvertPaperID, 1);
                break;
            }
            case 110: {
                SetUpNetwork.setUpICpt(tg, "ICNS" + ICDateStringnp + "stem");
                break;
            }
            case 101: {
                SetUpNetwork.setUphepphcit(tg);
                break;
            }
            case 100: {
                SetUpNetwork.setUphepthcit(tg);
                break;
            }
            case 90: {
                SetUpNetwork.setUpFCommon(tg);
                break;
            }
            case 80: {
                SetUpNetwork.setUpCondMat(tg, false);
                break;
            }
            case 81: {
                SetUpNetwork.setUpCondMat(tg, true);
                break;
            }
            case 75: {
                SetUpNetwork.setUpWordAssociationPDFV05(tg, "bright", 5);
                break;
            }
            case 74: {
                SetUpNetwork.setUpWordAssociationPDFV05(tg, "bright", 4);
                break;
            }
            case 73: {
                SetUpNetwork.setUpWordAssociationPDFV05(tg, "bright", 3);
                break;
            }
            case 72: {
                SetUpNetwork.setUpWordAssociationPDFV05(tg, "bright", 2);
                break;
            }
            case 71: {
                SetUpNetwork.setUpWordAssociationPDFV05(tg, "bright", 1);
                break;
            }
            case 70: {
                SetUpNetwork.setUpWordAssociationPDFV05(tg, "bright", 0);
                break;
            }
            case 69: {
                SetUpNetwork.setUpWordAssociationTest(tg);
                break;
            }
            case 64: {
                SetUpNetwork.setUpWordAssociationSubGraph(tg, "bright", 4);
                break;
            }
            case 63: {
                SetUpNetwork.setUpWordAssociationSubGraph(tg, "bright", 3);
                break;
            }
            case 62: {
                SetUpNetwork.setUpWordAssociationSubGraph(tg, "bright", 2);
                break;
            }
            case 61: {
                SetUpNetwork.setUpWordAssociationSubGraph(tg, "bright", 1);
                break;
            }
            case 60: {
                SetUpNetwork.setUpWordAssociation(tg);
                break;
            }
            case 50: {
                SetUpNetwork.setUpMacTutor(tg);
                break;
            }
            case 40: {
                SetUpNetwork.setUpNetScience(tg, false);
                break;
            }
            case 41: {
                SetUpNetwork.setUpNetScience(tg, true);
                break;
            }
            case 42: {
                SetUpNetwork.setUpNetScienceTest(tg);
                break;
            }
            case 30: {
                SetUpNetwork.setUpKarateClub(tg);
                break;
            }
            case 31: {
                SetUpNetwork.setUpKarateClubUCIuw(tg);
                break;
            }
            case 32: {
                SetUpNetwork.setUpKarateClubUCIw(tg);
                break;
            }
            case 20: {
                SetUpNetwork.setUpCaveMan4x8m1Ring(tg);
                break;
            }
            case 21: {
                SetUpNetwork.setUpCaveMan4x8m4Ring(tg);
                break;
            }
            case 22: {
                SetUpNetwork.setUpCaveMan8x4m1Ring(tg);
                break;
            }
            case 23: {
                SetUpNetwork.setUpCaveMan8x4m4Ring(tg);
                break;
            }
            case 24: {
                SetUpNetwork.setUpCaveManCV8x4m4Ring(tg);
                break;
            }
            case 25: {
                SetUpNetwork.setUpCaveManCV8x8m4Ring(tg);
                break;
            }
            case 11: {
                SetUpNetwork.setUpGraph(tg, "Line8K1");
                break;
            }
            case 10: {
                SetUpNetwork.setUpGraph(tg, "Line8K2");
                break;
            }
            case 3: {
                SetUpNetwork.setUpGraph(tg, "dBowTie");
                break;
            }
            case 2: {
                SetUpNetwork.setUpGraph(tg, "LongBowTie");
                break;
            }
            case 1: {
                SetUpNetwork.setUpGraph(tg, "BowTie");
                break;
            }
            case 0: {
                SetUpNetwork.initialise(tg, "timgraph", args, 0);
                break;
            }
            default: {
                throw new RuntimeException("Unknown graph type +" + graphType);
            }
        }
        return tg;
    }

    public static void initialise(timgraph tg, String name, String[] arglist, int infolevel) {
        tg.initialiseSomeParameters(name, dirRoot, infolevel, 0);
        tg.parseParam(arglist);
        tg.setNameRoot(tg.inputName.getNameRoot());
        tg.setNetworkInitialGraph(true);
        tg.printParametersBasic();
    }

    public static void setUpICpunit(timgraph tg, String basicFileName) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewf", "-gvlt", "-fi" + basicFileName, "-fieinputBVNLS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        SetUpNetwork.initialise(tg, basicFileName, aList, infoLevel);
    }

    public static void setUpICNStestpt(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewf", "-gvlt", "-gbt", "-finICNStestpt", "-fieinputBVNLS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        SetUpNetwork.initialise(tg, "ICNSpttest", aList, infoLevel);
    }

    public static void setUpICpt(timgraph tg, String basicFileName) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewf", "-gvlt", "-gbt", "-fin" + basicFileName + "pt", "-fieinputBVNLS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        SetUpNetwork.initialise(tg, basicFileName + "pt", aList, infoLevel);
    }

    public static void setUpICNStest2pt(timgraph tg) {
        boolean convertIgnoreColumn = false;
        General.preProcess(tg, "ICNStest2", convertIgnoreColumn, 1, true);
    }

    public static void setUpICnpDateStemEW(timgraph tg, String basicFileName, int numberLinesToSkip, String type, String weightCutString) {
        String outputroot = basicFileName + (numberLinesToSkip > 1 ? Integer.valueOf(numberLinesToSkip) : "") + "stem" + type + weightCutString;
        String bipartite = type.startsWith("pt") ? "t" : "f";
        String weighted = type.startsWith("pt") ? "f" : "t";
        String[] aList = new String[]{"-gvet", "-gdf", "-gew" + weighted, "-gvlt", "-gb" + bipartite, "-fin" + outputroot, "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        SetUpNetwork.initialise(tg, basicFileName + type, aList, infoLevel);
    }

    public static void setUpICstem(timgraph tg, String basicFileName, int numberLinesToSkip, boolean unlabelled, String type) {
        String outputroot = basicFileName + (numberLinesToSkip > 1 ? Integer.valueOf(numberLinesToSkip) : "") + "stem" + (unlabelled ? "UL" : "") + type;
        String bipartite = type.startsWith("pt") ? "t" : "f";
        String weighted = type.startsWith("pt") ? "f" : "t";
        String[] aList = new String[]{"-gvet", "-gdf", "-gew" + weighted, "-gvlt", "-gb" + bipartite, "-fin" + outputroot, "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        SetUpNetwork.initialise(tg, basicFileName + type, aList, infoLevel);
    }

    public static void setUpICstem(timgraph tg, String basicFileName, int numberLinesToSkip, String type) {
        SetUpNetwork.setUpICstem(tg, basicFileName, numberLinesToSkip, false, type);
    }

    public static void filterStemICpt(timgraph tg, String basicFileName, boolean convertIgnoreColumn, int numberLinesToSkip) {
        General.preProcess(tg, basicFileName, convertIgnoreColumn, numberLinesToSkip, true);
    }

    public static void setUphepphcit(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdt", "-gewf", "-gvlt", "-finhep-ph-citations", "-fieinputEL.dat", "-gn99", "-e0", "-o9", "-xi0"};
        SetUpNetwork.initialise(tg, "hepphcit", aList, infoLevel);
    }

    public static void setUphepthcit(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdt", "-gewf", "-gvlt", "-finhep-th-citations", "-fieinputELS.dat", "-gn99", "-e0", "-o9", "-xi0"};
        SetUpNetwork.initialise(tg, "hepthcit", aList, infoLevel);
    }

    public static void setUpFCommon(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewf", "-gvlt", "-finfcommon", "-fieinputBVNLS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        SetUpNetwork.initialise(tg, "fcommon", aList, infoLevel);
    }

    public static void setUpWordAssociation(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdt", "-gewt", "-gvlt", "-finSFWAN", "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        SetUpNetwork.initialise(tg, "SFWAN", aList, infoLevel);
    }

    public static void setUpWordAssociationSubGraph(timgraph tg, String vertexName, int maxDistance) {
        String[] aList = new String[]{"-gvet", "-gdt", "-gewt", "-gvlt", "-finSFWAN", "-fieinputELS.dat", "-gn99", "-e0", "-o11", "-xi0"};
        String name = "SFWAN";
        timgraph fullns = new timgraph();
        fullns.initialiseSomeParameters(name, dirRoot, infoLevel, 0);
        fullns.parseParam(aList);
        fullns.setNetworkInitialGraph(true);
        fullns.printParametersBasic();
        if (fullns.getNumberVertices() < 20) {
            fullns.printNetwork(true);
        }
        if ((tg = fullns.makeRing(vertexName, maxDistance, fullns.isDirected(), true, fullns.isWeighted(), true)).getNumberVertices() < 20) {
            tg.printNetwork(true);
        }
        tg.inputName.setNameRoot(name + vertexName + maxDistance);
        tg.outputName.setNameRoot(name + vertexName + maxDistance);
    }

    public static void setUpWordAssociationPDFV05(timgraph tg, String vertexName, int maxDistance) {
        timgraph ng;
        String[] aList = new String[]{"-gvet", "-gdt", "-gewt", "-gvlt", "-finSFWAN", "-fieinputELS.dat", "-gn99", "-e0", "-o11", "-xi0"};
        String name = "SFWANPDFV05";
        timgraph fullns = new timgraph();
        fullns.initialiseSomeParameters(name, dirRoot, infoLevel, 0);
        fullns.parseParam(aList);
        fullns.setNetworkInitialGraph(true);
        fullns.printParametersBasic();
        if (maxDistance <= 0) {
            ng = fullns;
        } else {
            ng = fullns.makeRing(vertexName, maxDistance, fullns.isDirected(), fullns.isWeighted(), fullns.isVertexLabelled(), fullns.isVertexEdgeListOn());
            ng.inputName.setNameRoot(name + vertexName + maxDistance);
            ng.outputName.setNameRoot(name + vertexName + maxDistance);
        }
        ng.printParametersBasic();
        BasicAnalysis.analyse(ng);
        if (ng.getNumberVertices() < 20) {
            ng.printNetwork(true);
        }
        tg = ng.makeConsolidated(0.025, true, true, false, true);
        tg.addToNameRoot("cons025");
        tg.printParametersBasic();
        if (tg.getNumberVertices() < 20) {
            tg.printNetwork(true);
        }
        BasicAnalysis.analyse(tg);
    }

    public timgraph makeSubGraph(timgraph fullns, String vertexName, int maxDistance) {
        int vertex;
        for (vertex = 0; vertex < fullns.getNumberVertices() && !fullns.getVertexName(vertex).equalsIgnoreCase(vertexName); ++vertex) {
        }
        if (vertex == fullns.getNumberVertices()) {
            System.err.println("*** NOT FOUND VERTEX " + vertexName);
        }
        TreeSet<Integer> sgvertexList = fullns.getRing(vertex, maxDistance);
        System.out.println("Component of " + fullns.inputName.getNameRoot() + " centred on vertex " + vertexName + " number " + vertex + " upto distance " + maxDistance + " found " + sgvertexList.size() + " vertices");
        timgraph newgraph = fullns.projectSubgraph("proj", sgvertexList, fullns.isDirected(), true, fullns.isWeighted(), true);
        return newgraph;
    }

    public static void setUpWordAssociationTest(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdt", "-gewf", "-gvlt", "-finSFWANtest", "-fieinputELS.dat", "-gn99", "-e0", "-o11", "-xi0"};
        SetUpNetwork.initialise(tg, "SFWAN", aList, infoLevel);
    }

    public static void setUpMacTutor(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdt", "-gewf", "-gvlt", "-finMacTutor", "-fieinputVNLS.dat", "-gn99", "-e0", "-o61", "-xi0"};
        SetUpNetwork.initialise(tg, "MacTutor", aList, infoLevel);
    }

    public static void setUpKarateClub(timgraph tg) {
        String[] aList = new String[]{"   "};
        SetUpNetwork.initialise(tg, "karateNeAT", aList, infoLevel);
    }

    public static void setUpKarateClubUCIuw(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewf", "-fieinputAdjMat.dat", "-gn99", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "karateUCIuw", aList, infoLevel);
    }

    public static void setUpKarateClubUCIw(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewt", "-fieinputAdjMat.dat", "-gn99", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "karateUCIw", aList, infoLevel);
    }

    public static timgraph setUpELS(String rootName, boolean getGCC, int infol, int outputc, boolean makeDirected, boolean makeLabelled, boolean makeWeighted, boolean makeVertexEdgeList) {
        timgraph tg;
        String[] aList = new String[]{"-gd" + SetUpNetwork.torf(makeDirected), "-gvl" + SetUpNetwork.torf(makeLabelled), "-gew" + SetUpNetwork.torf(makeWeighted), "-gve" + SetUpNetwork.torf(makeVertexEdgeList), "-fieinputELS.dat", "-gn99", "-e0", "-o" + outputc, "-xi" + infol};
        if (getGCC) {
            tg = SetUpNetwork.extractGCC(rootName, aList);
        } else {
            tg = new timgraph(aList);
            SetUpNetwork.initialise(tg, rootName, aList, infoLevel);
        }
        return tg;
    }

    public static timgraph setUpELS(String rootName, boolean getGCC, boolean makeDirected, boolean makeLabelled, boolean makeWeighted, boolean makeVertexEdgeList) {
        return SetUpNetwork.setUpELS(rootName, getGCC, infoLevel, outputControlNumber, makeDirected, makeLabelled, makeWeighted, makeVertexEdgeList);
    }

    public static String torf(boolean b) {
        return b ? "t" : "f";
    }

    public static void setUpNetScienceEL(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewf", "-gvlt", "-fieinputELS.dat", "-gn99", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "netscienceNeAT", aList, infoLevel);
    }

    public static void setUpNetScience(timgraph tg, boolean getGCC) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewt", "-gvlt", "-fieinput.gml", "-gn99", "-e0", "-o0", "-xi0"};
        String name = "netscience";
        if (getGCC) {
            tg = SetUpNetwork.extractGCC(name, aList);
        } else {
            SetUpNetwork.initialise(tg, name, aList, infoLevel);
        }
    }

    public static void setUpCondMat(timgraph tg, boolean getGCC) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewt", "-gvlt", "-fieinput.gml", "-gn99", "-e0", "-o0", "-xi0"};
        String name = "cond-mat";
        if (getGCC) {
            tg = SetUpNetwork.extractGCC(name, aList);
        } else {
            SetUpNetwork.initialise(tg, name, aList, infoLevel);
        }
    }

    public static timgraph extractGCC(String name, String[] aList) {
        timgraph fullns = new timgraph();
        fullns.initialiseSomeParameters(name, dirRoot, infoLevel, 0);
        fullns.parseParam(aList);
        fullns.setNetworkInitialGraph(true);
        fullns.printParametersBasic();
        if (fullns.getNumberVertices() < 20) {
            fullns.printNetwork(true);
        }
        fullns.calcComponents();
        fullns.printComponentInfo();
        TreeSet<Integer> sgvertexList = fullns.getGCC();
        timgraph tg = fullns.projectSubgraph("GCC", sgvertexList, fullns.isDirected(), true, fullns.isWeighted(), true);
        if (tg.getNumberVertices() < 20) {
            tg.printNetwork(true);
        }
        tg.inputName.setNameRoot(name + "GCC");
        tg.outputName.setNameRoot(name + "GCC");
        tg.printParametersBasic();
        return tg;
    }

    public static void setUpGraph(timgraph tg, String type) {
        if (type.startsWith("BowTie")) {
            SetUpNetwork.setUpBowTie(tg);
        }
        if (type.startsWith("LongBowTie")) {
            SetUpNetwork.setUpLongBowTie(tg);
        }
        if (type.startsWith("dBowTie")) {
            SetUpNetwork.setUpDirectedBowTie(tg);
        }
        if (type.startsWith("Line8K1")) {
            SetUpNetwork.setUpLine8K1(tg);
        }
        if (type.startsWith("Line8K2")) {
            SetUpNetwork.setUpLine8K2(tg);
        }
        if (type.startsWith("Line7K1")) {
            SetUpNetwork.setUpLine7K1(tg);
        }
    }

    public static void setUpBowTie(timgraph tg) {
        String[] BowTieList = new String[]{"-gvet", "-gn8", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "BowTie", BowTieList, infoLevel);
    }

    public static void setUpLongBowTie(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gn9", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "LongBowTie", aList, infoLevel);
    }

    public static void setUpDirectedBowTie(timgraph tg) {
        String[] directedBowTieList = new String[]{"-gdt", "-gvet", "-gn8", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "DirectedBowTie", directedBowTieList, infoLevel);
    }

    public static void setUpLine8K1(timgraph tg) {
        String[] line8K1List = new String[]{"-gvet", "-gn-1", "-gv8", "-gm1", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "Line8K1", line8K1List, infoLevel);
    }

    public static void setUpLine8K2(timgraph tg) {
        String[] line8K2List = new String[]{"-gvet", "-gn-1", "-gv8", "-gm2", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "Bline8K2", line8K2List, infoLevel);
    }

    public static void setUpLine7K1(timgraph tg) {
        String[] line7K1List = new String[]{"-gvet", "-gn-1", "-gv7", "-gm1", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "line7K1", line7K1List, infoLevel);
    }

    public static void setUpCaveMan4x8m1Ring(timgraph tg) {
        String[] line8K1List = new String[]{"-gvet", "-gn-12", "-gv32", "-gx4", "-gm1", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "CaveMan4x8m1", line8K1List, infoLevel);
    }

    public static void setUpCaveMan4x8m4Ring(timgraph tg) {
        String[] line8K1List = new String[]{"-gvet", "-gn-12", "-gv32", "-gx4", "-gm4", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "CaveMan4x8m4", line8K1List, infoLevel);
    }

    public static void setUpCaveMan8x4m1Ring(timgraph tg) {
        String[] line8K1List = new String[]{"-gvet", "-gn-12", "-gv32", "-gx8", "-gm1", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "CaveMan8x4m1", line8K1List, infoLevel);
    }

    public static void setUpCaveMan8x4m4Ring(timgraph tg) {
        String[] line8K1List = new String[]{"-gvet", "-gn-12", "-gv32", "-gx8", "-gm4", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "CaveMan8x4m4", line8K1List, infoLevel);
    }

    public static void setUpCaveManCV8x4m4Ring(timgraph tg) {
        String[] line8K1List = new String[]{"-gvet", "-gn-14", "-gv32", "-gx8", "-gm4", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "CaveManCV8x4m4", line8K1List, infoLevel);
    }

    public static void setUpCaveManCV8x8m4Ring(timgraph tg) {
        String[] line8K1List = new String[]{"-gvet", "-gn-14", "-gv64", "-gx8", "-gm3", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "CaveManCV8x8m4", line8K1List, infoLevel);
    }

    public static void setUpNetScienceTest(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewt", "-gvlt", "-fieinputELS.dat", "-gn99", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "netsciencetest", aList, infoLevel);
    }

    public static void setUpBowTieEL(timgraph tg) {
        String[] argList = new String[]{"-gvet", "-gdf", "-gewf", "-fieinputEL.dat", "-gn99", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "BowTie", argList, infoLevel);
    }

    public static void setUpNetworkCollaboration(timgraph tg) {
        String[] aList = new String[]{"-gvet", "-gdf", "-gewf", "-fieinputEL.dat", "-gn99", "-e0", "-o0", "-xi0"};
        SetUpNetwork.initialise(tg, "netscienceNeAT", aList, infoLevel);
    }

    private int typeIndex(String t) {
        for (int i = 0; i < type.length; ++i) {
            if (!type[i].startsWith(t)) continue;
            return i;
        }
        return -1;
    }

    private static int typeIndex(int t) {
        for (int i = 0; i < typeNumber.length; ++i) {
            if (t != typeNumber[i]) continue;
            return i;
        }
        return -1;
    }

    public static String typeString(int t) {
        int ti = SetUpNetwork.typeIndex(t);
        if (ti < 0) {
            return "UNSET";
        }
        return type[ti];
    }

    public static String typeString() {
        return SetUpNetwork.typeString(graphType);
    }

    public boolean typeExists(int type) {
        return SetUpNetwork.typeIndex(type) >= 0;
    }

    public static void printNetworkTypes(PrintStream PS, String cc, String sep) {
        for (int i = 0; i < typeNumber.length; ++i) {
            PS.println(cc + typeNumber[i] + sep + type[i] + sep + longType[i]);
        }
    }
}

