/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.VertexPartition;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;

public class MakeVertexPartitionFromVertexPartition {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public static void main(String[] args) {
        System.out.println("MakeVertexCommunityFromVertexPartition Arguments :<VPfilename> :<VertexIndexColumn> :<PartitionIndexColumn> :<preGammaString> :graphMLOn :edgeWeightMinimum :vertexPositionFile");
        int ano = 0;
        String vpFilename = "input/UKHEIiikpinvnslLouvainQS2000r0vertices.dat";
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            vpFilename = args[ano].substring(1, args[ano].length());
        }
        System.out.println("--- Vertex partition from file " + vpFilename);
        int vertexIndexColumn = 1;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            vertexIndexColumn = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Column with vertex index  " + vertexIndexColumn);
        int partitionIndexColumn = 2;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            partitionIndexColumn = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Column with partition index  " + partitionIndexColumn);
        boolean qdef = false;
        int qualityType = 2;
        String preGammaString = "LouvainQS";
        double gamma = -1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            try {
                gamma = Double.parseDouble(args[ano].substring(1, args[ano].length()));
            }
            catch (RuntimeException e) {
                preGammaString = args[ano].substring(1, args[ano].length());
            }
        }
        if (gamma < 0.0) {
            int c0 = vpFilename.lastIndexOf(preGammaString) + preGammaString.length();
            int c1 = vpFilename.lastIndexOf(".dat");
            String gammaString = vpFilename.substring(c0, c1);
            gamma = Double.parseDouble(gammaString);
            System.out.println("--- Modularity null model scaling gamma =" + gamma);
        } else {
            System.out.println("--- No modularity null model scaling gamma ");
        }
        boolean graphMLOutput = true;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            graphMLOutput = StringFilter.trueString((char)args[ano].charAt(1));
        }
        System.out.println("--- graphML output is " + StringFilter.onOffString((boolean)graphMLOutput));
        double edgeWeightMinimum = -3.57986421E8;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            edgeWeightMinimum = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- graphML output has minimum edge weight of  " + edgeWeightMinimum);
        String basicFileNameRoot = "UKHEIiikpinvnsl";
        String[] aList = new String[]{"-fin" + basicFileNameRoot, "-fieinputELS.dat", "-o23", "-xi0"};
        if (args.length > 0) {
            aList = args;
        }
        tg = new timgraph();
        tg.parseParam(aList);
        tg.setNameRoot(MakeVertexPartitionFromVertexPartition.tg.inputName.getNameRoot());
        System.out.println("Reading basic graph from file" + MakeVertexPartitionFromVertexPartition.tg.inputName.getFullFileName());
        int xColumn = 1;
        int yColumn = 2;
        boolean headerOn = false;
        boolean infoOn = false;
        int nameColumn = 1;
        tg.setNetworkFromInputFile(xColumn, yColumn, nameColumn, headerOn, infoOn);
        tg.printParametersBasic();
        boolean indexString = false;
        headerOn = false;
        if (vpFilename.endsWith("inputBVNLS.dat")) {
            headerOn = false;
            indexString = true;
            vertexIndexColumn = 1;
            partitionIndexColumn = 2;
        }
        if (vpFilename.endsWith("vertices.dat")) {
            indexString = false;
            headerOn = true;
            vertexIndexColumn = 1;
            partitionIndexColumn = 2;
        }
        boolean vpInformationOn = false;
        MakeVertexPartitionFromVertexPartition.makePartition(tg, vpFilename, vertexIndexColumn, partitionIndexColumn, edgeWeightMinimum, indexString, graphMLOutput, headerOn, vpInformationOn);
    }

    public static void makePartition(timgraph tg, String vpFilename, int vertexIndexColumn, int vertexCommunityColumn, double edgeWeightMinimum, boolean indexString, boolean graphMLOutput, boolean headerOn, boolean vpInformationOn) {
        String basicFileNameRoot = tg.inputName.getNameRoot();
        VertexPartition vp = new VertexPartition(tg);
        String vpname = "VP";
        int c = -1;
        try {
            c = vpFilename.indexOf(basicFileNameRoot);
            vpname = "VP" + vpFilename.substring(c + basicFileNameRoot.length(), vpFilename.length() - 4);
        }
        catch (RuntimeException e) {
            vpname = "VP" + vpFilename;
        }
        vp.setName(vpname);
        boolean relabelOn = true;
        if (indexString) {
            vp.readStringPartition(vpFilename, vertexIndexColumn, vertexCommunityColumn, headerOn);
        } else {
            vp.readIntPartition(vpFilename, vertexIndexColumn, vertexCommunityColumn, headerOn, relabelOn);
        }
        int neg = vp.hasNegativeCommunityLabels();
        if (neg >= 0) {
            System.err.println("*** Found negative partition label for " + vp.getNameOfElements() + " number " + neg);
        }
        boolean infoOn = true;
        headerOn = true;
        if (vpInformationOn) {
            FileOutput fovp = new FileOutput(tg.outputName);
            infoOn = true;
            headerOn = true;
            fovp.printPartitionStats(vp, SEP, SEP, infoOn, headerOn);
        }
        if (vp.getNumberElements() != tg.getNumberVertices()) {
            throw new RuntimeException("vertex partition has " + vp.getNumberElements() + " elements which is not equal to number of vertices " + tg.getNumberVertices());
        }
        tg.setVertexNumbers(vp);
        FileOutput fo = new FileOutput(tg);
        boolean simpleListOn = false;
        fo.printVertices("", SEP, infoOn, headerOn, vp, simpleListOn);
        boolean asNames = true;
        headerOn = true;
        boolean splitBipartite = false;
        boolean outputType1 = false;
        if (vpInformationOn) {
            fo.printPartitionStats(vp, "", SEP, infoOn, headerOn);
        }
        if (graphMLOutput) {
            fo.graphMLVertexPartition(vp);
        }
        if (graphMLOutput) {
            fo.graphML(vp.getCommunityName(c) + "B", edgeWeightMinimum);
        }
        boolean listPartitionOn = false;
    }

    static {
        infoLevel = 3;
    }
}

