/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.Community;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.VertexPartition;
import TimGraph.io.FileOutput;
import TimGraph.run.LineGraphCommunities;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class MakeVertexPartition {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public static void main(String[] args) {
        System.out.println("MakeVertexCommunities Arguments :<method> :<qualitydef> :<qualitytype> :<gammaMin> :<gammaMax> :<gammaStep> :numberRuns :<graphMLOn>");
        int ano = 0;
        int method = 0;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            method = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Using community method " + LineGraphCommunities.COMMUNITYMETHOD[method]);
        int qdef = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            qdef = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[qdef]);
        int qualityType = 1;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            qualityType = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[qualityType]);
        double gammaMin = 1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaMin = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double gammaMax = gammaMin + 1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaMax = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double minStep = 0.001;
        double gammaStep = gammaMax - gammaMin + 1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaStep = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        if (Math.abs(gammaStep) < minStep) {
            throw new RuntimeException("Step size must be greater than " + minStep + " in magnitude");
        }
        System.out.println("--- Modularity null model scaling gamma min, max step =" + gammaMin + "  " + gammaMax + "  " + gammaStep);
        int numberRuns = 1;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            numberRuns = Math.max(1, Integer.parseInt(args[ano].substring(1, args[ano].length())));
        }
        System.out.println("--- Number of runs for each gamma value =" + numberRuns);
        boolean fileOutput = true;
        boolean graphMLOutput = true;
        boolean projectedGraphOutput = false;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            graphMLOutput = StringFilter.trueString((char)args[ano].charAt(1));
        }
        System.out.println("--- file output is " + StringFilter.onOffString((boolean)fileOutput));
        System.out.println("--- graphML output is " + StringFilter.onOffString((boolean)graphMLOutput));
        System.out.println("--- projected graph output is " + StringFilter.onOffString((boolean)projectedGraphOutput));
        String basicFileName = "BowTieWD";
        String[] aList = new String[]{"-gvet", "-gdt", "-gewt", "-gvlt", "-gbf", "-fin" + basicFileName, "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        if (args.length > 0) {
            aList = args;
        }
        tg = new timgraph();
        tg.parseParam(aList);
        if (!tg.isVertexEdgeListOn()) {
            System.err.println("\n *** Vertex Edge List NOT on and it is required, use -vgvet option ***\n");
        }
        tg.setNameRoot(MakeVertexPartition.tg.inputName.getNameRoot());
        tg.setNetworkFromInputFile();
        tg.printParametersBasic();
        tg.calcStrength();
        FileOutput fo = new FileOutput(tg);
        String extension = "_" + Math.round(1000.0 * gammaMin) + "_" + Math.round(1000.0 * gammaMax) + "_" + Math.round(1000.0 * gammaStep) + "_gamma.dat";
        fo.fileName.setNameEnd(extension);
        try {
            FileOutputStream fout = new FileOutputStream(fo.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            Community c = new Community(tg, qdef, gammaMin, qualityType, infoLevel);
            PS.println("name\t" + c.informationNumbersLabel("", SEP));
            for (double gamma = gammaMin; gamma <= gammaMax && !(gamma <= 0.0); gamma += gammaStep) {
                System.out.println("\n--- gamma=" + String.format("%6.3f", gamma) + " ----------------------------------------------------");
                for (int r = 0; r < numberRuns; ++r) {
                    VertexPartition vp = MakeVertexPartition.calculateVertexPartition(tg, qdef, qualityType, gamma, method, r, infoLevel, fileOutput, graphMLOutput, projectedGraphOutput);
                    PS.println(r + SEP + vp.getName() + SEP + vp.informationNumbers("", SEP));
                }
            }
            if (infoLevel > -2) {
                System.out.println("Finished writing VP various gamma information file to " + fo.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fo.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public static VertexPartition calculateVertexPartition(timgraph tg, int qdef, int qualityType, double gamma, int method, int runNumber, int infoLevel, boolean fileOutput, boolean graphMLOutput, boolean projectedGraphOutput) {
        FileOutput fo;
        VertexPartition vp = VertexPartition.calculate(tg, qdef, qualityType, gamma, method, infoLevel);
        if (runNumber >= 0) {
            vp.setName(vp.getName() + "r" + runNumber);
        }
        tg.setVertexNumbers(vp);
        if (!tg.hasVertexPositions()) {
            tg.setVertexPositionsFromPartition(vp, 30.0, 90.0);
        }
        if (fileOutput) {
            fo = new FileOutput(tg);
            fo.informationPartition(vp, "", SEP, true);
            fo.printPartitionStats(vp, "", SEP, true, true);
            fo.printVertices("", SEP, false, false, vp, true);
            fo.printVertices("", SEP, false, true, vp, false);
            if (tg.outputControl.pajekFileOn) {
                fo.pajekPartition(vp.getName() + ".clu", vp);
            }
            if (graphMLOutput) {
                fo.graphMLVertexPartition(vp);
            }
        }
        if (projectedGraphOutput) {
            fo = new FileOutput(tg);
            timgraph projg = vp.getVertexPartitionGraph();
            fo = new FileOutput(projg);
            fo.informationGeneral("", SEP);
        }
        return vp;
    }

    static {
        infoLevel = 2;
    }
}

