/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.Partition;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;

public class MakeVertexCommunityFromEdgePartition {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public static void main(String[] args) {
        System.out.println("MakeVertexCommunityFromEdgePartition Arguments :<EPfilename> :<edgeIndexColumn> :<edgeCommunityColumn> :<preGammaString>");
        int ano = 0;
        String epFilename = "input/karateTSE_WLG_VP0.9.dat";
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            epFilename = args[ano].substring(1, args[ano].length());
        }
        System.out.println("--- Edge partition from file " + epFilename);
        int edgeIndexColumn = 1;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            edgeIndexColumn = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Column with edge index  " + edgeIndexColumn);
        int edgeCommunityColumn = 2;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            edgeCommunityColumn = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Column with edge community  " + edgeCommunityColumn);
        boolean qdef = false;
        int qualityType = 2;
        String preGammaString = "WLG_VP";
        double gamma = -1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            try {
                gamma = Double.parseDouble(args[ano].substring(1, args[ano].length()));
            }
            catch (RuntimeException e) {
                preGammaString = args[ano].substring(1, args[ano].length());
            }
        }
        if (gamma < 0.0) {
            int c0 = epFilename.lastIndexOf(preGammaString) + preGammaString.length();
            int c1 = epFilename.lastIndexOf(".dat");
            String gammaString = epFilename.substring(c0, c1);
            gamma = Double.parseDouble(gammaString);
        }
        System.out.println("--- Modularity null model scaling gamma =" + gamma);
        boolean graphMLOutput = true;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            graphMLOutput = StringFilter.trueString((char)args[ano].charAt(1));
        }
        System.out.println("--- graphML output is " + StringFilter.onOffString((boolean)graphMLOutput));
        String basicFileNameRoot = "karateTSE";
        String[] aList = new String[]{"-gvet", "-gdf", "-gewf", "-gvlt", "-gbt", "-fin" + basicFileNameRoot, "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        if (args.length > 0) {
            aList = args;
        }
        tg = new timgraph();
        tg.parseParam(aList);
        tg.setNameRoot(MakeVertexCommunityFromEdgePartition.tg.inputName.getNameRoot());
        int xColumn = 1;
        int yColumn = 2;
        boolean headerOn = false;
        boolean infoOn = false;
        int nameColumn = 1;
        tg.setNetworkFromInputFile(xColumn, yColumn, nameColumn, headerOn, infoOn);
        tg.printParametersBasic();
        tg.printParametersBasic();
        MakeVertexCommunityFromEdgePartition.makeCommunity(tg, epFilename, edgeIndexColumn, edgeCommunityColumn, graphMLOutput);
    }

    public static void makeCommunity(timgraph tg, String epFilename, int edgeIndexColumn, int edgeCommunityColumn, boolean graphMLOutput) {
        String basicFileNameRoot = tg.inputName.getNameRoot();
        Partition ep = new Partition();
        String epname = "VC";
        int c = -1;
        try {
            c = epFilename.indexOf(basicFileNameRoot);
            epname = "VC" + epFilename.substring(c + basicFileNameRoot.length(), epFilename.length() - 4);
        }
        catch (RuntimeException e) {
            epname = "VC" + epFilename;
        }
        ep.setName(epname);
        ep.setElementNameEdges();
        boolean headerOn = false;
        boolean relabelOn = true;
        String commentLine = "*";
        ep.readIntPartition(epFilename, edgeIndexColumn, edgeCommunityColumn, headerOn, commentLine, relabelOn);
        int neg = ep.hasNegativeCommunityLabels();
        if (neg >= 0) {
            System.err.println("*** Found negative community label for " + ep.getNameOfElements() + " number " + neg);
        }
        FileOutput foep = new FileOutput(tg.outputName);
        boolean infoOn = true;
        headerOn = true;
        foep.informationEdgePartition(ep, SEP, SEP, headerOn);
        foep.printPartitionStats(ep, SEP, SEP, infoOn, headerOn);
        if (ep.getNumberElements() != tg.getNumberEdges()) {
            throw new RuntimeException("edge partition has " + ep.getNumberElements() + " elements which is not equal to number of edges " + tg.getNumberEdges());
        }
        tg.setEdgeLabels(ep);
        FileOutput fo = new FileOutput(tg);
        fo.printEdges(true, true, true, true, ep.getName());
        boolean asNames = true;
        headerOn = true;
        boolean splitBipartite = false;
        boolean outputType1 = false;
        fo.printEdgeCommunityStats(ep.getName(), asNames, headerOn, splitBipartite, outputType1);
        if (tg.isBipartite()) {
            splitBipartite = true;
            outputType1 = true;
            fo.printEdgeCommunityStats(tg.getNameVerticesType1() + ep.getName(), asNames, headerOn, splitBipartite, outputType1);
            outputType1 = false;
            fo.printEdgeCommunityStats(tg.getNameVerticesType2() + ep.getName(), asNames, headerOn, splitBipartite, outputType1);
        }
        if (graphMLOutput) {
            fo.graphMLEdgePartition(ep);
        }
        boolean listPartitionOn = false;
        fo.informationEdgePartition(ep, "", SEP, listPartitionOn);
    }

    static {
        infoLevel = 3;
    }
}

