/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.Community;
import TimGraph.Community.VertexCommunity;
import TimGraph.Community.VertexPartition;
import TimGraph.algorithms.Projections;
import TimGraph.io.FileInput;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class MakeVertexCommunityFromCliqueGraph {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public static void main(String[] args) {
        System.out.println("MakeVertexCommunityFromCliquePartition Arguments :<RootName> :<CliqueGraphType> :<CliqueSize> :<gammaMin> :<gammaMax> :<gammaStep> :<GraphMLOn>");
        int ano = -1;
        String coreRoot = "N17";
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            coreRoot = args[ano].substring(1, args[ano].length());
        }
        System.out.println("Core root of file names is " + coreRoot);
        int cgTypeIndex = 2;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            cgTypeIndex = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("Clique type " + cgTypeIndex + ", " + MakeVertexCommunityFromCliqueGraph.cliqueGraphTypeString(cgTypeIndex));
        int cliqueSize = 3;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            cliqueSize = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        String cgType = "t" + cgTypeIndex + "c" + cliqueSize;
        System.out.println("Clique size " + cliqueSize + ", cgtype =" + cgType);
        String nameRoot = coreRoot + "_" + cgType;
        String cgNameRoot = nameRoot + "CG";
        System.out.println("--- Clique Graph from file with name root " + cgNameRoot);
        String cimFilename = "input/" + nameRoot + "CIMinputEL.dat";
        System.out.println("--- Clique Incidence Matrix from file " + cimFilename);
        boolean cimCliqueFirstColumn = false;
        int qdef = 0;
        int qualityType = 2;
        double gammaMin = 0.25;
        double gammaMax = 2.0;
        double gammaStep = 0.25;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaMin = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaMax = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double minStep = 0.001;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaStep = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        if (Math.abs(gammaStep) < minStep) {
            throw new RuntimeException("Step size must be greater than " + minStep + " in magnitude");
        }
        System.out.println("--- Modularity null model scaling gamma min, max, step = " + gammaMin + ", " + gammaMax + ", " + gammaStep);
        boolean graphMLOutput = true;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            graphMLOutput = StringFilter.trueString((char)args[ano].charAt(1));
        }
        System.out.println("--- graphML output is " + StringFilter.onOffString((boolean)graphMLOutput));
        String basicFileNameRoot = coreRoot;
        String[] aList = new String[]{"-gvet", "-gdf", "-gewf", "-gvlt", "-gbf", "-fin" + basicFileNameRoot, "-fieinputEL.dat", "-gn99", "-e0", "-o255", "-xi0"};
        tg = new timgraph();
        tg.parseParam(aList);
        tg.setNameRoot(MakeVertexCommunityFromCliqueGraph.tg.inputName.getNameRoot());
        System.out.println("Reading basic graph from file" + MakeVertexCommunityFromCliqueGraph.tg.inputName.getFullFileName());
        int xColumn = 1;
        int yColumn = 2;
        boolean headerOn = false;
        boolean infoOn = false;
        int nameColumn = 1;
        tg.setNetworkFromInputFile(xColumn, yColumn, nameColumn, headerOn, infoOn);
        tg.printParametersBasic();
        String cgext = "inputEL.dat";
        boolean cliquePercOn = true;
        VertexCommunity vc = MakeVertexCommunityFromCliqueGraph.makeCommunity(tg, cgType, cgNameRoot, cgext, cgTypeIndex, qdef, qualityType, gammaMin, gammaMax, gammaStep, cimFilename, cimCliqueFirstColumn, graphMLOutput, cliquePercOn);
    }

    public static VertexCommunity makeCommunity(timgraph tg, String cgType, String cgNameRoot, String cgext, int cgTypeIndex, int qdef, int qualityType, double gammaMin, double gammaMax, double gammaStep, String cimFilename, boolean cimCliqueFirstColumn, boolean graphMLOutput, boolean cliquePercOn) {
        boolean infoOn;
        boolean vertexLabelled;
        boolean directed;
        int columnLabel;
        int maxVertexIndex;
        boolean firstColumnCliqueIndex = false;
        ArrayList<Integer> cliqueLabel = null;
        ArrayList<ArrayList<Integer>> cliqueToVertex = new ArrayList<ArrayList<Integer>>();
        ArrayList<ArrayList<Integer>> vertexToClique = new ArrayList<ArrayList<Integer>>();
        boolean headerOn = false;
        FileInput.readIntIndexNeighbourList(cimFilename, cliqueLabel, cliqueToVertex, vertexToClique, cimCliqueFirstColumn, headerOn, infoLevel);
        System.out.println("Clique to Vertex matrix, size " + cliqueToVertex.size());
        int numberCliques = cliqueToVertex.size();
        if (numberCliques < 20) {
            int cn = 0;
            for (ArrayList<Integer> clique : cliqueToVertex) {
                System.out.print(cn++ + ": ");
                for (Integer v : clique) {
                    System.out.print(v + " ");
                }
                System.out.println();
            }
        }
        timgraph cg = new timgraph();
        cg.inputName.setFileName(tg.inputName);
        cg.setNameRoot(cgNameRoot);
        cg.setVertexEdgeList(true);
        int columnSource = 1;
        int columnTarget = 2;
        int columnWeight = 3;
        if (cgTypeIndex == 0 || cgTypeIndex == 1) {
            columnWeight = -99;
        }
        if ((maxVertexIndex = FileInput.processIntEdgeFile(cg, numberCliques, cgext, columnSource, columnTarget, columnWeight, columnLabel = -99, directed = false, vertexLabelled = false, infoOn = false)) <= 0) {
            throw new RuntimeException("FileInput.processIntEdgeFile returned maximum vertex index as " + maxVertexIndex);
        }
        String cpName = "";
        VertexCommunity vc = new VertexCommunity(tg);
        int cliqueSize = cliqueToVertex.get(0).size();
        System.out.println("Clique size is " + cliqueSize);
        double minWeight = (double)cliqueSize - 1.1;
        FileOutput fo = new FileOutput(cg);
        String extension = "_" + Math.round(1000.0 * gammaMin) + "_" + Math.round(1000.0 * gammaMax) + "_" + Math.round(1000.0 * gammaStep) + "_gamma.dat";
        fo.fileName.setNameEnd(extension);
        try {
            FileOutputStream fout = new FileOutputStream(fo.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            Community c = new Community(tg, qdef, gammaMin, qualityType, infoLevel);
            PS.println("gamma\t" + c.informationNumbersLabel("", SEP));
            if (cliquePercOn && cgTypeIndex == 4) {
                vc = MakeVertexCommunityFromCliqueGraph.makeCliquePercolationCommunity(tg, cg, cgType, cliqueToVertex, minWeight, graphMLOutput);
                PS.println("PERC\t" + vc.getName() + SEP + vc.informationNumbers("", SEP));
                System.out.println("--- PERC, found " + vc.getNumberCommunities() + " communities");
            }
            for (double gamma = gammaMin; gamma <= gammaMax; gamma += gammaStep) {
                cpName = "CP" + cgType + "l" + Math.round(gamma * 1000.0);
                vc.setName(cpName);
                vc = MakeVertexCommunityFromCliqueGraph.makeLouvainCliqueCommunity(tg, cg, cgType, cliqueToVertex, qdef, qualityType, gamma, graphMLOutput);
                System.out.println("--- gamma=" + gamma + ", found " + vc.getNumberCommunities() + " communities");
                PS.println(gamma + SEP + vc.getName() + SEP + vc.informationNumbers("", SEP));
            }
            if (infoLevel > -2) {
                System.out.println("Finished writing VP various gamma information file to " + fo.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fo.fileName.getFullFileName() + ", " + e.getMessage());
            return null;
        }
        return vc;
    }

    static VertexCommunity makeLouvainCliqueCommunity(timgraph tg, timgraph cg, String cgType, ArrayList<ArrayList<Integer>> cliqueToVertex, int qdef, int qualityType, double gamma, boolean graphMLOn) {
        VertexCommunity vc = new VertexCommunity(tg);
        int numberCliques = cg.getNumberVertices();
        if (numberCliques != cliqueToVertex.size()) {
            throw new RuntimeException("Number of cliques not consistent " + cg.getNumberVertices() + " != " + cliqueToVertex.size());
        }
        int method = 0;
        VertexPartition cgvp = VertexPartition.calculate(cg, qdef, qualityType, gamma, method, infoLevel);
        if (cg.getNumberVertices() < 20) {
            cgvp.printVertices(System.out, " ", SEP, true, true);
        }
        int[] cliqueToCommunity = new int[numberCliques];
        for (int m = 0; m < numberCliques; ++m) {
            cliqueToCommunity[m] = cgvp.getCommunity(m);
        }
        String cpName = "CP" + cgType + "l" + Math.round(gamma * 1000.0);
        vc.setName(cpName);
        boolean forceNormalisation = true;
        boolean checkNormalisation = true;
        vc.setUp(tg.getNumberVertices(), cliqueToVertex, cliqueToCommunity, forceNormalisation, checkNormalisation);
        MakeVertexCommunityFromCliqueGraph.printCliqueCommunity(tg, cpName, cliqueToVertex, cliqueToCommunity, vc, graphMLOn);
        MakeVertexCommunityFromCliqueGraph.setEdgeLabelsFromCliqueCommunity(tg, cliqueToVertex, cliqueToCommunity);
        MakeVertexCommunityFromCliqueGraph.setVertexNumbersFromCliqueCommunity(tg, cliqueToVertex, cliqueToCommunity);
        if (graphMLOn) {
            FileOutput tgfo = new FileOutput(tg);
            double edgeWeightMinimum = -3.57986421E8;
            tgfo.graphML(cpName, edgeWeightMinimum);
        }
        return vc;
    }

    static void setEdgeLabelsFromCliqueCommunity(timgraph tg, ArrayList<ArrayList<Integer>> cliqueToVertex, int[] cliqueToCommunity) {
        if (cliqueToCommunity.length != cliqueToVertex.size()) {
            throw new RuntimeException("Different numbers of communities in cliqueToCommunity and cliqueToVertex.size() " + cliqueToCommunity.length + ", " + cliqueToVertex.size());
        }
        tg.setEdgeLabels(-1);
        int s = -1;
        int t = -1;
        int e = -1;
        int l = -1;
        for (int cl = 0; cl < cliqueToCommunity.length; ++cl) {
            int commp1 = cliqueToCommunity[cl] + 1;
            ArrayList<Integer> vl = cliqueToVertex.get(cl);
            for (int i = 0; i < vl.size(); ++i) {
                s = vl.get(i);
                for (int j = i + 1; j < vl.size(); ++j) {
                    t = vl.get(j);
                    e = tg.getFirstEdgeGlobal(s, t);
                    if (e < 0) {
                        throw new RuntimeException("Looking at vertices " + s + " and " + t + ", the " + i + " and " + j + "  vertices of clique " + cl);
                    }
                    l = tg.getEdgeLabel(e);
                    if (l < 0) {
                        tg.setEdgeLabelQuick(e, commp1);
                        continue;
                    }
                    if (l == commp1) continue;
                    tg.setEdgeLabelQuick(e, 0);
                }
            }
        }
    }

    static void setVertexNumbersFromCliqueCommunity(timgraph tg, ArrayList<ArrayList<Integer>> cliqueToVertex, int[] cliqueToCommunity) {
        if (cliqueToCommunity.length != cliqueToVertex.size()) {
            throw new RuntimeException("Different numbers of communities in cliqueToCommunity and cliqueToVertex.size() " + cliqueToCommunity.length + ", " + cliqueToVertex.size());
        }
        tg.setVertexNumbers(-1);
        int s = -1;
        int n = -1;
        for (int cl = 0; cl < cliqueToCommunity.length; ++cl) {
            int commp1 = cliqueToCommunity[cl] + 1;
            ArrayList<Integer> vl = cliqueToVertex.get(cl);
            for (int i = 0; i < vl.size(); ++i) {
                s = vl.get(i);
                n = tg.getVertexNumber(s, -1);
                if (n < 0) {
                    tg.setVertexNumberQuick(s, commp1);
                    continue;
                }
                if (n == commp1) continue;
                tg.setVertexNumberQuick(s, 0);
            }
        }
    }

    static VertexCommunity makeCliquePercolationCommunity(timgraph tg, timgraph cg, String cgType, ArrayList<ArrayList<Integer>> cliqueToVertex, double minWeight, boolean graphMLOn) {
        VertexCommunity vc = new VertexCommunity(tg);
        int numberCliques = cg.getNumberVertices();
        if (numberCliques != cliqueToVertex.size()) {
            throw new RuntimeException("Number of cliques not consistent " + cg.getNumberVertices() + " != " + cliqueToVertex.size());
        }
        boolean makeLabelled = false;
        boolean makeWeighted = false;
        boolean makeVertexEdgeList = false;
        timgraph newcg = Projections.minimumEdgeWeight(cg, minWeight, makeLabelled, makeWeighted, makeVertexEdgeList);
        newcg.calcComponents();
        boolean componentDistribution = true;
        boolean vertexToComponent = true;
        int[] cliqueToCommunity = new int[numberCliques];
        for (int m = 0; m < numberCliques; ++m) {
            cliqueToCommunity[m] = newcg.getVertexComponentLabel(m);
        }
        String cpName = "CP" + cgType + "Perc";
        vc.setName(cpName);
        boolean forceNormalisation = true;
        boolean checkNormalisation = true;
        vc.setUp(tg.getNumberVertices(), cliqueToVertex, cliqueToCommunity, forceNormalisation, checkNormalisation);
        MakeVertexCommunityFromCliqueGraph.printCliqueCommunity(tg, cpName, cliqueToVertex, cliqueToCommunity, vc, graphMLOn);
        MakeVertexCommunityFromCliqueGraph.setEdgeLabelsFromCliqueCommunity(tg, cliqueToVertex, cliqueToCommunity);
        MakeVertexCommunityFromCliqueGraph.setVertexNumbersFromCliqueCommunity(tg, cliqueToVertex, cliqueToCommunity);
        if (graphMLOn) {
            FileOutput tgfo = new FileOutput(tg);
            double edgeWeightMinimum = -3.57986421E8;
            tgfo.graphML(cpName, edgeWeightMinimum);
        }
        return vc;
    }

    static void printCliqueCommunity(timgraph tg, String cpName, ArrayList<ArrayList<Integer>> cliqueToVertex, int[] cliqueToCommunity, VertexCommunity vc, boolean graphMLOn) {
        String cc = "";
        String sep = SEP;
        String ext = "_" + cpName + "CliqueList.dat";
        boolean headerOn = false;
        FileOutput tgfo = new FileOutput(tg);
        boolean motifIndexOn = true;
        headerOn = true;
        tgfo.printMotifs(cc, sep, ext, cliqueToCommunity, cliqueToVertex, motifIndexOn, headerOn);
        cc = "";
        sep = SEP;
        headerOn = true;
        boolean ElementLabelsOn = true;
        tgfo.printVertexCommunity(vc, cc, sep, headerOn, ElementLabelsOn);
    }

    public static String cliqueGraphTypeString(int type) {
        switch (type) {
            case 0: {
                return "Unweighted and no self loops (C of eqn 8)";
            }
            case 1: {
                return "Unweighted with self-loops (\\tilde{C} of footnote 2)";
            }
            case 2: {
                return "Low Weighted and no self loops (D of eqn 11)";
            }
            case 3: {
                return "Low Weighted with self-loops (E of eqn 14)";
            }
            case 4: {
                return "Weighted and no self loops (incidence counts)";
            }
            case 5: {
                return "Weighted with self-loops (incidence counts)";
            }
        }
        return "*** UNKNOWN Clique Graph Type";
    }

    static {
        infoLevel = 0;
    }
}

