/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.algorithms.LineGraphProjector;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;
import TimUtilities.TimMemory;
import TimUtilities.TimTiming;

public class MakeLineGraph {
    public static void main(String[] args) {
        TimTiming timing = new TimTiming();
        TimMemory memory = new TimMemory();
        System.out.println("\n !!! Initial Memory: " + memory.StringAllValues());
        int lgmethod = 4;
        int ano = 0;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            lgmethod = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Using Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod]);
        String basicFileName = "BowTieW";
        String[] aList = new String[]{"-gvet", "-gdf", "-gewt", "-gvlt", "-gbt", "-fin" + basicFileName, "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        if (args.length > 0) {
            aList = args;
        }
        timgraph tg = new timgraph();
        tg.parseParam(aList);
        tg.setNameRoot(tg.inputName.getNameRoot());
        tg.setNetworkFromInputFile();
        tg.printParametersBasic();
        FileOutput fotg = new FileOutput(tg);
        boolean asNames = true;
        boolean infoOn = true;
        boolean headerOn = true;
        boolean edgeIndexOn = true;
        boolean edgeLabelOn = false;
        fotg.printEdges(asNames, infoOn, headerOn, edgeIndexOn, edgeLabelOn);
        System.out.println("\n *** \n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod] + " *** \n");
        timgraph lineGraphtg = LineGraphProjector.makeLineGraph(tg, lgmethod, true);
        lineGraphtg.printParametersBasic();
        FileOutput folg = new FileOutput(lineGraphtg);
        folg.informationNetworkBasic("#", "\t ");
        folg.edgeListSimple(true);
        folg.graphML();
        System.out.println("\n *** Finished making Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod]);
        System.out.println(" !!! Took " + timing.runTimeString());
        System.out.println(" !!! Final Memory: " + memory.StringAllValues());
    }
}

