/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.VertexCommunity;
import TimGraph.Community.VertexPartition;
import TimGraph.OutputMode;
import TimGraph.algorithms.LineGraphProjector;
import TimGraph.io.FileOutput;
import TimGraph.run.LineGraphCommunities;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class MakeEdgePartition {
    static final String[] COMMUNITYMETHOD = new String[]{"Louvain", "SimAn"};
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static timgraph lineGraphtg;
    static int infoLevel;

    public MakeEdgePartition(timgraph newtg) {
        tg = newtg;
    }

    public static void usage(PrintStream PS) {
        char arg = timgraph.NOT_TIMGRAPH_ARGUMENT[0];
        PS.println("LineGraphCommunities " + arg + "<filename> " + arg + "<method> " + arg + "<lineGraphType> " + arg + "<quality> " + arg + "<lambda> -<timgraphArgument> ...");
        PS.println("Arguments for this class start with any of " + timgraph.otherArguments(", ") + ", but " + arg + " used for example here.");
        PS.println("First " + arg + " argument is the type of line graph");
        PS.println("Second " + arg + " argument is the method used to find communities, 0=Louvain/Greedy, 1= Simulated Annealing");
        PS.println("Third " + arg + " argument is type of line graph to use 0=C, 1=Ctilde, 2=D, 3=E (Dtilde)");
        PS.println("Fourth " + arg + " argument is definition of quality to use, 0=Q(A), 1=Q(A" + arg + "A-A)");
        PS.println("Fifth " + arg + " argument is type of quality class to use, 0=basic (dense matrix), 1=sparse matrix, 2=minimal memory ");
        PS.println("Sixth " + arg + " argument is value of lambda, scaling parameter of null model.");
        PS.println("Remaining arguments should start with a - and are parsed by <tt>timgraph</tt>.");
        SetUpNetwork.printNetworkTypes(PS, "", "  ");
    }

    public static void main(String[] args) {
        System.out.println("MakeEdgePartition Arguments :<method> :<qualitydef> :<qualitytype> :<gammaMin> :<gammaMax> :<gammaStep> :numberRuns :<graphMLOn>");
        int ano = 0;
        int lgmethod = 2;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            lgmethod = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Using Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod]);
        int method = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            method = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Using community method " + LineGraphCommunities.COMMUNITYMETHOD[method]);
        int qdef = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            qdef = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[qdef]);
        int qualityType = 2;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            qualityType = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[qualityType]);
        double gammaMin = 1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaMin = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double gammaMax = 1.1;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaMax = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double minStep = 0.001;
        double gammaStep = 1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaStep = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        if (Math.abs(gammaStep) < minStep) {
            throw new RuntimeException("Step size must be greater than " + minStep + " in magnitude");
        }
        System.out.println("--- Modularity null model scaling gamma min, max step =" + gammaMin + "  " + gammaMax + "  " + gammaStep);
        int numberRuns = 1;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            numberRuns = Math.max(1, Integer.parseInt(args[ano].substring(1, args[ano].length())));
        }
        System.out.println("--- Number of runs for each gamma value =" + numberRuns);
        boolean fileOutput = true;
        boolean graphMLOutput = true;
        boolean projectedGraphOutput = false;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            graphMLOutput = StringFilter.trueString((char)args[ano].charAt(1));
        }
        System.out.println("--- file output is " + StringFilter.onOffString((boolean)fileOutput));
        System.out.println("--- graphML output is " + StringFilter.onOffString((boolean)graphMLOutput));
        System.out.println("--- projected graph output is " + StringFilter.onOffString((boolean)projectedGraphOutput));
        String basicFileName = "BowTie";
        String[] aList = new String[]{"-fin" + basicFileName, "-fieinputELS.dat", "-o0", "-xi0"};
        if (args.length > 0) {
            aList = args;
        }
        tg = new timgraph();
        tg.parseParam(aList);
        if (!tg.isVertexEdgeListOn()) {
            System.err.println("\n *** Vertex Edge List NOT on and it is required, use -vgvet option ***\n");
        }
        tg.setNameRoot(MakeEdgePartition.tg.inputName.getNameRoot());
        int xColumn = 1;
        int yColumn = 2;
        boolean headerOn = false;
        boolean infoOn = false;
        int nameColumn = 1;
        tg.setNetworkFromInputFile(xColumn, yColumn, nameColumn, headerOn, infoOn);
        tg.printParametersBasic();
        tg.calcStrength();
        FileOutput fo = new FileOutput(tg);
        String extension = "_" + Math.round(1000.0 * gammaMin) + "_" + Math.round(1000.0 * gammaMax) + "_" + Math.round(1000.0 * gammaStep) + "_gamma.dat";
        fo.fileName.setNameEnd(extension);
        boolean printTriangles = true;
        boolean printSquares = true;
        boolean vertexListOn = true;
        boolean edgeListOn = false;
        boolean graphMLOn = false;
        boolean EP2VCprojOn = false;
        boolean incidenceGraphOn = false;
        boolean nextbit = true;
        MakeEdgePartition.analyseManyEdgePartitions(numberRuns, method, lgmethod, qdef, qualityType, gammaMin, gammaMax, gammaStep, printTriangles, printSquares, vertexListOn, edgeListOn, graphMLOn, EP2VCprojOn, incidenceGraphOn, nextbit);
    }

    public static void analyseManyEdgePartitions(int numberRuns, int method, int lgmethod, int qdef, int qualityType, double gammaMin, double gammaMax, double gammaStep, boolean printTriangles, boolean printSquares, boolean vertexListOn, boolean edgeListOn, boolean graphMLOn, boolean EP2VCprojOn, boolean incidenceGraphOn, boolean nextbit) {
        basicroot = MakeEdgePartition.tg.inputName.getNameRoot();
        FileOutput fo = new FileOutput(tg);
        OutputMode outputControl = null;
        fo.informationGeneral("", SEP, printTriangles, printSquares, vertexListOn, edgeListOn, graphMLOn, outputControl);
        if (tg.isVertexLabelled()) {
            fo.printEdges(true, false, false, false, false);
        } else {
            fo.edgeListSimple();
        }
        System.out.println("\n *** \n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod] + " *** \n");
        lineGraphtg = LineGraphProjector.makeLineGraph(tg, lgmethod, true);
        FileOutput folg = new FileOutput(lineGraphtg);
        if (graphMLOn) {
            folg.graphML();
        }
        folg.printEdges(true, true, true, true, true);
        String extension = "_" + Math.round(1000.0 * gammaMin) + "_" + Math.round(1000.0 * gammaMax) + "_" + Math.round(1000.0 * gammaStep) + "_gamma.dat";
        fo.fileName.setNameEnd(extension);
        VertexPartition louvainvp = null;
        try {
            FileOutputStream fout = new FileOutputStream(fo.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            for (double gamma = gammaMin; gamma <= gammaMax && !(gamma <= 0.0); gamma += gammaStep) {
                System.out.println("\n--- gamma=" + String.format("%6.3f", gamma) + " ----------------------------------------------------");
                louvainvp = VertexPartition.calculate(tg, qdef, qualityType, gamma, method, infoLevel);
                MakeEdgePartition.vertexPartitionGraphML(tg, louvainvp);
                for (int r = 0; r < numberRuns; ++r) {
                    VertexPartition ep = MakeEdgePartition.analyseOneEdgePartition(r, method, lgmethod, qdef, qualityType, gamma, printTriangles, printSquares, vertexListOn, edgeListOn, graphMLOn, EP2VCprojOn, incidenceGraphOn, nextbit, louvainvp);
                    PS.println(r + SEP + ep.getName() + SEP + ep.informationNumbers("", SEP));
                }
            }
            if (infoLevel > -2) {
                System.out.println("Finished writing EP various gamma information file to " + fo.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fo.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public static VertexPartition analyseOneEdgePartition(int runNumber, int method, int lgmethod, int qdef, int qualityType, double gamma, boolean printTriangles, boolean printSquares, boolean vertexListOn, boolean edgeListOn, boolean graphMLOn, boolean EP2VCprojOn, boolean incidenceGraphOn, boolean nextbit, VertexPartition louvainvp) {
        FileOutput fo = new FileOutput(tg);
        FileOutput folg = new FileOutput(lineGraphtg);
        System.out.println("*** Line Graph partition of type " + QualitySparse.QdefinitionString[qdef] + ", gamma=" + gamma);
        VertexPartition louvainep = VertexPartition.calculate(lineGraphtg, qdef, qualityType, gamma, method, infoLevel);
        louvainep.setName(louvainep.getName() + LineGraphProjector.lgExtensionList[lgmethod] + (runNumber < 0 ? "" : "r" + runNumber));
        System.out.println("    Communities info: " + louvainep.informationNumbers("", SEP));
        if (nextbit) {
            tg.setEdgeLabels(louvainep);
            fo = new FileOutput(tg);
            fo.printEdges(true, true, true, true, louvainep.getName());
            fo.printVertices("", SEP, null, printTriangles, printSquares, false);
            boolean splitBipartite = false;
            boolean outputType1 = false;
            fo.printEdgeCommunityStats(louvainep.getName(), true, true, splitBipartite, outputType1);
            MakeEdgePartition.edgePartitionGraphML(tg, louvainep);
            if (graphMLOn) {
                folg.graphMLVertexPartition(louvainep);
            }
            folg.informationPartition(louvainep, "", SEP, true);
            folg.printVertices("", SEP, louvainep, printTriangles, printSquares, false);
            if (louvainvp != null) {
                try {
                    MakeEdgePartition.vertexEdgePartitionGraphML(tg, louvainvp, louvainep);
                }
                catch (RuntimeException e) {
                    System.err.println("*** Tried and failed to produce vertex and edge parttioned graphML file, " + e);
                }
            }
        }
        if (EP2VCprojOn) {
            System.out.println("Trying a projection from edge partition to vertex community");
            MakeEdgePartition.doEP2VC(fo, tg, louvainep, qdef, gamma, qualityType);
        } else {
            System.out.println("No projection from edge partition to vertex community");
        }
        if (incidenceGraphOn) {
            System.out.println("\n *** \n *** Incidence Graph\n *** ");
            MakeEdgePartition.incidenceGraph(method);
        } else {
            System.out.println("No incidence graph");
        }
        return louvainep;
    }

    public static void analyseGraph(timgraph tg, int method, int lgmethod, int qdef, int qualityType, double lambda) {
        System.out.println("\n *** Analysing vertex and edge partitions of graph " + tg.inputName.getNameRoot());
        VertexPartition louvainvp = VertexPartition.calculate(tg, qdef, qualityType, lambda, method, infoLevel);
        MakeEdgePartition.vertexPartitionGraphML(tg, louvainvp);
        FileOutput fo = new FileOutput(tg);
        fo.pajekPartition(louvainvp.getName(), louvainvp);
        System.out.println("\n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod] + " *** \n");
        timgraph lg = LineGraphProjector.makeLineGraph(tg, lgmethod, true);
        FileOutput folg = new FileOutput(lg);
        folg.graphML();
        folg.printEdges(true, true, true, true, true);
        System.out.println("\n ***  Line Graph partition of type " + QualitySparse.QdefinitionString[qdef] + ", quality type =" + QualityType.qualityLongName[qualityType] + ", lambda=" + lambda);
        VertexPartition louvainlgvp = VertexPartition.calculate(lg, qdef, qualityType, lambda, method, infoLevel);
        louvainlgvp.setName(louvainlgvp.getName() + LineGraphProjector.lgExtensionList[lgmethod]);
        tg.setEdgeLabels(louvainlgvp);
        fo.printEdges(true, true, true, true, louvainlgvp.getName());
        boolean printNearestNeighbours = false;
        boolean printTriangles = true;
        boolean printSquares = true;
        fo.printVertices("", SEP, null, printTriangles, printSquares, printNearestNeighbours);
        boolean splitBipartite = false;
        boolean outputType1 = false;
        fo.printEdgeCommunityStats(true, true, splitBipartite, outputType1);
        MakeEdgePartition.edgePartitionGraphML(tg, louvainlgvp);
        MakeEdgePartition.vertexEdgePartitionGraphML(tg, louvainvp, louvainlgvp);
        folg.graphMLVertexPartition(louvainlgvp);
        folg.informationPartition(louvainlgvp, "", SEP, true);
        System.out.println("*** Finished analysing vertex and edge partitions of graph " + tg.inputName.getNameRoot());
    }

    public static void doEP2VC(FileOutput fo, timgraph tg, VertexPartition lgvp, int qdef, double newlambda, int qualityType) {
        VertexCommunity vc = new VertexCommunity(tg, lgvp, qdef, qualityType, newlambda);
        vc.calcQuality();
        fo.informationVertexCommunity(vc, "", SEP, true);
    }

    public static void doEP2VCandVP(FileOutput fo, timgraph tg, VertexPartition lgvp, int qdef, double newlambda, int qualityType) {
        VertexCommunity vc = new VertexCommunity(tg, lgvp, qdef, qualityType, newlambda);
        vc.calcQuality();
        fo.informationVertexCommunity(vc, "", SEP, true);
        VertexPartition pvp = new VertexPartition(tg, lgvp);
        pvp.calcQuality();
        fo.graphMLVertexPartition(pvp);
        MakeEdgePartition.vertexEdgePartitionGraphML(tg, pvp, lgvp);
    }

    public static void vertexPartitionGraphML(timgraph tg, VertexPartition vp) {
        FileOutput fo = new FileOutput(tg);
        fo.graphMLVertexPartition(vp);
        fo.printPartitionStats(vp, "", SEP, true, true);
        fo.informationPartition(vp, "", SEP, true);
    }

    public static void edgePartitionGraphML(timgraph tg, VertexPartition ep) {
        FileOutput fo = new FileOutput(tg);
        fo.graphMLEdgePartition(ep);
        fo.informationEdgePartition(ep, "", SEP, true);
    }

    public static void vertexEdgePartitionGraphML(timgraph tg, VertexPartition vp, VertexPartition ep) {
        FileOutput fo = new FileOutput(tg);
        fo.graphMLVertexEdgePartition(vp, ep);
        fo.informationVertexEdgePartition(vp, ep, "", SEP, true);
    }

    public static void incidenceVertexPartitionGraphML(timgraph tg, VertexPartition ip) {
        FileOutput fo = new FileOutput(tg);
        fo.graphMLIncidencePartition(ip);
        fo.informationIncidenceVertexPartition(ip, "", SEP, true);
    }

    public static void incidenceGraph(int vpmethod) {
        timgraph ig = tg.makeIncidenceGraph(tg.isDirected(), true, tg.isWeighted(), true);
        if (infoLevel > 1 && ig.getNumberVertices() < 21) {
            ig.printNetwork(true);
        }
        FileOutput foig = new FileOutput(ig);
        foig.informationNetworkBasic("", SEP);
        foig.graphML();
        foig.edgeListSimple();
        foig.printVertices("", SEP, null, true, true, true, false, false, false, false, true);
        VertexPartition iglouvainvp = VertexPartition.calculate(ig, 0, vpmethod, infoLevel);
        MakeEdgePartition.vertexPartitionGraphML(ig, iglouvainvp);
        MakeEdgePartition.incidenceVertexPartitionGraphML(tg, iglouvainvp);
    }

    static {
        infoLevel = 0;
    }
}

