/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.LouvainVertexPartition;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.SimulatedAnnealingvertexPartition;
import TimGraph.Community.VertexCommunity;
import TimGraph.Community.VertexPartition;
import TimGraph.OutputMode;
import TimGraph.algorithms.LineGraphProjector;
import TimGraph.io.FileOutput;
import TimGraph.io.GraphMLGenerator;
import TimGraph.io.GraphViz;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class LineGraphCommunities {
    static final String[] COMMUNITYMETHOD = new String[]{"Louvain", "SimAn"};
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static timgraph lineGraphtg;
    static int infoLevel;

    public LineGraphCommunities(timgraph newtg) {
        tg = newtg;
    }

    public static void usage(PrintStream PS) {
        char arg = timgraph.NOT_TIMGRAPH_ARGUMENT[0];
        PS.println("LineGraphCommunities " + arg + "<filename> " + arg + "<method> " + arg + "<lineGraphType> " + arg + "<quality> " + arg + "<lambda> -<timgraphArgument> ...");
        PS.println("Arguments for this class start with any of " + timgraph.otherArguments(", ") + ", but " + arg + " used for example here.");
        PS.println("First " + arg + " argument is the network number for the setup routine OR ? for this help");
        PS.println("Second " + arg + " argument is the method used to find communities, 0=Louvain/Greedy, 1= Simulated Annealing");
        PS.println("Third " + arg + " argument is type of line graph to use 0=C, 1=Ctilde, 2=D, 3=E (Dtilde)");
        PS.println("Fourth " + arg + " argument is definition of quality to use, 0=Q(A), 1=Q(A" + arg + "A-A)");
        PS.println("Fifth " + arg + " argument is type of quality class to use, 0=basic (dense matrix), 1=sparse matrix, 2=minimal memory ");
        PS.println("Sixth " + arg + " argument is value of lambda, scaling parameter of null model.");
        PS.println("Remaining arguments should start with a - and are parsed by <tt>timgraph</tt>.");
        SetUpNetwork.printNetworkTypes(PS, "", "  ");
    }

    public static void main(String[] args) {
        boolean incidenceGraphOn;
        boolean bestOn;
        System.out.println("LineGraphCommunities Arguments :networknumber :method :linegraphtype :qualitydef :qualityclass :lambda");
        int n = 142;
        int ano = 0;
        if (args.length > ano) {
            if (timgraph.isOtherArgument(args[ano])) {
                if (args[ano].charAt(1) == '?') {
                    LineGraphCommunities.usage(System.out);
                    return;
                }
                n = Integer.parseInt(args[ano].substring(1, args[ano].length()));
            } else {
                n = 0;
            }
        }
        System.out.println("--- Using network  " + SetUpNetwork.typeString(n));
        int method = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            method = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Using community method " + COMMUNITYMETHOD[method]);
        int lgmethod = 2;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            lgmethod = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Using Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod]);
        int qdef = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            qdef = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[qdef]);
        int qualityType = 2;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            qualityType = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[qualityType]);
        double lambda = 1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            lambda = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Line Graph null model scaling lambda=" + lambda);
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        tg = SetUpNetwork.setUpNetwork(n, args);
        basicroot = LineGraphCommunities.tg.inputName.getNameRoot();
        FileOutput fo = new FileOutput(tg);
        boolean printTrianglesSquares = true;
        boolean vertexListOn = true;
        boolean edgeListOn = false;
        boolean graphMLOn = false;
        OutputMode outputControl = null;
        fo.informationGeneral("", SEP, printTrianglesSquares, printTrianglesSquares, vertexListOn, edgeListOn, graphMLOn, outputControl);
        if (tg.isVertexLabelled()) {
            fo.printEdges(true, false, false, false, false);
        } else {
            fo.edgeListSimple();
        }
        System.out.println("\n *** \n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod] + " *** \n");
        lineGraphtg = LineGraphProjector.makeLineGraph(tg, lgmethod, true);
        FileOutput folg = new FileOutput(lineGraphtg);
        if (graphMLOn) {
            folg.graphML();
        }
        folg.printEdges(true, true, true, true, true);
        System.out.println("*** Line Graph partition of type " + QualitySparse.QdefinitionString[qdef] + ", lambda=" + lambda);
        VertexPartition louvainep = VertexPartition.calculate(lineGraphtg, qdef, qualityType, lambda, method, infoLevel);
        louvainep.setName(louvainep.getName() + LineGraphProjector.lgExtensionList[lgmethod]);
        boolean nextbit = true;
        if (n >= 140 && n < 150) {
            nextbit = true;
        }
        if (nextbit) {
            tg.setEdgeLabels(louvainep);
            fo = new FileOutput(tg);
            fo.printEdges(true, true, true, true, louvainep.getName());
            printTrianglesSquares = false;
            fo.printVertices("", SEP, null, printTrianglesSquares, printTrianglesSquares, false);
            boolean splitBipartite = false;
            boolean outputType1 = false;
            fo.printEdgeCommunityStats(louvainep.getName(), true, true, splitBipartite, outputType1);
            LineGraphCommunities.edgePartitionGraphML(tg, louvainep);
            if (graphMLOn) {
                folg.graphMLVertexPartition(louvainep);
            }
            folg.informationPartition(louvainep, "", SEP, true);
            folg.printVertices("", SEP, louvainep, printTrianglesSquares, printTrianglesSquares, false);
            VertexPartition louvainvp = VertexPartition.calculate(tg, qdef, qualityType, lambda, method, infoLevel);
            LineGraphCommunities.vertexPartitionGraphML(tg, louvainvp);
            LineGraphCommunities.vertexEdgePartitionGraphML(tg, louvainvp, louvainep);
        }
        boolean EP2VCprojOn = false;
        if (n >= 140 && n < 150) {
            EP2VCprojOn = true;
        }
        if (EP2VCprojOn) {
            System.out.println("Trying a projection from edge partition to vertex community");
            LineGraphCommunities.doEP2VC(fo, tg, louvainep, qdef, lambda, qualityType);
        } else {
            System.out.println("No projection from edge partition to vertex community");
        }
        boolean actualOn = true;
        if (actualOn) {
            if (basicroot.startsWith("karate")) {
                LineGraphCommunities.karateActualVP(fo, folg, method, louvainep);
            }
        } else {
            System.out.println("No actual partition for karate dealt with");
        }
        if (bestOn = true) {
            if (basicroot.startsWith("karate")) {
                LineGraphCommunities.karateBestVP(fo, folg, method, louvainep);
            }
        } else {
            System.out.println("No best  partition for karate dealt with");
        }
        if (incidenceGraphOn = false) {
            System.out.println("\n *** \n *** Incidence Graph\n *** ");
            LineGraphCommunities.incidenceGraph(method);
        } else {
            System.out.println("No incidence graph");
        }
    }

    public static void analyseGraph(timgraph tg, int method, int lgmethod, int qdef, int qualityType, double lambda) {
        System.out.println("\n *** Analysing vertex and edge partitions of graph " + tg.inputName.getNameRoot());
        VertexPartition louvainvp = VertexPartition.calculate(tg, qdef, qualityType, lambda, method, infoLevel);
        LineGraphCommunities.vertexPartitionGraphML(tg, louvainvp);
        FileOutput fo = new FileOutput(tg);
        fo.pajekPartition(louvainvp.getName(), louvainvp);
        System.out.println("\n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod] + " *** \n");
        timgraph lg = LineGraphProjector.makeLineGraph(tg, lgmethod, true);
        FileOutput folg = new FileOutput(lg);
        folg.graphML();
        folg.printEdges(true, true, true, true, true);
        System.out.println("\n ***  Line Graph partition of type " + QualitySparse.QdefinitionString[qdef] + ", quality type =" + QualityType.qualityLongName[qualityType] + ", lambda=" + lambda);
        VertexPartition louvainlgvp = VertexPartition.calculate(lg, qdef, qualityType, lambda, method, infoLevel);
        louvainlgvp.setName(louvainlgvp.getName() + LineGraphProjector.lgExtensionList[lgmethod]);
        tg.setEdgeLabels(louvainlgvp);
        fo.printEdges(true, true, true, true, louvainlgvp.getName());
        boolean printNearestNeighbours = false;
        boolean printTrianglesSquares = true;
        fo.printVertices("", SEP, null, printTrianglesSquares, printTrianglesSquares, printNearestNeighbours);
        boolean splitBipartite = false;
        boolean outputType1 = false;
        fo.printEdgeCommunityStats(true, true, splitBipartite, outputType1);
        LineGraphCommunities.edgePartitionGraphML(tg, louvainlgvp);
        LineGraphCommunities.vertexEdgePartitionGraphML(tg, louvainvp, louvainlgvp);
        folg.graphMLVertexPartition(louvainlgvp);
        folg.informationPartition(louvainlgvp, "", SEP, true);
        System.out.println("*** Finished analysing vertex and edge partitions of graph " + tg.inputName.getNameRoot());
    }

    public static void doEP2VC(FileOutput fo, timgraph tg, VertexPartition lgvp, int qdef, double newlambda, int qualityType) {
        VertexCommunity vc = new VertexCommunity(tg, lgvp, qdef, qualityType, newlambda);
        vc.calcQuality();
        fo.informationVertexCommunity(vc, "", SEP, true);
    }

    public static void doEP2VCandVP(FileOutput fo, timgraph tg, VertexPartition lgvp, int qdef, double newlambda, int qualityType) {
        VertexCommunity vc = new VertexCommunity(tg, lgvp, qdef, qualityType, newlambda);
        vc.calcQuality();
        fo.informationVertexCommunity(vc, "", SEP, true);
        VertexPartition pvp = new VertexPartition(tg, lgvp);
        pvp.calcQuality();
        fo.graphMLVertexPartition(pvp);
        LineGraphCommunities.vertexEdgePartitionGraphML(tg, pvp, lgvp);
    }

    public static void testLambda(int method) {
        int i;
        double[] lambdaList = new double[]{0.001, 0.1, 0.2, 0.3, 0.4, 0.425, 0.45, 0.5, 0.55, 0.6, 0.7, 0.8, 0.9, 1.0, 2.0, 4.0, 10.0, 20.0, 100.0};
        double[] results = new double[lambdaList.length];
        int[] nc = new int[lambdaList.length];
        for (i = 0; i < lambdaList.length; ++i) {
            double lambda = lambdaList[i];
            VertexPartition louvainep = VertexPartition.calculate(lineGraphtg, 0, 1, lambda, method, infoLevel);
            results[i] = louvainep.calcQuality();
            nc[i] = louvainep.getNumberOfCommunities();
        }
        System.out.println("lambda\tQ\tNo.Comm.");
        for (i = 0; i < lambdaList.length; ++i) {
            System.out.println(lambdaList[i] + SEP + results[i] + SEP + nc[i]);
        }
    }

    public static VertexPartition karateActualVP(FileOutput fo, FileOutput folg, int method, VertexPartition louvainep) {
        String pname = "Actualvp";
        VertexPartition actualvp = LineGraphCommunities.readVP(tg, "karate", pname);
        actualvp.recalculateCommunityLabels();
        actualvp.calcQuality();
        LineGraphCommunities.vertexPartitionGraphML(tg, actualvp);
        LineGraphCommunities.vertexEdgePartitionGraphML(tg, actualvp, louvainep);
        return actualvp;
    }

    public static VertexPartition karateBestVP(FileOutput fo, FileOutput folg, int method, VertexPartition louvainep) {
        String pname = "AK07BestQvp";
        VertexPartition bestvp = LineGraphCommunities.readVP(tg, "karate", pname);
        bestvp.recalculateCommunityLabels();
        bestvp.calcQuality();
        LineGraphCommunities.vertexPartitionGraphML(tg, bestvp);
        LineGraphCommunities.vertexEdgePartitionGraphML(tg, bestvp, louvainep);
        return bestvp;
    }

    public static void otherKarateTests(FileOutput fo, FileOutput folg, int method, VertexPartition louvainep) {
        String pname = "AK07BestQvp";
        VertexPartition bestvp = LineGraphCommunities.readVP(tg, "karate", pname);
        bestvp.recalculateCommunityLabels();
        bestvp.calcQuality();
        LineGraphCommunities.vertexPartitionGraphML(tg, bestvp);
        pname = "Other";
        LineGraphCommunities.lineGraphtg.inputName.setNameRoot("karateNeATLG");
        VertexPartition LGothervp = LineGraphCommunities.readVP(lineGraphtg, LineGraphCommunities.lineGraphtg.inputName.getNameRoot(), pname);
        LGothervp.recalculateCommunityLabels();
        LGothervp.calcQuality();
        LineGraphCommunities.vertexPartitionGraphML(lineGraphtg, LGothervp);
        LGothervp.printInformation(System.out, " ", "  ");
        pname = "Otherep";
        LineGraphCommunities.tg.inputName.setNameRoot("karateNeAT" + pname);
        VertexPartition otherep = LineGraphCommunities.readEP(tg, pname);
        otherep.printInformation(System.out, " ", "  ");
        tg.setEdgeLabels(otherep);
        fo.fileName.setNameRoot(LineGraphCommunities.tg.outputName.getNameRoot());
        fo.printEdges(true, true, true, true, otherep.getName());
        LineGraphCommunities.edgePartitionGraphML(tg, otherep);
        folg.fileName.setNameRoot(basicroot + "LG");
        folg.graphMLVertexPartition(otherep);
        LineGraphCommunities.vertexEdgePartitionGraphML(tg, bestvp, louvainep);
        LineGraphCommunities.vertexEdgePartitionGraphML(tg, bestvp, otherep);
    }

    public static VertexPartition readVP(timgraph tg, String nameRoot, String vpName) {
        VertexPartition vp = new VertexPartition(tg);
        vp.initialise(tg);
        vp.setName(vpName);
        boolean relabelOn = true;
        vp.readIntPartition(tg.inputName.getDirectoryFull() + nameRoot + vpName + "inputVP.dat", 1, 2, true, relabelOn);
        vp.calcQuality();
        return vp;
    }

    public static VertexPartition readEP(timgraph tg, String epname) {
        boolean makeUnweighted = false;
        boolean useSelfLoops = false;
        timgraph lgtg = new timgraph(tg, false, makeUnweighted, useSelfLoops, false, false);
        VertexPartition ep = new VertexPartition(lgtg);
        ep.initialise(lgtg);
        ep.setName(epname);
        boolean relabelOn = true;
        ep.readIntPartition(tg.inputName.getNameRootFullPath() + "inputEP.dat", 1, 2, true, relabelOn);
        ep.calcQuality();
        return ep;
    }

    public static void graphML(timgraph tg) {
        FileOutput fo = new FileOutput(tg);
        fo.graphML();
    }

    public static void vertexPartitionGraphML(timgraph tg, VertexPartition vp) {
        FileOutput fo = new FileOutput(tg);
        fo.graphMLVertexPartition(vp);
        fo.printPartitionStats(vp, "", SEP, true, true);
        fo.informationPartition(vp, "", SEP, true);
    }

    public static void edgePartitionGraphML(timgraph tg, VertexPartition ep) {
        FileOutput fo = new FileOutput(tg);
        fo.graphMLEdgePartition(ep);
        fo.informationEdgePartition(ep, "", SEP, true);
    }

    public static void vertexEdgePartitionGraphML(timgraph tg, VertexPartition vp, VertexPartition ep) {
        FileOutput fo = new FileOutput(tg);
        fo.graphMLVertexEdgePartition(vp, ep);
        fo.informationVertexEdgePartition(vp, ep, "", SEP, true);
    }

    public static void incidenceVertexPartitionGraphML(timgraph tg, VertexPartition ip) {
        FileOutput fo = new FileOutput(tg);
        fo.graphMLIncidencePartition(ip);
        fo.informationIncidenceVertexPartition(ip, "", SEP, true);
    }

    public static void incidenceGraph(int vpmethod) {
        timgraph ig = tg.makeIncidenceGraph(tg.isDirected(), true, tg.isWeighted(), true);
        if (infoLevel > 1 && ig.getNumberVertices() < 21) {
            ig.printNetwork(true);
        }
        FileOutput foig = new FileOutput(ig);
        foig.informationNetworkBasic("", SEP);
        foig.graphML();
        foig.edgeListSimple();
        foig.printVertices("", SEP, null, true, true, true, false, false, false, false, true);
        VertexPartition iglouvainvp = VertexPartition.calculate(ig, 0, vpmethod, infoLevel);
        LineGraphCommunities.vertexPartitionGraphML(ig, iglouvainvp);
        LineGraphCommunities.incidenceVertexPartitionGraphML(tg, iglouvainvp);
    }

    public static void testLineGraphity() {
        tg.printEdges();
        System.out.println("*** LineGraph Graph");
        boolean makeUnweighted = false;
        boolean useSelfLoops = false;
        String lineGraphType = "LG" + (makeUnweighted ? "uw" : "w") + (useSelfLoops ? "sl" : "nsl");
        timgraph ltg = new timgraph(tg, false, makeUnweighted, useSelfLoops, false, false);
        ltg.setNameRoot(basicroot + lineGraphType);
        ltg.printEdges();
    }

    public VertexPartition testLouvainCommunityTwoSteps() {
        VertexPartition c;
        int method = 1;
        switch (method) {
            default: {
                LouvainVertexPartition lc = new LouvainVertexPartition(tg, 0, 1, 2);
                lc.calculate();
                c = lc;
                break;
            }
            case 2: {
                SimulatedAnnealingvertexPartition sac = new SimulatedAnnealingvertexPartition(tg);
                sac.calc(10, 0.5);
                c = sac;
            }
        }
        c.recalculateCommunityLabels();
        boolean ignoreNegativeLabels = true;
        c.relabelCommunities(ignoreNegativeLabels);
        System.out.println("*** now Projected Graph");
        timgraph projg = new timgraph(tg, c.getCommunity(), c.getNumberOfCommunities(), false, false);
        projg.printEdges(System.out);
        switch (method) {
            default: {
                LouvainVertexPartition lc = new LouvainVertexPartition(projg, 0, 1, 2);
                lc.calculate();
                c = lc;
                break;
            }
            case 2: {
                SimulatedAnnealingvertexPartition sac = new SimulatedAnnealingvertexPartition(projg);
                sac.calc(10, 0.5);
                c = sac;
            }
        }
        c.relabelCommunities(ignoreNegativeLabels);
        return c;
    }

    public static void testLineGraphGraphMLOld(timgraph tg, VertexPartition c) {
        GraphMLGenerator gml = new GraphMLGenerator();
        tg.outputName.setNameEnd(".graphml");
        if (tg.getInformationLevel() > -2) {
            System.out.println("Writing LineGraphGraphML file to " + tg.outputName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(tg.outputName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            gml.outputEdgePartition(PS, tg, c);
            if (tg.getInformationLevel() > -2) {
                System.out.println("Finished writing LineGraphGraphML file to " + tg.outputName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + tg.outputName.getFullFileName());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file " + tg.outputName.getFullFileName());
            return;
        }
    }

    public static void testGraphViz(timgraph tg, VertexPartition c) {
        GraphViz gv = new GraphViz();
        tg.inputName.setNameEnd(".gv");
        if (tg.getInformationLevel() > -2) {
            System.out.println("Writing GraphViz file to " + tg.outputName.getFullFileName());
        }
        try {
            FileOutputStream fout = new FileOutputStream(tg.outputName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            gv.outputVertexCommunity(PS, tg, c, true);
            if (tg.getInformationLevel() > -2) {
                System.out.println("Finished writing GraphViz file to " + tg.outputName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + tg.outputName.getFullFileName());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file " + tg.outputName.getFullFileName());
            return;
        }
    }

    static {
        infoLevel = 0;
    }
}

