/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import JavaNotes.TextReader;
import JavaNotes.TextReaderTabSeparated;
import TimGraph.io.FileInput;
import TimGraph.run.Paper;
import TimGraph.run.SetOfPapers;
import TimGraph.run.UniversityOrganisation;
import TimUtilities.FileUtilities.FileNameSequence;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class ImperialPapersCR {
    static final String SEP = "\t";
    static String dirRoot = "/PRG/networks/timgraph/";
    UniversityOrganisation organisation;
    SetOfPapers setOfPapers;
    int infoLevel = 0;
    FileNameSequence inputName;
    FileNameSequence outputName;

    public static void main(String[] args) {
        System.out.println("*** ImperialPapersCR");
        ImperialPapersCR icr = new ImperialPapersCR();
        boolean test = false;
        String nameroot = "IC20090521";
        if (test) {
            nameroot = "ICtest20090521";
        }
        icr.inputName = new FileNameSequence(dirRoot, "input/", nameroot, "");
        icr.outputName = new FileNameSequence(dirRoot, "output/", nameroot, "");
        icr.readPaperSectionFile(true);
        icr.readPaperSectionFile(false);
        icr.readPaperCitationsFile();
        boolean headerOn = true;
        boolean sectionsOn = true;
        boolean levelOn = true;
        icr.setOfPapers.outputPapers(icr.outputName, SEP, headerOn, sectionsOn);
        icr.organisation.outputFile(icr.outputName, SEP, headerOn, levelOn);
        icr.outputUnits(SEP, headerOn);
        icr.outputName.setNameRoot(nameroot + "_psec");
        icr.setOfPapers.makeGraphEdgeList(icr.outputName, SEP, 1);
        icr.outputName.setNameRoot(nameroot + "_pdept");
        icr.outputUnits(SEP, headerOn, 1);
        icr.setOfPapers.makeGraphEdgeList(icr.outputName, SEP, icr.organisation.getFilterFactor(1));
        icr.outputName.setNameRoot(nameroot);
        icr.makeAllGRCYList();
        icr.makeLevelGRCYList(0);
        icr.makeLevelGRCYList(1);
    }

    public void makeLevelGRCYList(int level) {
        String levelName = this.organisation.getLevelName(level);
        this.outputName.setDirectoryEnd("output/" + levelName + "/");
        this.outputName.makeDirectories();
        int nUnits = this.organisation.getNumber(level);
        for (int nl = 1; nl < nUnits; ++nl) {
            HashSet<Paper> chosenPapers = this.makeUnitSubList(nl, level);
            boolean headerOn = true;
            boolean yearOn = true;
            boolean infoOn = true;
            String name = this.organisation.getNameFromLocalIndex(nl, level);
            name = UniversityOrganisation.toFileName(name);
            this.outputName.setNameRoot(this.inputName.getNameRoot() + name);
            SetOfPapers.outputGRCYList(this.outputName, SEP, chosenPapers, headerOn, yearOn, infoOn);
        }
    }

    public void makeAllGRCYList() {
        this.outputName.setDirectoryEnd("output/");
        boolean headerOn = true;
        boolean yearOn = true;
        boolean infoOn = true;
        this.outputName.setNameRoot(this.inputName.getNameRoot() + "All");
        this.setOfPapers.outputAllGRCYList(this.outputName, SEP, headerOn, yearOn, infoOn);
    }

    public HashSet<Paper> makeUnitSubList(int nlocal, int level) {
        HashSet<Paper> chosenPapers = new HashSet<Paper>();
        Collection<Paper> papers = this.setOfPapers.getPapers();
        block0: for (Paper p : papers) {
            for (Integer s : p.getSections()) {
                if (!this.organisation.isInUnit(s, nlocal, level)) continue;
                chosenPapers.add(p);
                continue block0;
            }
        }
        return chosenPapers;
    }

    public void printUnits(PrintStream PS, String sep, boolean headerOn, int level) {
        TreeSet<Integer> allFullUnitsUsed = this.setOfPapers.getAllUnitsUsed();
        if (headerOn) {
            PS.println("index" + sep + this.organisation.levelNameString(sep));
        }
        TreeSet<Object> allUnitsUsed = new TreeSet();
        int f = this.organisation.getFilterFactor(level);
        if (f == 1) {
            allUnitsUsed = allFullUnitsUsed;
        } else {
            for (Integer n : allFullUnitsUsed) {
                allUnitsUsed.add(n / f);
            }
        }
        for (Integer n : allUnitsUsed) {
            PS.print(n);
            String[] s = this.organisation.getName(n * f, level);
            for (int l = 0; l < s.length; ++l) {
                PS.print(sep + s[l]);
            }
            PS.println();
        }
    }

    public void outputUnits(String sep, boolean headerOn) {
        this.outputName.setNameEnd("UsedUnits.dat");
        this.outputUnits(this.outputName.getFullFileName(), sep, headerOn, UniversityOrganisation.NUMBERLEVELS - 1);
    }

    public void outputUnits(String sep, boolean headerOn, int level) {
        this.outputName.setNameEnd("UsedUnits.dat");
        this.outputUnits(this.outputName.getFullFileName(), sep, headerOn, level);
    }

    public void outputUnits(String fullfilename, String sep, boolean headerOn, int level) {
        if (this.infoLevel > -2) {
            System.out.println("Writing list of all " + this.organisation.getLevelNamePlural(level) + " used to " + fullfilename);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullfilename);
            PrintStream PS = new PrintStream(fout);
            this.printUnits(PS, sep, headerOn, level);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing list of all " + this.organisation.getLevelNamePlural(level) + " units used to " + fullfilename);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + fullfilename + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fullfilename + ", " + e.getMessage());
            return;
        }
    }

    public int readPaperSectionFile(boolean createOrganisation) {
        this.inputName.setNameEnd("sections.txt");
        return this.readPaperSectionFile(this.inputName.getFullFileName(), createOrganisation);
    }

    public int readPaperSectionFile(String fullfilename, boolean createOrganisation) {
        int maxColumns = 4;
        if (createOrganisation) {
            this.organisation = new UniversityOrganisation();
        } else {
            this.setOfPapers = new SetOfPapers();
        }
        int res = 0;
        TextReaderTabSeparated data = FileInput.openTabSeparatedFile(fullfilename);
        if (data == null) {
            return -1;
        }
        if (res < 0) {
            return res;
        }
        System.out.println("Starting to read paper section list from " + fullfilename + " and " + (createOrganisation ? "creating orgainisation" : "setting up set of papers"));
        try {
            System.out.println(" File: " + fullfilename);
            int linenumber = 0;
            while (!data.eof()) {
                ++linenumber;
                if (this.infoLevel > 2) {
                    System.out.println(linenumber + ": ");
                }
                int column = 0;
                String s = data.getln();
                String[] numbers = s.split(SEP, maxColumns + 1);
                if (numbers.length > maxColumns) {
                    System.out.println("!!! Warning - line " + linenumber + " does not have " + maxColumns + " columns but has " + numbers.length);
                }
                if (this.infoLevel > 1) {
                    System.out.print(linenumber);
                    for (int c = 0; c < numbers.length; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                    System.out.println();
                }
                try {
                    if (numbers.length < 4) {
                        System.out.println("!!! Warning too few columns on line " + linenumber + ", found " + column + ", column 0=" + numbers[0]);
                        String[] newNumbers = new String[maxColumns];
                        for (int c = numbers.length; c < maxColumns; ++c) {
                            newNumbers[c] = c < numbers.length ? numbers[c] : "";
                        }
                        numbers = newNumbers;
                    }
                    if (createOrganisation) {
                        if (numbers[2].length() == 0 && numbers[3].length() > 0) {
                            System.out.println("at line " + linenumber);
                        }
                        this.organisation.addSection(numbers[1], numbers[2], numbers[3]);
                        continue;
                    }
                    int unitNumber = this.organisation.getUnitIndex(numbers[1], numbers[2], numbers[3]);
                    this.setOfPapers.addUnitsToPaper(numbers[0], unitNumber);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                }
            }
            System.out.println("Finished reading Paper-Sections File from " + fullfilename);
            if (createOrganisation) {
                System.out.println("... " + this.organisation.informationSetString(" "));
            }
        }
        catch (TextReader.Error e) {
            throw new RuntimeException("*** Input Error: " + e.getMessage());
        }
        finally {
            data.close();
        }
        if (createOrganisation) {
            this.organisation.finishSetUp();
            System.out.println("... finished setting up organisation");
        } else {
            this.setOfPapers.sortSections();
            System.out.println("... finished setting up set of papers");
        }
        return res;
    }

    public int readPaperCitationsFile() {
        this.inputName.setNameEnd("citations.txt");
        return this.readPaperCitationsFile(this.inputName.getFullFileName());
    }

    public int readPaperCitationsFile(String fullfilename) {
        int maxColumns = 5;
        int res = 0;
        TextReaderTabSeparated data = FileInput.openTabSeparatedFile(fullfilename);
        if (data == null) {
            return -1;
        }
        if (res < 0) {
            return res;
        }
        System.out.println("Starting to read paper citations list from " + fullfilename);
        try {
            System.out.println(" File: " + fullfilename);
            int linenumber = 0;
            while (!data.eof()) {
                ++linenumber;
                if (this.infoLevel > 2) {
                    System.out.println(linenumber + ": ");
                }
                boolean column = false;
                String s = data.getln();
                String[] numbers = s.split(SEP, maxColumns + 1);
                if (this.infoLevel > 1) {
                    System.out.print(linenumber);
                    for (int c = 0; c < numbers.length; ++c) {
                        System.out.print(", " + numbers[c]);
                    }
                    System.out.println();
                }
                try {
                    if (numbers.length != maxColumns) {
                        System.out.println("!!! WARNING Wrong number of columns on line " + linenumber + ", found " + numbers.length);
                        res = -10;
                    }
                    String gid = numbers[0];
                    int year = this.tryIntegerParse(numbers[1], "year", linenumber);
                    String date = numbers[2];
                    int citations = this.tryIntegerParse(numbers[3], "citations", linenumber);
                    int references = this.tryIntegerParse(numbers[4], "references", linenumber);
                    Paper p = this.setOfPapers.getPaper(gid);
                    p.setYear(year);
                    p.setDate(date);
                    p.setCitations(citations);
                    p.setReferences(references);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + ", " + e.getMessage());
                }
            }
            System.out.println("Finished reading Paper-Sections File from " + fullfilename);
        }
        catch (TextReader.Error e) {
            throw new RuntimeException("*** Input Error: " + e.getMessage());
        }
        finally {
            data.close();
        }
        return res;
    }

    private int tryIntegerParse(String s, String name, int linenumber) {
        int n = -1;
        try {
            n = Integer.parseInt(s);
        }
        catch (RuntimeException e) {
            System.out.println("!!! WARNING problem with " + name + " \"" + s + "\" on line " + linenumber);
        }
        return n;
    }
}

