/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run.ImperialPapers;

import TimGraph.run.ImperialPapers.Paper;
import TimUtilities.FileUtilities.FileNameSequence;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;

public class SetOfPapers {
    TreeMap<String, Paper> paperMap = new TreeMap();
    int numberPapers = 0;
    int infoLevel = 0;

    public Collection<Paper> getPapers() {
        return this.paperMap.values();
    }

    public Paper getPaper(String gid) {
        return this.paperMap.get(gid);
    }

    public TreeSet<Integer> getAllUnitsUsed() {
        TreeSet<Integer> allUnitsUsed = new TreeSet<Integer>();
        for (Paper p : this.paperMap.values()) {
            allUnitsUsed.addAll(p.getSections());
        }
        return allUnitsUsed;
    }

    public void addUnitsToPaper(String gid, int unitIndex) {
        Paper p = this.getPaper(gid);
        if (p == null) {
            p = new Paper(this.numberPapers++, gid, unitIndex);
            this.paperMap.put(gid, p);
        } else {
            p.addSection(unitIndex);
        }
    }

    public void sortSections() {
        for (Paper p : this.paperMap.values()) {
            p.sortSections();
        }
    }

    public void print(PrintStream PS, String sep, boolean headerOn, boolean sectionsOn) {
        Collection<Paper> papers = this.paperMap.values();
        if (headerOn) {
            PS.println(Paper.toStringLabel(sep) + (sectionsOn ? sep + "sections" : ""));
        }
        for (Paper p : papers) {
            PS.println(p.toString(sep) + (sectionsOn ? sep + p.stringOfSections(sep) : ""));
        }
    }

    public void outputPapers(FileNameSequence fns, String sep, boolean headerOn, boolean sectionsOn) {
        fns.setNameEnd("papers.dat");
        this.outputPapers(fns.getFullFileName(), sep, headerOn, sectionsOn);
    }

    public void outputPapers(String fullfilename, String sep, boolean headerOn, boolean sectionsOn) {
        if (this.infoLevel > -2) {
            System.out.println("Writing list of all known units to " + fullfilename);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullfilename);
            PrintStream PS = new PrintStream(fout);
            this.print(PS, sep, headerOn, sectionsOn);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing list of all known papers to " + fullfilename);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + fullfilename + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fullfilename + ", " + e.getMessage());
            return;
        }
    }

    public static void outputGRCList(FileNameSequence fns, String sep, Collection<Paper> papers, boolean headerOn, boolean infoOn) {
        fns.setNameEnd("grc.dat");
        SetOfPapers.outputGRCYList(fns.getFullFileName(), sep, papers, headerOn, false, infoOn);
    }

    public static void outputGRCYList(FileNameSequence fns, String sep, Collection<Paper> papers, boolean headerOn, boolean yearOn, boolean infoOn) {
        fns.setNameEnd("grc" + (yearOn ? "y" : "") + ".dat");
        SetOfPapers.outputGRCYList(fns.getFullFileName(), sep, papers, headerOn, yearOn, infoOn);
    }

    public void outputAllGRCYList(FileNameSequence fns, String sep, boolean headerOn, boolean yearOn, boolean infoOn) {
        fns.setNameEnd("grc" + (yearOn ? "y" : "") + ".dat");
        SetOfPapers.outputGRCYList(fns.getFullFileName(), sep, this.paperMap.values(), headerOn, yearOn, infoOn);
    }

    public static void outputGRCYList(String fullfilename, String sep, Collection<Paper> papers, boolean headerOn, boolean yearOn, boolean infoOn) {
        if (infoOn) {
            System.out.println("Writing gid-reference-citation" + (yearOn ? "-year" : "") + " list to " + fullfilename);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullfilename);
            PrintStream PS = new PrintStream(fout);
            if (headerOn) {
                PS.println("gid" + sep + "References" + sep + "Citations" + (yearOn ? sep + "year" : ""));
            }
            for (Paper p : papers) {
                PS.println(p.gid + sep + p.getReferences() + sep + p.getCitations() + (yearOn ? sep + p.getYear() : ""));
            }
            if (infoOn) {
                System.out.println("Finished gid-reference-citation" + (yearOn ? "-year" : "") + " list to " + fullfilename);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + fullfilename + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fullfilename + ", " + e.getMessage());
            return;
        }
    }

    public void makeGraphEdgeList(FileNameSequence fns, String sep, int factor) {
        fns.setNameEnd("inputBVNLS.dat");
        this.makeGraphEdgeList(fns.getFullFileName(), sep, factor);
    }

    public void makeGraphEdgeList(String fullfilename, String sep, int factor) {
        if (this.infoLevel > -2) {
            System.out.println("Writing bipartite vertex neighbour list of strings, paper-section, to " + fullfilename);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullfilename);
            PrintStream PS = new PrintStream(fout);
            for (Paper p : this.paperMap.values()) {
                int na = p.getNumberAuthors();
                if (na == 0) continue;
                PS.println(p.gid + sep + p.stringOfSections(sep, factor));
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished bipartite vertex neighbour list of strings, paper-section, to " + fullfilename);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + fullfilename + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fullfilename + ", " + e.getMessage());
            return;
        }
    }
}

