/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run.ImperialPapers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Paper {
    public static final int UNSET = -912345687;
    int id = -912345687;
    String gid = "";
    int year = -912345687;
    String date = "";
    int ref = -912345687;
    int cite = -912345687;
    ArrayList<Integer> sectionNumber;

    public Paper(int id, String gid) {
        this.id = id;
        this.gid = gid;
        this.sectionNumber = new ArrayList();
    }

    public Paper(int id, String gid, int section) {
        this.id = id;
        this.gid = gid;
        this.sectionNumber = new ArrayList();
        this.addSection(section);
    }

    public void setReferences(int r) {
        this.ref = r;
    }

    public void setCitations(int c) {
        this.cite = c;
    }

    public void setYear(int y) {
        this.year = y;
    }

    public void setDate(String d) {
        this.date = d;
    }

    public int getReferences() {
        return this.ref;
    }

    public int getCitations() {
        return this.cite;
    }

    public int getYear() {
        return this.year;
    }

    public String getDate() {
        return this.date;
    }

    public int getNumberAuthors() {
        return this.sectionNumber.size();
    }

    public Collection<Integer> getSections() {
        return this.sectionNumber;
    }

    public void addSection(int n) {
        this.sectionNumber.add(n);
    }

    public void sortSections() {
        Collections.sort(this.sectionNumber);
    }

    public boolean isInSection(int n) {
        return this.sectionNumber.contains(n);
    }

    public String toString(String sep) {
        return this.id + sep + this.gid + sep + this.year + sep + this.date + sep + this.getNumberAuthors() + sep + this.cite + sep + this.ref;
    }

    public static String toStringLabel(String sep) {
        return "id" + sep + "gid" + sep + "year" + sep + "date" + sep + "no.authors" + sep + "cite" + sep + "ref";
    }

    public String stringOfSections(String sep) {
        return this.stringOfSections(sep, 1);
    }

    public String stringOfSections(String sep, int factor) {
        if (this.sectionNumber.size() == 0) {
            return "";
        }
        String s = "";
        for (Integer i : this.sectionNumber) {
            s = s + (s.length() > 0 ? sep : " ") + i / factor;
        }
        return s;
    }
}

