/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run.ImperialPapers;

import TimGraph.OutputMode;
import TimGraph.algorithms.BipartiteTransformations;
import TimGraph.run.BasicAnalysis;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;

public class Merge {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static int infoLevel = 0;

    public static void main(String[] args) {
        System.out.println("ImperialPapers Arguments :<network1number> :<network2number> :<outputMode> :<basicAnalysis>");
        int n1 = 139;
        int ano = 0;
        if (args.length > ano) {
            if (timgraph.isOtherArgument(args[ano])) {
                if (args[ano].charAt(1) == '?') {
                    SetUpNetwork.printNetworkTypes(System.out, "", "  ");
                    n1 = 0;
                } else {
                    n1 = Integer.parseInt(args[ano].substring(1, args[ano].length()));
                }
            } else {
                n1 = 0;
            }
        }
        System.out.println("--- Using network one " + SetUpNetwork.typeString(n1));
        int n2 = 119;
        if (args.length > ++ano) {
            if (timgraph.isOtherArgument(args[ano])) {
                if (args[ano].charAt(1) == '?') {
                    SetUpNetwork.printNetworkTypes(System.out, "", "  ");
                    n2 = 0;
                } else {
                    n2 = Integer.parseInt(args[ano].substring(1, args[ano].length()));
                }
            } else {
                n2 = 0;
            }
        }
        System.out.println("--- Using network two " + SetUpNetwork.typeString(n2));
        int outputMode = 255;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            outputMode = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        OutputMode om = new OutputMode(outputMode);
        System.out.println("--- Output Mode " + outputMode + ": " + om.getModeString(" "));
        boolean basicAnalysis = true;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano]) && args[ano].charAt(1) == 'y') {
            basicAnalysis = true;
        }
        System.out.println("--- Basic analysis is " + (basicAnalysis ? "on" : "off"));
        boolean basicAnalysis1 = false;
        boolean basicAnalysis2 = false;
        timgraph tg1 = Merge.processNetworkFile(n1, outputMode, basicAnalysis1, args);
        timgraph tg2 = Merge.processNetworkFile(n2, outputMode, basicAnalysis2, args);
        String newNameRoot = tg1.inputName.getDirectoryRoot();
        String newDirectoryRoot = tg1.inputName.getDirectoryRoot();
        boolean makeLabelled = true;
        boolean makeVertexEdgeList = true;
        timgraph ng = BipartiteTransformations.merge(tg1, tg2, true, true, newNameRoot, newDirectoryRoot, infoLevel, outputMode, makeLabelled, makeVertexEdgeList);
        if (ng.getNumberVertices() < 40) {
            ng.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(ng);
        }
    }

    public static timgraph processNetworkFile(int n, int outputMode, boolean basicAnalysis, String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        timgraph tg = SetUpNetwork.setUpNetwork(n, args);
        if (outputMode >= 0) {
            tg.outputControl.set(outputMode);
        }
        if (tg.getNumberVertices() < 40) {
            tg.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(tg);
        }
        return tg;
    }
}

