/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run.ImperialPapers;

import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.VertexPartition;
import TimGraph.algorithms.LineGraphProjector;
import TimGraph.io.FileOutput;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;

public class LineGraphCommunity {
    static final String[] COMMUNITYMETHOD = new String[]{"Louvain", "SimAn"};
    static final String SEP = "\t";
    static int infoLevel = 0;

    public static void main(String[] args) {
        System.out.println("ImperialPapers.LineGraphCommunity Arguments <filenameroot> <method> <linegraphtype> <qualitydef> <qualityclass> <lambda>");
        String fileNameRoot = "BowTie";
        int ano = 0;
        if (args.length > ano) {
            fileNameRoot = args[ano];
        }
        System.out.println("--- Using network  " + fileNameRoot);
        int method = 0;
        if (args.length > ++ano) {
            method = Integer.parseInt(args[ano]);
        }
        System.out.println("--- Using community method " + COMMUNITYMETHOD[method]);
        int lgmethod = 2;
        if (args.length > ++ano) {
            lgmethod = Integer.parseInt(args[ano]);
        }
        System.out.println("--- Using Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod]);
        int qdef = 0;
        if (args.length > ++ano) {
            qdef = Integer.parseInt(args[ano]);
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[qdef]);
        int qualityType = 2;
        if (args.length > ++ano) {
            qualityType = Integer.parseInt(args[ano]);
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[qualityType]);
        double lambda = 1.0;
        if (args.length > ++ano) {
            lambda = Double.parseDouble(args[ano]);
        }
        System.out.println("--- Line Graph null model scaling lambda=" + lambda);
        timgraph tg = new timgraph();
        String[] aList = new String[]{"-gvet", "-gdf", "-gewt", "-gvlt", "-gbf", "-fin" + fileNameRoot, "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        SetUpNetwork.initialise(tg, fileNameRoot, aList, infoLevel);
        System.out.println("\n *** \n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[lgmethod] + " (type " + lgmethod + ") *** \n");
        timgraph lineGraphtg = LineGraphProjector.makeLineGraph(tg, lgmethod, true);
        FileOutput folg = new FileOutput(lineGraphtg);
        System.out.println("*** Line Graph partition of type " + QualitySparse.QdefinitionString[qdef] + ", lambda=" + lambda);
        VertexPartition louvainep = VertexPartition.calculate(lineGraphtg, qdef, qualityType, lambda, method, infoLevel);
        louvainep.setName(louvainep.getName() + LineGraphProjector.lgExtensionList[lgmethod]);
        tg.setEdgeLabels(louvainep);
        FileOutput fo = new FileOutput(tg);
        fo.printEdges(true, true, true, true, louvainep.getName());
        fo.printVertices("", SEP, null, false, false, false);
        boolean splitBipartite = false;
        boolean outputType1 = false;
        fo.printEdgeCommunityStats(louvainep.getName(), true, true, splitBipartite, outputType1);
    }
}

