/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run.ImperialPapers;

import TimGraph.Community.VertexPartition;
import TimGraph.OutputMode;
import TimGraph.algorithms.BipartiteTransformations;
import TimGraph.algorithms.Projections;
import TimGraph.run.BasicAnalysis;
import TimGraph.run.LineGraphCommunities;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import TimUtilities.FileUtilities.FileOutput;
import TimUtilities.StringUtilities.Filters.ImperialPapersFilter;
import TimUtilities.StringUtilities.Filters.StringFilter;
import TimUtilities.StringUtilities.Filters.TextFileProcessor;
import cern.colt.list.DoubleArrayList;
import java.util.TreeMap;

public class General {
    static final String SEP = "\t";
    static final Double LOG26 = Math.log(26.0);
    static final int ACHAR = 65;
    static String basicroot = "UNSET";
    static int infoLevel = 0;

    public static void main(String[] args) {
        System.out.println("ImperialPapers.General Arguments :<networknumber> :<outputMode> :<basicAnalysis> :<minWeight> :<lambda>");
        int n = 111;
        int ano = 0;
        if (args.length > ano) {
            if (timgraph.isOtherArgument(args[ano])) {
                if (args[ano].charAt(1) == '?') {
                    SetUpNetwork.printNetworkTypes(System.out, "", "  ");
                    n = 0;
                } else {
                    n = Integer.parseInt(args[ano].substring(1, args[ano].length()));
                }
            } else {
                n = 0;
            }
        }
        System.out.println("--- Using network  " + SetUpNetwork.typeString(n));
        int outputMode = 3;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            outputMode = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        OutputMode om = new OutputMode(outputMode);
        System.out.println("--- Output Mode " + outputMode + ": " + om.getModeString(" "));
        boolean basicAnalysis = true;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano]) && args[ano].charAt(1) == 'y') {
            basicAnalysis = true;
        }
        System.out.println("--- Basic analysis is " + (basicAnalysis ? "on" : "off"));
        double minWeightCut = 0.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            minWeightCut = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        if (minWeightCut > 0.0) {
            System.out.println("--- Minimum Weight is  " + minWeightCut);
        } else {
            System.out.println("--- No Minimum Weight cut ");
        }
        double lambda = 0.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            lambda = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        if (lambda > 0.0) {
            System.out.println("--- lambda is  " + lambda);
        } else {
            System.out.println("--- No lambda, no vertex partitions ");
        }
        if (minWeightCut > 0.0) {
            DoubleArrayList minWeightList = new DoubleArrayList();
            double minWeight = minWeightCut;
            for (int w = 0; w < 4; ++w) {
                minWeightList.add(minWeight);
                minWeightList.add(minWeight / 2.0);
                minWeightList.add(minWeight / 5.0);
                minWeight /= 10.0;
            }
            General.minEdgeWeight(n, minWeightList, outputMode, basicAnalysis, args);
            Runtime.getRuntime().exit(0);
        }
        if (n == 111 || n == 114) {
            SetUpNetwork.setUpNetwork(n, args);
            --n;
        }
        if (n >= 110 && n < 120) {
            General.processOriginalFile(n, outputMode, basicAnalysis, lambda, args);
        }
        if (n >= 120 && n < 130) {
            General.processTermTerm(n, outputMode, basicAnalysis, lambda, args);
        }
        if (n >= 130 && n < 140) {
            General.processSections(n, outputMode, basicAnalysis, args);
        }
        if (n >= 140 && n < 150) {
            General.processPaperPaper(n, outputMode, basicAnalysis, lambda, args);
        }
    }

    public static void processSections(int n, int outputMode, boolean basicAnalysis, String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        System.out.println("\n *** Processing paper-unit graphs");
        timgraph tgpu = SetUpNetwork.setUpNetwork(n, args);
        if (tgpu.getNumberVertices() < 20) {
            tgpu.printNetwork(true);
        }
        tgpu.calcStrength();
        if (basicAnalysis) {
            BasicAnalysis.analyse(tgpu);
        }
        basicroot = tgpu.inputName.getNameRoot();
        int us = basicroot.lastIndexOf(95);
        String unitName = basicroot.substring(us + 2, basicroot.length());
        String stub = basicroot.substring(0, us);
        BipartiteTransformations bt = new BipartiteTransformations();
        int method = 0;
        int lgmethod = 2;
        int qdef = 0;
        int qualityType = 2;
        double lambda = 1.0;
        System.out.println("\n *** " + unitName + "-" + unitName + " projection");
        timgraph unitg = BipartiteTransformations.project(tgpu, false, tgpu.isVertexLabelled(), true, tgpu.isVertexEdgeListOn(), true);
        unitg.setNameRoot(stub + "_" + unitName);
        if (unitg.getNumberVertices() < 20) {
            unitg.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(unitg);
            TimGraph.io.FileOutput fo = new TimGraph.io.FileOutput(unitg);
            fo.pajek(false, false);
        }
        unitg.calcStrength();
        LineGraphCommunities.analyseGraph(unitg, method, lgmethod, qdef, qualityType, lambda);
    }

    public static void processPaperPaper(int n, int outputMode, boolean basicAnalysis, double lambda, String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        System.out.println("\n *** analysing paper-paper projection vertex partition");
        timgraph termg = SetUpNetwork.setUpNetwork(n, args);
        if (termg.getNumberVertices() < 20) {
            termg.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(termg);
        }
        termg.calcStrength();
        if (lambda > 0.0) {
            System.out.println("\n *** Analysing vertex partitions of graph " + termg.inputName.getNameRoot());
            int method = 0;
            int lgmethod = 2;
            int qdef = 0;
            int qualityType = 2;
            VertexPartition louvainvp = VertexPartition.calculate(termg, qdef, qualityType, lambda, method, infoLevel);
            LineGraphCommunities.vertexPartitionGraphML(termg, louvainvp);
        }
    }

    public static void processTermTerm(int n, int outputMode, boolean basicAnalysis, double lambda, String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        System.out.println("\n *** analysing term-term projection vertex partition");
        timgraph termg = SetUpNetwork.setUpNetwork(n, args);
        if (termg.getNumberVertices() < 20) {
            termg.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(termg);
        }
        termg.calcStrength();
        if (lambda > 0.0) {
            System.out.println("\n *** Analysing vertex partitions of graph " + termg.inputName.getNameRoot());
            int method = 0;
            int lgmethod = 2;
            int qdef = 0;
            int qualityType = 2;
            VertexPartition louvainvp = VertexPartition.calculate(termg, qdef, qualityType, lambda, method, infoLevel);
            LineGraphCommunities.vertexPartitionGraphML(termg, louvainvp);
        }
    }

    public static void minEdgeWeight(int n, double minWeight, int outputMode, boolean basicAnalysis, String[] args) {
        DoubleArrayList minWeightList = new DoubleArrayList();
        minWeightList.add(minWeight);
        General.minEdgeWeight(n, minWeightList, outputMode, basicAnalysis, args);
    }

    public static void minEdgeWeight(int n, DoubleArrayList minWeightList, int outputMode, boolean basicAnalysis, String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        System.out.print("\n *** " + SetUpNetwork.typeString(n) + " projection cut on minimum edge weights of: ");
        for (int w = 0; w < minWeightList.size(); ++w) {
            System.out.print(minWeightList.get(w));
        }
        System.out.println();
        timgraph termg = SetUpNetwork.setUpNetwork(n, args);
        if (termg.getNumberVertices() < 20) {
            termg.printNetwork(true);
        }
        boolean makeLabelled = termg.isVertexLabelled();
        boolean makeWeighted = termg.isWeighted();
        boolean makeVertexEdgeList = false;
        for (int w = 0; w < minWeightList.size(); ++w) {
            double minWeight = minWeightList.get(w);
            timgraph consg = Projections.minimumEdgeWeight(termg, minWeight, makeLabelled, makeWeighted, makeVertexEdgeList);
            consg.setNameRoot(termg.inputName.getNameRoot() + "ew" + Math.round(minWeight * 1000.0));
            if (consg.getNumberVertices() < 20) {
                consg.printNetwork(true);
            }
            consg.calcStrength();
            if (!basicAnalysis) continue;
            BasicAnalysis.analyse(consg);
        }
    }

    public static void preProcess(timgraph tg, String basicFileName, boolean convertIgnoreColumn, int numberLinesToSkip, boolean showProcess) {
        String preStemmedFileName = tg.inputName.getDirectoryFull() + basicFileName + "ptinputBVNLS.dat";
        String outputroot = basicFileName + (convertIgnoreColumn ? "np" : "") + (numberLinesToSkip > 1 ? Integer.valueOf(numberLinesToSkip) : "") + "stem";
        String postStemmedFileName = tg.inputName.getDirectoryFull() + outputroot + "ptinputBVNLS.dat";
        TreeMap stemMap = new TreeMap();
        TreeMap acceptedCountMap = new TreeMap();
        int columnIgnored = 1;
        String sep = SEP;
        ImperialPapersFilter ipf = new ImperialPapersFilter(2, 3, true);
        TextFileProcessor.processWordListFile((String)preStemmedFileName, (String)postStemmedFileName, (int)columnIgnored, (boolean)convertIgnoreColumn, (String)"\t ", stemMap, acceptedCountMap, (StringFilter)ipf, (int)numberLinesToSkip, (boolean)false);
        System.out.println("Stemming file " + preStemmedFileName + ", taking every " + numberLinesToSkip + " lines only, paper gid " + (convertIgnoreColumn ? "converted to simple index" : "left as original string"));
        System.out.println("Applied " + ipf.description());
        System.out.println("Producing file " + postStemmedFileName);
        String outputFileName = tg.outputName.getDirectoryFull() + outputroot + "ptStemMap.dat";
        FileOutput.FileOutputMap((String)outputFileName, (String)sep, stemMap, (boolean)true);
        outputFileName = tg.outputName.getDirectoryFull() + outputroot + "ptRejectList.dat";
        ipf.FileOutputRejectedList(outputFileName, showProcess);
    }

    public static void processOriginalFile(int n, int outputMode, boolean basicAnalysis, double lambda, String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        timgraph tg = SetUpNetwork.setUpNetwork(n, args);
        basicroot = tg.inputName.getNameRoot();
        if (!tg.inputName.getNameRoot().startsWith("IC")) {
            throw new RuntimeException("*** File read in does not start with IC, it was " + basicroot);
        }
        if (outputMode >= 0) {
            tg.outputControl.set(outputMode);
        }
        if (tg.getNumberVertices() < 40) {
            tg.printNetwork(true);
        }
        String stub = basicroot.substring(0, basicroot.length() - 2);
        boolean makeLabelled = true;
        if (!makeLabelled) {
            tg.makeUnlabelled();
            stub = stub + "UL";
        }
        System.out.println("\n *** term-term projection");
        timgraph termg = BipartiteTransformations.project(tg, false, tg.isVertexLabelled(), true, tg.isVertexEdgeListOn(), true);
        termg.setNameRoot(stub + "tt");
        if (termg.getNumberVertices() < 20) {
            termg.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(termg);
        }
        System.out.println("\n *** paper-paper " + (makeLabelled ? "" : "unlabelled ") + "projection");
        timgraph paperg = BipartiteTransformations.project(tg, true, makeLabelled, true, tg.isVertexEdgeListOn(), true);
        paperg.setNameRoot(stub + "pp");
        if (paperg.getNumberVertices() < 20) {
            paperg.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(paperg);
        }
        if (lambda <= 0.0) {
            return;
        }
        System.out.println("\n *** Vertex Communities");
        int method = 0;
        int lgmethod = 2;
        int qdef = 0;
        int qualityType = 2;
        termg.calcStrength();
        LineGraphCommunities.analyseGraph(termg, method, lgmethod, qdef, qualityType, lambda);
        paperg.calcStrength();
        LineGraphCommunities.analyseGraph(paperg, method, lgmethod, qdef, qualityType, lambda);
        if (basicAnalysis) {
            BasicAnalysis.analyse(tg);
        }
    }
}

