/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run.ImperialPapers;

import DataAnalysis.MutualInformation;
import TimGraph.Community.Community;
import TimGraph.Community.VertexCommunity;
import TimGraph.Community.VertexPartition;
import TimGraph.OutputMode;
import TimGraph.run.BasicAnalysis;
import TimGraph.run.SetUpNetwork;
import TimGraph.run.VertexCommunities;
import TimGraph.timgraph;
import java.util.TreeMap;

public class Compare {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static int infoLevel = 0;

    public static void main(String[] args) {
        System.out.println("ImperialPapers Arguments :<network> :<communityStructure> :<outputMode> :<basicAnalysis>");
        int n1 = 149;
        int ano = 0;
        if (args.length > ano) {
            if (timgraph.isOtherArgument(args[ano])) {
                if (args[ano].charAt(1) == '?') {
                    SetUpNetwork.printNetworkTypes(System.out, "", "  ");
                    n1 = 0;
                } else {
                    n1 = Integer.parseInt(args[ano].substring(1, args[ano].length()));
                }
            } else {
                n1 = 0;
            }
        }
        System.out.println("--- Using network one " + SetUpNetwork.typeString(n1));
        int n2 = 139;
        if (args.length > ++ano) {
            if (timgraph.isOtherArgument(args[ano])) {
                if (args[ano].charAt(1) == '?') {
                    SetUpNetwork.printNetworkTypes(System.out, "", "  ");
                    n2 = 0;
                } else {
                    n2 = Integer.parseInt(args[ano].substring(1, args[ano].length()));
                }
            } else {
                n2 = 0;
            }
        }
        System.out.println("--- Using network two " + SetUpNetwork.typeString(n2));
        int outputMode = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            outputMode = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        OutputMode om = new OutputMode(outputMode);
        System.out.println("--- Output Mode " + outputMode + ": " + om.getModeString(" "));
        boolean basicAnalysis = false;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano]) && args[ano].charAt(1) == 'y') {
            basicAnalysis = true;
        }
        System.out.println("--- Basic analysis is " + (basicAnalysis ? "on" : "off"));
        boolean basicAnalysis1 = false;
        boolean basicAnalysis2 = false;
        timgraph tg1 = Compare.processNetworkFile(n1, outputMode, basicAnalysis1, args);
        timgraph tg2 = Compare.processNetworkFile(n2, outputMode, basicAnalysis2, args);
        VertexCommunity vc2 = new VertexCommunity(tg1);
        TreeMap<String, Integer> vertexNameToIndex = tg1.getVertexNameIndexMap();
        boolean forceNormalisation = false;
        boolean checkNormalisation = true;
        boolean forceLowerCase = true;
        boolean checkBipartite = true;
        int sampleFrequency = 1;
        tg2.inputName.setNameEnd("inputBVNLS.dat");
        String fullFileName = tg2.inputName.getFullFileName();
        vc2.readStringVertexCommunitiesFile(vertexNameToIndex, fullFileName, forceLowerCase, checkBipartite, sampleFrequency, forceNormalisation, checkNormalisation);
        int qdef = 0;
        int qualityType = 2;
        double lambda = 1.0;
        int method = 0;
        boolean graphMLOutput = false;
        VertexPartition vp1 = VertexCommunities.calculateVertexPartition(tg1, qdef, qualityType, lambda, method, infoLevel, graphMLOutput);
        VertexCommunity vc1 = new VertexCommunity(tg1, vp1, qdef, qualityType, lambda);
        vc1.printCommunities(System.out, "", " ", true, true);
        vc2.printCommunities(System.out, "", " ", true, true);
        MutualInformation mi = Community.calcMutualInformation(vc1, vc2, tg1);
        int r = mi.checkNormalisations();
        if (r > 0) {
            throw new RuntimeException(mi.checkNormalisationsString(r));
        }
        System.out.println(" --- " + mi.checkNormalisationsString(r));
        r = mi.checkConsistentcy();
        if (r < 0) {
            throw new RuntimeException("Consistency Failure");
        }
        System.out.println(" --- Consistent probabilties");
        System.out.println(MutualInformation.toStringLabelDescriptive((String)" : "));
        System.out.println(MutualInformation.toStringLabel((String)" : "));
        System.out.println(mi.toString(" : "));
    }

    public static timgraph makeVertexPartition(int n, int outputMode, boolean basicAnalysis, String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        timgraph tg = SetUpNetwork.setUpNetwork(n, args);
        if (outputMode >= 0) {
            tg.outputControl.set(outputMode);
        }
        if (tg.getNumberVertices() < 40) {
            tg.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(tg);
        }
        return tg;
    }

    public static timgraph processNetworkFile(int n, int outputMode, boolean basicAnalysis, String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        timgraph tg = SetUpNetwork.setUpNetwork(n, args);
        if (outputMode >= 0) {
            tg.outputControl.set(outputMode);
        }
        if (tg.getNumberVertices() < 40) {
            tg.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(tg);
        }
        return tg;
    }
}

