/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import DataAnalysis.EntropyStatistics;
import DataAnalysis.MutualInformation;
import DataAnalysis.MutualInformationStatistics;
import TimGraph.Community.Community;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.VertexPartition;
import TimGraph.io.FileOutput;
import TimGraph.run.LineGraphCommunities;
import TimGraph.run.MakeVertexPartition;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class CompareVertexPartitions {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    int infoLevel = 0;
    EntropyStatistics sStats;
    EntropyStatistics sStatsTwo;
    MutualInformationStatistics miStats;

    public static void main(String[] args) {
        boolean infoOn = true;
        System.out.println("CompareVertexPartitions Arguments :<method> :<qualitydef> :<qualitytype> :<gammaMin> :<gammaMax> :<gammaStep> :<graphMLOn> :<numberRuns>");
        int ano = 0;
        int method = 0;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            method = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Using community method " + LineGraphCommunities.COMMUNITYMETHOD[method]);
        int qdef = 0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            qdef = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[qdef]);
        int qualityType = 2;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            qualityType = Integer.parseInt(args[ano].substring(1, args[ano].length()));
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[qualityType]);
        double gammaMin = 1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaMin = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double gammaMax = gammaMin + 0.25;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaMax = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        double minStep = 0.001;
        double gammaStep = 0.1;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaStep = Double.parseDouble(args[ano].substring(1, args[ano].length()));
        }
        if (Math.abs(gammaStep) < minStep) {
            throw new RuntimeException("Step size must be greater than " + minStep + " in magnitude");
        }
        System.out.println("--- Modularity null model scaling gamma min, max step =" + gammaMin + "  " + gammaMax + "  " + gammaStep);
        int numberRuns = 3;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            numberRuns = Math.max(1, Integer.parseInt(args[ano].substring(1, args[ano].length())));
        }
        System.out.println("--- Number of runs for each gamma value =" + numberRuns);
        boolean fileOutput = false;
        boolean graphMLOutput = false;
        boolean projectedGraphOutput = false;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            graphMLOutput = StringFilter.trueString((char)args[ano].charAt(1));
        }
        System.out.println("--- file output is " + StringFilter.onOffString((boolean)fileOutput));
        System.out.println("--- graphML output is " + StringFilter.onOffString((boolean)graphMLOutput));
        System.out.println("--- projected graph output is " + StringFilter.onOffString((boolean)projectedGraphOutput));
        String basicFileName = "karateTSE";
        String[] aList = new String[]{"-gvet", "-gdf", "-gewf", "-gvlt", "-gelf", "-gbf", "-fin" + basicFileName, "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        if (args.length > 0) {
            aList = args;
        }
        timgraph tg = new timgraph();
        tg.parseParam(aList);
        if (!tg.isVertexEdgeListOn()) {
            System.err.println("\n *** Vertex Edge List NOT on and it is required, use -vgvet option ***\n");
        }
        tg.setNameRoot(tg.inputName.getNameRoot());
        tg.setNetworkFromInputFile();
        tg.printParametersBasic();
        tg.calcStrength();
        CompareVertexPartitions cvp = new CompareVertexPartitions();
        cvp.compareUsingMethodFluctuations(tg, qdef, qualityType, gammaMin, gammaMax, gammaStep, method, numberRuns, fileOutput, graphMLOutput, projectedGraphOutput);
        cvp.compareUsingLouvainDeltaGamma(tg, qdef, qualityType, gammaMin, gammaMax, gammaStep, method, numberRuns, fileOutput, graphMLOutput, projectedGraphOutput);
        cvp.compareUsingRandomisedGraph(tg, qdef, qualityType, gammaMin, gammaMax, gammaStep, method, numberRuns, fileOutput, graphMLOutput, projectedGraphOutput);
    }

    public void compareUsingRandomisedGraph(timgraph tg, int qdef, int qualityType, double gammaMin, double gammaMax, double gammaStep, int method, int numberRuns, boolean fileOutput, boolean graphMLOutput, boolean projectedGraphOutput) {
        System.out.println("Comparing Vertex Partitions against randomised graphs");
        FileOutput fo = new FileOutput(tg);
        String extension = "_r" + numberRuns + "_" + Math.round(1000.0 * gammaMin) + "_" + Math.round(1000.0 * gammaMax) + "_" + Math.round(1000.0 * gammaStep) + "Rand_gamma.dat";
        fo.fileName.setNameEnd(extension);
        VertexPartition[] currentVP = new VertexPartition[numberRuns];
        VertexPartition[] randomVP = new VertexPartition[numberRuns];
        this.sStats = new EntropyStatistics("G(g)_");
        this.sStatsTwo = new EntropyStatistics("Rand_");
        this.miStats = new MutualInformationStatistics();
        timgraph rtg = tg;
        try {
            FileOutputStream fout = new FileOutputStream(fo.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println("name\tgamma\t" + this.sStats.toLabel(SEP) + SEP + this.sStatsTwo.toLabel(SEP) + SEP + this.miStats.toLabel(SEP));
            for (double gamma = gammaMin; gamma <= gammaMax && !(gamma <= 0.0); gamma += gammaStep) {
                System.out.println("\n--- gamma=" + String.format("%6.3f", gamma) + " ----------------------------------------------------");
                for (int r = 0; r < numberRuns; ++r) {
                    VertexPartition vp;
                    currentVP[r] = vp = MakeVertexPartition.calculateVertexPartition(tg, qdef, qualityType, gamma, method, r, this.infoLevel, fileOutput, graphMLOutput, projectedGraphOutput);
                    rtg = new timgraph(tg, tg.getMaximumVertices(), tg.getMaximumStubs(), false, false, false);
                    rtg.randomiseGraph();
                    rtg.addToNameRoot("Rand");
                    VertexPartition rvp = MakeVertexPartition.calculateVertexPartition(rtg, qdef, qualityType, gamma, method, r, this.infoLevel, fileOutput, graphMLOutput, projectedGraphOutput);
                    randomVP[r] = vp;
                }
                this.doComparison(currentVP, randomVP);
                System.out.println(this.sStats.averagesLabel(SEP) + SEP + this.sStatsTwo.averagesLabel(SEP) + SEP + this.miStats.averagesLabel(SEP));
                System.out.println(this.sStats.averagesString(SEP) + SEP + this.sStatsTwo.averagesString(SEP) + SEP + this.miStats.averagesString(SEP));
                PS.println(currentVP[0].getName() + SEP + gamma + SEP + this.sStats.toString(SEP) + SEP + this.sStatsTwo.toString(SEP) + SEP + this.miStats.toString(SEP));
            }
            if (this.infoLevel > -1) {
                System.out.println("Finished writing VP various gamma information file to " + fo.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fo.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public void compareUsingLouvainDeltaGamma(timgraph tg, int qdef, int qualityType, double gammaMin, double gammaMax, double gammaStep, int method, int numberRuns, boolean fileOutput, boolean graphMLOutput, boolean projectedGraphOutput) {
        System.out.println("Comparing Vertex Partitions for gamma against gamma-delta gamma");
        FileOutput fo = new FileOutput(tg);
        String extension = "_r" + numberRuns + "_" + Math.round(1000.0 * gammaMin) + "_" + Math.round(1000.0 * gammaMax) + "_" + Math.round(1000.0 * gammaStep) + "dgamma_gamma.dat";
        fo.fileName.setNameEnd(extension);
        VertexPartition[] currentVP = new VertexPartition[numberRuns];
        VertexPartition[] previousVP = new VertexPartition[numberRuns];
        this.sStats = new EntropyStatistics("G(g)_");
        this.sStatsTwo = new EntropyStatistics("G(g-dg)_");
        this.miStats = new MutualInformationStatistics();
        try {
            FileOutputStream fout = new FileOutputStream(fo.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println("name1\tname2\tgamma\t" + this.sStats.toLabel(SEP) + SEP + this.sStatsTwo.toLabel(SEP) + SEP + this.miStats.toLabel(SEP));
            for (double gamma = gammaMin; gamma <= gammaMax && !(gamma <= 0.0); gamma += gammaStep) {
                System.out.println("\n--- gamma=" + String.format("%6.3f", gamma) + " ----------------------------------------------------");
                for (int r = 0; r < numberRuns; ++r) {
                    VertexPartition vp = MakeVertexPartition.calculateVertexPartition(tg, qdef, qualityType, gamma, method, r, this.infoLevel, fileOutput, graphMLOutput, projectedGraphOutput);
                    previousVP[r] = currentVP[r];
                    currentVP[r] = vp;
                }
                if (!(gamma > gammaMin)) continue;
                this.doComparison(currentVP, previousVP);
                System.out.println(this.sStats.averagesLabel(SEP) + SEP + this.sStatsTwo.averagesLabel(SEP) + SEP + this.miStats.averagesLabel(SEP));
                System.out.println(this.sStats.averagesString(SEP) + SEP + this.sStatsTwo.averagesString(SEP) + SEP + this.miStats.averagesString(SEP));
                PS.println(currentVP[0].getName() + SEP + previousVP[0].getName() + SEP + gamma + SEP + this.sStats.toString(SEP) + SEP + this.sStatsTwo.toString(SEP) + SEP + this.miStats.toString(SEP));
            }
            if (this.infoLevel > -1) {
                System.out.println("Finished writing VP various gamma information file to " + fo.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fo.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public void compareUsingMethodFluctuations(timgraph tg, int qdef, int qualityType, double gammaMin, double gammaMax, double gammaStep, int method, int numberRuns, boolean fileOutput, boolean graphMLOutput, boolean projectedGraphOutput) {
        System.out.println("Comparing Vertex Partitions for gamma against each other");
        FileOutput fo = new FileOutput(tg);
        String extension = "_r" + numberRuns + "_" + Math.round(1000.0 * gammaMin) + "_" + Math.round(1000.0 * gammaMax) + "_" + Math.round(1000.0 * gammaStep) + "_gamma.dat";
        fo.fileName.setNameEnd(extension);
        VertexPartition[] currentVP = new VertexPartition[numberRuns];
        VertexPartition[] previousVP = new VertexPartition[numberRuns];
        this.sStats = new EntropyStatistics("G(g)_");
        this.miStats = new MutualInformationStatistics();
        try {
            FileOutputStream fout = new FileOutputStream(fo.fileName.getFullFileName());
            PrintStream PS = new PrintStream(fout);
            PS.println("name\tgamma\t" + this.sStats.toLabel(SEP) + SEP + this.miStats.toLabel(SEP));
            for (double gamma = gammaMin; gamma <= gammaMax && !(gamma <= 0.0); gamma += gammaStep) {
                System.out.println("\n--- gamma=" + String.format("%6.3f", gamma) + " ----------------------------------------------------");
                for (int r = 0; r < numberRuns; ++r) {
                    VertexPartition vp;
                    currentVP[r] = vp = MakeVertexPartition.calculateVertexPartition(tg, qdef, qualityType, gamma, method, r, this.infoLevel, fileOutput, graphMLOutput, projectedGraphOutput);
                }
                this.doComparison(currentVP);
                System.out.println(this.sStats.averagesLabel(SEP) + SEP + this.miStats.averagesLabel(SEP));
                System.out.println(this.sStats.averagesString(SEP) + SEP + this.miStats.averagesString(SEP));
                PS.println(currentVP[0].getName() + SEP + gamma + SEP + this.sStats.toString(SEP) + SEP + this.miStats.toString(SEP));
            }
            if (this.infoLevel > -1) {
                System.out.println("Finished writing VP various gamma information file to " + fo.fileName.getFullFileName());
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fo.fileName.getFullFileName() + ", " + e.getMessage());
            return;
        }
    }

    public void doComparison(VertexPartition[] vpArray) {
        int n = vpArray.length;
        this.miStats.reset();
        this.sStats.reset();
        for (int p1 = 0; p1 < vpArray.length; ++p1) {
            for (int p2 = p1 + 1; p2 < vpArray.length; ++p2) {
                MutualInformation mi = Community.calcMutualInformation(vpArray[p1], vpArray[p2], null);
                this.miStats.add(mi);
                if (p2 != p1 + 1) continue;
                this.sStats.addTwo(mi);
                if (p1 != 0) continue;
                this.sStats.addOne(mi);
            }
        }
    }

    public void doComparison(VertexPartition[] vpArray, VertexPartition[] vpArray2) {
        this.miStats.reset();
        this.sStats.reset();
        this.sStatsTwo.reset();
        for (int p1 = 0; p1 < vpArray.length; ++p1) {
            for (int p2 = 0; p2 < vpArray2.length; ++p2) {
                MutualInformation mi = Community.calcMutualInformation(vpArray[p1], vpArray2[p2], null);
                this.miStats.add(mi);
                if (p2 != p1) continue;
                this.sStatsTwo.addTwo(mi);
                this.sStats.addOne(mi);
            }
        }
    }
}

