/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import DataAnalysis.MutualInformation;
import TimGraph.Community.Community;
import TimGraph.Community.VertexCommunity;
import TimGraph.run.BasicAnalysis;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.util.TreeMap;

public class CompareVertexCommunities {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static int infoLevel = 0;

    public static void main(String[] args) {
        System.out.println("CompareVertexCommunities Arguments: fileName1 fileName2 outputNameRoot");
        String fileName1 = "input/TestVertexPartition1inputBVNLS.dat";
        int ano = 0;
        if (args.length > ano) {
            fileName1 = args[ano];
        }
        System.out.println("--- Using network one " + fileName1);
        String fileName2 = "input/TestVertexPartition2inputBVNLS.dat";
        if (args.length > ++ano) {
            fileName2 = args[ano];
        }
        System.out.println("--- Using network two " + fileName2);
        String rootName3 = "output/TestVP_1_2";
        if (args.length > ++ano) {
            rootName3 = args[ano];
        }
        System.out.println("--- Output to  " + rootName3);
        MutualInformation mi = CompareVertexCommunities.doComparision(fileName1, fileName2);
        System.out.println(MutualInformation.toStringLabelDescriptive((String)" : "));
        if (mi.getOrderOne() < 10 && mi.getOrderTwo() < 10) {
            System.out.println(MutualInformation.toStringLabel((String)" : "));
            System.out.println(mi.toString(" : "));
        }
        boolean statsOn = true;
        boolean jpOn = true;
        boolean entryLabelsOn = true;
        boolean numbersOn = true;
        boolean processInfoOn = true;
        mi.printToFile(rootName3, "", SEP, statsOn, jpOn, entryLabelsOn, numbersOn, processInfoOn);
        mi.printToFile(rootName3, "", SEP, statsOn, !jpOn, entryLabelsOn, numbersOn, processInfoOn);
        mi.printSummary(System.out, "", SEP, statsOn);
    }

    public static MutualInformation doComparision(String fileName1, String fileName2) {
        TreeMap<String, Integer> vertexNameToIndex = null;
        boolean forceNormalisation = true;
        boolean checkNormalisation = true;
        VertexCommunity vc1 = new VertexCommunity(fileName1);
        String name1 = StringFilter.beforeLastString((String)StringFilter.afterLastString((String)fileName1, (String)"/"), (String)".");
        vc1.setName(name1);
        vc1.readVertexCommunity(fileName1, vertexNameToIndex, forceNormalisation, checkNormalisation);
        if (vc1.getNumberElements() < 20) {
            vc1.printCommunityMatrix(System.out, "", " : ");
        }
        VertexCommunity vc2 = new VertexCommunity(fileName2);
        String name2 = StringFilter.beforeLastString((String)StringFilter.afterLastString((String)fileName2, (String)"/"), (String)".");
        vc2.setName(name2);
        vc2.readVertexCommunity(fileName2, vertexNameToIndex, forceNormalisation, checkNormalisation);
        if (vc2.getNumberElements() < 20) {
            vc2.printCommunityMatrix(System.out, "", " : ");
        }
        return CompareVertexCommunities.doComparision(vc1, vc2);
    }

    static MutualInformation doComparision(VertexCommunity vc1, VertexCommunity vc2) {
        MutualInformation mi = Community.calcMutualInformation(vc1, vc2, null);
        if (mi == null) {
            throw new RuntimeException("Community.calcMutualInformation failed to produce anything");
        }
        int r = mi.checkNormalisations();
        if (r > 0) {
            throw new RuntimeException("Normalisation failure, " + mi.checkNormalisationsString(r));
        }
        System.out.println(" --- " + mi.checkNormalisationsString(r));
        r = mi.checkConsistentcy();
        if (r < 0) {
            throw new RuntimeException("Consistency Failure");
        }
        System.out.println(" --- Consistent probabilties");
        return mi;
    }

    public static timgraph makeVertexPartition(int n, int outputMode, boolean basicAnalysis, String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        timgraph tg = SetUpNetwork.setUpNetwork(n, args);
        if (outputMode >= 0) {
            tg.outputControl.set(outputMode);
        }
        if (tg.getNumberVertices() < 40) {
            tg.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(tg);
        }
        return tg;
    }

    public static timgraph processNetworkFile(int n, int outputMode, boolean basicAnalysis, String[] args) {
        SetUpNetwork setnet = new SetUpNetwork(infoLevel);
        timgraph tg = SetUpNetwork.setUpNetwork(n, args);
        if (outputMode >= 0) {
            tg.outputControl.set(outputMode);
        }
        if (tg.getNumberVertices() < 40) {
            tg.printNetwork(true);
        }
        if (basicAnalysis) {
            BasicAnalysis.analyse(tg);
        }
        return tg;
    }
}

