/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import DataAnalysis.MutualInformation;
import TimGraph.run.CompareVertexCommunities;
import TimGraph.timgraph;
import TimUtilities.FileUtilities.FindFile;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class CompareTD2BU {
    public static void main(String[] args) {
        System.out.println("CompareTD2BU  :fileName1 :dirName2 :rootName2 :ext2 :outputNameRoot :gammaMultiplier");
        String fileName1 = "input/karateTSEActualVPinputBVNLS.dat";
        int ano = 0;
        if (args.length > ano && timgraph.isOtherArgument(args[ano])) {
            fileName1 = args[ano].substring(1);
        }
        System.out.println("--- Using reference network " + fileName1);
        String dirName2 = "output/karate/";
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            dirName2 = args[ano].substring(1);
        }
        String rootName2 = "karateTSE_VC_WLG_VP";
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            rootName2 = args[ano].substring(1);
        }
        String ext2 = "output.vcis";
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            ext2 = args[ano].substring(1);
        }
        System.out.println("--- Comparing against networks " + dirName2 + rootName2 + "(gamma)" + ext2);
        String rootName3 = "output/karateTSE_actual_WLG_VP";
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            rootName3 = args[ano].substring(1);
        }
        System.out.println("--- Output to  " + rootName3);
        double gammaMultiplier = 1.0;
        if (args.length > ++ano && timgraph.isOtherArgument(args[ano])) {
            gammaMultiplier = Double.parseDouble(args[ano].substring(1));
        }
        System.out.println("--- gamma multiplier  " + gammaMultiplier);
        FindFile ff = new FindFile();
        ff.getFileList(dirName2, rootName2, ext2, true);
        int nf = ff.filelist.length;
        String[] name2Array = new String[nf];
        MutualInformation[] miArray = new MutualInformation[nf];
        double[] gammaArray = new double[nf];
        PrintWriter results = null;
        String outputFile = rootName3 + "_gammaMI.dat";
        try {
            results = new PrintWriter(new FileWriter(outputFile));
        }
        catch (IOException e) {
            System.err.println("Problem with output file " + outputFile + ", " + e);
            System.exit(1);
        }
        System.out.println("--- Opened output file " + outputFile);
        String sep = "\t";
        results.println(MutualInformation.toStringBasicLabel((String)sep) + sep + "gamma" + sep + MutualInformation.toStringLabel((String)sep));
        for (int f = 0; f < nf; ++f) {
            String fullFileName2 = dirName2 + ff.filelist[f];
            System.out.println("--- Using network two " + fullFileName2);
            int c0 = fullFileName2.lastIndexOf(rootName2) + rootName2.length();
            int c1 = fullFileName2.lastIndexOf(ext2);
            String gammaString = fullFileName2.substring(c0, c1);
            double gamma = Double.parseDouble(gammaString) * gammaMultiplier;
            System.out.println("--- gamma =  " + gamma);
            MutualInformation mi = CompareVertexCommunities.doComparision(fileName1, fullFileName2);
            results.println(mi.toStringBasic(sep) + sep + gamma + sep + mi.toString(sep));
            results.flush();
            miArray[f] = new MutualInformation(mi, false, false);
            name2Array[f] = ff.filelist[f];
            gammaArray[f] = gamma;
        }
        results.close();
        System.out.println("--- Closed output file " + outputFile);
    }
}

