/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.OutputMode;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;

public class BasicAnalysis {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public BasicAnalysis(timgraph newtg) {
        tg = newtg;
    }

    public static void main(String[] args) {
        System.out.println("BasicAnalysis Arguments: just specify file name and characteristics using timgraph arguments alone");
        System.out.println("                         Output is controled by OutputMode argument -oNNN");
        OutputMode o = new OutputMode(255.0);
        o.printUsage(System.out, "");
        String basicFileName = "RAEmanAuthorPaper";
        String[] aList = new String[]{"-fin" + basicFileName + "inputBVNLS.dat", "-o511"};
        if (args.length > 0) {
            aList = args;
        }
        tg = new timgraph();
        tg.parseParam(aList);
        tg.setNameRoot(BasicAnalysis.tg.inputName.getNameRoot());
        int xColumn = 1;
        int yColumn = 2;
        boolean headerOn = false;
        boolean infoOn = false;
        int nameColumn = 1;
        tg.setNetworkFromInputFile(xColumn, yColumn, nameColumn, headerOn, infoOn);
        tg.printParametersBasic();
        if (tg.getNumberVertices() < 20) {
            tg.printNetwork(true);
        }
        BasicAnalysis.analyse(tg);
    }

    public static void analyse(timgraph tg) {
        basicroot = tg.inputName.getNameRoot();
        tg.calcStrength();
        FileOutput fo = new FileOutput(tg);
        fo.informationGeneral("", SEP);
        fo.edgeListSimple();
        if (tg.isVertexLabelled()) {
            fo.printEdges(true, false, false, false, false);
        }
    }

    static {
        infoLevel = 0;
    }
}

