/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import JavaNotes.TextReader;
import TimGraph.io.FileInput;
import TimGraph.io.FileOutput;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class PaperSynchoniser {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static boolean infoOn = true;

    public static void main(String[] args) {
        System.out.println("PaperSynchoniser Arguments: (input file 1) (input file 2) (convertToIndex y,t or n,f)(ouput file name of name to index list) (output file name 1) (output file name 2)");
        String fileName1 = "input/RAEmanGCCinputELS.dat";
        int ano = 0;
        if (args.length > ano) {
            fileName1 = args[ano];
        }
        System.out.println("--- File defining first vertex set " + fileName1);
        String fileName2 = "input/RAEmanAuthorInstituteinputBVNLS.dat";
        if (args.length > ++ano) {
            fileName2 = args[ano];
        }
        System.out.println("--- File defining second vertex set " + fileName2);
        boolean convertToIndex = false;
        if (args.length > ++ano) {
            convertToIndex = StringFilter.trueString((String)args[ano]);
        }
        System.out.println("--- " + (convertToIndex ? "C" : "Not c") + "onverting names to strings");
        int c = -1;
        c = fileName1.lastIndexOf(46);
        if (c < 0) {
            c = fileName1.length();
        }
        String fullNameToIndexFileName = fileName1.substring(0, c) + ".NameToIndex.dat";
        if (args.length > ++ano) {
            fullNameToIndexFileName = args[ano];
        }
        System.out.println("--- Name to Index file " + fullNameToIndexFileName);
        int c1 = fileName1.lastIndexOf(46);
        if (c1 < 0) {
            c = fileName1.length();
        }
        String fullOutputFileName1 = fileName1.substring(0, c1) + ".sync.dat";
        if (args.length > ++ano) {
            fullOutputFileName1 = args[ano];
        }
        System.out.println("--- Output file 1 " + fullOutputFileName1);
        int c2 = fileName2.lastIndexOf(46);
        if (c2 < 0) {
            c2 = fileName2.length();
        }
        String fullOutputFileName2 = fileName2.substring(0, c2) + ".sync.dat";
        if (args.length > ++ano) {
            fullOutputFileName2 = args[ano];
        }
        System.out.println("--- Output file 2 " + fullOutputFileName2);
        FileInput fi = new FileInput(infoOn ? 0 : -2);
        String cc = "";
        TreeSet<Integer> vertexColumnSet1 = new TreeSet<Integer>();
        vertexColumnSet1.add(1);
        if (fileName1.endsWith("ELS.dat") || fileName1.endsWith("EL.dat")) {
            vertexColumnSet1.add(2);
        }
        boolean forceLowerCase = true;
        TreeSet<String> vertexLL1 = new TreeSet<String>();
        vertexLL1.addAll(fi.readStringColumnsFromFile(fileName1, cc, vertexColumnSet1, forceLowerCase));
        TreeSet<Integer> vertexColumnSet2 = new TreeSet<Integer>();
        vertexColumnSet2.add(1);
        if (fileName2.endsWith("ELS.dat") || fileName2.endsWith("EL.dat")) {
            vertexColumnSet2.add(2);
        }
        forceLowerCase = true;
        TreeSet<String> vertexLL2 = new TreeSet<String>();
        vertexLL2.addAll(fi.readStringColumnsFromFile(fileName2, cc, vertexColumnSet2, forceLowerCase));
        TreeSet<String> vertexAll = new TreeSet<String>();
        vertexAll.addAll(vertexLL1);
        vertexAll.retainAll(vertexLL2);
        if (infoOn) {
            System.out.println("Found " + vertexAll.size() + " common vertices from " + vertexLL1.size() + " in file 1 and " + vertexLL2.size() + " in file 2");
        }
        TreeMap<String, Integer> vertexNameToIndex = new TreeMap<String, Integer>();
        int index = 0;
        for (String name : vertexAll) {
            vertexNameToIndex.put(name, index++);
        }
        String sep = SEP;
        String[] headerLines = new String[]{"#name" + sep + "index"};
        FileOutput.map(vertexNameToIndex, fullNameToIndexFileName, headerLines, sep, infoOn);
        PaperSynchoniser.synchroniseVertexList(vertexNameToIndex, fileName1, fullOutputFileName1, fileName2, cc, sep, vertexColumnSet1, convertToIndex, forceLowerCase, infoOn);
        PaperSynchoniser.synchroniseVertexList(vertexNameToIndex, fileName2, fullOutputFileName2, fileName1, cc, sep, vertexColumnSet2, convertToIndex, forceLowerCase, infoOn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int synchroniseVertexList(Map<String, Integer> vertexNameToIndex, String fullInputFileName, String fullOutputFileName, String fullOtherInputFileName, String cc, String sep, Set<Integer> vertexColumnList, boolean convertToIndex, boolean forceLowerCase, boolean infoOn) {
        PrintStream PS;
        FileOutputStream fout;
        TextReader data;
        int maxColumn = -1;
        for (Integer vertexColumn : vertexColumnList) {
            if (vertexColumn < 1) {
                throw new RuntimeException("first column is numbered 1, column with vertices given as " + vertexColumn);
            }
            maxColumn = Math.max(vertexColumn, maxColumn);
        }
        int res = 0;
        boolean dontTestForCommentLine = false;
        if (cc.length() == 0) {
            dontTestForCommentLine = true;
        }
        if ((data = FileInput.openFile(fullInputFileName)) == null) {
            System.err.println("*** synchroniseVertexList input file " + fullInputFileName + " not opened");
            return -1;
        }
        if (infoOn) {
            System.out.print("Starting to do vertex synchronisation on columns ");
            for (Integer vertexColumn : vertexColumnList) {
                System.out.print(vertexColumn + ", ");
            }
            System.out.println(" of file " + fullInputFileName);
            if (convertToIndex) {
                System.out.println("Converting names to indices");
            }
        }
        TreeSet<String> vertexFoundLL = new TreeSet<String>();
        TreeSet<String> vertexNotFound = new TreeSet<String>();
        try {
            fout = new FileOutputStream(fullOutputFileName);
            PS = new PrintStream(fout);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("**** synchroniseVertexList output file " + fullOutputFileName + " not opened, " + e.getMessage());
        }
        int linenumber = 0;
        int verticesInput = 0;
        int verticesOutput = 0;
        String[] vertexFound = new String[vertexColumnList.size()];
        try {
            String[] numbers = new String[1000];
            int column = 0;
            while (!data.eof()) {
                ++linenumber;
                column = 0;
                if (forceLowerCase) {
                    while (!data.eoln()) {
                        numbers[column++] = data.getWord().toLowerCase();
                    }
                } else {
                    while (!data.eoln()) {
                        numbers[column++] = data.getWord();
                    }
                }
                if (maxColumn > column) {
                    throw new RuntimeException("on line " + linenumber + " found " + column + " columns (first is numbered 1) but synchronising on column " + maxColumn);
                }
                try {
                    int c;
                    if (dontTestForCommentLine || !numbers[0].startsWith(cc)) {
                        boolean lineOK = true;
                        int vc = 0;
                        for (Integer vertexColumn : vertexColumnList) {
                            String vertex = numbers[vertexColumn - 1];
                            ++verticesInput;
                            if (!vertexNameToIndex.containsKey(vertex)) {
                                lineOK = false;
                            }
                            vertexFound[vc++] = vertex;
                        }
                        if (!lineOK) continue;
                        for (vc = 0; vc < vertexFound.length; ++vc) {
                            ++verticesOutput;
                            vertexFoundLL.add(vertexFound[vc]);
                        }
                    }
                    int columnMinusOne = column - 1;
                    if (convertToIndex) {
                        for (c = 0; c < column; ++c) {
                            PS.print((vertexColumnList.contains(c) ? (Serializable)vertexNameToIndex.get(numbers[c]) : numbers[c]) + (c == columnMinusOne ? "" : sep));
                        }
                    } else {
                        for (c = 0; c < column; ++c) {
                            PS.print(numbers[c] + (c == columnMinusOne ? "" : sep));
                        }
                    }
                    PS.println();
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("*** PROBLEM on line " + linenumber + " of input file, " + e.getMessage());
                }
            }
            for (String name : vertexNameToIndex.keySet()) {
                if (vertexFoundLL.contains(name)) continue;
                vertexNotFound.add(name);
            }
            if (infoOn) {
                System.out.println("Finished vertex synchronisation on first column of file " + fullInputFileName + " producing " + fullOutputFileName);
                System.out.println("    " + linenumber + " input lines found " + verticesInput + " lines with vertices, wrote " + verticesOutput + " lines with vertices in given list.");
                System.out.println("      Given " + vertexNameToIndex.size() + " distinct input vertices, " + vertexNotFound.size() + " were not used.");
                System.out.println("      Output " + vertexFoundLL.size() + " distinct output vertices.");
            }
        }
        catch (TextReader.Error e) {
            res = -3;
            throw new RuntimeException("*** File Error in " + fullInputFileName + " or " + fullOutputFileName + ", " + e.getMessage());
        }
        finally {
            try {
                data.close();
                fout.close();
            }
            catch (IOException e) {
                throw new RuntimeException("*** File Error closing " + fullInputFileName + " or " + fullOutputFileName + ", " + e.getMessage());
            }
        }
        String infoOutputFileName = fullOutputFileName + ".info.txt";
        try {
            fout = new FileOutputStream(infoOutputFileName);
            PS = new PrintStream(fout);
        }
        catch (FileNotFoundException e) {
            res = -2;
            throw new RuntimeException("**** synchroniseVertexList information file " + infoOutputFileName + " not opened, " + e.getMessage());
        }
        PS.println("Vertex synchronisation on first column of file " + fullInputFileName + "against file " + fullOtherInputFileName + " producing " + fullOutputFileName);
        PS.println("    " + linenumber + " input lines found " + verticesInput + " lines with vertices, wrote " + verticesOutput + " lines with vertices in given list.");
        PS.println("      Given " + vertexNameToIndex.size() + " distinct input vertices, " + vertexNotFound.size() + " were not used.");
        PS.println("      Output " + vertexFoundLL.size() + " distinct output vertices.");
        if (vertexNotFound.size() > 0) {
            PS.println("Vertices in input list not found in synchronised file");
            PS.println("name" + sep + "index");
            for (String name : vertexNotFound) {
                PS.println(name + sep + vertexNameToIndex.get(name));
            }
        }
        try {
            fout.close();
        }
        catch (IOException e) {
            throw new RuntimeException("*** File Error closing " + infoOutputFileName + ", " + e.getMessage());
        }
        return res;
    }
}

