/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import JavaNotes.TextReader;
import TimGraph.VertexLabel;
import TimGraph.timgraph;
import java.util.ArrayList;
import java.util.TreeMap;

public class InputGML {
    static final String UNSET = "UNSET";
    static final int IUNSET = -918273645;
    static final double DUNSET = -9.182736E45;
    static final String STARTSTRING = "[";
    static final String ENDSTRING = "]";
    boolean weightsOn = false;
    public boolean directedGraph = false;
    public int infoLevel = 0;
    TextReader data;
    public TreeMap<Integer, Integer> nodeIDToIndex;
    public ArrayList<Integer> nodeID;
    public ArrayList<String> nodeLabel;
    public ArrayList<Integer> nodeValue;
    public TreeMap<Integer, Integer> edgeIDToIndex;
    public ArrayList<Integer> edgeSource;
    public ArrayList<Integer> edgeTarget;
    public ArrayList<Double> edgeWeight;

    public InputGML(TextReader newData, boolean readWeights) {
        this.weightsOn = readWeights;
        this.data = newData;
    }

    public void findGraph() {
        String s = UNSET;
        String objectString = "graph";
        if (this.findNextWord(objectString).startsWith(UNSET)) {
            throw new RuntimeException("No line stating with " + objectString + " found before end of file");
        }
        if (this.findNextWord(STARTSTRING).startsWith(UNSET)) {
            throw new RuntimeException("Object " + objectString + " had no starting string " + STARTSTRING + " before end of file");
        }
        if (this.infoLevel > 1) {
            System.out.println("Found " + objectString + " object and start string " + STARTSTRING);
        }
        this.nodeIDToIndex = new TreeMap();
        this.nodeID = new ArrayList();
        this.nodeLabel = new ArrayList();
        this.nodeValue = new ArrayList();
        this.edgeSource = new ArrayList();
        this.edgeTarget = new ArrayList();
        if (this.weightsOn) {
            this.edgeWeight = new ArrayList();
        }
        while (!this.data.eof()) {
            s = this.data.getWord();
            if (this.infoLevel > 1) {
                System.out.println("s=\"" + s + "\"");
            }
            if (s.startsWith(ENDSTRING)) break;
            if (s.startsWith("directed")) {
                s = this.data.getWord();
                if (s.startsWith("1")) {
                    this.directedGraph = true;
                }
                if (s.startsWith("0")) {
                    this.directedGraph = false;
                }
                if (this.infoLevel <= 1) continue;
                System.out.println("Found directed keyword, value=" + (this.directedGraph ? "true" : "false"));
                continue;
            }
            if (s.startsWith("node")) {
                this.nodeObject();
                continue;
            }
            if (!s.startsWith("edge")) continue;
            this.edgeObject();
        }
        if (!s.startsWith(ENDSTRING)) {
            throw new RuntimeException("File ended before " + objectString + "  closed by " + ENDSTRING);
        }
        if (this.infoLevel > 1) {
            System.out.println("Found end string " + s + " for object " + objectString);
        }
    }

    private void nodeObject() {
        String s = UNSET;
        String objectString = "node";
        if (this.findNextWord(STARTSTRING).equals(UNSET)) {
            throw new RuntimeException("No opening [ found for " + objectString);
        }
        int id = -918273645;
        String label = UNSET;
        int value = -918273645;
        while (!this.data.eof() && !(s = this.data.getWord()).startsWith(ENDSTRING)) {
            if (s.startsWith("id")) {
                id = this.data.getInt();
                continue;
            }
            if (s.startsWith("label")) {
                label = this.processLabel(this.data.getWord());
                continue;
            }
            if (!s.startsWith("value")) continue;
            value = this.data.getInt();
        }
        if (!s.startsWith(ENDSTRING)) {
            throw new RuntimeException("File ended before " + objectString + "  closed by " + ENDSTRING);
        }
        this.nodeIDToIndex.put(id, this.nodeID.size());
        this.nodeLabel.add(label);
        this.nodeValue.add(value);
        this.nodeID.add(id);
        if (this.infoLevel > 1) {
            System.out.println("Found node " + (this.nodeID.size() - 1) + " id=" + this.valueString(id) + " label=" + label);
        }
    }

    private void edgeObject() {
        String s = UNSET;
        String objectString = "edge";
        if (this.findNextWord(STARTSTRING).equals(UNSET)) {
            throw new RuntimeException("No opening [ found for " + objectString);
        }
        int source = -918273645;
        int target = -918273645;
        double weight = -9.182736E45;
        while (!this.data.eof() && !(s = this.data.getWord()).startsWith(ENDSTRING)) {
            if (s.startsWith("source")) {
                source = this.data.getInt();
                continue;
            }
            if (s.startsWith("target")) {
                target = this.data.getInt();
                continue;
            }
            if (!s.startsWith("value")) continue;
            weight = this.data.getDouble();
        }
        if (!s.startsWith(ENDSTRING)) {
            throw new RuntimeException("File ended before " + objectString + "  closed by " + ENDSTRING);
        }
        if (source == -918273645 || target == -918273645) {
            throw new RuntimeException("Edge " + this.edgeSource.size() + " has bad source or target vertex");
        }
        if (this.weightsOn && weight == -9.182736E45) {
            throw new RuntimeException("Edge " + this.edgeSource.size() + " has bad weight ");
        }
        this.edgeSource.add(source);
        this.edgeTarget.add(target);
        if (this.weightsOn) {
            this.edgeWeight.add(weight);
        }
        if (this.infoLevel > 1) {
            s = " source=" + this.valueString(source) + " target=" + this.valueString(target);
            if (this.weightsOn) {
                s = s + " weight=" + this.valueString(weight);
            }
            System.out.println("Found edge " + (this.edgeSource.size() - 1) + s);
        }
    }

    private String findNextWord(String prefix) {
        while (!this.data.eof()) {
            String s = this.data.getWord();
            if (this.infoLevel > 1) {
                System.out.println("s=\"" + s + "\"");
            }
            if (!s.startsWith(prefix)) continue;
            return s;
        }
        return UNSET;
    }

    public int setTimGraph(timgraph tg, boolean weighted, boolean vertexLabelled) {
        tg.setDirectedGraph(this.directedGraph);
        tg.setNetwork(this.nodeID.size(), this.edgeSource.size() * 2);
        Integer id = new Integer(-918273645);
        Integer value = new Integer(-918273645);
        VertexLabel newLabel = new VertexLabel();
        for (int v = 0; v < this.nodeID.size(); ++v) {
            if (tg.isVertexLabelled()) {
                id = this.nodeID.get(v);
                if (id == -918273645) {
                    id = v;
                }
                value = this.nodeValue.get(v);
                String label = this.nodeLabel.get(v);
                if (label.equals(UNSET)) {
                    label = Integer.toString(v);
                }
                newLabel.setName(label);
                if (value == -918273645) {
                    newLabel.setNumber(id);
                } else {
                    newLabel.setNumber(value);
                }
                tg.addVertex(newLabel);
                continue;
            }
            tg.addVertex();
        }
        int source = -918273645;
        int target = -918273645;
        int s = -918273645;
        int t = -918273645;
        double weight = -9.182736E45;
        for (int e = 0; e < this.edgeSource.size(); ++e) {
            source = this.edgeSource.get(e);
            target = this.edgeTarget.get(e);
            s = this.nodeIDToIndex.get(source);
            t = this.nodeIDToIndex.get(target);
            if (tg.isWeighted()) {
                tg.addEdge(s, t, this.edgeWeight.get(e));
                continue;
            }
            tg.addEdge(s, t);
        }
        return 0;
    }

    public String processLabel(String sin) {
        int l;
        int f = 0;
        if (sin.charAt(0) == '\"') {
            f = 1;
        }
        if (sin.charAt((l = sin.length()) - 1) == '\"') {
            --l;
        }
        return sin.substring(f, l);
    }

    public int getNumberVertices() {
        return this.nodeID.size();
    }

    public int getNumberEdges() {
        return this.edgeSource.size();
    }

    private String valueString(int i) {
        String s = i == -918273645 ? "Unset" : Integer.toString(i);
        return s;
    }

    private String valueString(double d) {
        String s = d == -9.182736E45 ? "Unset" : Double.toString(d);
        return s;
    }
}

