/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import TimGraph.Community.VertexPartition;
import TimGraph.timgraph;
import TimUtilities.JavaColours;
import java.io.PrintStream;

public class GraphViz {
    public void output(PrintStream PS, timgraph tg, boolean edgeLabels) {
        String name = "";
        name = "\"" + tg.outputName.getNameRoot() + "\"";
        PS.println("graph " + name + "{");
        this.edgeList(PS, tg, edgeLabels);
        PS.println("}");
    }

    public void outputVertexCommunity(PrintStream PS, timgraph tg, VertexPartition vertexC, boolean edgeLabels) {
        String name = "";
        name = "\"" + tg.outputName.getNameRoot() + "\"";
        PS.println("graph " + name + "{");
        this.vertexList(PS, tg, vertexC);
        this.edgeList(PS, tg, edgeLabels);
        PS.println("}");
    }

    public void vertexList(PrintStream PS, timgraph tg, VertexPartition vertexC) {
        JavaColours nc = new JavaColours(vertexC.getNumberOfCommunities() + 2, true);
        nc.printAllColours(System.out);
        for (int v = 0; v < tg.getNumberVertices(); ++v) {
            PS.println(v + "  [ color = \"#" + nc.RGB(vertexC.getCommunity(v) + 1) + "\" ]");
        }
    }

    public void edgeList(PrintStream PS, timgraph tg, boolean gvLabels) {
        JavaColours nc = new JavaColours(20, false);
        nc.printAllColours(System.out);
        String edgeString = " -- ";
        if (tg.isDirected()) {
            edgeString = " -> ";
        }
        String ac = "";
        String aw = "";
        String al = "";
        int s = -1;
        int t = -1;
        for (int e = 0; e < tg.getNumberStubs(); e += 2) {
            s = tg.getVertexFromEdge(e);
            t = tg.getVertexFromEdge(e + 1);
            ac = nc.RGB(e + 1);
            System.out.println("e=" + e + ", c string = " + ac);
            if (tg.isWeighted()) {
                aw = "\n weight=" + tg.getEdgeWeight(e);
            }
            if (gvLabels) {
                al = "\n label = \"" + e + "\"";
            }
            PS.println(s + edgeString + t + " [ \n color = \"#" + ac + "\"  " + aw + al + "\n ]");
        }
    }

    private void printSingleLineComment(PrintStream PS, String s) {
        PS.println("// " + s);
    }

    private void printMultiLineComment(PrintStream PS, String[] s) {
        PS.println("/*");
        for (int i = 0; i < s.length; ++i) {
            PS.println(" * " + s[i]);
        }
        PS.println("*/");
    }
}

